/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.game.obstacles;

import com.ximad.pvn.audio.SoundSystem;
import com.ximad.pvn.engine.Application;
import com.ximad.pvn.game.Box2d;
import com.ximad.pvn.game.Camera;
import com.ximad.pvn.game.GameParameters;
import com.ximad.pvn.game.LevelCompleteStat;
import com.ximad.pvn.game.MyWorld;
import com.ximad.pvn.game.PhysicalGameObject;
import com.ximad.pvn.game.Point;
import com.ximad.pvn.game.obstacles.Obstacle;
import com.ximad.pvn.utils.ArrayList;

public class ObstacleGlass
extends Obstacle {
    private static final int DENSITY = 50;
    public static float densityGlass = 0.8f;
    public float collisionForce = 0.0f;
    static /* synthetic */ Class class$com$ximad$pvn$game$pandas$PandaMini;

    public ObstacleGlass() {
        this.isPlayerPenetratable = true;
        this.score = 50;
        this.durability = 1;
        this.type = 5003;
    }

    public void OnCollision(PhysicalGameObject obj, float force) {
        force = (float)((double)force * 0.8);
        super.OnCollision(obj, force);
        if (obj.typeDinamicalObjects == 101) {
            this.collisionForce = force;
            if (this.collisionForce > 6.0f) {
                --this.durability;
            }
        }
        if (obj.typeDinamicalObjects == 103) {
            this.collisionForce = force;
            if (this.collisionForce > 5.0f) {
                --this.durability;
            }
        }
        if (obj.typeDinamicalObjects == 104) {
            this.collisionForce = force;
            if (this.collisionForce > 5.0f) {
                --this.durability;
            }
        }
        if (obj.typeDinamicalObjects == 102 && obj.getClass() != (class$com$ximad$pvn$game$pandas$PandaMini == null ? (class$com$ximad$pvn$game$pandas$PandaMini = ObstacleGlass.class$("com.ximad.pvn.game.pandas.PandaMini")) : class$com$ximad$pvn$game$pandas$PandaMini)) {
            this.collisionForce = force;
            if (this.collisionForce > 12.0f) {
                this.durability = this.durability == 2 ? 0 : --this.durability;
            } else if (this.collisionForce > 5.0f) {
                --this.durability;
            }
        }
    }

    public void update(long dt) {
        super.update(dt);
        if (this.durability <= 0) {
            this.onDestroy = true;
        }
        if (this.onDestroy) {
            SoundSystem.SOUND_ON_GLASS_DESTROY.play();
            super.crushObstacle(this);
            this.destroyObstacle();
            ++((LevelCompleteStat)GameParameters.currentScenario.level.get((int)MyWorld.currentLevelInt)).obstacles;
            ((LevelCompleteStat)GameParameters.currentScenario.level.get((int)MyWorld.currentLevelInt)).score += (long)this.score;
        } else if (MyWorld.onPlay) {
            this.defaultFrame = this.nFrames - this.durability;
        }
        super.update(dt);
    }

    public static void createObstacle(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        ObstacleGlass obj = new ObstacleGlass();
        ArrayList shape = new ArrayList();
        obj.restitution = 1;
        obj.friction = 100;
        obj.isCrushable = true;
        obj.density = 50;
        obj.isBullet = false;
        obj.isStatic = sstatic;
        shape.add(new Point(x1, y1));
        shape.add(new Point(x2, y2));
        shape.add(new Point(x3, y3));
        shape.add(new Point(x4, y4));
        obj.loadImage("glass1", shape);
        obj.setShape(shape, false, false);
        MyWorld.physicalGameObjects.add(obj);
        obj.mass = Box2d.getMass(obj.box2dId);
        obj.damage = obj.durability = obj.nFrames;
        obj.box2dId.setParent(obj);
    }

    public static void createObstacle(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4, String imageName, int angle) {
        ObstacleGlass obj = new ObstacleGlass();
        ArrayList shape = new ArrayList();
        obj.restitution = 1;
        obj.friction = 100;
        obj.isCrushable = true;
        obj.density = 50;
        obj.angle = angle;
        obj.isStatic = sstatic;
        shape.add(new Point(x1, y1));
        shape.add(new Point(x2, y2));
        shape.add(new Point(x3, y3));
        shape.add(new Point(x4, y4));
        obj.loadImage(imageName, shape);
        obj.setShape(shape, false, false);
        MyWorld.physicalGameObjects.add(obj);
        obj.mass = Box2d.getMass(obj.box2dId);
        obj.damage = obj.durability = obj.nFrames;
        obj.box2dId.setParent(obj);
    }

    public static void createObstacle(int x1, int y1, int x2, int y2, int x3, int y3, String imageName, int angle) {
        ObstacleGlass obj = new ObstacleGlass();
        ArrayList shape = new ArrayList();
        obj.restitution = 1;
        obj.friction = 100;
        obj.isCrushable = true;
        obj.density = 50;
        obj.angle = angle;
        obj.isTriangle = true;
        obj.isStatic = sstatic;
        shape.add(new Point(x1, y1));
        shape.add(new Point(x2, y2));
        shape.add(new Point(x3, y3));
        obj.loadImage(imageName, shape);
        obj.setShape(shape, false, false);
        MyWorld.physicalGameObjects.add(obj);
        obj.mass = Box2d.getMass(obj.box2dId);
        obj.damage = obj.durability = obj.nFrames;
        obj.box2dId.setParent(obj);
    }

    public static void createObstacle(int x, int y, int R) {
        ObstacleGlass obj = new ObstacleGlass(){

            protected boolean isVisible() {
                int x = this.box2dId.positionFX().xAsInt();
                return x + this.radius > Camera.position && x - this.radius < Camera.position + Application.screenWidth;
            }
        };
        ArrayList shape = new ArrayList();
        obj.restitution = 1;
        obj.friction = 100;
        obj.isCrushable = true;
        obj.isCircle = true;
        obj.density = 50;
        obj.radius = R;
        obj.isStatic = sstatic;
        shape.add(new Point(x, y));
        obj.loadImage("glass_circle1", shape);
        obj.setShape(shape, false, false);
        MyWorld.physicalGameObjects.add(obj);
        obj.mass = Box2d.getMass(obj.box2dId);
        obj.damage = obj.durability = obj.nFrames;
        obj.box2dId.setParent(obj);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

