/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.game.obstacles;

import com.ximad.pvn.engine.Application;
import com.ximad.pvn.game.Box2d;
import com.ximad.pvn.game.Camera;
import com.ximad.pvn.game.MyWorld;
import com.ximad.pvn.game.PhysicalGameObject;
import com.ximad.pvn.game.Point;
import com.ximad.pvn.game.obstacles.Obstacle;
import com.ximad.pvn.utils.ArrayList;

public class ObstacleMetal
extends Obstacle {
    private static final int DENSITY = 35;
    public float collisionForce = 0.0f;

    public ObstacleMetal() {
        this.isPlayerPenetratable = true;
        this.score = 100;
        this.durability = 1;
        this.type = 5007;
    }

    public void OnCollision(PhysicalGameObject obj, float force) {
        super.OnCollision(obj, force);
        this.collisionForce = force;
        if (obj.typeDinamicalObjects == 101) {
            // empty if block
        }
        if (obj.typeDinamicalObjects == 103) {
            // empty if block
        }
        if (obj.typeDinamicalObjects == 104) {
            // empty if block
        }
        if (obj.typeDinamicalObjects == 102) {
            // empty if block
        }
    }

    public void update(long dt) {
        super.update(dt);
        if (this.durability <= 0) {
            this.onDestroy = true;
        }
        if (this.onDestroy) {
            this.destroyObstacle();
        } else if (MyWorld.onPlay) {
            this.defaultFrame = this.nFrames - this.durability;
        }
    }

    public static void createObstacle(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        ObstacleMetal obj = new ObstacleMetal();
        ArrayList shape = new ArrayList();
        obj.restitution = 1;
        obj.friction = 99;
        obj.isCrushable = true;
        obj.density = 35;
        obj.isStatic = sstatic;
        shape.add(new Point(x1, y1));
        shape.add(new Point(x2, y2));
        shape.add(new Point(x3, y3));
        shape.add(new Point(x4, y4));
        obj.loadImage("metal_rect1", shape);
        obj.setShape(shape, false, false);
        MyWorld.physicalGameObjects.add(obj);
        obj.mass = Box2d.getMass(obj.box2dId);
        obj.damage = obj.durability = obj.nFrames;
        obj.box2dId.setParent(obj);
    }

    public static void createObstacle(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4, String imageName, int angle) {
        ObstacleMetal obj = new ObstacleMetal();
        ArrayList shape = new ArrayList();
        obj.restitution = 1;
        obj.friction = 99;
        obj.isCrushable = true;
        obj.density = 35;
        obj.angle = angle;
        obj.isStatic = sstatic;
        shape.add(new Point(x1, y1));
        shape.add(new Point(x2, y2));
        shape.add(new Point(x3, y3));
        shape.add(new Point(x4, y4));
        obj.loadImage(imageName, shape);
        obj.setShape(shape, false, false);
        MyWorld.physicalGameObjects.add(obj);
        obj.mass = Box2d.getMass(obj.box2dId);
        obj.damage = obj.durability = obj.nFrames;
        obj.box2dId.setParent(obj);
    }

    public static void createObstacle(int x, int y, int R) {
        ObstacleMetal obj = new ObstacleMetal(){

            protected boolean isVisible() {
                int x = this.box2dId.positionFX().xAsInt();
                return x + this.radius > Camera.position && x - this.radius < Camera.position + Application.screenWidth;
            }
        };
        ArrayList shape = new ArrayList();
        obj.friction = 99;
        obj.isCrushable = true;
        obj.isCircle = true;
        if (R == 5) {
            obj.density = 175;
            obj.restitution = 99;
        } else {
            obj.density = 35;
            obj.restitution = 1;
        }
        obj.radius = R;
        obj.isStatic = sstatic;
        shape.add(new Point(x, y));
        obj.loadImage("metal_circle1", shape);
        obj.setShape(shape, false, false);
        MyWorld.physicalGameObjects.add(obj);
        obj.mass = Box2d.getMass(obj.box2dId);
        obj.damage = obj.durability = obj.nFrames;
        obj.box2dId.setParent(obj);
    }

    public static void createObstacle(int x1, int y1, int x2, int y2, int x3, int y3, String imageName, int angle) {
        ObstacleMetal obj = new ObstacleMetal();
        ArrayList shape = new ArrayList();
        obj.restitution = 1;
        obj.friction = 99;
        obj.isCrushable = true;
        obj.density = 35;
        obj.angle = angle;
        obj.isTriangle = true;
        obj.isStatic = sstatic;
        shape.add(new Point(x1, y1));
        shape.add(new Point(x2, y2));
        shape.add(new Point(x3, y3));
        obj.loadImage(imageName, shape);
        obj.setShape(shape, false, false);
        MyWorld.physicalGameObjects.add(obj);
        obj.mass = Box2d.getMass(obj.box2dId);
        obj.damage = obj.durability = obj.nFrames;
        obj.box2dId.setParent(obj);
    }
}

