/*
 * Decompiled with CFR 0.152.
 */
package henson.m3g;

import henson.m3g.MIDlet1;
import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Background;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Light;
import javax.microedition.m3g.Material;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;

public class MainCanvas
extends Canvas
implements CommandListener {
    private float iAngle = 0.0f;
    private Appearance iAppearance;
    private Background iBackground;
    private Camera iCamera;
    private Graphics3D iG3D;
    private IndexBuffer iIb;
    private Image iImage;
    private Image iImageBackground;
    private Light iLight;
    private Material iMaterial;
    private Transform iTransform = new Transform();
    private VertexBuffer iVb;
    private String m_FPS = "";
    private String m_FPSprefix = "";
    private int m_count;
    private long m_lastFrame;
    private long m_sumTime;

    public MainCanvas() {
        this.iBackground = new Background();
        this.iMaterial = new Material();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.m_lastFrame = System.currentTimeMillis();
        this.m_sumTime = 0L;
        this.m_count = 0;
        this.m_FPSprefix = "" + this.getWidth() + "x" + this.getHeight() + " ";
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command.getCommandType() == 7) {
            MIDlet1.quitApp();
        }
    }

    private void jbInit() throws Exception {
        this.setCommandListener(this);
        this.addCommand(new Command("Exit", 7, 1));
    }

    protected void paint(Graphics g) {
        this.iG3D.bindTarget((Object)g, true, 12);
        this.iG3D.clear(this.iBackground);
        Transform transform = new Transform();
        transform.postTranslate(0.0f, 0.0f, 100.0f);
        this.iG3D.setCamera(this.iCamera, transform);
        this.iG3D.resetLights();
        this.iG3D.addLight(this.iLight, transform);
        this.iAngle += 1.0f;
        int i = -30;
        while (i < 60) {
            this.iTransform.setIdentity();
            this.iTransform.postTranslate((float)i, 0.0f, 0.0f);
            this.iTransform.postRotate(this.iAngle, 1.0f, 1.0f, 1.0f);
            this.iG3D.render(this.iVb, this.iIb, this.iAppearance, this.iTransform);
            i += 30;
        }
        this.iG3D.releaseTarget();
        long diff = System.currentTimeMillis() - this.m_lastFrame;
        this.m_sumTime += diff;
        ++this.m_count;
        if (this.m_count == 20) {
            float fps = 20000.0f / (float)this.m_sumTime;
            this.m_FPS = Float.toString(fps);
            this.m_count = 0;
            this.m_sumTime = 0L;
        }
        this.m_lastFrame = System.currentTimeMillis();
        g.setColor(0xFFFFFF);
        g.drawString(this.m_FPSprefix + this.m_FPS, 0, 0, 20);
    }

    public void startApp() {
        this.iG3D = Graphics3D.getInstance();
        this.iCamera = new Camera();
        this.iCamera.setPerspective(60.0f, (float)this.getWidth() / (float)this.getHeight(), 1.0f, 100.0f);
        this.iLight = new Light();
        this.iLight.setColor(0xFFFFFF);
        this.iLight.setIntensity(1.25f);
        short[] vert = new short[]{10, 10, 10, -10, 10, 10, 10, -10, 10, -10, -10, 10, -10, 10, -10, 10, 10, -10, -10, -10, -10, 10, -10, -10, -10, 10, 10, -10, 10, -10, -10, -10, 10, -10, -10, -10, 10, 10, -10, 10, 10, 10, 10, -10, -10, 10, -10, 10, 10, 10, -10, -10, 10, -10, 10, 10, 10, -10, 10, 10, 10, -10, 10, -10, -10, 10, 10, -10, -10, -10, -10, -10};
        VertexArray vertArray = new VertexArray(vert.length / 3, 3, 2);
        vertArray.set(0, vert.length / 3, vert);
        byte[] norm = new byte[]{0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, -127, 0, 0, -127, 0, 0, -127, 0, 0, -127, -127, 0, 0, -127, 0, 0, -127, 0, 0, -127, 0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, -127, 0, 0, -127, 0, 0, -127, 0, 0, -127, 0};
        VertexArray normArray = new VertexArray(norm.length / 3, 3, 1);
        normArray.set(0, norm.length / 3, norm);
        short[] tex = new short[]{1, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 1, 1, 0, 1};
        VertexArray texArray = new VertexArray(tex.length / 2, 2, 2);
        texArray.set(0, tex.length / 2, tex);
        int[] stripLen = new int[]{4, 4, 4, 4, 4, 4};
        VertexBuffer vb = this.iVb = new VertexBuffer();
        vb.setPositions(vertArray, 1.0f, null);
        vb.setNormals(normArray);
        vb.setTexCoords(0, texArray, 1.0f, null);
        this.iIb = new TriangleStripArray(0, stripLen);
        try {
            this.iImage = Image.createImage((String)"/ttex2.png");
            this.iImageBackground = Image.createImage((String)"/texture.png");
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
        Image2D image2D = new Image2D(99, (Object)this.iImage);
        Image2D image2Dbackground = new Image2D(99, (Object)this.iImageBackground);
        Texture2D texture = new Texture2D(image2D);
        texture.setFiltering(210, 210);
        texture.setWrapping(241, 241);
        texture.setBlending(228);
        this.iAppearance = new Appearance();
        this.iAppearance.setTexture(0, texture);
        this.iAppearance.setMaterial(this.iMaterial);
        this.iMaterial.setColor(2048, -1);
        this.iMaterial.setColor(8192, -1);
        this.iMaterial.setShininess(100.0f);
        this.iBackground.setColor(16074120);
        this.iBackground.setImage(image2Dbackground);
    }
}

