/*
 * Decompiled with CFR 0.152.
 */
package com.annimon;

import com.annimon.Quantize;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.microedition.lcdui.Image;
import net.sf.zipme.CRC32;
import net.sf.zipme.Deflater;
import net.sf.zipme.DeflaterOutputStream;

public class Png8bitWriter {
    private byte[] data;
    private CRC32 crc;
    private int w;
    private int h;

    public void encode(Image img, DataOutputStream dos) throws IOException {
        img = this.Quantize(img, 256);
        this.w = img.getWidth();
        this.h = img.getHeight();
        this.crc = new CRC32();
        ((OutputStream)dos).write(new byte[]{-119, 80, 78, 71, 13, 10, 26, 10});
        this.writeIHDR(dos);
        this.writePLTE(dos, this.getPallete(img));
        this.writeIDAT(dos);
        this.writeIEND(dos);
    }

    private void writeIHDR(DataOutputStream dos) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream b2 = new DataOutputStream(baos);
        ((OutputStream)b2).write(new byte[]{73, 72, 68, 82});
        b2.writeInt(this.w);
        b2.writeInt(this.h);
        b2.writeByte(8);
        b2.writeByte(3);
        b2.writeByte(0);
        b2.writeByte(0);
        b2.writeByte(0);
        b2.close();
        dos.writeInt(baos.size() - 4);
        ((OutputStream)dos).write(baos.toByteArray());
        this.crc.reset();
        this.crc.update(baos.toByteArray());
        dos.writeInt((int)this.crc.getValue());
    }

    private void writePLTE(DataOutputStream dos, byte[] palette) throws IOException {
        dos.writeInt(palette.length);
        byte[] PLTE = new byte[]{80, 76, 84, 69};
        ((OutputStream)dos).write(PLTE);
        this.crc.reset();
        this.crc.update(PLTE);
        ((OutputStream)dos).write(palette);
        this.crc.update(palette);
        dos.writeInt((int)this.crc.getValue());
    }

    private void writeIDAT(DataOutputStream dos) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream b2 = new DataOutputStream(baos);
        DeflaterOutputStream def = new DeflaterOutputStream(baos, new Deflater(9, false));
        for (int y2 = 0; y2 < this.h; ++y2) {
            def.write(0);
            for (int x2 = 0; x2 < this.w; ++x2) {
                def.write(this.data[y2 * this.w + x2]);
            }
        }
        def.close();
        byte[] compressedLines = baos.toByteArray();
        int nCompressed = compressedLines.length;
        byte[] IDAT = new byte[]{73, 68, 65, 84};
        this.crc.reset();
        dos.writeInt(nCompressed);
        ((OutputStream)dos).write(IDAT);
        this.crc.update(IDAT);
        ((OutputStream)dos).write(compressedLines);
        this.crc.update(compressedLines, 0, nCompressed);
        dos.writeInt((int)this.crc.getValue());
        b2.close();
    }

    private void writeIEND(DataOutputStream dos) throws IOException {
        dos.writeInt(0);
        byte[] IEND = new byte[]{73, 69, 78, 68};
        ((OutputStream)dos).write(IEND);
        this.crc.reset();
        this.crc.update(IEND);
        dos.writeInt((int)this.crc.getValue());
    }

    private Image Quantize(Image img, int quant) {
        int[][] pixels = this.getPixels(img);
        int[] palette = new Quantize().quantizeImage(pixels, quant);
        int w2 = pixels.length;
        int h2 = pixels[0].length;
        int[] pixl = new int[w2 * h2];
        int x2 = w2;
        while (x2-- > 0) {
            int y2 = h2;
            while (y2-- > 0) {
                pixl[y2 * w2 + x2] = palette[pixels[x2][y2]];
            }
        }
        return Image.createRGBImage((int[])pixl, (int)img.getWidth(), (int)img.getHeight(), (boolean)false);
    }

    private int[][] getPixels(Image image) {
        int w2 = image.getWidth();
        int h2 = image.getHeight();
        int[] pixx = new int[w2 * h2];
        image.getRGB(pixx, 0, w2, 0, 0, w2, h2);
        int[][] pixels = new int[w2][h2];
        int x2 = w2;
        while (x2-- > 0) {
            int y2 = h2;
            while (y2-- > 0) {
                pixels[x2][y2] = pixx[y2 * w2 + x2];
            }
        }
        return pixels;
    }

    private byte[] getPallete(Image img) {
        int[] rgb = new int[this.w * this.h];
        img.getRGB(rgb, 0, this.w, 0, 0, this.w, this.h);
        this.data = new byte[rgb.length];
        byte[] c2 = new byte[768];
        int n2 = 0;
        for (int y2 = 0; y2 < this.h; ++y2) {
            for (int x2 = 0; x2 < this.w; ++x2) {
                int s2;
                for (s2 = 0; s2 < n2 && (c2[s2 * 3] != (byte)(rgb[y2 * this.w + x2] >> 16 & 0xFF) || c2[s2 * 3 + 1] != (byte)(rgb[y2 * this.w + x2] >> 8 & 0xFF) || c2[s2 * 3 + 2] != (byte)(rgb[y2 * this.w + x2] & 0xFF)); ++s2) {
                }
                this.data[y2 * this.w + x2] = (byte)s2;
                if (s2 != n2) continue;
                c2[s2 * 3] = (byte)(rgb[y2 * this.w + x2] >> 16 & 0xFF);
                c2[s2 * 3 + 1] = (byte)(rgb[y2 * this.w + x2] >> 8 & 0xFF);
                c2[s2 * 3 + 2] = (byte)(rgb[y2 * this.w + x2] & 0xFF);
                ++n2;
            }
        }
        byte[] pal = new byte[n2 * 3];
        System.arraycopy(c2, 0, pal, 0, n2 * 3);
        return pal;
    }
}

