/*
 * Decompiled with CFR 0.152.
 */
package com.annimon;

public class Quantize {
    private boolean QUICK = true;
    private int MAX_RGB = 255;
    private int MAX_NODES = 266817;
    private int MAX_TREE_DEPTH = 8;
    private int[] SQUARES = new int[this.MAX_RGB + this.MAX_RGB + 1];
    private int[] SHIFT;

    public Quantize() {
        int i2;
        for (i2 = -this.MAX_RGB; i2 <= this.MAX_RGB; ++i2) {
            this.SQUARES[i2 + this.MAX_RGB] = i2 * i2;
        }
        this.SHIFT = new int[this.MAX_TREE_DEPTH + 1];
        for (i2 = 0; i2 < this.MAX_TREE_DEPTH + 1; ++i2) {
            this.SHIFT[i2] = 1 << 15 - i2;
        }
    }

    public int[] quantizeImage(int[][] pixels, int max_colors) {
        Cube cube = new Cube(pixels, max_colors);
        cube.classification();
        cube.reduction();
        cube.assignment();
        return cube.colormap;
    }

    private class Cube {
        private int[][] pixels;
        private int max_colors;
        private int[] colormap;
        private Node root;
        private int depth;
        private int colors;
        private int nodes;

        private Cube(int[][] pixels, int max_colors) {
            this.pixels = pixels;
            this.max_colors = max_colors;
            int i2 = max_colors;
            this.depth = 1;
            while (i2 != 0) {
                i2 /= 4;
                ++this.depth;
            }
            if (this.depth > 1) {
                --this.depth;
            }
            if (this.depth > Quantize.this.MAX_TREE_DEPTH) {
                this.depth = Quantize.this.MAX_TREE_DEPTH;
            } else if (this.depth < 2) {
                this.depth = 2;
            }
            this.root = new Node(this);
        }

        private void classification() {
            int[][] pix = this.pixels;
            int width = pix.length;
            int height = pix[0].length;
            int x2 = width;
            while (x2-- > 0) {
                int y2 = height;
                while (y2-- > 0) {
                    int p2 = pix[x2][y2];
                    int red = p2 >> 16 & 0xFF;
                    int green = p2 >> 8 & 0xFF;
                    int blue = p2 & 0xFF;
                    if (this.nodes > Quantize.this.MAX_NODES) {
                        this.root.pruneLevel();
                        --this.depth;
                    }
                    Node node = this.root;
                    for (int level = 1; level <= this.depth; ++level) {
                        int id = (red > node.mid_red ? 1 : 0) | (green > node.mid_green ? 1 : 0) << 1 | (blue > node.mid_blue ? 1 : 0) << 2;
                        if (node.child[id] == null) {
                            new Node(node, id, level);
                        }
                        node = node.child[id];
                        node.number_pixels += Quantize.this.SHIFT[level];
                    }
                    ++node.unique;
                    node.total_red += red;
                    node.total_green += green;
                    node.total_blue += blue;
                }
            }
        }

        private void reduction() {
            int threshold = 1;
            while (this.colors > this.max_colors) {
                this.colors = 0;
                threshold = this.root.reduce(threshold, Integer.MAX_VALUE);
            }
        }

        private void assignment() {
            this.colormap = new int[this.colors];
            this.colors = 0;
            this.root.colormap();
            int[][] pix = this.pixels;
            int width = pix.length;
            int height = pix[0].length;
            Search search = new Search();
            int x2 = width;
            while (x2-- > 0) {
                int y2 = height;
                while (y2-- > 0) {
                    int pixel = pix[x2][y2];
                    int red = pixel >> 16 & 0xFF;
                    int green = pixel >> 8 & 0xFF;
                    int blue = pixel & 0xFF;
                    Node node = this.root;
                    while (true) {
                        int id = (red > node.mid_red ? 1 : 0) | (green > node.mid_green ? 1 : 0) << 1 | (blue > node.mid_blue ? 1 : 0) << 2;
                        if (node.child[id] == null) break;
                        node = node.child[id];
                    }
                    if (Quantize.this.QUICK) {
                        pix[x2][y2] = node.color_number;
                        continue;
                    }
                    search.distance = Integer.MAX_VALUE;
                    node.parent.closestColor(red, green, blue, search);
                    pix[x2][y2] = search.color_number;
                }
            }
        }

        private class Node {
            private Cube cube;
            private Node parent;
            private Node[] child;
            private int nchild;
            private int id;
            private int level;
            private int mid_red;
            private int mid_green;
            private int mid_blue;
            private int number_pixels;
            private int unique;
            private int total_red;
            private int total_green;
            private int total_blue;
            private int color_number;

            private Node(Cube cube2) {
                this.cube = cube2;
                this.parent = this;
                this.child = new Node[8];
                this.id = 0;
                this.level = 0;
                this.number_pixels = Integer.MAX_VALUE;
                this.mid_red = Quantize.this.MAX_RGB + 1 >> 1;
                this.mid_green = Quantize.this.MAX_RGB + 1 >> 1;
                this.mid_blue = Quantize.this.MAX_RGB + 1 >> 1;
            }

            private Node(Node parent, int id, int level) {
                this.cube = parent.cube;
                this.parent = parent;
                this.child = new Node[8];
                this.id = id;
                this.level = level;
                ++this.cube.nodes;
                if (level == this.cube.depth) {
                    ++this.cube.colors;
                }
                ++parent.nchild;
                parent.child[id] = this;
                int bi2 = 1 << Quantize.this.MAX_TREE_DEPTH - level >> 1;
                this.mid_red = parent.mid_red + ((id & 1) > 0 ? bi2 : -bi2);
                this.mid_green = parent.mid_green + ((id & 2) > 0 ? bi2 : -bi2);
                this.mid_blue = parent.mid_blue + ((id & 4) > 0 ? bi2 : -bi2);
            }

            private void pruneChild() {
                --this.parent.nchild;
                this.parent.unique += this.unique;
                this.parent.total_red += this.total_red;
                this.parent.total_green += this.total_green;
                this.parent.total_blue += this.total_blue;
                this.parent.child[this.id] = null;
                --this.cube.nodes;
                this.cube = null;
                this.parent = null;
            }

            private void pruneLevel() {
                if (this.nchild != 0) {
                    for (int id = 0; id < 8; ++id) {
                        if (this.child[id] == null) continue;
                        this.child[id].pruneLevel();
                    }
                }
                if (this.level == this.cube.depth) {
                    this.pruneChild();
                }
            }

            private int reduce(int threshold, int next_threshold) {
                if (this.nchild != 0) {
                    for (int id = 0; id < 8; ++id) {
                        if (this.child[id] == null) continue;
                        next_threshold = this.child[id].reduce(threshold, next_threshold);
                    }
                }
                if (this.number_pixels <= threshold) {
                    this.pruneChild();
                } else {
                    if (this.unique != 0) {
                        this.cube.colors++;
                    }
                    if (this.number_pixels < next_threshold) {
                        next_threshold = this.number_pixels;
                    }
                }
                return next_threshold;
            }

            private void colormap() {
                if (this.nchild != 0) {
                    for (int id = 0; id < 8; ++id) {
                        if (this.child[id] == null) continue;
                        this.child[id].colormap();
                    }
                }
                if (this.unique != 0) {
                    int r2 = (this.total_red + (this.unique >> 1)) / this.unique;
                    int g2 = (this.total_green + (this.unique >> 1)) / this.unique;
                    int b2 = (this.total_blue + (this.unique >> 1)) / this.unique;
                    ((Cube)this.cube).colormap[((Cube)this.cube).colors] = 0xFF000000 | (r2 & 0xFF) << 16 | (g2 & 0xFF) << 8 | (b2 & 0xFF) << 0;
                    this.color_number = this.cube.colors++;
                }
            }

            private void closestColor(int red, int green, int blue, Search search) {
                int color;
                int distance;
                if (this.nchild != 0) {
                    for (int id = 0; id < 8; ++id) {
                        if (this.child[id] == null) continue;
                        this.child[id].closestColor(red, green, blue, search);
                    }
                }
                if (this.unique != 0 && (distance = this.distance(color = this.cube.colormap[this.color_number], red, green, blue)) < search.distance) {
                    search.distance = distance;
                    search.color_number = this.color_number;
                }
            }

            private int distance(int color, int r2, int g2, int b2) {
                return Quantize.this.SQUARES[(color >> 16 & 0xFF) - r2 + Quantize.this.MAX_RGB] + Quantize.this.SQUARES[(color >> 8 & 0xFF) - g2 + Quantize.this.MAX_RGB] + Quantize.this.SQUARES[(color & 0xFF) - b2 + Quantize.this.MAX_RGB];
            }
        }

        private class Search {
            private int distance;
            private int color_number;

            private Search() {
            }
        }
    }
}

