/*
 * Decompiled with CFR 0.152.
 */
package com.lge.sensor;

import com.lge.sensor.ChannelImpl;
import com.lge.sensor.DataImpl;
import com.lge.sensor.SensorConnectionImpl;
import com.lge.sensor.SensorInfoImpl;
import java.util.Vector;
import javax.microedition.sensor.Condition;
import javax.microedition.sensor.ConditionListener;
import javax.microedition.sensor.Data;

public class ConditionMonitor
implements Runnable {
    private ChannelImpl channelImplObj;
    private Vector conditionVector;
    private Vector conditionListenerVector;
    private SensorConnectionImpl sensorconnection;
    private boolean canRun;
    private Data[] dataTaken;

    public ConditionMonitor(SensorConnectionImpl sensorConnectionImpl, ChannelImpl channelImpl) {
        this.sensorconnection = sensorConnectionImpl;
        this.channelImplObj = channelImpl;
    }

    public Condition[] getConditions() {
        if (this.conditionVector != null && this.conditionListenerVector != null) {
            int n = this.conditionVector.size();
            Object[] objectArray = new Condition[n];
            this.conditionVector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public synchronized Condition[] getConditions(ConditionListener conditionListener) {
        if (this.conditionVector != null && this.conditionListenerVector != null) {
            Vector<Condition> vector = new Vector<Condition>(1);
            int n = 0;
            Object[] objectArray = null;
            int n2 = this.conditionVector.size();
            for (n = 0; n < n2; ++n) {
                if ((ConditionListener)this.conditionListenerVector.elementAt(n) != conditionListener) continue;
                vector.addElement((Condition)this.conditionVector.elementAt(n));
            }
            n2 = vector.size();
            n = 0;
            objectArray = new Condition[n2];
            if (n2 > 0) {
                vector.copyInto(objectArray);
            }
            return objectArray;
        }
        return new Condition[0];
    }

    public synchronized void addConditionListener(ConditionListener conditionListener, Condition condition) {
        int n;
        if (this.conditionVector == null) {
            this.conditionVector = new Vector();
        }
        if (this.conditionListenerVector == null) {
            this.conditionListenerVector = new Vector();
        }
        if ((n = this.conditionVector.indexOf(condition)) == -1) {
            this.conditionListenerVector.addElement(conditionListener);
            this.conditionVector.addElement(condition);
            if (this.conditionListenerVector.size() == 1) {
                new Thread(this).start();
                this.canRun = true;
            }
        }
    }

    public synchronized void removeAllCondition() {
        if (this.conditionVector != null && this.conditionListenerVector != null) {
            this.conditionVector.removeAllElements();
            this.conditionListenerVector.removeAllElements();
            this.canRun = false;
        }
    }

    public synchronized void removeCondition(ConditionListener conditionListener, Condition condition) {
        if (this.conditionVector != null && this.conditionListenerVector != null) {
            int n = 0;
            int n2 = 0;
            n2 = this.conditionVector.indexOf(condition);
            if (n2 != -1 && (ConditionListener)this.conditionListenerVector.elementAt(n2) == conditionListener) {
                n = n2;
            }
            if (n != -1 && n2 != -1 && n == n2) {
                this.conditionVector.removeElementAt(n);
                this.conditionListenerVector.removeElementAt(n);
            }
            if (this.conditionListenerVector.size() == 0) {
                this.canRun = false;
            }
        }
    }

    public synchronized void removeConditionListener(ConditionListener conditionListener) {
        if (this.conditionVector != null && this.conditionListenerVector != null) {
            while (this.conditionListenerVector.contains(conditionListener)) {
                int n = this.conditionListenerVector.indexOf(conditionListener);
                this.conditionVector.removeElementAt(n);
                this.conditionListenerVector.removeElement(conditionListener);
            }
            if (this.conditionListenerVector.size() == 0) {
                this.canRun = false;
            }
        }
    }

    private Data getDataFromCollection(Data[] dataArray, String string) {
        DataImpl dataImpl = null;
        if (dataArray != null) {
            int n = 0;
            for (n = 0; n < dataArray.length && !dataArray[n].getChannelInfo().getName().equalsIgnoreCase(string); ++n) {
            }
            if (n < dataArray.length) {
                dataImpl = (DataImpl)dataArray[n];
            }
        }
        return dataImpl;
    }

    public void run() {
        int n = 0;
        ConditionListener conditionListener = null;
        Condition condition = null;
        SensorInfoImpl sensorInfoImpl = (SensorInfoImpl)this.channelImplObj.sensorconnection.getSensorInfo();
        int n2 = sensorInfoImpl.getMaxBufferSize();
        String string = this.channelImplObj.getChannelInfo().getName();
        int n3 = this.channelImplObj.getChannelInfo().getDataType();
        do {
            Data data = this.getDataFromCollection(this.sensorconnection.getAsyncData(n2), string);
            block3: for (n = 0; n < this.conditionListenerVector.size(); ++n) {
                int n4;
                Object[] objectArray;
                try {
                    conditionListener = (ConditionListener)this.conditionListenerVector.elementAt(n);
                    condition = (Condition)this.conditionVector.elementAt(n);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (n3 == 2) {
                    objectArray = data.getIntValues();
                    if (objectArray == null) continue;
                    for (n4 = 0; n4 < objectArray.length; ++n4) {
                        if (!condition.isMet(objectArray[n4])) continue;
                        conditionListener.conditionMet(this.channelImplObj.sensorconnection, data, condition);
                        this.removeCondition(conditionListener, condition);
                        --n;
                        conditionListener = null;
                        condition = null;
                        continue block3;
                    }
                    continue;
                }
                if (n3 == 1) {
                    objectArray = data.getDoubleValues();
                    if (objectArray == null) continue;
                    for (n4 = 0; n4 < objectArray.length; ++n4) {
                        if (!condition.isMet(objectArray[n4])) continue;
                        conditionListener.conditionMet(this.channelImplObj.sensorconnection, data, condition);
                        this.removeCondition(conditionListener, condition);
                        --n;
                        conditionListener = null;
                        condition = null;
                        continue block3;
                    }
                    continue;
                }
                if (n3 != 4 || (objectArray = (Object[])data.getObjectValues()) == null) continue;
                for (n4 = 0; n4 < objectArray.length; ++n4) {
                    if (!condition.isMet((Object)objectArray[n4])) continue;
                    conditionListener.conditionMet(this.channelImplObj.sensorconnection, data, condition);
                    this.removeCondition(conditionListener, condition);
                    --n;
                    conditionListener = null;
                    condition = null;
                    continue block3;
                }
            }
        } while (this.canRun);
    }
}

