/*
 * Decompiled with CFR 0.152.
 */
package com.lge.sensor;

import java.util.Hashtable;
import java.util.Vector;

public class ParseUrlLogic {
    private final char[] symbolArray = new char[]{'`', '~', '!', '@', '#', '$', '%', '^', '&', '*', '(', ')', '-', '_', '+', '?', '|', '/', ':', ';', ',', '.', '\"'};
    private final String[] sensorURLTokenArray = new String[]{"sensor:", "contexttype=", "model=", "location="};
    private final String[] sensorURLActualTokenArray = new String[]{"quantity", "contexttype", "model", "location"};
    private final String[] limitConditionArray = new String[]{"eq", "lt", "le", "ge", "gt"};
    private final String[] rangeConditionLowerOpArray = new String[]{"ge", "gt"};
    private final String[] rangeConditionUpperOpArray = new String[]{"le", "lt"};
    private Vector urlTokenVect = new Vector(4);
    private Vector urlTokenValueVect = new Vector(4);
    private final String[] limitOp = new String[]{"eq", "lt", "le", "ge", "gt"};
    private final int LIMIT_OP_SIZE;
    private final String[] rangeLowerOp = new String[]{"ge", "gt"};
    private final String[] rangeUpperOp = new String[]{"le", "lt"};
    private final int RANGE_UP_OP_SIZE;
    private final Hashtable pushHashTable = new Hashtable();
    private final Hashtable sensorURLHashTable = new Hashtable();
    private int suffix = 0;
    private int noOfPushChannels = 0;
    private static final char DELIMETER1 = '&';
    private static final char DELIMETER2 = '=';
    private static final int LEN4 = 4;
    private static final int LEN3 = 3;
    private static final int LEN2 = 2;
    private static final String sensorProtocol = "sensor:";

    public ParseUrlLogic() {
        this.LIMIT_OP_SIZE = 5;
        this.RANGE_UP_OP_SIZE = 2;
    }

    public void parseURL(String string) {
        String string2 = null;
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = string.indexOf(sensorProtocol);
        this.assertValue(n2);
        string = string.substring(sensorProtocol.length());
        this.assertValue(n2);
        string = "quantity:" + string;
        n2 = "quantity:".length() - 1;
        do {
            string2 = string.substring(n, n2);
            this.urlTokenVect.addElement(string2);
            n = n2 + 1;
            n2 = string.indexOf(";", n);
            if (n2 == -1) {
                n2 = string.indexOf("?", n);
                if (n2 == -1) {
                    n2 = string.length();
                } else {
                    bl2 = true;
                }
                bl = true;
            }
            this.urlTokenValueVect.addElement(string.substring(n, n2));
            n = n2 + 1;
            n2 = string.indexOf("=", n);
        } while (string.indexOf(";", n) != -1 || !bl);
        bl = false;
        if (bl2) {
            boolean bl3 = false;
            int n3 = 0;
            bl2 = false;
            this.urlTokenVect.addElement(string.substring(string.indexOf("?", 0) + 1, n2));
            n3 = string.indexOf("&", n2);
            this.assertValue(n2);
            this.urlTokenValueVect.addElement(string.substring(n2 + 1, n3));
            do {
                int n4;
                String string3;
                String string4 = null;
                int n5 = string.length();
                n2 = string.indexOf("=", n3);
                string4 = string.substring(n3 + 1, n2);
                if (string4.equals("channel")) {
                    this.urlTokenVect.addElement(string4);
                    n3 = string.indexOf("&", n2);
                    this.urlTokenValueVect.addElement(string.substring(n2 + 1, n3));
                    continue;
                }
                if (string4.equals("limit")) {
                    string3 = null;
                    this.urlTokenVect.addElement(string4);
                    n3 = string.indexOf("&", n2);
                    string3 = string.substring(n2 + 1, n3);
                    this.urlTokenValueVect.addElement(string3);
                    n2 = string.indexOf("=", n3);
                    this.assertValue(n2);
                    string4 = string.substring(n3 + 1, n2);
                    if (string4.equals("op")) {
                        n3 = string.indexOf("&", n2);
                        if (n3 == -1) {
                            n3 = n5;
                            bl = true;
                        }
                        string3 = string.substring(n2 + 1, n3);
                        for (n4 = 0; n4 < 5; ++n4) {
                            if (!string3.equals(this.limitOp[n4])) continue;
                            this.urlTokenVect.addElement(string4);
                            this.urlTokenValueVect.addElement(string3);
                            bl3 = true;
                            break;
                        }
                        if (!bl3) {
                            throw new IllegalArgumentException("Error in Contion");
                        }
                        bl3 = false;
                        continue;
                    }
                    throw new IllegalArgumentException("op parameter missing.");
                }
                if (!string4.equals("lowerLimit") && (!string4.equals("upperLimit") || !bl2)) continue;
                string3 = null;
                this.urlTokenVect.addElement(string4);
                n3 = string.indexOf("&", n2);
                this.assertValue(n2);
                string3 = string.substring(n2 + 1, n3);
                this.urlTokenValueVect.addElement(string3);
                n2 = string.indexOf("=", n3);
                this.assertValue(n2);
                string4 = string.substring(n3 + 1, n2);
                if (string4.equals("lowerOp") || string4.equals("upperOp") && bl2) {
                    n3 = string.indexOf("&", n2);
                    if (!bl2) {
                        this.assertValue(n3);
                    }
                    if (n3 == -1) {
                        if (bl2) {
                            n3 = n5;
                            bl = true;
                        } else {
                            throw new IllegalArgumentException("lowerOp value not specified.");
                        }
                    }
                    string3 = string.substring(n2 + 1, n3);
                    for (n4 = 0; n4 < 2; ++n4) {
                        String string5 = null;
                        string5 = bl2 ? this.rangeUpperOp[n4] : this.rangeLowerOp[n4];
                        if (!string3.equals(string5)) continue;
                        this.urlTokenVect.addElement(string4);
                        this.urlTokenValueVect.addElement(string3);
                        bl3 = true;
                        break;
                    }
                    if (!bl3) {
                        throw new IllegalArgumentException("Error in Contion");
                    }
                    bl3 = false;
                    bl2 = true;
                    continue;
                }
                throw new IllegalArgumentException("lowerOp parameter missing.");
            } while (!bl);
        }
    }

    private String getQuantity() {
        int n = this.urlTokenVect.indexOf("quantity");
        this.assertValue(n);
        return this.urlTokenValueVect.elementAt(n).toString();
    }

    private String getContextType() {
        int n = this.urlTokenVect.indexOf("contextType");
        this.assertValue(n);
        return this.urlTokenValueVect.elementAt(n).toString();
    }

    private String getModel() {
        int n = this.urlTokenVect.indexOf("model");
        this.assertValue(n);
        return this.urlTokenValueVect.elementAt(n).toString();
    }

    private String getLocation() {
        int n = this.urlTokenVect.indexOf("location");
        this.assertValue(n);
        return this.urlTokenValueVect.elementAt(n).toString();
    }

    public String[] getSensorUrlContents() {
        String[] stringArray = new String[4];
        try {
            stringArray[0] = this.getQuantity();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Invalid Url");
        }
        try {
            stringArray[1] = this.getContextType();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringArray[1] = null;
        }
        try {
            stringArray[2] = this.getModel();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringArray[2] = null;
        }
        try {
            stringArray[3] = this.getLocation();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringArray[3] = null;
        }
        return stringArray;
    }

    private boolean assertValue(int n) {
        boolean bl = false;
        if (n == -1) {
            throw new IllegalArgumentException("ERROR");
        }
        bl = true;
        return bl;
    }

    public Hashtable getPushUrlContents() {
        return this.pushHashTable;
    }

    public int getNoOfChannels() {
        return this.noOfPushChannels;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parsePushURL(String string) {
        int n = -1;
        String string2 = string;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string3 = null;
        boolean bl = true;
        int n5 = 0;
        int n6 = 1;
        int n7 = 1;
        int n8 = 0;
        int n9 = 0;
        do {
            if ((n = string2.indexOf("channel")) == -1) {
                bl = false;
                break;
            }
            ++n2;
            n5 = string2.indexOf(38, n + 1);
            if (n5 == -1) {
                throw new IllegalArgumentException("Invalid Push URL");
            }
            string2 = string2.substring(n5 + 1);
        } while (bl);
        this.noOfPushChannels = n2;
        string2 = string;
        for (int i = 1; i <= n2; ++i) {
            n6 = 1;
            n7 = 1;
            n8 = 0;
            n9 = 0;
            n4 = string2.indexOf(61);
            n3 = string2.indexOf(38);
            this.pushHashTable.put("channel" + i + "", string2.substring(n4 + 1, n3));
            string2 = string2.substring(n3 + 1);
            n4 = string2.indexOf(61);
            string3 = string2.substring(0, n4);
            while (string2.indexOf(38) != -1) {
                n4 = string2.indexOf(61);
                string3 = string2.substring(0, n4);
                if (string3.equalsIgnoreCase("limit")) {
                    n3 = string2.indexOf(38);
                    n4 = string2.indexOf(61);
                    this.pushHashTable.put("limit" + i + "" + n6 + "", string2.substring(n4 + 1, n3));
                    string2 = string2.substring(n3 + 1);
                    n4 = string2.indexOf(61);
                    string3 = string2.substring(0, n4);
                    if (!string3.equalsIgnoreCase("op")) throw new IllegalArgumentException("Invalid Push URL");
                    n3 = string2.indexOf(38);
                    if (n3 == -1) {
                        n4 = string2.indexOf(61);
                        this.pushHashTable.put("op" + i + "" + n6 + "", string2.substring(n4 + 1));
                    } else {
                        n4 = string2.indexOf(61);
                        this.pushHashTable.put("op" + i + "" + n6 + "", string2.substring(n4 + 1, n3));
                        string2 = string2.substring(n3 + 1);
                    }
                    ++n6;
                    this.pushHashTable.put("limitCount" + i + "", String.valueOf(++n8));
                }
                if (string3.equalsIgnoreCase("LowerLimit")) {
                    n3 = string2.indexOf(38);
                    n4 = string2.indexOf(61);
                    this.pushHashTable.put("lowerLimit" + i + "" + n7 + "", string2.substring(n4 + 1, n3));
                    string2 = string2.substring(n3 + 1);
                    n4 = string2.indexOf(61);
                    string3 = string2.substring(0, n4);
                    if (!string3.equalsIgnoreCase("lowerOp")) throw new IllegalArgumentException("Invalid Push URL");
                    n3 = string2.indexOf(38);
                    this.pushHashTable.put("lowerOp" + i + "" + n7 + "", string2.substring(n4 + 1, n3));
                    string2 = string2.substring(n3 + 1);
                    n4 = string2.indexOf(61);
                    string3 = string2.substring(0, n4);
                    if (!string3.equalsIgnoreCase("upperLimit")) throw new IllegalArgumentException("Invalid Push URL");
                    n3 = string2.indexOf(38);
                    this.pushHashTable.put("upperLimit" + i + "" + n7 + "", string2.substring(n4 + 1, n3));
                    string2 = string2.substring(n3 + 1);
                    n4 = string2.indexOf(61);
                    string3 = string2.substring(0, n4);
                    if (string3.equalsIgnoreCase("upperOp")) {
                        n3 = string2.indexOf(38);
                        if (n3 == -1) {
                            this.pushHashTable.put("upperOp" + i + "" + n7 + "", string2.substring(n4 + 1));
                        } else {
                            this.pushHashTable.put("upperOp" + i + "" + n7 + "", string2.substring(n4 + 1, n3));
                            string2 = string2.substring(n3 + 1);
                        }
                    }
                    ++n7;
                    this.pushHashTable.put("rangeCount" + i + "", String.valueOf(++n9));
                }
                if (string2.indexOf("channel=") != 0) continue;
            }
        }
    }

    public boolean isAlphaNumStr(String string) {
        for (int i = 0; i < this.symbolArray.length; ++i) {
            if (string.indexOf(this.symbolArray[i]) == -1) continue;
            return false;
        }
        return true;
    }

    public boolean isLimitConditionOp(String string) {
        for (int i = 0; i < this.limitConditionArray.length; ++i) {
            if (!this.limitConditionArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isRangeConditionLowerOp(String string) {
        for (int i = 0; i < this.rangeConditionLowerOpArray.length; ++i) {
            if (!this.rangeConditionLowerOpArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isRangeConditionUpperOp(String string) {
        for (int i = 0; i < this.rangeConditionUpperOpArray.length; ++i) {
            if (!this.rangeConditionUpperOpArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validateSensorPushURL(String string) {
        int n;
        int n2 = -1;
        int n3 = -1;
        String string2 = string;
        String string3 = null;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        String string4 = null;
        int n7 = 0;
        boolean bl = true;
        if (string.indexOf(sensorProtocol) != 0) {
            throw new IllegalArgumentException("Invalid Push URL");
        }
        string2 = string;
        for (n = 0; n < this.sensorURLTokenArray.length; ++n) {
            if (string2.indexOf(this.sensorURLTokenArray[n]) == -1) continue;
            if (string2.indexOf(this.sensorURLTokenArray[n]) != 0) {
                throw new IllegalArgumentException("Invalid Push URL");
            }
            if ((string2 = string2.substring(this.sensorURLTokenArray[n].length())).indexOf(this.sensorURLTokenArray[n]) != -1) {
                throw new IllegalArgumentException("Invalid Push URL");
            }
            n2 = string2.indexOf(";");
            if (n2 == -1) {
                n2 = string2.indexOf("?");
            }
            if (!this.isAlphaNumStr(string4 = n2 != -1 ? string2.substring(0, n2) : string2)) {
                throw new IllegalArgumentException("Invalid Push URL");
            }
            this.sensorURLHashTable.put(this.sensorURLActualTokenArray[n], string4);
            if (n2 == -1) break;
            string2 = string2.substring(string4.length() + 1);
        }
        string3 = string2;
        do {
            if ((n3 = string2.indexOf("channel")) == -1) {
                bl = false;
                break;
            }
            ++n4;
            n7 = string2.indexOf(38, n3 + 1);
            if (n7 == -1) {
                throw new IllegalArgumentException("Invalid Push URL");
            }
            string2 = string2.substring(n7 + 1);
        } while (bl);
        this.noOfPushChannels = n4;
        string2 = string3;
        for (n = 1; n <= n4; ++n) {
            int n8 = 1;
            int n9 = 1;
            String string5 = null;
            String string6 = null;
            n6 = string2.indexOf(61);
            string4 = string2.substring(n6 + 1, n5 = string2.indexOf(38));
            if (!this.isAlphaNumStr(string4)) throw new IllegalArgumentException("Invalid Push URL");
            if (this.pushHashTable.contains(string4)) {
                throw new IllegalArgumentException("Invalid Push URL");
            }
            this.pushHashTable.put("channel" + n + "", string4);
            string2 = string2.substring(n5 + 1);
            while (string2.indexOf(38) != -1) {
                n6 = string2.indexOf(61);
                string4 = string2.substring(0, n6);
                if (string4.equalsIgnoreCase("limit")) {
                    n5 = string2.indexOf(38);
                    n6 = string2.indexOf(61);
                    if (n5 == -1 || n6 == -1 || n5 <= n6 + 1) {
                        throw new IllegalArgumentException("Invalid Push URL");
                    }
                    string4 = string2.substring(n6 + 1, n5);
                    this.pushHashTable.put("limit" + n8 + "", string4);
                    string2 = string2.substring(n5 + 1);
                    n6 = string2.indexOf(61);
                    string4 = string2.substring(0, n6);
                    if (!string4.equalsIgnoreCase("op")) throw new IllegalArgumentException("Invalid Push URL");
                    n5 = string2.indexOf(38);
                    if (n5 == -1) {
                        n6 = string2.indexOf(61);
                        string4 = string2.substring(n6 + 1);
                        if (!this.isLimitConditionOp(string4)) throw new IllegalArgumentException("Invalid Push URL");
                        this.pushHashTable.put("op" + n8 + "", string4);
                    } else {
                        n6 = string2.indexOf(61);
                        string4 = string2.substring(n6 + 1, n5);
                        if (!this.isLimitConditionOp(string4)) {
                            throw new IllegalArgumentException("Invalid Push URL");
                        }
                        this.pushHashTable.put("op" + n8 + "", string4);
                        string2 = string2.substring(n5 + 1);
                    }
                    ++n8;
                } else if (string4.equalsIgnoreCase("LowerLimit")) {
                    n5 = string2.indexOf(38);
                    n6 = string2.indexOf(61);
                    if (n5 == -1 || n6 == -1 || n5 <= n6 + 1) {
                        throw new IllegalArgumentException("Invalid Push URL");
                    }
                    string4 = string2.substring(n6, n5);
                    this.pushHashTable.put("lowerLimit" + n9 + "", string4);
                    string2 = string2.substring(n5 + 1);
                    n6 = string2.indexOf(61);
                    string4 = string2.substring(0, n6);
                    if (!string4.equalsIgnoreCase("lowerOp")) throw new IllegalArgumentException("Invalid Push URL");
                    n5 = string2.indexOf(38);
                    if (n5 == -1 || n6 == -1 || n5 <= n6 + 1) throw new IllegalArgumentException("Invalid Push URL");
                    string4 = string2.substring(n6 + 1, n5);
                    if (!this.isRangeConditionLowerOp(string4)) {
                        throw new IllegalArgumentException("Invalid Push URL");
                    }
                    this.pushHashTable.put("lowerOp" + n9 + "", string4);
                    string5 = string4;
                    string2 = string2.substring(n5 + 1);
                    n6 = string2.indexOf(61);
                    string4 = string2.substring(0, n6);
                    if (!string4.equalsIgnoreCase("upperLimit")) throw new IllegalArgumentException("Invalid Push URL");
                    n5 = string2.indexOf(38);
                    if (n5 == -1 || n6 == -1 || n5 <= n6 + 1) {
                        throw new IllegalArgumentException("Invalid Push URL");
                    }
                    string4 = string2.substring(n6 + 1, n5);
                    this.pushHashTable.put("upperLimit" + n9 + "", string4);
                    string2 = string2.substring(n5 + 1);
                    n6 = string2.indexOf(61);
                    string4 = string2.substring(0, n6);
                    if (!string4.equalsIgnoreCase("upperOp")) throw new IllegalArgumentException("Invalid Push URL");
                    n5 = string2.indexOf(38);
                    if (n5 == -1) {
                        string4 = string2.substring(n6 + 1);
                        if (!this.isRangeConditionUpperOp(string4)) {
                            throw new IllegalArgumentException("Invalid Push URL");
                        }
                        this.pushHashTable.put("upperOp" + n9 + "", string4);
                        string6 = string4;
                    } else {
                        string4 = string2.substring(n6 + 1, n5);
                        if (!this.isRangeConditionUpperOp(string4)) {
                            throw new IllegalArgumentException("Invalid Push URL");
                        }
                        this.pushHashTable.put("upperOp" + n9 + "", string4);
                        string6 = string4;
                        string2 = string2.substring(n5 + 1);
                    }
                    ++n9;
                }
                if (string2.indexOf("channel=") != 0) continue;
            }
        }
    }
}

