/*
 * Decompiled with CFR 0.152.
 */
package com.lge.sensor;

import com.lge.sensor.ChannelInfoImpl;
import com.lge.sensor.SensorContainer;
import java.util.Vector;
import javax.microedition.sensor.ChannelInfo;
import javax.microedition.sensor.SensorInfo;

public class SensorInfoImpl
implements SensorInfo {
    int sensorID;
    int connectionType;
    String quantity;
    String contextType;
    ChannelInfoImpl[] channelInfo;
    String sensorDescription;
    boolean prop_location;
    boolean prop_longitude;
    boolean prop_lattitude;
    public boolean prop_isControllable;
    public byte supportedControls;
    boolean prop_isReportingErrors;
    float maxSamplingRate;
    String vendor;
    String version;
    boolean isConditionPushSupported;
    boolean isAvailabilityPushSupported;
    int numberOfChannel;
    private int numberOfSupportedErrorCodes;
    private final int defaultMaxBufferSize;

    public SensorInfoImpl() {
        this.defaultMaxBufferSize = 256;
    }

    public int getSensorID() {
        return this.sensorID;
    }

    public ChannelInfo[] getChannelInfos() {
        return this.channelInfo;
    }

    public int getConnectionType() {
        return this.connectionType;
    }

    public String getContextType() {
        return this.contextType;
    }

    public String getDescription() {
        return this.sensorDescription;
    }

    public int getMaxBufferSize() {
        int n = SensorInfoImpl.nGetMaxBufferSize(this.sensorID);
        if (n < 256) {
            n = 256;
        }
        return n;
    }

    public String getModel() {
        return this.vendor;
    }

    public Object getProperty(String string) {
        if (string == null) {
            throw new NullPointerException("name cannot be NULL");
        }
        int n = SensorContainer.propertyNames.length;
        int n2 = 0;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            if (!string.equals(SensorContainer.propertyNames[i])) continue;
            n2 = i;
            bl = true;
            break;
        }
        if (!bl) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                if (this.prop_isControllable) {
                    return Boolean.TRUE;
                }
                throw new IllegalArgumentException();
            }
            case 1: {
                if (this.prop_isReportingErrors) {
                    return Boolean.TRUE;
                }
                throw new IllegalArgumentException();
            }
            case 2: {
                if (this.prop_lattitude) {
                    double d = SensorInfoImpl.nGetLatitude(this.sensorID);
                    return new Double(d);
                }
                throw new IllegalArgumentException();
            }
            case 3: {
                if (this.prop_location) {
                    String string2 = SensorInfoImpl.nGetLocation(this.sensorID);
                    return string2;
                }
                throw new IllegalArgumentException();
            }
            case 4: {
                if (this.prop_longitude) {
                    double d = SensorInfoImpl.nGetLongitude(this.sensorID);
                    return new Double(d);
                }
                throw new IllegalArgumentException();
            }
            case 5: {
                if (this.maxSamplingRate != 0.0f) {
                    return new Float(this.maxSamplingRate);
                }
                throw new IllegalArgumentException();
            }
            case 6: {
                if (this.vendor != null) {
                    return this.vendor;
                }
                throw new IllegalArgumentException();
            }
            case 7: {
                if (this.version != null) {
                    return this.version;
                }
                throw new IllegalArgumentException();
            }
        }
        throw new IllegalArgumentException();
    }

    public String[] getPropertyNames() {
        Vector<String> vector = new Vector<String>();
        if (this.prop_isControllable) {
            vector.addElement("controllable");
        }
        if (this.prop_isReportingErrors) {
            vector.addElement("errorsReported");
        }
        if (this.prop_lattitude) {
            vector.addElement("latitude");
        }
        if (this.prop_location) {
            vector.addElement("location");
        }
        if (this.prop_longitude) {
            vector.addElement("longitude");
        }
        if (this.maxSamplingRate > 0.0f) {
            vector.addElement("maxSamplingRate");
        }
        if (this.vendor != null) {
            vector.addElement("vendor");
        }
        if (this.version != null) {
            vector.addElement("version");
        }
        int n = vector.size();
        Object[] objectArray = new String[n];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String getQuantity() {
        return this.quantity;
    }

    public String getUrl() {
        String string = null;
        String string2 = this.getContextType();
        String string3 = this.getModel();
        string = "sensor:" + this.getQuantity();
        if (string2 != null) {
            string = string + ";contextType=" + string2;
        }
        if (string3 != null) {
            string = string + ";model=" + string3;
        }
        if (this.prop_location) {
            string = string + ";location=" + SensorInfoImpl.nGetLocation(this.sensorID);
        }
        return string;
    }

    public boolean isAvailabilityPushSupported() {
        return this.isAvailabilityPushSupported;
    }

    public boolean isAvailable() {
        return SensorInfoImpl.nIsAvailable(this.sensorID);
    }

    public boolean isConditionPushSupported() {
        return this.isConditionPushSupported;
    }

    public int getNumberOfChannels() {
        return this.numberOfChannel;
    }

    private static native double nGetLatitude(int var0);

    private static native boolean nIsAvailable(int var0);

    private static native String nGetLocation(int var0);

    private static native double nGetLongitude(int var0);

    private static native int nGetMaxBufferSize(int var0);
}

