/*
 * Decompiled with CFR 0.152.
 */
package com.lge.sensor;

import com.lge.sensor.SensorInfoImpl;
import java.util.Vector;
import javax.microedition.sensor.SensorInfo;
import javax.microedition.sensor.SensorListener;

public class SensorMonitor
implements Runnable {
    private static Vector sensorInfoVector;
    private static Vector sensorListenerVector;
    private static int sizeOfMap;
    private static boolean canRun;
    private static final int NO_CHANGE_STATE = 2;
    private static final int SENSOR_AVAILABLE = 1;
    private static final int SENSOR_UNAVAILABLE = 0;
    private int sensorMonitorID = this.nInitializeSensorMonitor();

    private native int nInitializeSensorMonitor();

    private static native int ngetSensorStatus(int var0);

    private static native void nregisterSensorListeners(int[] var0, int[] var1, int var2);

    private native void nFinalize();

    private SensorMonitor() {
    }

    public void run() {
        int n;
        int n2 = sensorInfoVector.size();
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray[n] = ((SensorInfoImpl)sensorInfoVector.elementAt(n)).getSensorID();
        }
        do {
            if (sizeOfMap != n2) {
                nArray = null;
                nArray2 = null;
                nArray = new int[sizeOfMap];
                nArray2 = new int[sizeOfMap];
                n2 = sizeOfMap;
                for (n = 0; n < n2; ++n) {
                    nArray[n] = ((SensorInfoImpl)sensorInfoVector.elementAt(n)).getSensorID();
                }
            }
            SensorMonitor.nregisterSensorListeners(nArray, nArray2, this.sensorMonitorID);
            for (n = 0; n < n2; ++n) {
                if (nArray2[n] >= 2) continue;
                SensorInfoImpl sensorInfoImpl = (SensorInfoImpl)sensorInfoVector.elementAt(n);
                SensorListener sensorListener = (SensorListener)sensorListenerVector.elementAt(n);
                if (nArray2[n] == 0) {
                    sensorListener.sensorUnavailable(sensorInfoImpl);
                    continue;
                }
                if (nArray2[n] != 1) continue;
                sensorListener.sensorAvailable(sensorInfoImpl);
            }
        } while (canRun);
        this.nFinalize();
    }

    public static void addSensorInfoMap(SensorListener sensorListener, SensorInfo sensorInfo) {
        int n = -1;
        if (sensorInfoVector == null) {
            sensorInfoVector = new Vector(1);
        }
        if (sensorListenerVector == null) {
            sensorListenerVector = new Vector(1);
        }
        if ((n = sensorInfoVector.indexOf(sensorInfo)) == -1) {
            int n2 = -1;
            int n3 = -1;
            sensorListenerVector.addElement(sensorListener);
            sensorInfoVector.addElement((SensorInfoImpl)sensorInfo);
            n3 = ((SensorInfoImpl)sensorInfo).getSensorID();
            n2 = SensorMonitor.ngetSensorStatus(n3);
            if (n2 == 1) {
                sensorListener.sensorAvailable(sensorInfo);
            } else if (n2 == 0) {
                sensorListener.sensorUnavailable(sensorInfo);
            }
            if (sensorListenerVector.size() == 1) {
                new Thread(new SensorMonitor()).start();
                canRun = true;
            }
            sizeOfMap = sensorInfoVector.size();
        }
    }

    public static void removeSensorInfoMap(SensorListener sensorListener) {
        if (sensorInfoVector != null && sensorListenerVector != null && sensorListenerVector.contains(sensorListener)) {
            for (int i = 0; i < sensorInfoVector.size(); ++i) {
                if (sensorListener != (SensorListener)sensorListenerVector.elementAt(i)) continue;
                sensorListenerVector.removeElementAt(i);
                sensorInfoVector.removeElementAt(i);
                sizeOfMap = sensorInfoVector.size();
                --i;
            }
            if (sensorInfoVector.size() == 0) {
                canRun = false;
            }
        } else {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SensorInfo[] getSensorInfos(SensorListener sensorListener) {
        SensorInfoImpl[] sensorInfoImplArray = null;
        int n = 0;
        if (sensorInfoVector == null) {
            n = 0;
        } else {
            Vector vector = new Vector();
            n = sensorInfoVector.size();
            SensorMonitor sensorMonitor = this;
            synchronized (sensorMonitor) {
                for (int i = 0; i < n; ++i) {
                    int n2 = sensorListenerVector.indexOf(sensorListener);
                    if (n2 <= 0) continue;
                    vector.addElement(sensorInfoVector.elementAt(n2));
                }
            }
            n = vector.size();
            sensorInfoImplArray = new SensorInfoImpl[n];
            for (int i = 0; i < n; ++i) {
                sensorInfoImplArray[i] = (SensorInfoImpl)vector.elementAt(i);
            }
        }
        return sensorInfoImplArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SensorListener[] getSensorListener(SensorInfo sensorInfo) {
        SensorListener[] sensorListenerArray = null;
        Vector vector = new Vector();
        int n = sensorListenerVector.size();
        SensorMonitor sensorMonitor = this;
        synchronized (sensorMonitor) {
            for (int i = 0; i < n; ++i) {
                int n2 = sensorInfoVector.indexOf(sensorInfo);
                if (n2 <= 0) continue;
                vector.addElement(sensorListenerVector.elementAt(n2));
            }
        }
        n = vector.size();
        sensorListenerArray = new SensorListener[n];
        for (int i = 0; i < n; ++i) {
            sensorListenerArray[i] = (SensorListener)vector.elementAt(i);
        }
        return sensorListenerArray;
    }
}

