/*
 * Decompiled with CFR 0.152.
 */
package com.lge.sensor.control;

import com.lge.sensor.SensorInfoImpl;
import javax.microedition.sensor.ChannelInfo;
import javax.microedition.sensor.MeasurementRange;
import javax.microedition.sensor.control.MeasurementRangeControl;

public class MeasurementRangeControlImpl
implements MeasurementRangeControl {
    private int sensorID;
    private int instanceID;
    private boolean controlable;
    private MeasurementRange[] measurementRanges;
    private SensorInfoImpl sensorInfo;
    private static final int SMALLEST_VALUE = 0;
    private static final int LARGEST_VALUE = 1;
    private static final int RESOLUTION_VALUE = 2;

    private native void ngetMeasurementRange(int var1, int var2, String var3, double[] var4);

    private native boolean nsetMeasurementRange(int var1, int var2, String var3, double var4, double var6, double var8);

    public MeasurementRangeControlImpl(SensorInfoImpl sensorInfoImpl, int n) {
        this.sensorID = sensorInfoImpl.getSensorID();
        this.instanceID = n;
        Boolean bl = (Boolean)sensorInfoImpl.getProperty("controllable");
        this.controlable = bl;
        this.sensorInfo = sensorInfoImpl;
    }

    public void execute() {
        try {
            ChannelInfo[] channelInfoArray = this.sensorInfo.getChannelInfos();
            for (int i = 0; i < channelInfoArray.length; ++i) {
                this.setMeasurementRange(channelInfoArray[i], channelInfoArray[i].getMeasurementRanges()[0]);
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException();
        }
    }

    public String getName() {
        return "MeasurementRangeControl";
    }

    public MeasurementRange getMeasurementRange(ChannelInfo channelInfo) {
        double[] dArray = new double[3];
        if (channelInfo == null) {
            throw new NullPointerException();
        }
        if (channelInfo.getDataType() == 4) {
            throw new IllegalArgumentException();
        }
        this.ngetMeasurementRange(this.sensorID, this.instanceID, channelInfo.getName(), dArray);
        MeasurementRange[] measurementRangeArray = channelInfo.getMeasurementRanges();
        for (int i = 0; i < measurementRangeArray.length; ++i) {
            if (measurementRangeArray[i].getSmallestValue() != dArray[0] || measurementRangeArray[i].getLargestValue() != dArray[1] || measurementRangeArray[i].getResolution() != dArray[2]) continue;
            return measurementRangeArray[i];
        }
        return null;
    }

    public void setMeasurementRange(ChannelInfo channelInfo, MeasurementRange measurementRange) {
        if (channelInfo == null || measurementRange == null) {
            throw new NullPointerException();
        }
        MeasurementRange[] measurementRangeArray = channelInfo.getMeasurementRanges();
        int n = measurementRangeArray.length;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            if (measurementRangeArray[i].getLargestValue() != measurementRange.getLargestValue() || measurementRangeArray[i].getResolution() != measurementRange.getResolution() || measurementRangeArray[i].getSmallestValue() != measurementRange.getSmallestValue()) continue;
            bl = true;
            break;
        }
        if (channelInfo.getDataType() == 4 || !bl) {
            throw new IllegalArgumentException();
        }
        if (!this.nsetMeasurementRange(this.sensorID, this.instanceID, channelInfo.getName(), measurementRange.getSmallestValue(), measurementRange.getLargestValue(), measurementRange.getResolution())) {
            throw new IllegalStateException();
        }
    }
}

