/*
 * Decompiled with CFR 0.152.
 */
package com.lge.sensor.control;

import com.lge.sensor.SensorInfoImpl;
import javax.microedition.sensor.control.SampleRateControl;

public class SampleRateControlImpl
implements SampleRateControl {
    private int sensorID;
    private int instanceID;
    private float[] sampleRate;
    boolean controlable;
    private float MaxSampleRate;

    private native int ngetNumSampleRates(int var1);

    private native void ngetSampleRates(int var1, float[] var2);

    private native float ngetSampleRate(int var1, int var2);

    private native boolean nsetSampleRate(int var1, int var2, float var3);

    public SampleRateControlImpl(SensorInfoImpl sensorInfoImpl, int n) {
        this.sensorID = sensorInfoImpl.getSensorID();
        this.instanceID = n;
        Float f = (Float)sensorInfoImpl.getProperty("maxSamplingRate");
        this.MaxSampleRate = f.floatValue();
        Boolean bl = (Boolean)sensorInfoImpl.getProperty("controllable");
        this.controlable = bl;
    }

    public void execute() {
        try {
            this.setSampleRate(this.getSampleRates()[0]);
        }
        catch (Exception exception) {
            throw new IllegalStateException();
        }
    }

    public String getName() {
        return "SampleRateControl";
    }

    public float getSampleRate() {
        return this.ngetSampleRate(this.sensorID, this.instanceID);
    }

    public float[] getSampleRates() {
        int n = 0;
        n = this.ngetNumSampleRates(this.sensorID);
        this.sampleRate = new float[n];
        this.ngetSampleRates(this.sensorID, this.sampleRate);
        return this.sampleRate;
    }

    public void setSampleRate(float f) {
        if (f <= 0.0f || f > this.MaxSampleRate) {
            throw new IllegalArgumentException("sampleRate is not a valid value");
        }
        float[] fArray = this.getSampleRates();
        int n = fArray.length;
        if (n == 0) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < n; ++i) {
            if (fArray[i] != f) continue;
            if (this.nsetSampleRate(this.sensorID, this.instanceID, f)) {
                return;
            }
            throw new IllegalStateException();
        }
        throw new IllegalArgumentException();
    }
}

