/*
 * Decompiled with CFR 0.152.
 */
package Application;

import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;

public class GUI
extends Canvas {
    private int state = 0;
    private final int playersCount;
    private Player[] player = new Player[3];
    private Player curPlayer;
    private final int imagesCount;
    private Image[] images = new Image[3];
    private Image aboutImage;
    private int currentImage = 0;
    private int lastI = -1;
    private int count = 0;
    private String mode = "main";

    public GUI() {
        this.playersCount = 3;
        this.imagesCount = 3;
    }

    public void init() {
        this.setFullScreenMode(true);
        try {
            int i;
            for (i = 0; i < 3; ++i) {
                if (this.player[i] == null) continue;
                this.player[i] = null;
            }
            System.gc();
            for (i = 0; i < 3; ++i) {
                InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("/" + Integer.toString(i) + ".mp3");
                this.player[i] = Manager.createPlayer((InputStream)in, (String)"audio/mpeg");
                this.player[i].prefetch();
            }
            this.aboutImage = Image.createImage((String)"/about.png");
            for (i = 0; i < 3; ++i) {
                this.images[i] = Image.createImage((String)("/" + Integer.toString(i) + ".jpg"));
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return;
        }
        catch (MediaException e) {
            e.printStackTrace();
            return;
        }
    }

    public void setState(int value) {
        if (this.state == value) {
            return;
        }
        this.state = value;
        if (this.state == 1) {
            PlayerLaunch pl = new PlayerLaunch();
            pl.start();
        }
        this.repaint();
    }

    public void playSound() {
        try {
            if (this.curPlayer != null) {
                this.curPlayer.stop();
            }
            Random random = new Random();
            int i = Math.abs(random.nextInt()) % 3;
            while (i == this.lastI) {
                i = Math.abs(random.nextInt()) % 3;
            }
            InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("/" + Integer.toString(i) + ".mp3");
            this.lastI = i;
            this.player[i] = Manager.createPlayer((InputStream)in, (String)"audio/mpeg");
            this.player[i].prefetch();
            this.curPlayer = this.player[i];
            this.curPlayer.start();
        }
        catch (IOException ioe) {
        }
        catch (MediaException e) {
            return;
        }
    }

    protected void keyPressed(int keyCode) {
        if (keyCode == -7) {
            --this.currentImage;
            if (this.currentImage < 0) {
                this.currentImage = 2;
            }
            this.repaint();
        }
        if (keyCode == -10) {
            ++this.currentImage;
            if (this.currentImage >= 3) {
                this.currentImage = 0;
            }
            this.repaint();
        }
    }

    protected void pointerPressed(int x, int y) {
        if (this.mode.equals("about")) {
            this.mode = "main";
            this.repaint();
            return;
        }
        if (x >= this.getWidth() - this.aboutImage.getWidth() && y >= this.getHeight() - this.aboutImage.getHeight()) {
            this.mode = "about";
            this.repaint();
        } else {
            ++this.currentImage;
            if (this.currentImage >= 3) {
                this.currentImage = 0;
            }
            this.repaint();
        }
    }

    protected void paint(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.drawImage(this.images[this.currentImage], (this.getWidth() - this.images[this.currentImage].getWidth()) / 2, (this.getHeight() - this.images[this.currentImage].getHeight()) / 2, 0);
        g.drawImage(this.aboutImage, this.getWidth() - this.aboutImage.getWidth(), this.getHeight() - this.aboutImage.getHeight(), 0);
        if (this.mode.equals("about")) {
            g.fillRect(10, 20, this.getWidth() - 20, this.getHeight() - 40);
            g.setColor(100, 100, 100);
            g.drawRect(10, 20, this.getWidth() - 20, this.getHeight() - 40);
            g.setColor(200, 200, 200);
            g.setFont(Font.getFont((int)0, (int)1, (int)16));
            String text = "\u041e \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0435";
            g.drawString(text, (this.getWidth() - g.getFont().stringWidth(text)) / 2, 40, 0);
            g.setFont(Font.getFont((int)0, (int)1, (int)0));
            text = "Jedi 0.1";
            g.drawString(text, (this.getWidth() - g.getFont().stringWidth(text)) / 2, 110, 0);
            text = "\u0410\u0432\u0442\u043e\u0440: Yanex";
            g.drawString(text, (this.getWidth() - g.getFont().stringWidth(text)) / 2, 130, 0);
            text = "\u0421\u0430\u0439\u0442\u044b:";
            g.drawString(text, (this.getWidth() - g.getFont().stringWidth(text)) / 2, 170, 0);
            text = "http://keeg.ru/";
            g.drawString(text, (this.getWidth() - g.getFont().stringWidth(text)) / 2, 190, 0);
            text = "http://yanex.org/";
            g.drawString(text, (this.getWidth() - g.getFont().stringWidth(text)) / 2, 210, 0);
            text = "E-mail: me@yanex.org";
            g.drawString(text, (this.getWidth() - g.getFont().stringWidth(text)) / 2, 260, 0);
            g.setFont(Font.getFont((int)0, (int)1, (int)8));
            text = "\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430 \u0440\u0430\u0441\u043f\u0440\u043e\u0441\u0442\u0440\u0430\u043d\u044f\u0435\u0442\u0441\u044f";
            g.drawString(text, (this.getWidth() - g.getFont().stringWidth(text)) / 2, this.getHeight() - 60 - g.getFont().getHeight(), 0);
            text = "\u0430\u0431\u0441\u043e\u043b\u044e\u0442\u043d\u043e \u0431\u0435\u0441\u043f\u043b\u0430\u0442\u043d\u043e.";
            g.drawString(text, (this.getWidth() - g.getFont().stringWidth(text)) / 2, this.getHeight() - 40 - g.getFont().getHeight(), 0);
        }
    }

    class PlayerLaunch
    extends Thread {
        PlayerLaunch() {
        }

        public void run() {
            GUI.this.playSound();
            System.gc();
        }
    }
}

