/*
 * Decompiled with CFR 0.152.
 */
package com.lge.sensor;

import com.lge.sensor.ChannelInfoImpl;
import com.lge.sensor.ConditionMonitor;
import com.lge.sensor.DataImpl;
import com.lge.sensor.SensorConnectionImpl;
import com.lge.sensor.SensorInfoImpl;
import com.lge.sensor.SensorPushReturnData;
import javax.microedition.sensor.Channel;
import javax.microedition.sensor.ChannelInfo;
import javax.microedition.sensor.Condition;
import javax.microedition.sensor.ConditionListener;
import javax.microedition.sensor.LimitCondition;
import javax.microedition.sensor.ObjectCondition;
import javax.microedition.sensor.RangeCondition;

public class ChannelImpl
implements Channel {
    private ChannelInfoImpl channelInfo;
    private DataImpl dataObj;
    public SensorConnectionImpl sensorconnection;
    ConditionMonitor conMonitor;
    int errorCode;

    public ChannelImpl(ChannelInfo channelInfo, DataImpl dataImpl) {
        this.channelInfo = (ChannelInfoImpl)channelInfo;
        this.dataObj = dataImpl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addCondition(ConditionListener conditionListener, Condition condition) {
        if (conditionListener == null) {
            throw new NullPointerException("ConditionListener cannot be null");
        }
        if (condition == null) {
            if (this.sensorconnection.getState() == 4) {
                throw new IllegalStateException("The SensorConnection is in the STATE_CLOSED state");
            }
            if (!this.sensorconnection.getSensorInfo().isConditionPushSupported()) throw new NullPointerException("Condition push not supproted");
            SensorPushReturnData sensorPushReturnData = new SensorPushReturnData();
            int n = this.nGetPushData(sensorPushReturnData, ((SensorInfoImpl)this.sensorconnection.getSensorInfo()).getSensorID(), this.sensorconnection.getInstanceID());
            if (n != 1) throw new NullPointerException("Application not launched automatically :: NULL condition to be provided only when application is launched automatically");
            if (sensorPushReturnData.getPushType() == 247) {
                if (n == 1 && sensorPushReturnData.getSensorID() == ((SensorInfoImpl)this.sensorconnection.getSensorInfo()).getSensorID()) {
                    if (this.channelInfo.getName().equals(sensorPushReturnData.getChannelName()) && this.channelInfo.getDataType() == sensorPushReturnData.getChannelDataType()) {
                        int n2 = 1;
                        boolean bl = true;
                        boolean bl2 = true;
                        boolean bl3 = true;
                        this.dataObj.setDataProperties(n2, bl, bl2, bl3);
                        this.dataObj.allocateMemory();
                        switch (sensorPushReturnData.getChannelDataType()) {
                            case 2: {
                                this.dataObj.intValues[0] = sensorPushReturnData.getIntValue();
                                break;
                            }
                            case 1: {
                                this.dataObj.doubleValues[0] = sensorPushReturnData.getDoubleValue();
                                break;
                            }
                            default: {
                                System.out.println("WRONG DATA TYPE");
                            }
                        }
                        this.dataObj.timestamp[0] = sensorPushReturnData.getTimeStamp();
                        this.dataObj.uncertainty[0] = sensorPushReturnData.getUncertainty();
                        this.dataObj.validity[0] = sensorPushReturnData.getValidity();
                        switch (sensorPushReturnData.getConditionType()) {
                            case 0: {
                                conditionListener.conditionMet(this.sensorconnection, this.dataObj, new LimitCondition(sensorPushReturnData.getLimitValue(), sensorPushReturnData.getLimitOperand()));
                                return;
                            }
                            case 1: {
                                conditionListener.conditionMet(this.sensorconnection, this.dataObj, new RangeCondition(sensorPushReturnData.getRangeLowerLimit(), sensorPushReturnData.getRangeLowerOperand(), sensorPushReturnData.getRangeUpperLimit(), sensorPushReturnData.getRangeUpperOperand()));
                                return;
                            }
                            default: {
                                return;
                            }
                        }
                    } else {
                        System.out.println("WRONG CONDITION - PUSH CHANNEL NOT MATCHING THE SET CHANNEL");
                    }
                    return;
                } else {
                    System.out.println("SENSOR ID MIS MATCH");
                }
                return;
            } else {
                System.out.println("PUSH_TYPE - AVAILABILITY");
            }
            return;
        } else {
            if ((this.channelInfo.getDataType() == 2 || this.channelInfo.getDataType() == 1) && condition instanceof ObjectCondition) {
                throw new IllegalArgumentException("IllegalArgumentException");
            }
            if (this.channelInfo.getDataType() == 4 && (condition instanceof LimitCondition || condition instanceof RangeCondition)) {
                throw new IllegalArgumentException("IllegalArgumentException");
            }
            if (this.sensorconnection.getState() == 4) {
                throw new IllegalStateException("The SensorConnection is in the STATE_CLOSED state");
            }
            if (this.conMonitor == null) {
                this.conMonitor = new ConditionMonitor(this.sensorconnection, this);
            }
            this.conMonitor.addConditionListener(conditionListener, condition);
        }
    }

    public ChannelInfo getChannelInfo() {
        return this.channelInfo;
    }

    public String getChannelUrl() {
        String string = null;
        Condition[] conditionArray = this.conMonitor.getConditions();
        string = "channel=" + this.channelInfo.getName();
        for (int i = 0; i < conditionArray.length; ++i) {
            if (conditionArray[i] instanceof LimitCondition) {
                string = string + "&" + "limit=" + ((LimitCondition)conditionArray[i]).getLimit();
                string = string + "&" + "op=" + ((LimitCondition)conditionArray[i]).getOperator();
                continue;
            }
            if (!(conditionArray[i] instanceof RangeCondition)) continue;
            string = string + "&" + "lowerLimit=" + ((RangeCondition)conditionArray[i]).getLowerLimit();
            string = string + "&" + "lowerOp=" + ((RangeCondition)conditionArray[i]).getLowerOp();
            string = string + "&" + "upperLimit=" + ((RangeCondition)conditionArray[i]).getUpperLimit();
            string = string + "&" + "upperOp=" + ((RangeCondition)conditionArray[i]).getUpperOp();
        }
        return string;
    }

    public Condition[] getConditions(ConditionListener conditionListener) {
        if (conditionListener == null) {
            throw new NullPointerException("ConditionListener cannot be null");
        }
        if (this.conMonitor != null) {
            return this.conMonitor.getConditions(conditionListener);
        }
        return new Condition[0];
    }

    public void removeAllConditions() {
        if (this.sensorconnection.getState() == 4) {
            throw new IllegalStateException("The SensorConnection is in the STATE_CLOSED state");
        }
        if (this.conMonitor != null) {
            this.conMonitor.removeAllCondition();
        }
    }

    public void removeCondition(ConditionListener conditionListener, Condition condition) {
        if (conditionListener == null || condition == null) {
            throw new NullPointerException("ConditionListener or Condition cannot be null");
        }
        if (this.sensorconnection.getState() == 4) {
            throw new IllegalStateException("The SensorConnection is in the STATE_CLOSED state");
        }
        if (this.conMonitor != null) {
            this.conMonitor.removeCondition(conditionListener, condition);
        }
    }

    public void removeConditionListener(ConditionListener conditionListener) {
        if (conditionListener == null) {
            throw new NullPointerException("ConditionListener cannot be null");
        }
        if (this.sensorconnection.getState() == 4) {
            throw new IllegalStateException("The SensorConnection is in the STATE_CLOSED state");
        }
        if (this.conMonitor != null) {
            this.conMonitor.removeConditionListener(conditionListener);
        }
    }

    protected void setConnectionObject(SensorConnectionImpl sensorConnectionImpl) {
        this.sensorconnection = sensorConnectionImpl;
    }

    private native int nGetPushData(SensorPushReturnData var1, int var2, int var3);
}

