/*
 * Decompiled with CFR 0.152.
 */
package com.lge.sensor;

import com.lge.sensor.ChannelInfoImpl;
import javax.microedition.sensor.ChannelInfo;
import javax.microedition.sensor.Data;

public class DataImpl
implements Data {
    public int[] intValues;
    public double[] doubleValues;
    public Object[] objectValues;
    public long[] timestamp;
    public float[] uncertainty;
    public boolean[] validity;
    private int bufferSize;
    private ChannelInfoImpl channelInfo;
    private boolean isTimestampRequested;
    private boolean isUncertaintyRequested;
    private boolean isValidityRequested;

    public DataImpl() {
    }

    public DataImpl(ChannelInfo channelInfo) {
        this.channelInfo = (ChannelInfoImpl)channelInfo;
        this.isTimestampRequested = false;
        this.isUncertaintyRequested = false;
        this.isValidityRequested = false;
    }

    public ChannelInfo getChannelInfo() {
        return this.channelInfo;
    }

    public double[] getDoubleValues() {
        if (this.channelInfo.getDataType() == 1) {
            return this.doubleValues;
        }
        throw new IllegalStateException();
    }

    public int[] getIntValues() {
        if (this.channelInfo.getDataType() == 2) {
            return this.intValues;
        }
        throw new IllegalStateException();
    }

    public long getTimestamp(int n) {
        if (!this.isTimestampRequested) {
            throw new IllegalStateException();
        }
        if (n < 0 || n > this.bufferSize - 1) {
            throw new IndexOutOfBoundsException();
        }
        return this.timestamp[n];
    }

    public float getUncertainty(int n) {
        if (!this.isUncertaintyRequested) {
            throw new IllegalStateException();
        }
        if (n < 0 || n > this.bufferSize - 1) {
            throw new IndexOutOfBoundsException();
        }
        return this.uncertainty[n];
    }

    public boolean isValid(int n) {
        if (!this.isValidityRequested) {
            throw new IllegalStateException();
        }
        if (n < 0 || n > this.bufferSize - 1) {
            throw new IndexOutOfBoundsException();
        }
        return this.validity[n];
    }

    public Object[] getObjectValues() {
        if (this.channelInfo.getDataType() == 4) {
            return this.objectValues;
        }
        throw new IllegalStateException();
    }

    protected void setDataProperties(int n, boolean bl, boolean bl2, boolean bl3) {
        this.bufferSize = n;
        this.isTimestampRequested = bl;
        this.isUncertaintyRequested = bl2;
        this.isValidityRequested = bl3;
    }

    protected void allocateMemory() {
        switch (this.getChannelInfo().getDataType()) {
            case 1: {
                this.doubleValues = new double[this.bufferSize];
                break;
            }
            case 2: {
                this.intValues = new int[this.bufferSize];
                break;
            }
            case 4: {
                this.objectValues = new Object[this.bufferSize];
                break;
            }
        }
        this.timestamp = (long[])(this.isTimestampRequested ? new long[this.bufferSize] : null);
        this.uncertainty = (float[])(this.isUncertaintyRequested ? new float[this.bufferSize] : null);
        this.validity = (boolean[])(this.isValidityRequested ? new boolean[this.bufferSize] : null);
    }

    protected int getBufferSize() {
        return this.bufferSize;
    }
}

