/*
 * Decompiled with CFR 0.152.
 */
package com.lge.sensor;

import com.lge.sensor.DataImpl;
import com.lge.sensor.SensorConnectionImpl;
import javax.microedition.sensor.ChannelInfo;
import javax.microedition.sensor.Data;
import javax.microedition.sensor.DataListener;
import javax.microedition.sensor.SensorInfo;

public class DataMonitor
implements Runnable {
    private SensorConnectionImpl sensor;
    private DataListener listener;
    private boolean isDataLost;
    private boolean stopMonitor;
    private long timeStamp;
    private int errorCode;
    private int bufferSize;
    private long bufferingPeriod;
    private boolean isTimestampIncluded;
    private boolean isUncertainityIncluded;
    private boolean isValidityIncluded;

    public DataMonitor(SensorConnectionImpl sensorConnectionImpl, DataListener dataListener, int n) {
        this.sensor = sensorConnectionImpl;
        this.listener = dataListener;
        this.bufferSize = n;
    }

    public DataMonitor(SensorConnectionImpl sensorConnectionImpl, DataListener dataListener, int n, long l, boolean bl, boolean bl2, boolean bl3) {
        this.sensor = sensorConnectionImpl;
        this.listener = dataListener;
        this.bufferSize = n;
        this.bufferingPeriod = l;
        this.isTimestampIncluded = bl;
        this.isUncertainityIncluded = bl2;
        this.isValidityIncluded = bl3;
    }

    public void setDataListener(DataListener dataListener, int n) {
        this.listener = dataListener;
        this.bufferSize = n;
    }

    public void setDataListener(DataListener dataListener, int n, long l, boolean bl, boolean bl2, boolean bl3) {
        this.listener = dataListener;
        this.bufferSize = n;
        this.bufferingPeriod = l;
        this.isTimestampIncluded = bl;
        this.isUncertainityIncluded = bl2;
        this.isValidityIncluded = bl3;
    }

    public synchronized void setStopMonitor(boolean bl) {
        this.stopMonitor = bl;
    }

    private synchronized Data[] getAsyncData() {
        SensorInfo sensorInfo = this.sensor.getSensorInfo();
        ChannelInfo[] channelInfoArray = sensorInfo.getChannelInfos();
        Data[] dataArray = new DataImpl[channelInfoArray.length];
        dataArray = this.sensor.getAsyncData(this.bufferSize);
        this.errorCode = this.sensor.getErrorCode();
        if (this.errorCode != 0) {
            this.isDataLost = true;
        }
        return dataArray;
    }

    private Data[] getAsyncDataWithBufferPeriod() {
        SensorInfo sensorInfo = this.sensor.getSensorInfo();
        ChannelInfo[] channelInfoArray = sensorInfo.getChannelInfos();
        Data[] dataArray = new DataImpl[channelInfoArray.length];
        dataArray = this.sensor.getAsyncData(this.bufferSize, this.bufferingPeriod, this.isTimestampIncluded, this.isUncertainityIncluded, this.isValidityIncluded);
        this.errorCode = this.sensor.getErrorCode();
        if (this.errorCode != 0) {
            this.isDataLost = true;
        }
        return dataArray;
    }

    public void run() {
        do {
            Data[] dataArray = this.bufferingPeriod == 0L ? this.getAsyncData() : this.getAsyncDataWithBufferPeriod();
            if (this.stopMonitor) continue;
            this.listener.dataReceived(this.sensor, dataArray, this.isDataLost);
        } while (!this.stopMonitor);
    }
}

