/*
 * Decompiled with CFR 0.152.
 */
package com.lge.sensor;

import com.lge.sensor.ChannelImpl;
import com.lge.sensor.DataAndErrorMonitor;
import com.lge.sensor.DataImpl;
import com.lge.sensor.DataMonitor;
import com.lge.sensor.SensorContainer;
import com.lge.sensor.SensorInfoImpl;
import java.io.IOException;
import java.util.Hashtable;
import javax.microedition.sensor.Channel;
import javax.microedition.sensor.ChannelInfo;
import javax.microedition.sensor.Data;
import javax.microedition.sensor.DataAndErrorListener;
import javax.microedition.sensor.DataListener;
import javax.microedition.sensor.SensorConnection;
import javax.microedition.sensor.SensorInfo;

public class SensorConnectionImpl
implements SensorConnection {
    private int sensorConnectionState = 4;
    private int sensorID;
    private int instanceID;
    protected SensorInfoImpl sensorInfo;
    private ChannelImpl[] channel;
    private DataImpl[] data;
    private DataMonitor dataMonitor;
    private DataAndErrorMonitor dataAndErrorMonitor;
    private boolean reportErrors;
    private Thread dataMonitorThread;
    private Thread errorMonitorThread;
    private int numberOfSupportedErrorCodes;
    private int[] errors = null;
    private String[] errorDescription;
    private Hashtable sensorErrorCodeTable;
    private int errorCode;

    public SensorConnectionImpl() {
    }

    public SensorConnectionImpl(SensorInfoImpl sensorInfoImpl) {
        int n = 0;
        ChannelInfo[] channelInfoArray = null;
        this.sensorInfo = sensorInfoImpl;
        n = this.sensorInfo.getNumberOfChannels();
        channelInfoArray = this.sensorInfo.getChannelInfos();
        this.data = new DataImpl[n];
        this.channel = new ChannelImpl[n];
        for (int i = 0; i < n; ++i) {
            this.data[i] = new DataImpl(channelInfoArray[i]);
            this.channel[i] = new ChannelImpl(channelInfoArray[i], this.data[i]);
        }
        this.sensorID = this.sensorInfo.getSensorID();
    }

    public Channel getChannel(ChannelInfo channelInfo) {
        if (channelInfo == null) {
            throw new NullPointerException("The channelInfo is null");
        }
        for (int i = 0; i < this.sensorInfo.getNumberOfChannels(); ++i) {
            if (!channelInfo.equals(this.channel[i].getChannelInfo())) continue;
            return this.channel[i];
        }
        throw new IllegalArgumentException("SensorInfo does not contain matching ChannelInfo object");
    }

    public Data[] getData(int n) throws IOException {
        String[] stringArray = new String[this.sensorInfo.getNumberOfChannels()];
        int[] nArray = new int[this.sensorInfo.getNumberOfChannels()];
        int n2 = this.sensorInfo.getNumberOfChannels();
        boolean bl = true;
        if (n < 1 || n > this.sensorInfo.getMaxBufferSize()) {
            throw new IllegalArgumentException("buffer size out of the limits");
        }
        if (this.sensorConnectionState == 2) {
            throw new IllegalStateException("sensor is in listening state");
        }
        if (this.sensorConnectionState == 4) {
            throw new IOException("sensor is in closed state");
        }
        for (int i = 0; i < n2; ++i) {
            stringArray[i] = this.data[i].getChannelInfo().getName();
            nArray[i] = this.data[i].getChannelInfo().getDataType();
            this.data[i].setDataProperties(n, false, false, false);
            this.data[i].allocateMemory();
        }
        int n3 = this.nGetData(this.sensorInfo.getSensorID(), this.instanceID, stringArray, nArray, this.data, n, bl, this.reportErrors, 0L, false, false, false);
        if (n3 < 0) {
            this.errorCode = n3;
        }
        return this.data;
    }

    public Data[] getData(int n, long l, boolean bl, boolean bl2, boolean bl3) throws IOException {
        int n2;
        String[] stringArray = new String[this.sensorInfo.getNumberOfChannels()];
        int[] nArray = new int[this.sensorInfo.getNumberOfChannels()];
        int n3 = this.sensorInfo.getNumberOfChannels();
        int n4 = 0;
        Float f = null;
        boolean bl4 = true;
        if (n < 1 && l < 1L || n > this.sensorInfo.getMaxBufferSize()) {
            throw new IllegalArgumentException("buffer size out of the limits");
        }
        if (this.sensorConnectionState == 2) {
            throw new IllegalStateException("sensor is in listening state");
        }
        if (this.sensorConnectionState == 4) {
            throw new IOException("sensor is in closed state");
        }
        if (n < 1 && l > 0L) {
            n2 = this.sensorInfo.getMaxBufferSize();
            try {
                f = (Float)this.sensorInfo.getProperty("maxSamplingRate");
            }
            catch (Exception exception) {
                f = new Float(1.0);
            }
            n4 = (int)((float)(l / 1000L) * f.floatValue());
            n4 = n4 > n2 ? n2 : n4;
        } else if (l < 1L && n > 0) {
            n4 = n;
        } else if (n > 0 && l > 0L) {
            n2 = this.sensorInfo.getMaxBufferSize();
            try {
                f = (Float)this.sensorInfo.getProperty("maxSamplingRate");
            }
            catch (Exception exception) {
                f = new Float(1.0);
            }
            n4 = (int)((float)(l / 1000L) * f.floatValue());
            n4 = n4 > n2 ? n2 : n4;
            n4 = n4 > n ? n : n4;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            stringArray[n2] = this.data[n2].getChannelInfo().getName();
            nArray[n2] = this.data[n2].getChannelInfo().getDataType();
            this.data[n2].setDataProperties(n4, bl, bl2, bl3);
            this.data[n2].allocateMemory();
        }
        int n5 = this.nGetData(this.sensorInfo.getSensorID(), this.instanceID, stringArray, nArray, this.data, n4, bl4, this.reportErrors, l, bl, bl2, bl3);
        if (n5 < 0) {
            this.errorCode = n5;
        }
        return this.data;
    }

    protected DataImpl[] getAsyncData(int n) {
        String[] stringArray = new String[this.sensorInfo.getNumberOfChannels()];
        int[] nArray = new int[this.sensorInfo.getNumberOfChannels()];
        boolean bl = false;
        int n2 = this.sensorInfo.getNumberOfChannels();
        for (int i = 0; i < n2; ++i) {
            stringArray[i] = this.data[i].getChannelInfo().getName();
            nArray[i] = this.data[i].getChannelInfo().getDataType();
            this.data[i].setDataProperties(n, false, false, false);
            this.data[i].allocateMemory();
        }
        int n3 = this.nGetData(this.sensorInfo.getSensorID(), this.instanceID, stringArray, nArray, this.data, n, bl, this.reportErrors, 0L, false, false, false);
        if (n3 < 0) {
            this.errorCode = n3;
        }
        return this.data;
    }

    protected DataImpl[] getAsyncData(int n, long l, boolean bl, boolean bl2, boolean bl3) {
        int n2;
        String[] stringArray = new String[this.sensorInfo.getNumberOfChannels()];
        int[] nArray = new int[this.sensorInfo.getNumberOfChannels()];
        boolean bl4 = false;
        int n3 = 0;
        int n4 = this.sensorInfo.getNumberOfChannels();
        Float f = null;
        if (n < 1 && l > 0L) {
            n2 = this.sensorInfo.getMaxBufferSize();
            try {
                f = (Float)this.sensorInfo.getProperty("maxSamplingRate");
            }
            catch (Exception exception) {
                f = new Float(1.0);
            }
            n3 = (int)((float)(l / 1000L) * f.floatValue());
            n3 = n3 > n2 ? n2 : n3;
        } else if (l < 1L && n > 0) {
            n3 = n;
        } else if (n > 0 && l > 0L) {
            n2 = this.sensorInfo.getMaxBufferSize();
            try {
                f = (Float)this.sensorInfo.getProperty("maxSamplingRate");
            }
            catch (Exception exception) {
                f = new Float(1.0);
            }
            n3 = (int)((float)(l / 1000L) * f.floatValue());
            n3 = n3 > n2 ? n2 : n3;
            n3 = n3 > n ? n : n3;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            stringArray[n2] = this.data[n2].getChannelInfo().getName();
            nArray[n2] = this.data[n2].getChannelInfo().getDataType();
            this.data[n2].setDataProperties(n3, bl, bl2, bl3);
            this.data[n2].allocateMemory();
        }
        int n5 = this.nGetData(this.sensorInfo.getSensorID(), this.instanceID, stringArray, nArray, this.data, n3, bl4, this.reportErrors, l, bl, bl2, bl3);
        if (n5 < 0) {
            this.errorCode = n5;
        }
        return this.data;
    }

    private void getErrorTable() {
        this.sensorErrorCodeTable = new Hashtable();
        this.numberOfSupportedErrorCodes = SensorConnectionImpl.nGetNumberOfSupportedErrorCodes(this.sensorInfo.getSensorID());
        this.errors = new int[this.numberOfSupportedErrorCodes];
        this.errorDescription = new String[this.numberOfSupportedErrorCodes];
        SensorConnectionImpl.nGetErrorCodes(this.sensorInfo.getSensorID(), this.errors, this.errorDescription);
        for (int i = 0; i < this.numberOfSupportedErrorCodes; ++i) {
            Integer n = new Integer(this.errors[i]);
            this.sensorErrorCodeTable.put(n, this.errorDescription[i]);
        }
    }

    public int[] getErrorCodes() {
        String[] stringArray = this.sensorInfo.getPropertyNames();
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] != SensorContainer.propertyNames[1]) continue;
            bl = true;
            break;
        }
        if (bl) {
            if (this.errors == null) {
                this.getErrorTable();
            }
            return this.errors;
        }
        this.errors = new int[0];
        return this.errors;
    }

    public String getErrorText(int n) throws IllegalArgumentException {
        String[] stringArray = this.sensorInfo.getPropertyNames();
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] != SensorContainer.propertyNames[1]) continue;
            bl = true;
            break;
        }
        if (bl) {
            if (this.errorDescription == null) {
                this.getErrorTable();
            }
            if (this.sensorErrorCodeTable.containsKey(new Integer(n))) {
                return (String)this.sensorErrorCodeTable.get(new Integer(n));
            }
            throw new IllegalArgumentException("Not a Valid Error Code");
        }
        throw new IllegalArgumentException("SensorInfo.PROP_IS_REPORTING_ERRORS is not set");
    }

    protected int getErrorCode() {
        return this.errorCode;
    }

    public SensorInfo getSensorInfo() {
        return this.sensorInfo;
    }

    public int getState() {
        return this.sensorConnectionState;
    }

    public void removeDataListener() throws IllegalStateException {
        if (this.sensorConnectionState == 4) {
            throw new IllegalStateException("This SensorConnection is already closed");
        }
        if (this.dataMonitor == null) {
            return;
        }
        this.dataMonitor.setStopMonitor(true);
        if (this.reportErrors) {
            this.dataAndErrorMonitor.setStopMonitor(true);
        }
        this.dataMonitor = null;
        this.dataAndErrorMonitor = null;
        this.reportErrors = false;
        this.sensorConnectionState = 1;
    }

    public void setDataListener(DataListener dataListener, int n) throws NullPointerException, IllegalArgumentException, IllegalArgumentException {
        if (this.sensorConnectionState == 4) {
            throw new IllegalStateException("Sensor Connection is already Closed");
        }
        if (dataListener == null) {
            throw new NullPointerException("DataListener cannot be null");
        }
        if (n <= 0 || n > this.getSensorInfo().getMaxBufferSize()) {
            throw new IllegalArgumentException("Buffer Size cannot be zero/negative value or exceeds max value");
        }
        if (this.dataMonitor == null) {
            if (dataListener instanceof DataAndErrorListener && this.sensorInfo.prop_isReportingErrors) {
                this.reportErrors = true;
                this.dataAndErrorMonitor = new DataAndErrorMonitor(this, (DataAndErrorListener)dataListener);
                this.errorMonitorThread = new Thread(this.dataAndErrorMonitor);
                this.errorMonitorThread.start();
            }
        } else {
            this.dataMonitor.setDataListener(dataListener, n);
            return;
        }
        this.dataMonitor = new DataMonitor(this, dataListener, n);
        this.dataMonitorThread = new Thread(this.dataMonitor);
        this.dataMonitorThread.start();
        this.sensorConnectionState = 2;
    }

    public void setDataListener(DataListener dataListener, int n, long l, boolean bl, boolean bl2, boolean bl3) throws NullPointerException, IllegalArgumentException, IllegalArgumentException {
        if (this.sensorConnectionState == 4) {
            throw new IllegalStateException("Sensor Connection is already Closed");
        }
        if (dataListener == null) {
            throw new NullPointerException("DataListener cannot be null");
        }
        if (n <= 0 && l <= 0L || n > this.getSensorInfo().getMaxBufferSize()) {
            throw new IllegalArgumentException("Buffer Size/Period cannot be zero or negative value or exceeds max value");
        }
        if (this.dataMonitor == null) {
            if (dataListener instanceof DataAndErrorListener && this.sensorInfo.prop_isReportingErrors) {
                this.reportErrors = true;
                this.dataAndErrorMonitor = new DataAndErrorMonitor(this, (DataAndErrorListener)dataListener);
                this.errorMonitorThread = new Thread(this.dataAndErrorMonitor);
                this.errorMonitorThread.start();
            }
        } else {
            this.dataMonitor.setDataListener(dataListener, n, l, bl, bl2, bl3);
            return;
        }
        this.dataMonitor = new DataMonitor(this, dataListener, n, l, bl, bl2, bl3);
        Thread thread = new Thread(this.dataMonitor);
        thread.start();
        this.sensorConnectionState = 2;
    }

    public boolean open(int n) throws IOException, NullPointerException {
        boolean bl = false;
        for (int i = 0; i < this.channel.length; ++i) {
            this.channel[i].setConnectionObject(this);
        }
        this.instanceID = this.nOpenSensorConnection(n);
        if (this.instanceID < 0) {
            bl = false;
        } else {
            bl = true;
            this.sensorConnectionState = 1;
        }
        this.sensorID = n;
        return bl;
    }

    public void close() throws IOException {
        if (this.sensorConnectionState == 4) {
            return;
        }
        if (!this.nCloseSensorConnection(this.sensorInfo.getSensorID(), this.instanceID)) {
            throw new IOException("FAILED: Sensor Connection not closed.");
        }
        this.sensorConnectionState = 4;
        if (this.dataMonitor == null) {
            return;
        }
        this.dataMonitor.setStopMonitor(true);
        if (this.reportErrors) {
            this.dataAndErrorMonitor.setStopMonitor(true);
        }
        this.dataMonitor = null;
        this.dataAndErrorMonitor = null;
        this.reportErrors = false;
    }

    public int getInstanceID() {
        return this.instanceID;
    }

    private native int nOpenSensorConnection(int var1);

    private native boolean nCloseSensorConnection(int var1, int var2);

    private static native int nGetNumberOfSupportedErrorCodes(int var0);

    private static native void nGetErrorCodes(int var0, int[] var1, String[] var2);

    private native int nGetData(int var1, int var2, String[] var3, int[] var4, DataImpl[] var5, int var6, boolean var7, boolean var8, long var9, boolean var11, boolean var12, boolean var13);

    private native void finalize();
}

