/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.sensor;

import javax.microedition.sensor.Condition;

public final class RangeCondition
implements Condition {
    private double lowerLimit;
    private double upperLimit;
    private String lowerOp;
    private String upperOp;

    public RangeCondition(double d, String string, double d2, String string2) {
        if (string == null || string2 == null) {
            throw new NullPointerException("Operators cannot be NULL");
        }
        if (!string.equals("gt") && !string.equals("ge")) {
            throw new IllegalArgumentException("Not a valid Lowe Limit Operator");
        }
        if (!string2.equals("lt") && !string2.equals("le")) {
            throw new IllegalArgumentException("Not a valid Upper Limit Operator");
        }
        if (d > d2) {
            throw new IllegalArgumentException("Not valid Limits");
        }
        if (!(d != d2 || string.equals("ge") && string2.equals("le"))) {
            throw new IllegalArgumentException("Not valid Limits");
        }
        this.lowerLimit = d;
        this.upperLimit = d2;
        this.lowerOp = string;
        this.upperOp = string2;
    }

    public final double getLowerLimit() {
        return this.lowerLimit;
    }

    public final String getLowerOp() {
        return this.lowerOp;
    }

    public final double getUpperLimit() {
        return this.upperLimit;
    }

    public final String getUpperOp() {
        return this.upperOp;
    }

    public boolean isMet(double d) {
        return this.lowerOp.equals("gt") && this.upperOp.equals("lt") ? d > this.lowerLimit && d < this.upperLimit : (this.lowerOp.equals("ge") && this.upperOp.equals("le") ? d >= this.lowerLimit && d <= this.upperLimit : (this.lowerOp.equals("gt") && this.upperOp.equals("le") ? d > this.lowerLimit && d <= this.upperLimit : this.lowerOp.equals("ge") && this.upperOp.equals("lt") && d >= this.lowerLimit && d < this.upperLimit));
    }

    public boolean isMet(Object object) {
        return false;
    }
}

