/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.sensor;

import com.lge.sensor.SensorContainer;
import com.lge.sensor.SensorInfoImpl;
import com.lge.sensor.SensorMonitor;
import java.util.Vector;
import javax.microedition.sensor.SensorInfo;
import javax.microedition.sensor.SensorListener;

public final class SensorManager {
    private static final char DELIMITOR = ';';

    private SensorManager() {
    }

    public static void addSensorListener(SensorListener sensorListener, SensorInfo sensorInfo) {
        SensorInfoImpl[] sensorInfoImplArray = null;
        if (sensorListener == null || sensorInfo == null) {
            throw new NullPointerException();
        }
        if (sensorInfoImplArray == null) {
            sensorInfoImplArray = (SensorInfoImpl[])SensorManager.findSensors(sensorInfo.getUrl());
        }
        if (sensorInfoImplArray != null) {
            boolean bl = false;
            int n = 0;
            int n2 = sensorInfoImplArray.length;
            while (!(bl = sensorInfoImplArray[n].getSensorID() == ((SensorInfoImpl)sensorInfo).getSensorID()) && ++n < n2) {
            }
            if (!bl) {
                throw new IllegalArgumentException();
            }
            SensorMonitor.addSensorInfoMap(sensorListener, sensorInfo);
        }
    }

    public static void addSensorListener(SensorListener sensorListener, String string) {
        Vector<SensorInfoImpl> vector = new Vector<SensorInfoImpl>();
        int n = 0;
        int n2 = 0;
        SensorInfoImpl[] sensorInfoImplArray = null;
        if (sensorListener == null || string == null) {
            throw new NullPointerException();
        }
        if (sensorInfoImplArray == null) {
            sensorInfoImplArray = (SensorInfoImpl[])SensorManager.findSensors(string, null);
        }
        n = sensorInfoImplArray.length;
        do {
            if (!sensorInfoImplArray[n2].getQuantity().equals(string)) continue;
            vector.addElement(sensorInfoImplArray[n2]);
        } while (++n2 < n);
        n = vector.size();
        for (n2 = 0; n2 < n; ++n2) {
            SensorManager.addSensorListener(sensorListener, (SensorInfoImpl)vector.elementAt(n2));
        }
    }

    public static SensorInfo[] findSensors(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        SensorInfo[] sensorInfoArray = null;
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        String string6 = null;
        int n5 = -1;
        int n6 = -1;
        if (string == null) {
            throw new NullPointerException("The url parameter cannot be null");
        }
        if (string.charAt(string.length() - 1) != ';') {
            string = string + ";";
        }
        if ((n2 = string.indexOf("sensor:", n = 0)) == -1) {
            throw new IllegalArgumentException("sensor URL is malformed according to the sensor URL scheme");
        }
        n2 = "sensor:".length() - 1;
        do {
            vector.addElement(string.substring(n, n2));
            n = n2 + 1;
            n2 = string.indexOf(";", n);
            string6 = string.substring(n, n2);
            if (string6.indexOf(",") != -1 || string6.indexOf("=") != -1) {
                throw new IllegalArgumentException("sensor URL is malformed according to the sensor URL scheme");
            }
            vector2.addElement(string.substring(n, n2));
            n = n2 + 1;
            if (string.indexOf(";", n) == -1 || (n2 = string.indexOf("=", n)) != -1) continue;
            throw new IllegalArgumentException("sensor URL is malformed according to the sensor URL scheme");
        } while (string.indexOf(";", n) != -1);
        n5 = vector.indexOf("sensor");
        n6 = vector.indexOf("contextType");
        if (n6 == -1) {
            n6 = vector.indexOf("contexttype");
        }
        n3 = vector.indexOf("location");
        n4 = vector.indexOf("model");
        if (n5 != -1) {
            string2 = vector2.elementAt(n5).toString();
        }
        if (n6 != -1) {
            string3 = vector2.elementAt(n6).toString();
        }
        if (n4 != -1) {
            string4 = vector2.elementAt(n4).toString();
        }
        if (n3 != -1) {
            string5 = vector2.elementAt(n3).toString();
        }
        sensorInfoArray = SensorContainer.getSensorInfo(string2, string3, string4, string5, true);
        return sensorInfoArray;
    }

    public static SensorInfo[] findSensors(String string, String string2) {
        if (string == null && string2 == null) {
            return SensorContainer.getAllSupportedSensorInfo();
        }
        if (!(string2 == null || string2.equals("ambient") || string2.equals("device") || string2.equals("user") || string2.equals("vehicle"))) {
            throw new IllegalArgumentException("Context Type is none of the valid values");
        }
        return SensorContainer.getSensorInfo(string, string2, null, null, true);
    }

    public static void removeSensorListener(SensorListener sensorListener) {
        if (sensorListener == null) {
            throw new NullPointerException();
        }
        SensorMonitor.removeSensorInfoMap(sensorListener);
    }
}

