/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Light;
import javax.microedition.m3g.Loader;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Object3D;
import javax.microedition.m3g.World;

public class M3GCanvas
extends Canvas
implements Runnable {
    boolean running;
    public static int RENDERING_HINTS = 14;
    boolean left;
    boolean right;
    boolean up;
    boolean down;
    Graphics3D g3d;
    World world;
    int currentTime = 0;
    Camera cam;
    float camRot = 0.0f;
    double camSine = 0.0;
    double camCosine = 0.0;
    float headDeg = 0.0f;
    Mesh leon;
    Mesh ganado;
    float a = 0.0f;
    float b = 0.0f;
    float d = 0.0f;
    float e = 13.0f;
    float g;
    float f;
    float r = this.e;
    float teta;

    public M3GCanvas() {
        this.setFullScreenMode(true);
        this.loadWorld();
        this.loadCamera();
        this.init();
    }

    private void loadCamera() {
        if (this.world != null) {
            this.cam = this.world.getActiveCamera();
            Light light = new Light();
            light.setMode(128);
            light.setIntensity(3.0f);
            this.world.addChild((Node)light);
            this.cam.translate(0.0f, 5.0f, this.e);
        }
    }

    private void loadWorld() {
        try {
            Object3D[] object3DArray = Loader.load((String)"/map.m3g");
            int n = 0;
            while (n < object3DArray.length) {
                if (!(object3DArray[n] instanceof World)) continue;
                this.world = (World)object3DArray[n];
                break;
            }
            this.leon = (Mesh)this.world.find(286);
            this.ganado = (Mesh)this.world.find(287);
        }
        catch (Exception exception) {
            System.out.println("Loading error!");
        }
    }

    public void paint(Graphics graphics) {
        this.g3d = Graphics3D.getInstance();
        this.g3d.bindTarget((Object)graphics, true, RENDERING_HINTS);
        this.g3d.render(this.world);
        this.g3d.releaseTarget();
        this.leon.animate(this.currentTime);
        if (this.down || this.up || this.left || this.right) {
            this.currentTime += 40;
        }
    }

    private void moveCamera() {
        if (this.left) {
            this.camRot += 5.0f;
        }
        if (this.right) {
            this.camRot -= 5.0f;
        }
        this.g = (float)((double)this.a + (double)this.r * Math.sin(Math.toRadians(this.camRot)));
        this.f = (float)((double)this.b + (double)this.r * Math.cos(Math.toRadians(this.camRot)));
        this.cam.translate(this.g - this.d, 0.0f, this.f - this.e);
        this.d = this.g;
        this.e = this.f;
        this.leon.setOrientation(this.camRot, 0.0f, 1.0f, 0.0f);
        this.cam.setOrientation(this.camRot, 0.0f, 1.0f, 0.0f);
        double d = Math.toRadians(this.camRot);
        this.camSine = Math.sin(d);
        this.camCosine = Math.cos(d);
        int n = 0;
        if (this.up) {
            n = -1;
        }
        if (this.down) {
            n = 1;
        }
        float f = 0.7f * (float)this.camSine * (float)n;
        float f2 = 0.7f * (float)this.camCosine * (float)n;
        this.cam.translate(f, 0.0f, f2);
        this.a += f;
        this.b += f2;
        this.leon.translate(f, 0.0f, f2);
        this.d += f;
        this.e += f2;
        if (n != 0) {
            this.headDeg += 0.5f;
            this.leon.translate(0.0f, (float)Math.sin(this.headDeg) / 20.0f, 0.0f);
        }
    }

    public void init() {
        Thread thread = new Thread(this);
        this.running = true;
        thread.start();
    }

    public void run() {
        while (this.running) {
            this.moveCamera();
            this.repaint();
            this.serviceRepaints();
            try {
                Thread.sleep(35L);
            }
            catch (Exception exception) {}
        }
    }

    public void keyReleased(int n) {
        int n2 = this.getGameAction(n);
        switch (n2) {
            case 2: {
                this.left = false;
                break;
            }
            case 5: {
                this.right = false;
                break;
            }
            case 1: {
                this.up = false;
                break;
            }
            case 6: {
                this.down = false;
            }
        }
    }

    public void keyPressed(int n) {
        int n2 = this.getGameAction(n);
        switch (n2) {
            case 2: {
                this.left = true;
                break;
            }
            case 5: {
                this.right = true;
                break;
            }
            case 1: {
                this.up = true;
                break;
            }
            case 6: {
                this.down = true;
            }
        }
    }
}

