/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Random;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextBox;
import javax.microedition.midlet.MIDlet;

public class Application
extends MIDlet
implements CommandListener,
ItemCommandListener {
    private Command copy;
    private Command back;
    private Command exit;
    private Command next;
    private Command clear;
    private Command okay;
    private String[] animals;
    private String[] earth;
    private String[] science;
    private String[] stats;
    private String[] trivia;
    private Display display;
    private List menu;
    private List categs;
    private SplashScreen splash;
    private Form form;
    private Form info;
    private Form credits;
    private StringItem main;
    private String text;
    private String[] url = new String[]{"http://ae-mods.ru/publ/0-0-13", "http://deadinvader.spaces.ru/"};
    private Random random = new Random();
    private TextBox textBox;
    private String position;
    private int count = 1;

    public Application() {
        this.animals = new String[20];
        this.earth = new String[20];
        this.science = new String[20];
        this.stats = new String[20];
        this.trivia = new String[20];
        for (int i = 0; i < 20; ++i) {
            this.animals[i] = this.getLine("animals.txt", i);
            this.earth[i] = this.getLine("earth.txt", i);
            this.science[i] = this.getLine("science.txt", i);
            this.stats[i] = this.getLine("statistics.txt", i);
            this.trivia[i] = this.getLine("trivia.txt", i);
        }
        this.text = this.getLine("info.txt", 0);
        this.copy = new Command("Copy", 8, 0);
        this.back = new Command("Back", 2, 0);
        this.exit = new Command("Exit", 7, 0);
        this.next = new Command("Next", 4, 0);
        this.okay = new Command("Select", 8, 1);
        this.clear = new Command("Clear", 1, 0);
        this.main = new StringItem(null, null);
        this.main.setFont(Font.getFont((int)0, (int)0, (int)8));
        this.main.setLabel("Did you know... ?");
    }

    private StringItem getItem(String t, String c) {
        StringItem temp_item = null;
        temp_item = new StringItem(t + "\n", c);
        temp_item.setFont(Font.getFont((int)0, (int)0, (int)8));
        return temp_item;
    }

    private StringItem getLink(String t, String url) {
        StringItem str = new StringItem(t, url, 1);
        str.setFont(Font.getFont((int)0, (int)0, (int)8));
        str.addCommand(this.okay);
        str.setItemCommandListener((ItemCommandListener)this);
        return str;
    }

    public void startApp() {
        this.display = Display.getDisplay((MIDlet)this);
        this.splash = new SplashScreen("images/splash");
        try {
            this.display.setCurrent((Displayable)this.splash);
            Thread.sleep(2000L);
        }
        catch (Exception exc) {
            this.showException(exc);
        }
        this.display.setCurrent((Displayable)this.getMenu());
    }

    public void pauseApp() {
        Runtime.getRuntime().gc();
        System.gc();
    }

    public void destroyApp(boolean unconditional) {
        Runtime.getRuntime().gc();
        this.display.setCurrent(null);
    }

    private Form getForm() {
        if (this.form == null) {
            this.form = new Form("Did you know... ?");
            this.form.append((Item)this.main);
            this.form.addCommand(this.back);
            this.form.addCommand(this.copy);
            this.form.addCommand(this.next);
            this.form.setCommandListener((CommandListener)this);
        }
        return this.form;
    }

    private void getRandom() {
        this.getForm().deleteAll();
        this.getForm().setTitle("Random fact");
        this.main.setText(this.getRandomFact());
        this.getForm().append((Item)this.main);
    }

    private TextBox getTextBox() {
        if (this.textBox == null) {
            this.textBox = new TextBox(null, null, 256, 0);
            this.textBox.addCommand(this.clear);
            this.textBox.addCommand(this.back);
            this.textBox.setCommandListener((CommandListener)this);
        }
        return this.textBox;
    }

    private List getMenu() {
        if (this.menu == null) {
            this.menu = new List("Did you know... ?", 3);
            this.menu.append(" Random ", null);
            this.menu.append(" Topics ", null);
            this.menu.append(" Info ", null);
            this.menu.append(" About ", null);
            this.menu.append(" Exit ", null);
            this.menu.setSelectCommand(this.okay);
            this.menu.addCommand(this.exit);
            this.menu.setCommandListener((CommandListener)this);
        }
        return this.menu;
    }

    private List getCategories() {
        if (this.categs == null) {
            this.categs = new List("Topics", 3);
            this.categs.append(" Animals ", null);
            this.categs.append(" Earth ", null);
            this.categs.append(" Science ", null);
            this.categs.append(" Statistics ", null);
            this.categs.append(" Trivia ", null);
            this.categs.setSelectCommand(this.okay);
            this.categs.addCommand(this.back);
            this.categs.setCommandListener((CommandListener)this);
        }
        return this.categs;
    }

    private Form getInformation() {
        String[] s = new String[]{"More applications", "http://ae-mods.ru/publ/0-0-13"};
        if (this.info == null) {
            this.info = new Form("Information");
            this.info.append((Item)this.getItem("Information", this.text));
            this.info.append((Item)this.getLink(s[0], s[1]));
            this.info.addCommand(this.back);
            this.info.setCommandListener((CommandListener)this);
        }
        return this.info;
    }

    private Form getCredits() {
        String[] s = new String[]{"Did you know... ?", "Version 0.1 (build 17)", "Developed by", "Dead Invader, 31.08.2014", "Spaces account", "http://deadinvader.spaces.ru/"};
        if (this.credits == null) {
            this.credits = new Form("About");
            this.credits.append((Item)this.getItem(s[0], s[1]));
            this.credits.append((Item)this.getItem(s[2], s[3]));
            this.credits.append((Item)this.getLink(s[4], s[5]));
            this.credits.addCommand(this.back);
            this.credits.setCommandListener((CommandListener)this);
        }
        return this.credits;
    }

    private String getRandomFact() {
        String teh_string = "";
        int cat = Math.abs((this.random.nextInt() >>> 1) % 4);
        int num = Math.abs((this.random.nextInt() >>> 1) % 20);
        if (cat == 0) {
            teh_string = this.animals[num];
        } else if (cat == 1) {
            teh_string = this.earth[num];
        } else if (cat == 2) {
            teh_string = this.science[num];
        } else if (cat == 3) {
            teh_string = this.stats[num];
        } else if (cat == 4) {
            teh_string = this.trivia[num];
        }
        return teh_string;
    }

    private void connectionRequest(String URL2) {
        try {
            this.platformRequest(URL2);
        }
        catch (ConnectionNotFoundException cnfe) {
            this.showException((Exception)((Object)cnfe));
        }
        catch (Exception exc) {
            this.showException(exc);
        }
    }

    private void showException(Exception exc) {
        String msg = exc.getMessage();
        String str = exc.toString();
        System.out.println("Message: " + msg);
        System.out.println("String: " + str);
    }

    private void showForm(String title, String content) {
        this.getForm().deleteAll();
        this.getForm().setTitle(title + " (01/20)");
        this.main.setText("" + content);
        this.getForm().append((Item)this.main);
        this.display.setCurrent((Displayable)this.getForm());
        this.categs = null;
    }

    private void changeItem(String[] target) {
        String number = "";
        ++this.count;
        if (this.count == 21) {
            this.count = 1;
        }
        number = this.count < 10 ? "0" + this.count : "" + this.count;
        String num = " (" + number + "/20)";
        this.form.setTitle(this.position + num);
        this.main.setText(target[this.count - 1]);
    }

    private String getLine(String path, int line) {
        String sts = "/META-RES/" + path;
        DataInputStream dis = new DataInputStream(((Object)((Object)this)).getClass().getResourceAsStream(sts));
        for (int i = 0; i < line + 1; ++i) {
            boolean tmp = false;
            StringBuffer sb = new StringBuffer();
            int ch = 0;
            int size = 0;
            try {
                while ((ch = dis.read()) != -1 & !tmp) {
                    ++size;
                    if (ch != 13 & ch != 10 & ch != -1) {
                        sb.append((char)(ch >= 192 && ch <= 255 ? ch + 848 : ch));
                        continue;
                    }
                    tmp = true;
                }
                if (i != line) continue;
                dis.close();
                return sb.toString();
            }
            catch (IOException exc) {
                this.showException(exc);
            }
        }
        return "\r\n";
    }

    public void commandAction(Command c, Displayable d) {
        if (d == this.menu) {
            if (c == this.okay) {
                switch (this.getMenu().getSelectedIndex()) {
                    case 0: {
                        this.getRandom();
                        this.display.setCurrent((Displayable)this.getForm());
                        this.position = "Random";
                        return;
                    }
                    case 1: {
                        this.menu = null;
                        this.display.setCurrent((Displayable)this.getCategories());
                        return;
                    }
                    case 2: {
                        this.display.setCurrent((Displayable)this.getInformation());
                        this.position = "Info";
                        return;
                    }
                    case 3: {
                        this.display.setCurrent((Displayable)this.getCredits());
                        this.position = "Credits";
                        return;
                    }
                    case 4: {
                        this.destroyApp(true);
                        this.notifyDestroyed();
                    }
                }
            } else if (c == this.exit) {
                this.destroyApp(true);
                this.notifyDestroyed();
            }
        } else if (d == this.categs) {
            if (c == this.okay) {
                switch (this.getCategories().getSelectedIndex()) {
                    case 0: {
                        this.showForm("Animals", this.animals[0]);
                        this.position = "Animals";
                        return;
                    }
                    case 1: {
                        this.showForm("Earth", this.earth[0]);
                        this.position = "Earth";
                        return;
                    }
                    case 2: {
                        this.showForm("Science", this.science[0]);
                        this.position = "Science";
                        return;
                    }
                    case 3: {
                        this.showForm("Statistics", this.stats[0]);
                        this.position = "Statistics";
                        return;
                    }
                    case 4: {
                        this.showForm("Trivia", this.trivia[0]);
                        this.position = "Trivia";
                        return;
                    }
                }
            } else if (c == this.back) {
                this.categs = null;
                this.display.setCurrent((Displayable)this.getMenu());
            }
        } else if (d == this.form) {
            if (c == this.back) {
                if (this.position.equals("Animals") || this.position.equals("Earth") || this.position.equals("Science") || this.position.equals("Statistics") || this.position.equals("Trivia")) {
                    this.count = 1;
                    this.display.setCurrent((Displayable)this.getCategories());
                } else if (this.position.equals("Random")) {
                    this.display.setCurrent((Displayable)this.getMenu());
                }
            } else if (c == this.copy) {
                this.getTextBox().setTitle("Mark and copy");
                this.getTextBox().setString("");
                this.getTextBox().setString(this.main.getText());
                this.display.setCurrent((Displayable)this.getTextBox());
            } else if (c == this.next) {
                if (this.position.equals("Animals")) {
                    this.changeItem(this.animals);
                } else if (this.position.equals("Earth")) {
                    this.changeItem(this.earth);
                } else if (this.position.equals("Science")) {
                    this.changeItem(this.science);
                } else if (this.position.equals("Statistics")) {
                    this.changeItem(this.stats);
                } else if (this.position.equals("Trivia")) {
                    this.changeItem(this.trivia);
                } else if (this.position.equals("Random")) {
                    this.main.setText(this.getRandomFact());
                }
            }
        } else if (d == this.info || d == this.credits) {
            if (c == this.back) {
                this.display.setCurrent((Displayable)this.getMenu());
            }
        } else if (d == this.textBox) {
            if (c == this.clear) {
                this.textBox.setString(null);
            } else if (c == this.back) {
                this.display.setCurrent((Displayable)this.getForm());
            }
        }
    }

    public void commandAction(Command c, Item i) {
        if (c == this.okay) {
            if (this.position.equals("Info")) {
                this.connectionRequest(this.url[0] + "3515-0-17");
                Runtime.getRuntime().gc();
            } else if (this.position.equals("Credits")) {
                this.connectionRequest(this.url[1]);
                Runtime.getRuntime().gc();
            }
        }
    }
}

