/*
 * Decompiled with CFR 0.152.
 */
package com.AI;

import com.AI.Player;
import com.AI.misc.Blood;
import com.AI.misc.Trace;
import com.Collision.Ray;
import com.Gameplay.Map.House;
import com.Gameplay.Map.Portal;
import com.Gameplay.Map.Scene;
import com.Gameplay.Objects.GameObject;
import com.Math.Matrix;
import com.Math.Vector3D;
import com.Rendering.Fps;
import com.Rendering.Graphics3D;
import com.Rendering.Meshes.Mesh;
import com.Rendering.Meshes.Polygon4V;
import com.Rendering.RenderObject;
import com.Rendering.Vertex;
import com.misc.Main;
import java.util.Vector;

public abstract class Bot
extends GameObject {
    private static Fps fps;
    public static boolean cleverPathfinfing;
    private static final Ray ray;
    private static final Vector3D tmpVec;
    private static final Vector3D side;
    private static final Vector3D up;
    private static final Vector3D dir;
    private Blood blood = new Blood(this);
    private final Vector3D bloodSpeed = new Vector3D();
    private final Vector3D bloodPos = new Vector3D();
    private Trace bloodwall = null;
    public int fraction = 0;
    public boolean deathFall = true;

    public void set(Vector3D pos) {
        this.character.reset();
        this.character.getTransform().setPosition(pos.x, pos.y, pos.z);
        this.setPart(-1);
        this.blood.reset();
    }

    public void destroy() {
        this.blood.destroy();
        this.bloodwall = null;
        this.blood = null;
    }

    protected final boolean isNeedRecomputePart() {
        return super.isNeedRecomputePart();
    }

    protected final void renderBlood(Graphics3D g3d, int sz) {
        if (this.blood.isBleeding()) {
            this.blood.render(g3d, 3250, this.bloodPos);
            this.bloodPos.add(-this.bloodSpeed.x * 200 / Fps.getFps(), -this.bloodSpeed.y * 200 / Fps.getFps(), -this.bloodSpeed.z * 200 / Fps.getFps());
        }
    }

    public boolean damage(GameObject obj, int dmg) {
        if (dmg > 0) {
            Matrix mat = this.character.getTransform();
            this.bloodPos.set(mat.m03, mat.m13 + this.character.getHeight(), mat.m23);
            if (obj != null) {
                Matrix mat2 = obj.getCharacter().getTransform();
                tmpVec.set(mat.m03 - mat2.m03, mat.m13 - mat2.m13, mat.m23 - mat2.m23);
                tmpVec.setLength2(dmg * this.character.getRadius() / 400);
                this.character.getSpeed().set(Bot.tmpVec.x, Bot.tmpVec.y, Bot.tmpVec.z);
                tmpVec.setLength2(60);
                this.bloodSpeed.set(tmpVec);
            }
            this.blood.bleed();
        }
        return super.damage(obj, dmg);
    }

    public final void update(Scene scene, Player player) {
        if (!this.isDead()) {
            this.action(scene);
        } else {
            if (this.bloodwall == null && Main.blood && (this.character.getTransform().m11 == 16384 || !this.deathFall)) {
                this.spawnBlood(scene);
            }
            if (this.deathFall) {
                this.drop(scene);
            }
        }
        super.update(scene, player);
    }

    protected abstract void action(Scene var1);

    protected void spawnBlood(Scene scene) {
        ray.reset();
        Matrix mat = this.getCharacter().getTransform();
        ray.getStart().set(mat.m03, mat.m13 + 1, mat.m23);
        ray.getDir().set(0, -10, 0);
        ray.reset();
        scene.getHouse().rayCast(this.getPart(), ray);
        if (ray.isCollision()) {
            this.bloodwall = this.createTrace(ray.getCollisionPoint(), ray.getTriangle());
            this.bloodwall.setPart(ray.getNumRoom());
            scene.getHouse().addObject(this.bloodwall);
        }
    }

    protected void drop(Scene scene) {
        if (this.character.getTransform().m11 > 0) {
            this.character.drop(-8);
        }
    }

    protected final boolean notCollided(House house, GameObject obj) {
        if (!cleverPathfinfing) {
            return this.getPart() == obj.getPart();
        }
        Matrix objMat = obj.getCharacter().getTransform();
        Matrix mat = this.character.getTransform();
        ray.reset();
        ray.getStart().set(mat.m03, mat.m13 + this.character.getHeight(), mat.m23);
        ray.getDir().set(objMat.m03 - mat.m03, objMat.m13 - mat.m13, objMat.m23 - mat.m23);
        house.rayCast(this.getPart(), ray);
        return !ray.isCollision();
    }

    protected GameObject findBot(Vector objs, GameObject ignore, int[] fractions) {
        long dis = Long.MAX_VALUE;
        GameObject bot = null;
        if (objs.isEmpty()) {
            return null;
        }
        for (int var1 = 0; var1 < objs.size(); ++var1) {
            GameObject obj;
            if (!(objs.elementAt(var1) instanceof GameObject) || (obj = (GameObject)objs.elementAt(var1)).isDead() || !(obj instanceof Bot) && !(obj instanceof Player) || obj == ignore) continue;
            long dis2 = this.getCharacter().distance(obj.getCharacter());
            if (obj instanceof Bot) {
                if (dis2 >= dis || !Bot.contains(fractions, ((Bot)obj).fraction)) continue;
                dis = dis2;
                bot = obj;
                continue;
            }
            if (dis2 >= dis || !Bot.contains(fractions, 0)) continue;
            dis = dis2;
            bot = obj;
        }
        return bot;
    }

    protected final void lookAt(int x, int z) {
        Matrix pos = this.getCharacter().getTransform();
        dir.set(pos.m03 - x, 0, pos.m23 - z);
        dir.setLength(-16384);
        if (Bot.dir.x == 0 && Bot.dir.y == 0) {
            return;
        }
        this.setDir(pos, Bot.dir.x, Bot.dir.z);
    }

    private void setDir(Matrix m, int dirX, int dirZ) {
        dir.set(dirX, 0, dirZ);
        dir.setLength(16384);
        if (Bot.equals(Bot.dir.x, Bot.dir.y, Bot.dir.z, m.m02, m.m12, m.m22)) {
            return;
        }
        up.set(0, 16384, 0);
        side.cross(up, dir, 14);
        side.setLength(16384);
        if (dir.lengthSquared() != 0 && side.lengthSquared() != 0) {
            m.setDir(Bot.dir.x, Bot.dir.y, Bot.dir.z);
            m.setSide(Bot.side.x, Bot.side.y, Bot.side.z);
            m.setUp(Bot.up.x, Bot.up.y, Bot.up.z);
        }
    }

    protected static void increaseMeshSz(Mesh mesh, int z) {
        RenderObject[] objs = mesh.getPoligons();
        for (int i = 0; i < objs.length; ++i) {
            objs[i].sz += z;
        }
    }

    protected static Portal commonPortal(House house, int part1, int part2) {
        Portal[] portals = house.getRooms()[part1].getPortals();
        for (int i = 0; i < portals.length; ++i) {
            Portal portal = portals[i];
            if (portal.getRoom() == null || portal.getRoom().getId() != part2) continue;
            return portal;
        }
        return null;
    }

    protected static void computeCentre(Portal portal, Vector3D center) {
        Vertex[] vers = portal.getVertices();
        int sx = 0;
        int sy = 0;
        int sz = 0;
        for (int i = 0; i < vers.length; ++i) {
            Vertex v = vers[i];
            sx += v.x;
            sy += v.y;
            sz += v.z;
        }
        center.set(sx /= vers.length, sy /= vers.length, sz /= vers.length);
    }

    public static boolean contains(int[] list, int need) {
        if (list == null) {
            return true;
        }
        for (int i = 0; i < list.length; ++i) {
            if (list[i] != need) continue;
            return true;
        }
        return false;
    }

    private static boolean equals(int ax, int ay, int az, int bx, int by, int bz) {
        return Math.abs(ax - bx) < 20 && Math.abs(ay - by) < 20 && Math.abs(az - bz) < 20;
    }

    protected static long sqr(int x) {
        return (long)x * (long)x;
    }

    public Trace createTrace(Vector3D vector3f, RenderObject meshr) {
        int minx = 0;
        int miny = 0;
        int minz = 0;
        int maxx = 0;
        int maxy = 0;
        int maxz = 0;
        Vector3D v1 = new Vector3D(0, 0, 0);
        Vector3D v2 = new Vector3D(0, 0, 0);
        Vector3D v3 = new Vector3D(0, 0, 0);
        Vector3D v4 = new Vector3D(0, 0, 0);
        if (meshr instanceof Polygon4V) {
            Polygon4V p4v = (Polygon4V)meshr;
            int posx = (p4v.a.x + p4v.b.x + p4v.c.x + p4v.d.x) / 4;
            int posy = (p4v.a.y + p4v.b.y + p4v.c.y + p4v.d.y) / 4;
            int posz = (p4v.a.z + p4v.b.z + p4v.c.z + p4v.d.z) / 4;
            minx = Math.min(Math.min(Math.min(p4v.a.x, p4v.b.x), p4v.c.x), p4v.d.x) - posx;
            miny = Math.min(Math.min(Math.min(p4v.a.y, p4v.b.y), p4v.c.y), p4v.d.y) - posy;
            minz = Math.min(Math.min(Math.min(p4v.a.z, p4v.b.z), p4v.c.z), p4v.d.z) - posz;
            maxx = Math.max(Math.max(Math.max(p4v.a.x, p4v.b.x), p4v.c.x), p4v.d.x) - posx;
            maxy = Math.max(Math.max(Math.max(p4v.a.y, p4v.b.y), p4v.c.y), p4v.d.y) - posy;
            maxz = Math.max(Math.max(Math.max(p4v.a.z, p4v.b.z), p4v.c.z), p4v.d.z) - posz;
            v1.set(p4v.a.x - posx, p4v.a.y - posy, p4v.a.z - posz);
            v2.set(p4v.b.x - posx, p4v.b.y - posy, p4v.b.z - posz);
            v3.set(p4v.c.x - posx, p4v.c.y - posy, p4v.c.z - posz);
            v4.set(p4v.d.x - posx, p4v.d.y - posy, p4v.d.z - posz);
        }
        return new Trace(vector3f.x, vector3f.y, vector3f.z, v1, v2, v3, v4, new Vector3D(Math.abs(minx) + Math.abs(maxx), Math.abs(miny) + Math.abs(maxy), Math.abs(minz) + Math.abs(maxz)));
    }

    static {
        cleverPathfinfing = false;
        ray = new Ray();
        tmpVec = new Vector3D();
        side = new Vector3D();
        up = new Vector3D();
        dir = new Vector3D();
    }
}

