/*
 * Decompiled with CFR 0.152.
 */
package com.Gameplay.Map;

import com.Collision.Ray;
import com.Collision.RayCast;
import com.Gameplay.Map.House;
import com.Gameplay.Map.Light;
import com.Gameplay.Map.Room;
import com.Math.MathUtils;
import com.Math.Vector3D;
import com.Rendering.Graphics3D;
import com.Rendering.Meshes.LightedPolygon3V;
import com.Rendering.Meshes.LightedPolygon4V;
import com.Rendering.Meshes.Mesh;
import com.Rendering.Meshes.Polygon3V;
import com.Rendering.Meshes.Polygon4V;
import com.Rendering.RenderObject;
import com.Rendering.Vertex;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.OutputConnection;
import javax.microedition.io.file.FileConnection;

public class LightMapper {
    public static int aoDistance = 2048;
    public static int aoIntensity = 315;
    public static int ambientLight = 64;
    public static int skyLightIntensity = 512;
    public static int sunLightIntensity = 0;
    public static boolean cameraVectorLight = false;
    public static Ray ray;
    private static final int meterUnit = 885;
    private static final int sqrMeter = 783225;
    public static Light[] lights;

    public static void reset() {
        aoDistance = 2048;
        aoIntensity = 315;
        ambientLight = 64;
        skyLightIntensity = 512;
        sunLightIntensity = 0;
        cameraVectorLight = false;
    }

    public static final void generateLightMap(House house, Mesh[] meshes) {
        Room room;
        int i;
        long totalBeginTime = System.currentTimeMillis();
        Room[] rooms = house.getRooms();
        ray = new Ray();
        LightMapper.ray.findNearest = true;
        LightMapper.ray.infinity = true;
        long beginTime = System.currentTimeMillis();
        System.out.println("Generating sun and sky light...");
        for (i = 0; i < rooms.length; ++i) {
            room = rooms[i];
            if (room == null) continue;
            LightMapper.calculateSkyLight(house, room, meshes);
        }
        System.out.println("Sun and sky light done in: " + (System.currentTimeMillis() / 1000L - beginTime / 1000L) + " seconds");
        beginTime = System.currentTimeMillis();
        System.out.println("Generating ambient occulusion...");
        for (i = 0; i < rooms.length; ++i) {
            room = rooms[i];
            if (room == null || aoIntensity == 0) continue;
            LightMapper.calculateAO(house, room, meshes);
        }
        ray.reset();
        System.out.println("Ambient occulusion done in: " + (System.currentTimeMillis() / 1000L - beginTime / 1000L) + " seconds");
        beginTime = System.currentTimeMillis();
        System.out.println("Generating lights...");
        for (i = 0; i < rooms.length; ++i) {
            room = rooms[i];
            if (room == null || lights == null) continue;
            LightMapper.calculateLights(house, room, meshes);
        }
        ray.reset();
        System.out.println("Lights done in: " + (System.currentTimeMillis() / 1000L - beginTime / 1000L) + " seconds");
        System.out.println("Lightmapping done in: " + (System.currentTimeMillis() / 1000L - totalBeginTime / 1000L) + " seconds");
    }

    private static boolean checkOpenSky(House house, Room room) {
        if (room.isOpenSky()) {
            return true;
        }
        Room[] rooms = house.getNeighbourRooms(room.getId());
        if (rooms == null) {
            return false;
        }
        for (int i = 0; i < rooms.length; ++i) {
            if (rooms[i] == null || !rooms[i].isOpenSky()) continue;
            return true;
        }
        return false;
    }

    private static void calculateSkyLight(House house, Room room, Mesh[] meshes) {
        Vertex tmp = new Vertex();
        RenderObject[] objs = room.fullMesh.getPolygons();
        for (int i = 0; i < objs.length; ++i) {
            RenderObject pol;
            if (objs[i] instanceof LightedPolygon3V) {
                pol = (LightedPolygon3V)objs[i];
                tmp.set(pol.a);
                tmp.add(pol.b.x, pol.b.y, pol.b.z);
                tmp.add(pol.c.x, pol.c.y, pol.c.z);
                tmp.div(3, 3, 3);
                pol.la = (byte)Math.min(127, pol.la + LightMapper.skySunLight(house, meshes, pol.a, pol.nx, pol.ny, pol.nz, tmp));
                pol.lb = (byte)Math.min(127, pol.lb + LightMapper.skySunLight(house, meshes, pol.b, pol.nx, pol.ny, pol.nz, tmp));
                pol.lc = (byte)Math.min(127, pol.lc + LightMapper.skySunLight(house, meshes, pol.c, pol.nx, pol.ny, pol.nz, tmp));
                continue;
            }
            if (!(objs[i] instanceof LightedPolygon4V)) continue;
            pol = (LightedPolygon4V)objs[i];
            tmp.set(((LightedPolygon4V)pol).a);
            tmp.add(((LightedPolygon4V)pol).b.x, ((LightedPolygon4V)pol).b.y, ((LightedPolygon4V)pol).b.z);
            tmp.add(((LightedPolygon4V)pol).c.x, ((LightedPolygon4V)pol).c.y, ((LightedPolygon4V)pol).c.z);
            tmp.add(((LightedPolygon4V)pol).d.x, ((LightedPolygon4V)pol).d.y, ((LightedPolygon4V)pol).d.z);
            tmp.div(4, 4, 4);
            ((LightedPolygon4V)pol).la = (byte)Math.min(127, ((LightedPolygon4V)pol).la + LightMapper.skySunLight(house, meshes, ((LightedPolygon4V)pol).a, ((LightedPolygon4V)pol).nx, ((LightedPolygon4V)pol).ny, ((LightedPolygon4V)pol).nz, tmp));
            ((LightedPolygon4V)pol).lb = (byte)Math.min(127, ((LightedPolygon4V)pol).lb + LightMapper.skySunLight(house, meshes, ((LightedPolygon4V)pol).b, ((LightedPolygon4V)pol).nx, ((LightedPolygon4V)pol).ny, ((LightedPolygon4V)pol).nz, tmp));
            ((LightedPolygon4V)pol).lc = (byte)Math.min(127, ((LightedPolygon4V)pol).lc + LightMapper.skySunLight(house, meshes, ((LightedPolygon4V)pol).c, ((LightedPolygon4V)pol).nx, ((LightedPolygon4V)pol).ny, ((LightedPolygon4V)pol).nz, tmp));
            ((LightedPolygon4V)pol).ld = (byte)Math.min(127, ((LightedPolygon4V)pol).ld + LightMapper.skySunLight(house, meshes, ((LightedPolygon4V)pol).d, ((LightedPolygon4V)pol).nx, ((LightedPolygon4V)pol).ny, ((LightedPolygon4V)pol).nz, tmp));
        }
    }

    private static void calculateAO(House house, Room room, Mesh[] meshes) {
        Vertex tmp = new Vertex();
        RenderObject[] objs = room.fullMesh.getPolygons();
        for (int i = 0; i < objs.length; ++i) {
            RenderObject pol;
            if (objs[i] instanceof LightedPolygon3V) {
                pol = (LightedPolygon3V)objs[i];
                tmp.set(pol.a);
                tmp.add(pol.b.x, pol.b.y, pol.b.z);
                tmp.add(pol.c.x, pol.c.y, pol.c.z);
                tmp.div(3, 3, 3);
                pol.la = LightMapper.ambientOcculusion(house, meshes, pol.a, pol.nx, pol.ny, pol.nz, tmp, pol.la);
                pol.lb = LightMapper.ambientOcculusion(house, meshes, pol.b, pol.nx, pol.ny, pol.nz, tmp, pol.lb);
                pol.lc = LightMapper.ambientOcculusion(house, meshes, pol.c, pol.nx, pol.ny, pol.nz, tmp, pol.lc);
                continue;
            }
            if (!(objs[i] instanceof LightedPolygon4V)) continue;
            pol = (LightedPolygon4V)objs[i];
            tmp.set(((LightedPolygon4V)pol).a);
            tmp.add(((LightedPolygon4V)pol).b.x, ((LightedPolygon4V)pol).b.y, ((LightedPolygon4V)pol).b.z);
            tmp.add(((LightedPolygon4V)pol).c.x, ((LightedPolygon4V)pol).c.y, ((LightedPolygon4V)pol).c.z);
            tmp.add(((LightedPolygon4V)pol).d.x, ((LightedPolygon4V)pol).d.y, ((LightedPolygon4V)pol).d.z);
            tmp.div(4, 4, 4);
            ((LightedPolygon4V)pol).la = LightMapper.ambientOcculusion(house, meshes, ((LightedPolygon4V)pol).a, ((LightedPolygon4V)pol).nx, ((LightedPolygon4V)pol).ny, ((LightedPolygon4V)pol).nz, tmp, ((LightedPolygon4V)pol).la);
            ((LightedPolygon4V)pol).lb = LightMapper.ambientOcculusion(house, meshes, ((LightedPolygon4V)pol).b, ((LightedPolygon4V)pol).nx, ((LightedPolygon4V)pol).ny, ((LightedPolygon4V)pol).nz, tmp, ((LightedPolygon4V)pol).lb);
            ((LightedPolygon4V)pol).lc = LightMapper.ambientOcculusion(house, meshes, ((LightedPolygon4V)pol).c, ((LightedPolygon4V)pol).nx, ((LightedPolygon4V)pol).ny, ((LightedPolygon4V)pol).nz, tmp, ((LightedPolygon4V)pol).lc);
            ((LightedPolygon4V)pol).ld = LightMapper.ambientOcculusion(house, meshes, ((LightedPolygon4V)pol).d, ((LightedPolygon4V)pol).nx, ((LightedPolygon4V)pol).ny, ((LightedPolygon4V)pol).nz, tmp, ((LightedPolygon4V)pol).ld);
        }
    }

    private static void calculateLights(House house, Room room, Mesh[] meshes) {
        Vertex tmp = new Vertex();
        RenderObject[] objs = room.fullMesh.getPolygons();
        for (int i = 0; i < objs.length; ++i) {
            RenderObject pol;
            if (objs[i] instanceof LightedPolygon3V) {
                pol = (LightedPolygon3V)objs[i];
                tmp.set(pol.a);
                tmp.add(pol.b.x, pol.b.y, pol.b.z);
                tmp.add(pol.c.x, pol.c.y, pol.c.z);
                tmp.div(3, 3, 3);
                pol.la = LightMapper.lightCalcMini(house, meshes, pol.a, pol.nx, pol.ny, pol.nz, tmp, pol.la);
                pol.lb = LightMapper.lightCalcMini(house, meshes, pol.b, pol.nx, pol.ny, pol.nz, tmp, pol.lb);
                pol.lc = LightMapper.lightCalcMini(house, meshes, pol.c, pol.nx, pol.ny, pol.nz, tmp, pol.lc);
                continue;
            }
            if (!(objs[i] instanceof LightedPolygon4V)) continue;
            pol = (LightedPolygon4V)objs[i];
            tmp.set(((LightedPolygon4V)pol).a);
            tmp.add(((LightedPolygon4V)pol).b.x, ((LightedPolygon4V)pol).b.y, ((LightedPolygon4V)pol).b.z);
            tmp.add(((LightedPolygon4V)pol).c.x, ((LightedPolygon4V)pol).c.y, ((LightedPolygon4V)pol).c.z);
            tmp.add(((LightedPolygon4V)pol).d.x, ((LightedPolygon4V)pol).d.y, ((LightedPolygon4V)pol).d.z);
            tmp.div(4, 4, 4);
            ((LightedPolygon4V)pol).la = LightMapper.lightCalcMini(house, meshes, ((LightedPolygon4V)pol).a, ((LightedPolygon4V)pol).nx, ((LightedPolygon4V)pol).ny, ((LightedPolygon4V)pol).nz, tmp, ((LightedPolygon4V)pol).la);
            ((LightedPolygon4V)pol).lb = LightMapper.lightCalcMini(house, meshes, ((LightedPolygon4V)pol).b, ((LightedPolygon4V)pol).nx, ((LightedPolygon4V)pol).ny, ((LightedPolygon4V)pol).nz, tmp, ((LightedPolygon4V)pol).lb);
            ((LightedPolygon4V)pol).lc = LightMapper.lightCalcMini(house, meshes, ((LightedPolygon4V)pol).c, ((LightedPolygon4V)pol).nx, ((LightedPolygon4V)pol).ny, ((LightedPolygon4V)pol).nz, tmp, ((LightedPolygon4V)pol).lc);
            ((LightedPolygon4V)pol).ld = LightMapper.lightCalcMini(house, meshes, ((LightedPolygon4V)pol).d, ((LightedPolygon4V)pol).nx, ((LightedPolygon4V)pol).ny, ((LightedPolygon4V)pol).nz, tmp, ((LightedPolygon4V)pol).ld);
        }
    }

    private static int calculateNormal(Mesh[] meshes, Vector3D norm, int nx, int ny, int nz, Vertex vert, int maxRot, int D, boolean div) {
        int polys = 0;
        for (int r = 0; r < meshes.length - 1; ++r) {
            polys = LightMapper.calcMeshNormals(meshes[r].getPolygons(), norm, nx, ny, nz, vert, maxRot, polys, D);
        }
        if (polys > 1 && div) {
            norm.div(polys, polys, polys);
        }
        return polys;
    }

    private static int calcMeshNormals(RenderObject[] objs, Vector3D norm, int nx, int ny, int nz, Vertex vert, int maxRot, int polys, int D) {
        for (int i = 0; i < objs.length; ++i) {
            RenderObject pol;
            if (objs[i] instanceof Polygon3V) {
                pol = (Polygon3V)objs[i];
                if (!LightMapper.distance(pol.a, vert, D) && !LightMapper.distance(pol.b, vert, D) && !LightMapper.distance(pol.c, vert, D) || !LightMapper.distance(pol.nx, pol.ny, pol.nz, nx, ny, nz, maxRot)) continue;
                norm.add(pol.nx, pol.ny, pol.nz);
                ++polys;
                continue;
            }
            if (!(objs[i] instanceof Polygon4V)) continue;
            pol = (Polygon4V)objs[i];
            if (!LightMapper.distance(((Polygon4V)pol).a, vert, D) && !LightMapper.distance(((Polygon4V)pol).b, vert, D) && !LightMapper.distance(((Polygon4V)pol).c, vert, D) && !LightMapper.distance(((Polygon4V)pol).d, vert, D) || !LightMapper.distance(((Polygon4V)pol).nx, ((Polygon4V)pol).ny, ((Polygon4V)pol).nz, nx, ny, nz, maxRot)) continue;
            norm.add(((Polygon4V)pol).nx, ((Polygon4V)pol).ny, ((Polygon4V)pol).nz);
            ++polys;
        }
        return polys;
    }

    private static boolean distance(Vertex a, Vertex b, int D) {
        return Math.abs(a.x - b.x) <= D && Math.abs(a.y - b.y) <= D && Math.abs(a.z - b.z) <= D;
    }

    private static long distanceSqr(Vector3D a, Vector3D b) {
        return (a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y) + (a.z - b.z) * (a.z - b.z);
    }

    private static long distanceSqr(Vertex a, Vector3D b) {
        return (a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y) + (a.z - b.z) * (a.z - b.z);
    }

    private static boolean distance(int x1, int y1, int z1, int x, int y, int z, int D) {
        return Math.abs(x1 - x) < D && Math.abs(y1 - y) < D && Math.abs(z1 - z) < D;
    }

    private static void rayRepeat(int length, int steps, Mesh[] meshes) {
        int o;
        ray.getDir().setLength(length);
        for (o = 0; o < steps; ++o) {
            for (int i = 0; i < meshes.length - 1; ++i) {
                RayCast.rayCast(meshes[i], ray);
            }
            if (ray.isCollision()) break;
            LightMapper.ray.getDir().x -= Graphics3D.lightdirx;
            LightMapper.ray.getDir().y -= Graphics3D.lightdiry;
            LightMapper.ray.getDir().z -= Graphics3D.lightdirz;
        }
        LightMapper.ray.distance += ray.getDir().length() * o;
    }

    private static void rayRepeatSky(int length, int steps, Mesh[] meshes) {
        int o;
        ray.getDir().setLength(length);
        int rx = LightMapper.ray.getDir().x;
        int ry = LightMapper.ray.getDir().y;
        int rz = LightMapper.ray.getDir().z;
        for (o = 0; o < steps; ++o) {
            for (int i = 0; i < meshes.length - 1; ++i) {
                RayCast.rayCast(meshes[i], ray);
            }
            if (ray.isCollision()) break;
            LightMapper.ray.getDir().x += rx;
            LightMapper.ray.getDir().y += ry;
            LightMapper.ray.getDir().z += rz;
        }
        LightMapper.ray.distance += ray.getDir().length() * o;
    }

    private static byte ambientOcculusion(House house, Mesh[] meshes, Vertex vert, int nx, int ny, int nz, Vertex polCentre, byte bri) {
        Vector3D posCheck = new Vector3D(0, 0, 0);
        Vector3D norm = new Vector3D(nx, ny, nz);
        Vector3D norm2 = new Vector3D(nx, ny, nz);
        posCheck.set(0, 0, 0);
        int polys = LightMapper.calculateNormal(meshes, posCheck, nx, ny, nz, vert, 6000, 3, false);
        norm2.set(posCheck);
        norm2.div(polys, polys, polys);
        posCheck.setLength(4096);
        if (polys > 1) {
            int mz;
            int my;
            int r = 6;
            Vector3D ps = new Vector3D(0, 0, 0);
            ps.set(posCheck);
            posCheck.div(polys, polys, polys);
            int mx = posCheck.x / 256;
            if (mx > -6 && mx < 6 && ps.x != 0) {
                mx = ps.x * 6 / Math.abs(ps.x);
            }
            if ((my = posCheck.y / 256) > -6 && my < 6 && ps.y != 0) {
                my = ps.y * 6 / Math.abs(ps.y);
            }
            if ((mz = posCheck.z / 256) > -6 && mz < 6 && ps.z != 0) {
                mz = ps.z * 6 / Math.abs(ps.z);
            }
            posCheck.set(vert.x - mx, vert.y - my, vert.z - mz);
        } else {
            posCheck.set((vert.x * 3 + polCentre.x) / 4 - nx / 256, (vert.y * 3 + polCentre.y) / 4 - ny / 256, (vert.z * 3 + polCentre.z) / 4 - nz / 256);
        }
        int skydomelight = 0;
        int rays = 0;
        if (aoIntensity != 0) {
            LightMapper.calculateNormal(meshes, norm, nx, ny, nz, vert, 2700, 1, true);
            for (int x = -4096; x <= 4096; x += 2048) {
                for (int y = -4096; y <= 4096; y += 2048) {
                    for (int z = -4096; z <= 4096; z += 2048) {
                        ++rays;
                        int shadow2 = 0;
                        int lit = MathUtils.calcLight(-x, -y, -z, norm.x, norm.y, norm.z);
                        ray.reset();
                        ray.getDir().set(x, y, z);
                        ray.getDir().setLength(4096);
                        ray.getStart().set(posCheck);
                        for (int i = 0; i < meshes.length - 1; ++i) {
                            RayCast.rayCast(meshes[i], ray);
                        }
                        if (ray.isCollision() && ray.getDistance() < aoDistance) {
                            shadow2 += Math.min(255, Math.max(aoDistance - ray.getDistance(), 0) * 255 / aoDistance);
                        }
                        skydomelight += shadow2 * lit / 255;
                    }
                }
            }
        }
        int ao = Math.min(255, Math.max(255 - skydomelight / rays * aoIntensity / 255, 0));
        return (byte)(Math.max(0, Math.min((bri + 128) * ao >> 8, 255)) - 128);
    }

    private static byte lightCalcMini(House house, Mesh[] meshes, Vertex vert, int nx, int ny, int nz, Vertex polCentre, byte bri) {
        Vector3D posCheck = new Vector3D(0, 0, 0);
        Vector3D norm = new Vector3D(nx, ny, nz);
        Vector3D norm2 = new Vector3D(nx, ny, nz);
        posCheck.set(0, 0, 0);
        int polys = LightMapper.calculateNormal(meshes, posCheck, nx, ny, nz, vert, 6000, 3, false);
        norm2.set(posCheck);
        norm2.div(polys, polys, polys);
        posCheck.setLength(4096);
        if (polys > 1) {
            int mz;
            int my;
            int r = 6;
            Vector3D ps = new Vector3D(0, 0, 0);
            ps.set(posCheck);
            posCheck.div(polys, polys, polys);
            int mx = posCheck.x / 256;
            if (mx > -6 && mx < 6 && ps.x != 0) {
                mx = ps.x * 6 / Math.abs(ps.x);
            }
            if ((my = posCheck.y / 256) > -6 && my < 6 && ps.y != 0) {
                my = ps.y * 6 / Math.abs(ps.y);
            }
            if ((mz = posCheck.z / 256) > -6 && mz < 6 && ps.z != 0) {
                mz = ps.z * 6 / Math.abs(ps.z);
            }
            posCheck.set(vert.x - mx, vert.y - my, vert.z - mz);
        } else {
            posCheck.set((vert.x * 3 + polCentre.x) / 4 - nx / 256, (vert.y * 3 + polCentre.y) / 4 - ny / 256, (vert.z * 3 + polCentre.z) / 4 - nz / 256);
        }
        int lit = 0;
        for (int i = 0; i < lights.length; ++i) {
            Light light = lights[i];
            long distSqr = LightMapper.distanceSqr(vert, light.pos);
            int intensity = (int)((long)(light.brightness * 8 * 783225) / Math.max(1L, distSqr));
            if (distSqr < 0L) {
                intensity = 0;
            }
            if (intensity > 1) {
                if (light.direction == null) {
                    intensity = intensity * MathUtils.calcLight(norm.x, norm.y, norm.z, vert.x - light.pos.x, vert.y - light.pos.y, vert.z - light.pos.z) / 255;
                } else {
                    Vector3D direction = light.direction;
                    intensity = intensity * MathUtils.calcLight(direction.x, direction.y, direction.z, vert.x - light.pos.x, vert.y - light.pos.y, vert.z - light.pos.z) / 255;
                    intensity = intensity * MathUtils.calcLight(norm.x, norm.y, norm.z, -direction.x, -direction.y, -direction.z) / 255;
                }
                if (intensity > 1) {
                    ray.reset();
                    ray.getDir().set(light.pos.x - posCheck.x, light.pos.y - posCheck.y, light.pos.z - posCheck.z);
                    ray.getStart().set(posCheck);
                    for (int i2 = 0; i2 < meshes.length - 1; ++i2) {
                        RayCast.rayCast(meshes[i2], ray);
                    }
                    if (ray.isCollision() && (long)(ray.getDistance() * ray.getDistance()) <= distSqr && ray.getDistance() > 0) {
                        intensity = 0;
                    }
                }
            }
            if (intensity <= 1) continue;
            lit += intensity;
        }
        return (byte)Math.max(-128, Math.min(lit + bri, 127));
    }

    private static int skySunLight(House house, Mesh[] meshes, Vertex vert, int nx, int ny, int nz, Vertex polCentre) {
        int skyLitDirectional = 0;
        int shadow = 255;
        Vector3D posCheck = new Vector3D(0, 0, 0);
        int polys = LightMapper.calculateNormal(meshes, posCheck, nx, ny, nz, vert, 2700, 5, true);
        Vector3D norm = new Vector3D(nx, ny, nz);
        norm.setLength(4096);
        if (polys > 1) {
            norm.set(posCheck);
        }
        posCheck.set(0, 0, 0);
        polys = LightMapper.calculateNormal(meshes, posCheck, nx, ny, nz, vert, 6000, 1, false);
        posCheck.setLength(4096);
        if (polys > 1) {
            int mz;
            int my;
            int r = 6;
            Vector3D ps = new Vector3D(0, 0, 0);
            ps.set(posCheck);
            posCheck.div(polys, polys, polys);
            int mx = posCheck.x / 256;
            if (mx > -6 && mx < 6 && ps.x != 0) {
                mx = ps.x * 6 / Math.abs(ps.x);
            }
            if ((my = posCheck.y / 256) > -6 && my < 6 && ps.y != 0) {
                my = ps.y * 6 / Math.abs(ps.y);
            }
            if ((mz = posCheck.z / 256) > -6 && mz < 6 && ps.z != 0) {
                mz = ps.z * 6 / Math.abs(ps.z);
            }
            posCheck.set(vert.x - mx, vert.y - my, vert.z - mz);
        } else {
            posCheck.set((vert.x * 3 + polCentre.x) / 4 - nx / 256, (vert.y * 3 + polCentre.y) / 4 - ny / 256, (vert.z * 3 + polCentre.z) / 4 - nz / 256);
        }
        if (sunLightIntensity != 0) {
            int i;
            skyLitDirectional = MathUtils.calcLight(Graphics3D.lightdirx, Graphics3D.lightdiry, Graphics3D.lightdirz, norm.x, norm.y, norm.z);
            ray.reset();
            ray.getStart().set(posCheck);
            ray.getDir().set(-Graphics3D.lightdirx, -Graphics3D.lightdiry, -Graphics3D.lightdirz);
            ray.getDir().setLength(30000);
            for (i = 0; i < meshes.length - 1; ++i) {
                RayCast.rayCast(meshes[i], ray);
            }
            ray.getDir().setLength(4096);
            for (i = 0; i < meshes.length - 1; ++i) {
                RayCast.rayCast(meshes[i], ray);
            }
            if (ray.isCollision()) {
                shadow = 0;
            }
            ray.reset();
        }
        int skydomelight = 0;
        int rays = 0;
        if (skyLightIntensity != 0) {
            LightMapper.calculateNormal(meshes, norm, nx, ny, nz, vert, 2700, 1, true);
            for (int x = -4096; x < 4096; x += 2048) {
                for (int y = 0; y < 4096; y += 1024) {
                    for (int z = -4096; z < 4096; z += 2048) {
                        ++rays;
                        int shadow2 = 255;
                        int lit = MathUtils.calcLight(-x, -y, -z, norm.x, norm.y, norm.z);
                        if (lit > 0) {
                            ray.reset();
                            ray.getDir().set(x, y, z);
                            ray.getDir().setLength(4096);
                            ray.getStart().set(posCheck);
                            for (int i = 0; i < meshes.length - 1; ++i) {
                                RayCast.rayCast(meshes[i], ray);
                            }
                            if (ray.isCollision()) {
                                shadow2 = 0;
                            }
                        }
                        skydomelight += shadow2 * lit >> 8;
                    }
                }
            }
        }
        if (rays == 0) {
            rays = 1;
        }
        return shadow * skyLitDirectional / 255 * sunLightIntensity / 255 + skydomelight / rays * skyLightIntensity / 255 + ambientLight;
    }

    public static void saveLightMap(Mesh[] meshes, String lightdataFile) {
        try {
            OutputConnection con = (OutputConnection)Connector.open((String)"file:///root/lightmap.vla", (int)2);
            FileConnection fc = (FileConnection)con;
            if (!fc.exists()) {
                fc.create();
            } else {
                fc.delete();
                fc.create();
            }
            OutputStream out = con.openOutputStream();
            DataOutputStream dos = new DataOutputStream(out);
            int size = 0;
            for (int i = 0; i < meshes.length; ++i) {
                RenderObject[] objs = meshes[i].getPolygons();
                for (int x = 0; x < objs.length; ++x) {
                    if (objs[x] instanceof LightedPolygon3V) {
                        size += 3;
                        continue;
                    }
                    if (!(objs[x] instanceof LightedPolygon4V)) continue;
                    size += 4;
                }
            }
            byte[] lightdata = new byte[size];
            size = 0;
            for (int i = 0; i < meshes.length; ++i) {
                RenderObject[] objs = meshes[i].getPolygons();
                for (int x = 0; x < objs.length; ++x) {
                    RenderObject pol;
                    if (objs[x] instanceof LightedPolygon3V) {
                        pol = (LightedPolygon3V)objs[x];
                        lightdata[size++] = pol.la;
                        lightdata[size++] = pol.lb;
                        lightdata[size++] = pol.lc;
                        continue;
                    }
                    if (!(objs[x] instanceof LightedPolygon4V)) continue;
                    pol = (LightedPolygon4V)objs[x];
                    lightdata[size++] = ((LightedPolygon4V)pol).la;
                    lightdata[size++] = ((LightedPolygon4V)pol).lb;
                    lightdata[size++] = ((LightedPolygon4V)pol).lc;
                    lightdata[size++] = ((LightedPolygon4V)pol).ld;
                }
            }
            dos.write(lightdata);
            dos.close();
            con.close();
        }
        catch (Exception exc) {
            System.out.println("Lightmap save error: " + exc.getMessage());
        }
    }

    public static void loadLightMap(Mesh[] meshes, String lightdataFile) {
        try {
            InputStream is = new Object().getClass().getResourceAsStream(lightdataFile);
            DataInputStream dis = new DataInputStream(is);
            for (int i = 0; i < meshes.length; ++i) {
                RenderObject[] objs = meshes[i].getPolygons();
                for (int x = 0; x < objs.length; ++x) {
                    RenderObject pol;
                    if (objs[x] instanceof LightedPolygon3V) {
                        pol = (LightedPolygon3V)objs[x];
                        pol.la = dis.readByte();
                        pol.lb = dis.readByte();
                        pol.lc = dis.readByte();
                        continue;
                    }
                    if (!(objs[x] instanceof LightedPolygon4V)) continue;
                    pol = (LightedPolygon4V)objs[x];
                    ((LightedPolygon4V)pol).la = dis.readByte();
                    ((LightedPolygon4V)pol).lb = dis.readByte();
                    ((LightedPolygon4V)pol).lc = dis.readByte();
                    ((LightedPolygon4V)pol).ld = dis.readByte();
                }
            }
            dis.close();
            is.close();
        }
        catch (Exception exc) {
            System.out.println("Lightmap load error: " + exc.getMessage());
        }
    }
}

