/*
 * Decompiled with CFR 0.152.
 */
package com.Gameplay;

import com.AI.BigZombie;
import com.AI.Bot;
import com.AI.NPC;
import com.AI.Player;
import com.AI.Zombie;
import com.Gameplay.Arsenal;
import com.Gameplay.GameScreen;
import com.Gameplay.Map.House;
import com.Gameplay.Map.HouseCreator;
import com.Gameplay.Map.Light;
import com.Gameplay.Map.LightMapper;
import com.Gameplay.Map.Room;
import com.Gameplay.Map.RoomObject;
import com.Gameplay.Map.Scene;
import com.Gameplay.Map.Skybox;
import com.Gameplay.Objects.GameObject;
import com.Gameplay.Objects.Image2D;
import com.Gameplay.Objects.KeyObject;
import com.Gameplay.Objects.LVLChange;
import com.Gameplay.Objects.MeshObject;
import com.Gameplay.Objects.NPCSpawner;
import com.Gameplay.Objects.ShopObject;
import com.Gameplay.Objects.SpriteObject;
import com.Gameplay.Objects.Teleport;
import com.Gameplay.Shop;
import com.Math.Vector3D;
import com.Rendering.Camera;
import com.Rendering.Graphics3D;
import com.Rendering.Meshes.Mesh;
import com.Rendering.Meshes.MeshImage;
import com.Rendering.Meshes.Sprite;
import com.Rendering.MultyTexture;
import com.Rendering.Texture;
import com.Rendering.Vertex;
import com.misc.Asset;
import com.misc.ImageResize;
import com.misc.Main;
import com.misc.Stringer;
import com.misc.WeatherGenerator;
import java.util.Vector;
import javax.microedition.lcdui.Image;

public class Respawn {
    public final Vector3D point;
    public final int part;
    private static Main main;
    public byte mode = (byte)-128;
    public byte cmode = (byte)-128;
    public boolean respa = false;
    public static boolean defaultOneBot;

    public Respawn(Vector3D point, House house) {
        this.point = point;
        this.part = house.computePart(-1, point.x, point.y, point.z);
        if (this.part == -1) {
            System.out.println("ERROR: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u0430\u044f \u0442\u043e\u0447\u043a\u0430 \u0441\u0442\u0430\u0440\u0442\u0430 " + point.x + " " + point.y + " " + point.z);
        }
    }

    public static final Scene createScene(int width, int height, String file, Main main, GameScreen gs) {
        String str;
        boolean botsInLevel;
        String file2 = Mesh.getStringFromResource(file);
        int endpos = file2.indexOf(91);
        if (endpos >= 0) {
            file2 = file2.substring(0, endpos - 1);
        }
        Stringer var10 = new Stringer(file2);
        int d = 0;
        Main.zombiemod = null;
        Main.bigzombiemod = null;
        Main.bigzombietex = null;
        Main.zombietex = null;
        Main.zombieanimspeed = 140;
        Main.zombieattackanimspeed = 700;
        Main.zombiedamage = 1;
        Main.zombieattackradius = 1.2f;
        Main.zombiejumpheight = 140;
        Main.zombiejumpspeed = 1.2f;
        Main.zombiespeed = 140;
        Main.zombiereacttimer = 8;
        Main.zombieattacktimer = 8;
        Main.zombieai = 1;
        Main.zombieplayerreaction = 2;
        Main.zombieattacktrigger = 2;
        Main.bigzombieanimspeed = 135;
        Main.bigzombieattackanimspeed = 270;
        Main.bigzombiedamage = 7;
        Main.bigzombieattackradius = 1.2f;
        Main.bigzombiejumpheight = 202;
        Main.bigzombiejumpspeed = 1.2f;
        Main.bigzombiejumpheight2 = 202;
        Main.bigzombiejumpspeed2 = 1.5f;
        Main.bigzombiespeed = 135;
        Main.bigzombiereacttimer = 8;
        Main.bigzombieattacktimer = 14;
        Main.bigzombieai = 1;
        Main.bigzombieplayerreaction = 2;
        Main.bigzombieattacktrigger = 2;
        Main.zombieprice = 10;
        Main.bigzombieprice = 30;
        Zombie.max_hp = 100;
        BigZombie.max_hp = 400;
        String zombiemod = "/zombie.3d";
        String zombietex = "/zombie.png";
        String bigzombiemod = "/big_zombie.3d";
        String bigzombietex = "/big_zombie.png";
        Zombie.attack = new int[]{0, 3};
        BigZombie.attack = new int[]{0, 3};
        float bigzombiescale = 50.0f;
        float zombiescale = 4.5f;
        Stringer setting = Main.settings;
        defaultOneBot = Respawn.getInt("SPAWN_ONE_ENEMY", var10, setting, 0) == 1;
        Bot.cleverPathfinfing = Respawn.getInt("BOTS_CLEVER_PATHFINDING", var10, setting, 1) == 1;
        float var3 = 1.0f;
        if (setting.getString("WORLD_SCALE") != null) {
            var3 = setting.getFloat("WORLD_SCALE");
        }
        if (var10.getString("WORLD_SCALE") != null) {
            var3 = var10.getFloat("WORLD_SCALE");
        }
        Main.offsetsz = 0;
        if (setting.getString("FLOOR_OFFSETSZ") != null) {
            Main.offsetsz = setting.getInt("FLOOR_OFFSETSZ");
        }
        if (var10.getString("FLOOR_OFFSETSZ") != null) {
            Main.offsetsz = var10.getInt("FLOOR_OFFSETSZ");
        }
        Main.fullScreenSight = false;
        if (Respawn.getString("MAXIMIZE_SIGHT", var10, setting) != null && Respawn.getString("MAXIMIZE_SIGHT", var10, setting).equals("1")) {
            Main.fullScreenSight = true;
        }
        Main.originalSight = false;
        if (Respawn.getString("ORIGNAL_SIGHT", var10, setting) != null && Respawn.getString("ORIGNAL_SIGHT", var10, setting).equals("1")) {
            Main.originalSight = true;
        }
        Main.sight_icon = "/sight.png";
        if (Respawn.getString("SIGHT_ICON", var10, setting) != null) {
            Main.sight_icon = Respawn.getString("SIGHT_ICON", var10, setting);
        }
        Main.originalUseIcon = false;
        if (Respawn.getString("ORIGINAL_USE_ICON", var10, setting) != null && Respawn.getString("ORIGINAL_USE_ICON", var10, setting).equals("1")) {
            Main.originalUseIcon = true;
        }
        if (Respawn.getString("LIFE_ZOMBIE", var10, setting) != null) {
            Zombie.max_hp = Respawn.getInt("LIFE_ZOMBIE", var10, setting);
        }
        if (Respawn.getString("LIFE_BIG_ZOMBIE", var10, setting) != null) {
            BigZombie.max_hp = Respawn.getInt("LIFE_BIG_ZOMBIE", var10, setting);
        }
        if (Respawn.getString("BIGZOMBIE_ANIMSPEED", var10, setting) != null) {
            Main.bigzombieanimspeed = Respawn.getInt("BIGZOMBIE_ANIMSPEED", var10, setting);
        }
        if (Respawn.getString("BIGZOMBIE_ATTACKANIMSPEED", var10, setting) != null) {
            Main.bigzombieattackanimspeed = Respawn.getInt("BIGZOMBIE_ATTACKANIMSPEED", var10, setting);
        }
        if (Respawn.getString("BIGZOMBIE_DAMAGE", var10, setting) != null) {
            Main.bigzombiedamage = Respawn.getInt("BIGZOMBIE_DAMAGE", var10, setting);
        }
        if (Respawn.getString("BIGZOMBIE_ATTACKRADIUS", var10, setting) != null) {
            Main.bigzombieattackradius = Respawn.getFloat("BIGZOMBIE_ATTACKRADIUS", var10, setting);
        }
        if (Respawn.getString("BIGZOMBIE_JUMPHEIGHT", var10, setting) != null) {
            Main.bigzombiejumpheight = Respawn.getInt("BIGZOMBIE_JUMPHEIGHT", var10, setting);
        }
        if (Respawn.getString("BIGZOMBIE_JUMPSPEED", var10, setting) != null) {
            Main.bigzombiejumpspeed = Respawn.getFloat("BIGZOMBIE_JUMPSPEED", var10, setting);
        }
        if (Respawn.getString("BIGZOMBIE_JUMPHEIGHT2", var10, setting) != null) {
            Main.bigzombiejumpheight2 = Respawn.getInt("BIGZOMBIE_JUMPHEIGHT2", var10, setting);
        }
        if (Respawn.getString("BIGZOMBIE_JUMPSPEED2", var10, setting) != null) {
            Main.bigzombiejumpspeed2 = Respawn.getFloat("BIGZOMBIE_JUMPSPEED2", var10, setting);
        }
        if (Respawn.getString("BIGZOMBIE_SPEED", var10, setting) != null) {
            Main.bigzombiespeed = Respawn.getInt("BIGZOMBIE_SPEED", var10, setting);
        }
        if (Respawn.getString("ZOMBIE_REACTTIMER", var10, setting) != null) {
            Main.bigzombiereacttimer = Respawn.getInt("BIGZOMBIE_REACTTIMER", var10, setting);
        }
        if (Respawn.getString("BIGZOMBIE_ATTACKTIMER", var10, setting) != null) {
            Main.bigzombieattacktimer = Respawn.getInt("BIGZOMBIE_ATTACKTIMER", var10, setting);
        }
        if (Respawn.getString("BIGZOMBIE_AI", var10, setting) != null) {
            Main.bigzombieai = Respawn.getInt("BIGZOMBIE_AI", var10, setting);
        }
        if (Respawn.getString("BIGZOMBIE_PLAYERREACTION", var10, setting) != null) {
            Main.bigzombieplayerreaction = Respawn.getInt("BIGZOMBIE_PLAYERREACTION", var10, setting);
        }
        if (Respawn.getString("BIGZOMBIE_ATTACKTRIGGER", var10, setting) != null) {
            Main.bigzombieattacktrigger = Respawn.getInt("BIGZOMBIE_ATTACKTRIGGER", var10, setting);
        }
        if (Respawn.getString("ZOMBIE_ANIMSPEED", var10, setting) != null) {
            Main.zombieanimspeed = Respawn.getInt("ZOMBIE_ANIMSPEED", var10, setting);
        }
        if (Respawn.getString("ZOMBIE_ATTACKANIMSPEED", var10, setting) != null) {
            Main.zombieattackanimspeed = Respawn.getInt("ZOMBIE_ATTACKANIMSPEED", var10, setting);
        }
        if (Respawn.getString("ZOMBIE_DAMAGE", var10, setting) != null) {
            Main.zombiedamage = Respawn.getInt("ZOMBIE_DAMAGE", var10, setting);
        }
        if (Respawn.getString("ZOMBIE_ATTACKRADIUS", var10, setting) != null) {
            Main.zombieattackradius = Respawn.getFloat("ZOMBIE_ATTACKRADIUS", var10, setting);
        }
        if (Respawn.getString("ZOMBIE_JUMPHEIGHT", var10, setting) != null) {
            Main.zombiejumpheight = Respawn.getInt("ZOMBIE_JUMPHEIGHT", var10, setting);
        }
        if (Respawn.getString("ZOMBIE_JUMPSPEED", var10, setting) != null) {
            Main.zombiejumpspeed = Respawn.getFloat("ZOMBIE_JUMPSPEED", var10, setting);
        }
        if (Respawn.getString("ZOMBIE_SPEED", var10, setting) != null) {
            Main.zombiespeed = Respawn.getInt("ZOMBIE_SPEED", var10, setting);
        }
        if (Respawn.getString("ZOMBIE_REACTTIMER", var10, setting) != null) {
            Main.zombiereacttimer = Respawn.getInt("ZOMBIE_REACTTIMER", var10, setting);
        }
        if (Respawn.getString("ZOMBIE_ATTACKTIMER", var10, setting) != null) {
            Main.zombieattacktimer = Respawn.getInt("ZOMBIE_ATTACKTIMER", var10, setting);
        }
        if (Respawn.getString("ZOMBIE_AI", var10, setting) != null) {
            Main.zombieai = Respawn.getInt("ZOMBIE_AI", var10, setting);
        }
        if (Respawn.getString("ZOMBIE_ATTACK", var10, setting) != null) {
            Zombie.attack = Mesh.cutOnInts(Respawn.getString("ZOMBIE_ATTACK", var10, setting), ',', ';');
        }
        if (Respawn.getString("BIGZOMBIE_ATTACK", var10, setting) != null) {
            BigZombie.attack = Mesh.cutOnInts(Respawn.getString("BIGZOMBIE_ATTACK", var10, setting), ',', ';');
        }
        if (Respawn.getString("ZOMBIE_PLAYERREACTION", var10, setting) != null) {
            Main.zombieplayerreaction = Respawn.getInt("ZOMBIE_PLAYERREACTION", var10, setting);
        }
        if (Respawn.getString("ZOMBIE_ATTACKTRIGGER", var10, setting) != null) {
            Main.zombieattacktrigger = Respawn.getInt("ZOMBIE_ATTACKTRIGGER", var10, setting);
        }
        if (Respawn.getString("ZOMBIE_TEXTURE", var10, setting) != null) {
            zombietex = Respawn.getString("ZOMBIE_TEXTURE", var10, setting);
        }
        if (Respawn.getString("BLOOD_TEX", var10, setting) != null) {
            Main.Blood = Respawn.getString("BLOOD_TEX", var10, setting);
        }
        if (Respawn.getString("ZOMBIE_SCALE", var10, setting) != null) {
            zombiescale = Respawn.getFloat("ZOMBIE_SCALE", var10, setting);
        }
        if (Respawn.getString("BIGZOMBIE_SCALE", var10, setting) != null) {
            bigzombiescale = Respawn.getFloat("BIGZOMBIE_SCALE", var10, setting);
        }
        if (Respawn.getString("BIGZOMBIE_TEXTURE", var10, setting) != null) {
            bigzombietex = Respawn.getString("BIGZOMBIE_TEXTURE", var10, setting);
        }
        if (Respawn.getString("ZOMBIE_MODEL", var10, setting) != null) {
            zombiemod = Respawn.getString("ZOMBIE_MODEL", var10, setting);
        }
        if (Respawn.getString("BIGZOMBIE_MODEL", var10, setting) != null) {
            bigzombiemod = Respawn.getString("BIGZOMBIE_MODEL", var10, setting);
        }
        if (Respawn.getString("ZOMBIE_PRICE", var10, setting) != null) {
            Main.zombieprice = Respawn.getInt("ZOMBIE_PRICE", var10, setting);
        }
        if (Respawn.getString("BIGZOMBIE_PRICE", var10, setting) != null) {
            Main.bigzombieprice = Respawn.getInt("BIGZOMBIE_PRICE", var10, setting);
        }
        Zombie.fallDeath = Respawn.getInt("ZOMBIE_FALL_ON_DEATH", var10, setting, 1) == 1;
        boolean bl = BigZombie.fallDeath = Respawn.getInt("BIGZOMBIE_FALL_ON_DEATH", var10, setting, 1) == 1;
        if (var10.getString("LIGHT_Y") != null) {
            d = var10.getInt("LIGHT_Y");
            Graphics3D.lightdiry = (short)d;
        } else {
            Graphics3D.lightdiry = (short)4096;
        }
        if (var10.getString("LIGHT_X") != null) {
            d = var10.getInt("LIGHT_X");
            Graphics3D.lightdirx = (short)d;
        } else {
            Graphics3D.lightdirx = (short)-4096;
        }
        if (var10.getString("LIGHT_Z") != null) {
            d = var10.getInt("LIGHT_Z");
            Graphics3D.lightdirz = (short)d;
        } else {
            Graphics3D.lightdirz = (short)4096;
        }
        if (var10.getString("BLOOM") != null && var10.getInt("BLOOM") == 1) {
            GameScreen.bloom = true;
        }
        if (var10.get("FOGD") != null) {
            Graphics3D.setFogDist(var10.getInt("FOGD"));
        }
        if (var10.get("DIST") != null) {
            Graphics3D.setDrDist(var10.getInt("DIST"));
        }
        if (var10.get("DMODE") != null && (Graphics3D.fog = var10.getByte("DMODE")) == 6) {
            Graphics3D.fogc = 0;
        }
        if (var10.get("FOGCR") != null) {
            int fogc;
            Graphics3D.fogc = fogc = var10.getInt("FOGCR") << 16 | var10.getInt("FOGCG") << 8 | var10.getInt("FOGCB");
        }
        MultyTexture mt = Asset.getMultyTexture(var10.getString("WORLD_TEXTURE"));
        Mesh[] var12 = Room.loadMeshes(var10.getString("WORLD_MODEL"), var3, var3, var3, mt);
        String modes = var10.getString("DRAW_MODES");
        if (modes != null) {
            Asset.applyMeshEffects(var12, modes);
        }
        if ((modes = var10.getString("MAP_ADDSZ")) != null) {
            int[] asz = Mesh.cutOnInts(modes, ',', ';');
            for (int i = 0; i < asz.length; ++i) {
                mt.textures[i].addsz = asz[i];
            }
        }
        String var5 = var10.getString("SKYBOX_MODEL");
        String var6 = var10.getString("SKYBOX_TEXTURE");
        boolean M3G_SkyBoxSpeedUp = false;
        try {
            Class.forName("javax.microedition.m3g.Graphics3D");
        }
        catch (ClassNotFoundException e) {
            M3G_SkyBoxSpeedUp = false;
        }
        Skybox var7 = null;
        byte oldf = Graphics3D.fog;
        Graphics3D.fog = 0;
        if (var5 != null && var6 != null) {
            if (!M3G_SkyBoxSpeedUp || var6.indexOf(59) > -1 || var6.indexOf(44) > -1) {
                String modesz;
                var7 = new Skybox(var10.getString("SKYBOX_MODEL"), var10.getString("SKYBOX_TEXTURE"), false, 0, 0);
                if (Respawn.getString("SKYBOX_PERS", var10, setting) != null && Respawn.getInt("SKYBOX_PERS", var10, setting) == 0) {
                    Texture[] texs = var7.texture.textures;
                    for (int ti = 0; ti < texs.length; ++ti) {
                        texs[ti].setPerspectiveCorrection(false);
                    }
                }
                Main.forceLQFog = false;
                if (Respawn.getString("LQFOG", var10, setting) != null) {
                    Main.forceLQFog = false;
                    if (Respawn.getInt("LQFOG", var10, setting) == 1) {
                        Main.forceLQFog = true;
                    }
                }
                Main.updateOnlyNear = false;
                if (Respawn.getString("UPDATE_ONLYNEAR", var10, setting) != null && Respawn.getInt("UPDATE_ONLYNEAR", var10, setting) == 1) {
                    Main.updateOnlyNear = true;
                }
                if ((modesz = var10.getString("SKYBOX_MODES")) != null) {
                    Asset.applyMeshEffects(var7.getMesh(), modesz);
                }
            } else {
                var7 = new Skybox(var10.getString("SKYBOX_MODEL"), var10.getString("SKYBOX_TEXTURE"), true, width, height);
            }
        } else if (var10.getString("SKYBOX_COLOR_R") != null && var5 == null && var6 == null) {
            var7 = new Skybox(var10.getInt("SKYBOX_COLOR_R") << 16 | var10.getInt("SKYBOX_COLOR_G") << 8 | var10.getInt("SKYBOX_COLOR_B"));
        } else if (var10.getString("SKYBOX_COLOR") != null && var5 == null && var6 == null) {
            int[] rgb = Mesh.cutOnInts(var10.getString("SKYBOX_COLOR"), ',', ';');
            var7 = new Skybox(rgb[0] << 16 | rgb[1] << 8 | rgb[2]);
        } else if (var10.getString("SKYBOX_COLOR_R") == null && var5 == null && var6 != null) {
            float xs = 1.0f;
            float ys = 1.0f;
            if (var10.getString("SKYBOX_REPEAT_X") != null) {
                xs = var10.getFloat("SKYBOX_REPEAT_X");
            }
            if (var10.getString("SKYBOX_REPEAT_Y") != null) {
                ys = var10.getFloat("SKYBOX_REPEAT_Y");
            }
            var7 = new Skybox(Asset.getTexture(var6), xs, ys);
        }
        if (var7 != null) {
            boolean bl2 = var7.skyboxAlways = Respawn.getInt("SKYBOX_ALWAYS", var10, setting, 0) == 1;
        }
        if (var7 != null) {
            var7.addViewport(0, 0, width, height);
        }
        Graphics3D.fog = oldf;
        Room.chunkSize = Respawn.getInt("CHUNK_COLLISION_SIZE", var10, setting, 9000);
        Room.chunkSizeRender = Respawn.getInt("CHUNK_SIZE", var10, setting, 0);
        LightMapper.reset();
        LightMapper.ambientLight = Respawn.getInt("AMBIENT_LIGHT", var10, setting, LightMapper.ambientLight);
        LightMapper.aoDistance = Respawn.getInt("AO_DISTANCE", var10, setting, LightMapper.aoDistance);
        LightMapper.aoIntensity = Respawn.getInt("AO_INTENSITY", var10, setting, LightMapper.aoIntensity);
        LightMapper.skyLightIntensity = Respawn.getInt("SKY_LIGHT_INTENSITY", var10, setting, LightMapper.skyLightIntensity);
        LightMapper.sunLightIntensity = Respawn.getInt("SUN_LIGHT_INTENSITY", var10, setting, LightMapper.sunLightIntensity);
        LightMapper.cameraVectorLight = Respawn.getInt("CAMERA_VECTOR_LIGHT", var10, setting, 0) == 1;
        Main.arcadeJumpPhysics = Respawn.getInt("ARCADE_JUMP_PHYSICS", var10, setting, 0) == 1;
        Respawn.loadLights(file, var10);
        House var13 = HouseCreator.create(var12, false, var10.getString("LIGHTMAP"));
        Respawn var14 = null;
        if (var10.getString("START") != null) {
            var14 = Respawn.readPoints(var10.getString("START"), var13)[0];
        }
        Respawn var15 = null;
        if (var10.getString("FINISH") != null) {
            var15 = Respawn.readPoints(var10.getString("FINISH"), var13)[0];
        }
        Respawn[] var16 = null;
        if (var10.getString("ENEMIES") != null) {
            var16 = Respawn.readPoints(var10.getString("ENEMIES"), var13);
        }
        int var8 = 0;
        if (var16 != null) {
            var8 = var16.length;
        }
        if (var10.getString("ENEMY_COUNT") != null) {
            var8 = var10.getInt("ENEMY_COUNT");
        }
        int var11 = 2000;
        if (Respawn.getString("FREQUENCY", var10, setting) != null) {
            var11 = Respawn.getInt("FREQUENCY", var10, setting);
        }
        boolean bl3 = botsInLevel = var16 != null;
        if (botsInLevel) {
            boolean bl4 = botsInLevel = var16.length > 0;
        }
        if (var8 > 0 && botsInLevel) {
            Main.bigzombietex = Asset.getMultyTexture(bigzombietex, false);
            Main.zombietex = Asset.getMultyTexture(zombietex, false);
            Main.zombiemod = Asset.getMeshImageDynamic(zombiemod, zombiescale, zombiescale, zombiescale);
            Zombie.model_height = Main.zombiemod.getAnimation().getMesh().maxY() - Main.zombiemod.getAnimation().getMesh().minY();
            Main.bigzombiemod = Asset.getMeshImageDynamic(bigzombiemod, bigzombiescale, bigzombiescale, bigzombiescale);
            BigZombie.model_height = Main.bigzombiemod.getAnimation().getMesh().maxY() - Main.bigzombiemod.getAnimation().getMesh().minY();
            if (Respawn.getString("ZOMBIE_DRAW_MODES", var10, setting) != null) {
                Asset.applyMeshEffects(Main.zombiemod.getMesh(), Respawn.getString("ZOMBIE_DRAW_MODES", var10, setting));
            }
            if (Respawn.getString("BIGZOMBIE_DRAW_MODES", var10, setting) != null) {
                Asset.applyMeshEffects(Main.bigzombiemod.getMesh(), Respawn.getString("BIGZOMBIE_DRAW_MODES", var10, setting));
            }
        } else {
            Main.zombietex = null;
            Main.zombiemod = null;
            Main.bigzombietex = null;
            Main.bigzombiemod = null;
        }
        int zc = 5;
        if (Respawn.getString("ZOMBIE_COUNT", var10, setting) != null) {
            zc = Respawn.getInt("ZOMBIE_COUNT", var10, setting);
        }
        Scene var9 = new Scene(width, height, var13, var14, var15, var16, var8, var11, main, zc);
        var9.getHouse().setSkybox(var7);
        if (var10.get("NEED_TO_EXIT") != null) {
            var9.need = Mesh.cutOnStrings(var10.getString("NEED_TO_EXIT"), ',');
        }
        if (Respawn.getString("DELETE_IN_DISTANCE", var10, setting) != null) {
            if (Respawn.getInt("DELETE_IN_DISTANCE", var10, setting) == 1) {
                var9.deleteAnPart = true;
            }
            if (Respawn.getInt("DELETE_IN_DISTANCE", var10, setting) == 0) {
                var9.deleteAnPart = false;
            }
        }
        var9.alwaysExit = false;
        if (Respawn.getString("ALWAYS_EXIT", var10, setting) != null && Respawn.getInt("ALWAYS_EXIT", var10, setting) == 1) {
            var9.alwaysExit = true;
        }
        GameScreen.mus = "/music.mid";
        if (Respawn.getString("MUSIC", var10, setting) != null) {
            GameScreen.mus = Respawn.getString("MUSIC", var10, setting);
        }
        boolean bl5 = var9.ne = Respawn.getInt("NEW_EXIT", var10, setting, 0) == 1;
        if (Respawn.getString2("PLAYER_SHOP", var10, setting) != null) {
            String sh = Respawn.getString2("PLAYER_SHOP", var10, setting);
            gs.shopItems = (int[])(sh.equals("OFF") ? null : Mesh.cutOnInts(sh, ','));
        }
        if (gs.shopItems != null) {
            for (int i = 0; i < gs.shopItems.length; ++i) {
                if (gs.shopItems[i] != -1) continue;
                gs.shopItems[i] = Arsenal.weapons.length - 1;
            }
        }
        if (Respawn.getString("WEATHER", var10, setting) != null) {
            int pc = 170;
            if (Respawn.getString("WEATHER_PARTICLES_COUNT", var10, setting) != null) {
                pc = Respawn.getInt("WEATHER_PARTICLES_COUNT", var10, setting);
            }
            if (Respawn.getString("WEATHER", var10, setting).equals("SNOW")) {
                gs.wg = new WeatherGenerator(GameScreen.width, GameScreen.height * Main.getDisplaySize() / 100, pc, 0xAABBDD, 0x666666, 0xFFFFFF, 13290719, false, 4, 90, GameScreen.width / 2, GameScreen.height / 2, 2, 10, 22);
                gs.wg.generate = (byte)2;
                gs.wg.createParticles();
            } else if (Respawn.getString("WEATHER", var10, setting).equals("RAIN")) {
                gs.wg = new WeatherGenerator(GameScreen.width, GameScreen.height * Main.getDisplaySize() / 100, pc, 0xAABBDD, 0x666666, 0xFFFFFF, 13290719, false, 4, 90, GameScreen.width / 2, GameScreen.height / 2, 2, 10, 22);
                gs.wg.generate = 1;
                gs.wg.createParticles();
            }
        }
        if ((str = Respawn.getString("WALK_SOUND", var10, setting)) != null) {
            String[] snds = Mesh.cutOnStrings(str, ';', ',');
            Main.stepSound = snds;
            for (int i = 0; i < snds.length; ++i) {
                if (!Main.isFootsteps || Main.footsteps == 0) continue;
                Asset.getSound(snds[i]);
            }
        }
        if (Respawn.getString("JUMP_SOUND", var10, setting) != null) {
            Main.jumpSound = Respawn.getString("JUMP_SOUND", var10, setting);
            if (Main.isFootsteps && Main.footsteps != 0) {
                Asset.getSound(Main.jumpSound);
            }
        }
        gs.var10 = var10;
        for (int i = 0; i < var9.getHouse().getRooms().length; ++i) {
            String tmp;
            Object[] snds;
            Room rm = var9.getHouse().getRooms()[i];
            str = var10.getString("WALK_SOUND_" + i);
            if (str != null) {
                snds = Mesh.cutOnStrings(str, ';', ',');
                rm.stepSound = snds;
                for (int i2 = 0; i2 < snds.length; ++i2) {
                    if (!Main.isFootsteps || Main.footsteps == 0) continue;
                    Asset.getSound(snds[i2]);
                }
            }
            if (var10.getString("JUMP_SOUND_" + i) != null) {
                rm.jumpSound = var10.getString("JUMP_SOUND_" + i);
                if (Main.isFootsteps && Main.footsteps != 0) {
                    Asset.getSound(rm.jumpSound);
                }
            }
            if ((str = Respawn.getString("PLAYER_ZOOM", var10, setting)) != null) {
                snds = Mesh.cutOnInts(str, ';', ',');
                Main.minZoom = (int)snds[0];
                Main.maxZoom = (int)snds[1];
                Main.hasZoom = false;
                if (snds[2] == true) {
                    Main.hasZoom = true;
                }
            }
            var9.g3d.updateFov(Main.minZoom);
            Main.l2dRoomRendering = Respawn.getInt("L2D_ROOM_RENDERING", var10, setting, 0) == 1;
            Main.fallDamage = Respawn.getInt("FALL_DAMAGE", var10, setting, 1) == 1;
            boolean bl6 = gs.fullMoveLvl = Respawn.getInt("LEVEL_END_CHANGEPOS", var10, setting, 0) == 1;
            if (Respawn.getString("SPAWN_LIMITER", var10, setting) != null) {
                var9.botLimiter = Mesh.cutOnInts(Respawn.getString("SPAWN_LIMITER", var10, setting), ',', ';');
            }
            if ((tmp = Respawn.getString("VIGNETTE", var10, setting)) == null) continue;
            Image img = ImageResize.createImage(tmp, var9.g3d.getWidth(), var9.g3d.getHeight());
            int[] vignette = new int[img.getWidth() * img.getHeight()];
            img.getRGB(vignette, 0, width, 0, 0, img.getWidth(), img.getHeight());
            gs.vignette = new byte[vignette.length];
            for (i = 0; i < vignette.length; ++i) {
                gs.vignette[i] = (byte)((vignette[i] & 0xFF) - 128);
            }
        }
        return var9;
    }

    private static Respawn[] readPoints(String file, House house) {
        int var3;
        if (file == null) {
            return null;
        }
        StringBuffer var2 = new StringBuffer();
        for (var3 = 0; var3 < file.length(); ++var3) {
            char var4 = file.charAt(var3);
            if (var4 == ' ') continue;
            var2.append(var4);
        }
        String[] var5 = Mesh.cutOnStrings(var2.toString(), ';');
        Respawn[] var6 = new Respawn[var5.length];
        for (var3 = 0; var3 < var6.length; ++var3) {
            int[] var7 = Mesh.cutOnInts(var5[var3], ',');
            Vector3D var8 = new Vector3D(var7[0], var7[1], var7[2]);
            var6[var3] = new Respawn(var8, house);
            if (var7.length == 4 || var7.length == 5) {
                var6[var3].mode = (byte)-127;
                var6[var3].cmode = (byte)(-127 + var7[3]);
                if (var7.length != 5 || var7[4] != 1) continue;
                var6[var3].respa = true;
                continue;
            }
            if (!defaultOneBot) continue;
            var6[var3].mode = (byte)-127;
            var6[var3].cmode = (byte)-126;
        }
        return var6;
    }

    public static final void loadLights(String level, Stringer lvl) {
        int pos = 0;
        String file = Mesh.getStringFromResource(level);
        Vector<Light> light = new Vector<Light>();
        while (file.indexOf(91) >= 0) {
            pos = file.indexOf(91);
            int endpos = file.indexOf(93);
            String objectType = file.substring(pos + 1, endpos);
            String object = file.substring(endpos + 1);
            if ((endpos = object.indexOf(91)) >= 0) {
                file = object.substring(endpos);
                object = object.substring(0, endpos - 1);
            }
            Stringer obj = new Stringer(object);
            String key = obj.getString("PRESET") + "@@@";
            if (objectType.indexOf("LIGHT") > -1) {
                String[] poses = Mesh.cutOnStrings(obj.getString("POS"), ';');
                for (int count = 0; count < poses.length; ++count) {
                    Light l = new Light(Mesh.cutOnInts(poses[count], ','), Respawn.getInt("BRIGHTNESS", obj, Main.settings, key, lvl, 255));
                    String tmp = Respawn.getString("DIRECTION", obj, Main.settings, key);
                    if (tmp != null) {
                        l.direction = new Vector3D(Mesh.cutOnInts(tmp, ','));
                    }
                    light.addElement(l);
                }
            }
            if (endpos >= 0) continue;
            break;
        }
        if (light.size() > 0) {
            Light[] l2 = new Light[light.size()];
            for (int i = 0; i < l2.length; ++i) {
                l2[i] = (Light)light.elementAt(i);
            }
            LightMapper.lights = l2;
        }
    }

    public static final void loadObjects(String level, Stringer lvl, Scene scene, Player p, boolean onlyObjs) {
        int pos = 0;
        String file = Mesh.getStringFromResource(level);
        while (file.indexOf(91) >= 0) {
            RoomObject mobj;
            pos = file.indexOf(91);
            int endpos = file.indexOf(93);
            String objectType = file.substring(pos + 1, endpos);
            System.out.println("Found Object:" + objectType);
            String object = file.substring(endpos + 1);
            endpos = object.indexOf(91);
            if (endpos >= 0) {
                file = object.substring(endpos);
                object = object.substring(0, endpos - 1);
            }
            Stringer obj = new Stringer(object);
            String key = obj.getString("PRESET") + "@@@";
            if (objectType.indexOf("_ON_ACTIVATE") > -1) {
                Vector objs = scene.getHouse().getObjects();
                if (objs.size() > 0) {
                    String newName = objectType.substring(0, objectType.indexOf("_ON_ACTIVATE"));
                    System.out.println(newName);
                    for (int i = 0; i < objs.size(); ++i) {
                        if ((RoomObject)objs.elementAt(i) == null || ((RoomObject)objs.elementAt((int)i)).name == null || !((RoomObject)objs.elementAt((int)i)).name.equals(newName)) continue;
                        ((RoomObject)objs.elementAt((int)i)).additional = Respawn.createScript(object);
                    }
                }
            } else if (objectType.indexOf("_ON_SPAWN") > -1) {
                Vector objs = scene.getHouse().getObjects();
                if (objs.size() > 0) {
                    String newName = objectType.substring(0, objectType.indexOf("_ON_SPAWN"));
                    System.out.println(newName);
                    for (int i = 0; i < objs.size(); ++i) {
                        if ((RoomObject)objs.elementAt(i) == null || ((RoomObject)objs.elementAt((int)i)).name == null || !((RoomObject)objs.elementAt((int)i)).name.equals(newName) || !(objs.elementAt(i) instanceof NPCSpawner)) continue;
                        ((NPCSpawner)objs.elementAt((int)i)).onSpawn = Respawn.createScript(object);
                    }
                }
            } else if (objectType.indexOf("OBJECT") > -1) {
                System.out.println("Spawning OBJ");
                String[] poses = Mesh.cutOnStrings(obj.getString("POS"), ';');
                for (int count = 0; count < poses.length; ++count) {
                    int[] ps = Mesh.cutOnInts(poses[count], ',');
                    KeyObject t = new KeyObject(new Vector3D(ps[0], ps[1], ps[2]));
                    Respawn.loadRM(obj, t, lvl, key);
                    scene.getHouse().addObject(t);
                }
            } else if (objectType.indexOf("TELEPORT") > -1) {
                System.out.println("Spawning OBJ");
                String[] poses = Mesh.cutOnStrings(obj.getString("POS"), ';');
                for (int count = 0; count < poses.length; ++count) {
                    int[] ps = Mesh.cutOnInts(poses[count], ',');
                    int[] ps2 = Mesh.cutOnInts(Respawn.getString("NEW_POS", obj, Main.settings, key), ',');
                    Teleport t = new Teleport(new Vector3D(ps[0], ps[1], ps[2]), new Vector3D(ps2[0], ps2[1], ps2[2]));
                    Respawn.loadRM(obj, t, lvl, key);
                    if (Respawn.getString("ROT", obj, Main.settings, key) != null) {
                        t.pRot = Respawn.getInt("ROT", obj, Main.settings, key);
                    }
                    scene.getHouse().addObject(t);
                }
            } else if (objectType.indexOf("NPC") > -1) {
                System.out.println("Spawning NPC");
                String[] poses = Mesh.cutOnStrings(obj.getString("POS"), ';');
                for (int count = 0; count < poses.length; ++count) {
                    int[] ps = Mesh.cutOnInts(poses[count], ',');
                    NPC t = Respawn.loadNPC(obj, key, ps);
                    NPCSpawner spawn = null;
                    String str = Respawn.getString("SPAWN", obj, Main.settings, key);
                    if (str != null) {
                        int[] sets = Mesh.cutOnInts(str, ',', ';');
                        spawn = new NPCSpawner(new Vector3D(ps[0], ps[1], ps[2]));
                        spawn.canSpawn = sets[0];
                        if (sets.length >= 2) {
                            spawn.respawnIn = sets[1];
                        }
                        if (sets.length == 3) {
                            spawn.rot = sets[2];
                        }
                        Respawn.loadRM(obj, spawn, lvl, key, "SPAWNER_");
                        if (Respawn.getString("SPAWNER_IGNORE_VISIBLITY_CHECK", obj, Main.settings, key) != null && Respawn.getInt("SPAWNER_IGNORE_VISIBLITY_CHECK", obj, Main.settings, key) == 1) {
                            spawn.visiblityChecker = false;
                        }
                        if (Respawn.getString("SPAWNER_DISTANCE", obj, Main.settings, key) != null) {
                            spawn.distanceToSpawn = Respawn.getLong("SPAWNER_DISTANCE", obj, Main.settings, key);
                        }
                        if (Respawn.getString("SPAWNER_ON_SPAWN", obj, Main.settings, key) != null) {
                            spawn.onSpawn = Mesh.cutOnStrings(Respawn.getString("SPAWNER_ON_SPAWN", obj, Main.settings, key), ',');
                        }
                        if (Respawn.getString("SPAWNER_COUNT", obj, Main.settings, key) != null) {
                            spawn.bots = new NPC[Math.max(1, Respawn.getInt("SPAWNER_COUNT", obj, Main.settings, key))];
                            spawn.bots[0] = t;
                            for (int i = 1; i < spawn.bots.length; ++i) {
                                spawn.bots[i] = Respawn.loadNPC(obj, key, ps);
                                spawn.bots[i].name = spawn.bots[i].name + "_" + String.valueOf(i);
                            }
                        } else {
                            spawn.bots = new NPC[1];
                            spawn.bots[0] = t;
                            spawn.bots[0].name = spawn.bots[0].name + "_1";
                        }
                    }
                    Respawn.loadRM(obj, t, lvl, key);
                    if (spawn == null) {
                        scene.getHouse().addObject(t);
                        continue;
                    }
                    scene.getHouse().addObject(spawn);
                }
            } else if (objectType.indexOf("SPRITE") > -1) {
                System.out.println("creating sprite");
                String[] poses = Mesh.cutOnStrings(obj.getString("POS"), ';');
                for (int count = 0; count < poses.length; ++count) {
                    int[] flc;
                    int[] ps = Mesh.cutOnInts(poses[count], ',', ';');
                    String[] texs = Mesh.cutOnStrings(Respawn.getString("TEX", obj, Main.settings, key), ',', ';');
                    Texture[] textures = new Texture[texs.length];
                    for (int ti = 0; ti < texs.length; ++ti) {
                        textures[ti] = Asset.getTextureNM(texs[ti]);
                    }
                    SpriteObject spr = new SpriteObject();
                    spr.spr.setTextures(textures);
                    if (Respawn.getString("SCALE", obj, Main.settings, key) != null) {
                        spr.spr.setScale(Respawn.getInt("SCALE", obj, Main.settings, key));
                    }
                    if (Respawn.getString("ADDSZ", obj, Main.settings, key) != null) {
                        spr.addsz = Respawn.getInt("ADDSZ", obj, Main.settings, key);
                    }
                    if (Respawn.getString("COLOR", obj, Main.settings, key) != null) {
                        spr.spr.color = Respawn.getInt("COLOR", obj, Main.settings, key);
                    }
                    if (Respawn.getString("OFFSET", obj, Main.settings, key) != null) {
                        if (Respawn.getString("OFFSET", obj, Main.settings, key).equals("MID")) {
                            spr.spr.setOffset(0, -spr.spr.getHeight() / 2);
                        }
                        if (Respawn.getString("OFFSET", obj, Main.settings, key).equals("UP")) {
                            spr.spr.setOffset(0, -spr.spr.getHeight());
                        }
                    }
                    if (Respawn.getString("ANIMATION_SPEED", obj, Main.settings, key) != null) {
                        spr.spr.animation_speed = Respawn.getFloat("ANIMATION_SPEED", obj, Main.settings, key);
                    }
                    if (Respawn.getString("MODE", obj, Main.settings, key) != null) {
                        if (Respawn.getString("MODE", obj, Main.settings, key).equals("ADD")) {
                            spr.spr.mode = 1;
                        }
                        if (Respawn.getString("MODE", obj, Main.settings, key).equals("MUL")) {
                            spr.spr.mode = (byte)2;
                        }
                        if (Respawn.getString("MODE", obj, Main.settings, key).equals("OPAQUE") && textures[0].alphaMixing) {
                            spr.spr.mode = (byte)3;
                        }
                    } else {
                        spr.spr.mode = 0;
                        if (textures[0].alphaMixing) {
                            spr.spr.mode = (byte)3;
                        }
                    }
                    if (Respawn.getString("CUTOFF", obj, Main.settings, key) != null && Respawn.getString("CUTOFF", obj, Main.settings, key).equals("UP")) {
                        spr.spr.cutoff = 1;
                    }
                    if (Respawn.getString("FOG", obj, Main.settings, key) != null) {
                        if (Respawn.getString("FOG", obj, Main.settings, key).equals("MIX")) {
                            spr.spr.fog = true;
                        }
                    } else if (Graphics3D.fog == 6 || Graphics3D.fog == 3 || Graphics3D.fog == 1) {
                        spr.spr.fog = true;
                    }
                    if (Respawn.getString("FLICKER", obj, Main.settings, key) != null) {
                        flc = Mesh.cutOnInts(Respawn.getString("FLICKER", obj, Main.settings, key), ',', ';');
                        boolean[] flicker = new boolean[flc.length];
                        for (int fi = 0; fi < flc.length; ++fi) {
                            flicker[fi] = false;
                            if (flc[fi] != 1) continue;
                            flicker[fi] = true;
                        }
                        spr.flicker = flicker;
                    }
                    if (Respawn.getString("COLOR_ANIM", obj, Main.settings, key) != null) {
                        flc = Mesh.cutOnInts(Respawn.getString("COLOR_ANIM", obj, Main.settings, key), ',', ';');
                        spr.colorFlicker = flc;
                    }
                    spr.spr.getPosition().set(ps[0], ps[1], ps[2]);
                    Respawn.loadRM(obj, spr, lvl, key);
                    scene.getHouse().addObject(spr);
                }
            } else if (objectType.indexOf("MESH") > -1) {
                System.out.println("creating mesh");
                String[] poses = Mesh.cutOnStrings(obj.getString("POS"), ';');
                for (int count = 0; count < poses.length; ++count) {
                    int physics;
                    int[] ps = Mesh.cutOnInts(poses[count], ',');
                    float scale = 1.0f;
                    if (Respawn.getString("MODEL_SCALE", obj, Main.settings, key) != null) {
                        scale = Respawn.getFloat("MODEL_SCALE", obj, Main.settings, key);
                    }
                    if (Respawn.getString("SCALE", obj, Main.settings, key) != null) {
                        scale = Respawn.getFloat("SCALE", obj, Main.settings, key);
                    }
                    System.out.println("placing model");
                    Mesh[] meshes = Asset.getMeshes(Respawn.getString("MODEL", obj, Main.settings, key), scale, scale, scale);
                    MultyTexture mt = Asset.getMultyTexture(Respawn.getString("TEX", obj, Main.settings, key));
                    mobj = new MeshObject(meshes, mt, ps[0], ps[1], ps[2]);
                    Respawn.loadRM(obj, mobj, lvl, key);
                    String modes = Respawn.getString("DRAW_MODES", obj, Main.settings, key);
                    Mesh meshz = ((MeshObject)mobj).animation.getMesh();
                    if (modes != null) {
                        Asset.applyMeshEffects(meshz, modes);
                    }
                    if (Respawn.getString("ROTATE_Z", obj, Main.settings, key) != null) {
                        ((GameObject)mobj).getCharacter().getTransform().rotY(Respawn.getInt("ROTATE_Z", obj, Main.settings, key));
                    }
                    if (Respawn.getString("ROT", obj, Main.settings, key) != null) {
                        ((GameObject)mobj).getCharacter().getTransform().rotY(Respawn.getInt("ROT", obj, Main.settings, key));
                    }
                    if (Respawn.getString("ANIMATION_SPEED", obj, Main.settings, key) != null) {
                        ((MeshObject)mobj).animSpeed = Respawn.getFloat("ANIMATION_SPEED", obj, Main.settings, key);
                    }
                    if (Respawn.getString("PHYSICS", obj, Main.settings, key) != null) {
                        int physics2 = Respawn.getInt("PHYSICS", obj, Main.settings, key);
                        if (physics2 == 1) {
                            ((GameObject)mobj).getCharacter().setCollision(true);
                        }
                        if (physics2 == 0) {
                            ((GameObject)mobj).getCharacter().setCollision(false);
                        }
                    }
                    if (Respawn.getString("COLLIDER", obj, Main.settings, key) != null) {
                        int collider = Respawn.getInt("COLLIDER", obj, Main.settings, key);
                        if (collider == 1) {
                            ((GameObject)mobj).getCharacter().setCollidable(true);
                        }
                        if (collider == 0) {
                            ((GameObject)mobj).getCharacter().setCollidable(false);
                        }
                    }
                    if (Respawn.getString("FRICTION", obj, Main.settings, key) != null) {
                        ((GameObject)mobj).setFriction(Respawn.getFloat("FRICTION", obj, Main.settings, key));
                    }
                    if (Respawn.getString("HP", obj, Main.settings, key) != null) {
                        ((GameObject)mobj).setHp(Respawn.getInt("HP", obj, Main.settings, key));
                    }
                    float cscalex = 1.0f;
                    float cscaley = 1.0f;
                    if (Respawn.getString("COLLISION_SCALE_X", obj, Main.settings, key) != null) {
                        cscalex = Respawn.getFloat("COLLISION_SCALE_X", obj, Main.settings, key);
                    }
                    if (Respawn.getString("COLLISION_SCALE_Y", obj, Main.settings, key) != null) {
                        cscaley = Respawn.getFloat("COLLISION_SCALE_Y", obj, Main.settings, key);
                    }
                    int xsize = ((MeshObject)mobj).animation.getMesh().maxX() - ((MeshObject)mobj).animation.getMesh().minX();
                    int zsize = ((MeshObject)mobj).animation.getMesh().maxZ() - ((MeshObject)mobj).animation.getMesh().minZ();
                    int ysize = ((MeshObject)mobj).animation.getMesh().maxY() - ((MeshObject)mobj).animation.getMesh().minY();
                    ((GameObject)mobj).setCharacterSize((int)((float)(xsize / 2) * cscalex), (int)((float)(zsize / 2) * cscalex), (int)((float)ysize * cscaley));
                    if (Respawn.getString("LIFT_POS", obj, Main.settings, key) != null) {
                        String[] poses2 = Mesh.cutOnStrings(Respawn.getString("LIFT_POS", obj, Main.settings, key), ';');
                        ((MeshObject)mobj).poses = new Vector3D[poses2.length + 1];
                        ((MeshObject)mobj).poses[0] = new Vector3D(ps);
                        for (int i = 0; i < poses2.length; ++i) {
                            int[] ps2 = Mesh.cutOnInts(poses2[i], ',');
                            ((MeshObject)mobj).poses[i + 1] = new Vector3D(ps2);
                        }
                        ((MeshObject)mobj).liftCycled = Respawn.getInt("LIFT_LOOP", obj, Main.settings, key, lvl, 0) == 1;
                        String tmp = Respawn.getString("LIFT_TIMER", obj, Main.settings, key);
                        if (tmp != null) {
                            ((MeshObject)mobj).timeToMove = Mesh.cutOnInts(tmp, ',', ';');
                        } else {
                            int speed = Respawn.getInt("LIFT_SPEED", obj, Main.settings, key, lvl, 2000);
                            ((MeshObject)mobj).timeToMove = new int[((MeshObject)mobj).poses.length - (((MeshObject)mobj).liftCycled ? 0 : 1)];
                            for (int i = 0; i < ((MeshObject)mobj).timeToMove.length; ++i) {
                                int i2 = i + 1;
                                if (i2 >= ((MeshObject)mobj).poses.length) {
                                    i2 = 0;
                                }
                                Vector3D a = ((MeshObject)mobj).poses[i];
                                Vector3D b = ((MeshObject)mobj).poses[i2];
                                ((MeshObject)mobj).timeToMove[i] = (int)(Math.sqrt((double)(a.x - b.x) * (double)(a.x - b.x) + (double)(a.y - b.y) * (double)(a.y - b.y) + (double)(a.z - b.z) * (double)(a.z - b.z)) * 1000.0 / (double)speed);
                            }
                        }
                        ((MeshObject)mobj).lookAtDirect(((MeshObject)mobj).poses[1].x, ((MeshObject)mobj).poses[1].z);
                        ((MeshObject)mobj).activable = Respawn.getInt("ACTIVABLE", obj, Main.settings, key, lvl, 1) == 1;
                        ((MeshObject)mobj).clickable = Respawn.getInt("CLICKABLE", obj, Main.settings, key, lvl, 1) == 1;
                        ((MeshObject)mobj).liftReUse = Respawn.getInt("LIFT_REUSE", obj, Main.settings, key, lvl, 1) == 1;
                        ((MeshObject)mobj).disactivateOnEnd = Respawn.getInt("LIFT_DISACTIVABLE_ON_END", obj, Main.settings, key, lvl, 0) == 1;
                        ((MeshObject)mobj).liftSmoothMove = Respawn.getInt("LIFT_SMOOTH_MOVE", obj, Main.settings, key, lvl, 0);
                        ((MeshObject)mobj).liftRotateToMove = Respawn.getInt("LIFT_SMOOTH_ROTATE", obj, Main.settings, key, lvl, 0) == 1;
                        ((MeshObject)mobj).liftCanBePaused = Respawn.getInt("LIFT_CAN_BE_PAUSED", obj, Main.settings, key, lvl, 0) == 1;
                        tmp = Respawn.getString("LIFT_PLAYER_FOLLOW", obj, Main.settings, key);
                        if (tmp != null) {
                            ((MeshObject)mobj).playerFollowLift = new Vector3D(Mesh.cutOnInts(tmp, ',', ';'));
                        }
                    }
                    if (Respawn.getString("ADDSZ", obj, Main.settings, key) != null) {
                        ((MeshObject)mobj).addsz = Respawn.getInt("ADDSZ", obj, Main.settings, key);
                    }
                    if (Respawn.getString("ANIMATION_TYPE", obj, Main.settings, key) != null) {
                        int at = Respawn.getInt("ANIMATION_TYPE", obj, Main.settings, key);
                        if (at == 1) {
                            ((MeshObject)mobj).animType = 1;
                        }
                        if (at == 0) {
                            ((MeshObject)mobj).animType = 0;
                        }
                        if (at == 2) {
                            ((MeshObject)mobj).animType = 2;
                            ((MeshObject)mobj).state = 2;
                            ((MeshObject)mobj).activable = true;
                            ((MeshObject)mobj).clickable = true;
                        }
                    }
                    boolean bl = ((MeshObject)mobj).ignoreWeaponRayCast = Respawn.getInt("IGNORE_WEAPON_RAYCAST", obj, Main.settings, key, lvl, 0) == 1;
                    if (Respawn.getString("PRECISE_COLLISION", obj, Main.settings, key) != null && (physics = Respawn.getInt("PRECISE_COLLISION", obj, Main.settings, key)) == 1) {
                        ((MeshObject)mobj).precCol = true;
                    }
                    scene.getHouse().addObject(mobj);
                }
            } else if (objectType.indexOf("SHOP") > -1) {
                System.out.println("creating shop");
                String[] poses = Mesh.cutOnStrings(obj.getString("POS"), ';');
                for (int count = 0; count < poses.length; ++count) {
                    int[] ps = Mesh.cutOnInts(poses[count], ',');
                    int[] prices = null;
                    String[] files = null;
                    int[] items = Shop.items;
                    if (Respawn.getString("SHOP", obj, Main.settings, key) != null) {
                        items = Mesh.cutOnInts(Respawn.getString("SHOP", obj, Main.settings, key), ',');
                        for (int i = 0; i < items.length; ++i) {
                            if (items[i] != -1) continue;
                            items[i] = Arsenal.weapons.length - 1;
                        }
                    }
                    if (Respawn.getString("PRICES", obj, Main.settings, key) != null) {
                        prices = Mesh.cutOnInts(Respawn.getString("PRICES", obj, Main.settings, key), ',');
                    }
                    if (Respawn.getString("FILES", obj, Main.settings, key) != null) {
                        files = Mesh.cutOnStrings(Respawn.getString("FILES", obj, Main.settings, key), ',');
                    }
                    mobj = new ShopObject(items, prices, files, ps[0], ps[1], ps[2]);
                    Respawn.loadRM(obj, mobj, lvl, key);
                    scene.getHouse().addObject(mobj);
                }
            } else if (objectType.indexOf("LEVELCHANGE") > -1) {
                System.out.println("creating level change");
                String[] poses = Mesh.cutOnStrings(obj.getString("POS"), ';');
                for (int count = 0; count < poses.length; ++count) {
                    int[] ps = Mesh.cutOnInts(poses[count], ',');
                    int[] ps2 = Mesh.cutOnInts(Respawn.getString("START_POS", obj, Main.settings, key), ',');
                    LVLChange mobj2 = new LVLChange(ps[0], ps[1], ps[2], new Vector3D(ps2[0], ps2[1], ps2[2]), Respawn.getInt("LEVEL", obj, Main.settings, key));
                    if (Respawn.getString("ROT", obj, Main.settings, key) != null) {
                        mobj2.pRot = Respawn.getInt("ROT", obj, Main.settings, key);
                    }
                    if (Respawn.getString("SAVEMUSIC", obj, Main.settings, key) != null && Respawn.getInt("SAVEMUSIC", obj, Main.settings, key) == 1) {
                        mobj2.saveMus = true;
                    }
                    mobj2.fullMove = Respawn.getInt("FULLMOVE", obj, Main.settings, key, lvl, 0) == 1;
                    mobj2.activable = true;
                    Respawn.loadRM(obj, mobj2, lvl, key);
                    scene.getHouse().addObject(mobj2);
                }
            } else if (objectType.indexOf("IMAGE2D") > -1) {
                System.out.println("creating image2D");
                String[] poses = Mesh.cutOnStrings(obj.getString("POS"), ';');
                for (int count = 0; count < poses.length; ++count) {
                    int[] ps = Mesh.cutOnInts(poses[count], ',');
                    Image img = null;
                    try {
                        if (Respawn.getString("IMAGE", obj, Main.settings, key) != null) {
                            String scaleType = "PROPORTIONAL3D";
                            img = Image.createImage((String)Respawn.getString("IMAGE", obj, Main.settings, key));
                            float scalex = 1.0f;
                            float scaley = 1.0f;
                            if (Respawn.getString("SCALE_X", obj, Main.settings, key) != null) {
                                scalex = Respawn.getFloat("SCALE_X", obj, Main.settings, key);
                            }
                            if (Respawn.getString("SCALE_Y", obj, Main.settings, key) != null) {
                                scaley = Respawn.getFloat("SCALE_Y", obj, Main.settings, key);
                            }
                            if (Respawn.getString("RESIZE", obj, Main.settings, key) != null) {
                                scaleType = Respawn.getString("RESIZE", obj, Main.settings, key);
                            }
                            if (scaleType.equalsIgnoreCase("PROPORTIONAL3D")) {
                                img = ImageResize.bilinearScaleImage(img, (float)scene.g3d.height * scalex / (float)img.getHeight(), (float)scene.g3d.height * scaley / (float)img.getHeight());
                            } else if (scaleType.equalsIgnoreCase("FULL3DSCREEN")) {
                                img = ImageResize.bilinearScaleImage(img, (float)scene.g3d.width * scalex / (float)img.getWidth(), (float)scene.g3d.height * scaley / (float)img.getHeight());
                            } else if (scaleType.equalsIgnoreCase("PROPORTIONAL")) {
                                img = ImageResize.bilinearScaleImage(img, (float)scene.g3d.height * scalex / (float)img.getHeight(), (float)(scene.g3d.height * 100 / Main.displaySize) * scaley / (float)img.getHeight());
                            } else if (scaleType.equalsIgnoreCase("FULLSCREEN")) {
                                img = ImageResize.bilinearResizeImage(img, scene.g3d.width, scene.g3d.height * 100 / Main.displaySize);
                            } else if (scaleType.equalsIgnoreCase("ORIGINALSIZE")) {
                                img = ImageResize.bilinearScaleImage(img, scaley, scaley);
                            }
                        }
                    }
                    catch (Exception scaleType) {
                        // empty catch block
                    }
                    long timeout = 1000L;
                    if (Respawn.getString("TIMEOUT", obj, Main.settings, key) != null) {
                        timeout = Respawn.getLong("TIMEOUT", obj, Main.settings, key);
                    }
                    mobj = new Image2D(new Vector3D(ps[0], ps[1], ps[2]), img, timeout);
                    Respawn.loadRM(obj, mobj, lvl, key);
                    scene.getHouse().addObject(mobj);
                }
            } else if (!onlyObjs && objectType.indexOf("PLAYER") == 0) {
                if (Respawn.getString("CAM_X", obj, Main.settings, key) != null || Respawn.getString("CAM_Y", obj, Main.settings, key) != null || Respawn.getString("CAM_Z", obj, Main.settings, key) != null || Respawn.getString("CAM_ANGLE", obj, Main.settings, key) != null || Respawn.getString("THIRDPERSON", obj, Main.settings, key) != null) {
                    System.out.println("creating camera");
                    GameScreen.cam = new Camera();
                    if (Respawn.getString("CAM_X", obj, Main.settings, key) != null) {
                        GameScreen.cam.x = Respawn.getInt("CAM_X", obj, Main.settings, key);
                    }
                    if (Respawn.getString("CAM_Y", obj, Main.settings, key) != null) {
                        GameScreen.cam.y = Respawn.getInt("CAM_Y", obj, Main.settings, key);
                    }
                    if (Respawn.getString("CAM_Z", obj, Main.settings, key) != null) {
                        GameScreen.cam.z = Respawn.getInt("CAM_Z", obj, Main.settings, key);
                    }
                    if (Respawn.getString("CAM_ANGLE", obj, Main.settings, key) != null) {
                        GameScreen.cam.angle = Respawn.getInt("CAM_ANGLE", obj, Main.settings, key);
                    }
                }
                if (Respawn.getString("MODEL", obj, Main.settings, key) != null) {
                    float scale = 1.0f;
                    if (Respawn.getString("SCALE", obj, Main.settings, key) != null) {
                        scale = Respawn.getFloat("SCALE", obj, Main.settings, key);
                    }
                    System.out.println("placing model");
                    p.setModel(Respawn.getString("MODEL", obj, Main.settings, key), Respawn.getString("TEX", obj, Main.settings, key), scale);
                    String modes = Respawn.getString("DRAW_MODES", obj, Main.settings, key);
                    Mesh meshz = p.getAnim().getMesh();
                    if (modes != null) {
                        System.out.println("applying effects");
                        Asset.applyMeshEffects(meshz, modes);
                    }
                }
                if (Respawn.getString("FRICTION", obj, Main.settings, key) != null) {
                    System.out.println("set friction");
                    p.setFriction(obj.getFloat("FRICTION"));
                }
            }
            if (endpos >= 0) continue;
            break;
        }
    }

    public static NPC loadNPC(Stringer obj, String key, int[] ps) {
        String tmp;
        int ti;
        Texture[] textures;
        String[] texs;
        float scale = 1.0f;
        if (Respawn.getString("SCALE", obj, Main.settings, key) != null) {
            scale = Respawn.getFloat("SCALE", obj, Main.settings, key);
        }
        if (Respawn.getString("MODEl_SCALE", obj, Main.settings, key) != null) {
            scale = Respawn.getFloat("MODEl_SCALE", obj, Main.settings, key);
        }
        int hp = 100;
        if (Respawn.getString("HP", obj, Main.settings, key) != null) {
            hp = Respawn.getInt("HP", obj, Main.settings, key);
        }
        MultyTexture mt = null;
        if (Respawn.getString("TEX", obj, Main.settings, key) != null) {
            mt = Asset.getMultyTexture(Respawn.getString("TEX", obj, Main.settings, key));
        }
        String modes = Respawn.getString("DRAW_MODES", obj, Main.settings, key);
        MeshImage meim = null;
        if (Respawn.getString("MODEL", obj, Main.settings, key) != null) {
            meim = Asset.getMeshImageDynamic(Respawn.getString("MODEL", obj, Main.settings, key), scale, scale, scale);
        }
        NPC t = new NPC(new Vector3D(ps[0], ps[1], ps[2]), meim, hp, mt);
        String str = Respawn.getString("DAMAGE_ANIM", obj, Main.settings, key);
        if (str != null) {
            texs = Mesh.cutOnStrings(str, ',', ';');
            textures = new Texture[texs.length - 2];
            for (ti = 0; ti < texs.length; ++ti) {
                if (ti <= 1) continue;
                textures[ti - 2] = Asset.getTextureNM(texs[ti]);
            }
            t.damageFront = new Sprite(textures, Stringer.parseInt(texs[1]), Stringer.parseFloat(texs[0]));
        }
        if ((str = Respawn.getString("DEATH_ANIM", obj, Main.settings, key)) != null) {
            texs = Mesh.cutOnStrings(str, ',', ';');
            textures = new Texture[texs.length - 2];
            for (ti = 0; ti < texs.length; ++ti) {
                if (ti <= 1) continue;
                textures[ti - 2] = Asset.getTextureNM(texs[ti]);
            }
            t.deathFront = new Sprite(textures, Stringer.parseInt(texs[1]), Stringer.parseFloat(texs[0]));
            t.deathFront.limiter = true;
        }
        if ((str = Respawn.getString("ATTACK_ANIM", obj, Main.settings, key)) != null) {
            texs = Mesh.cutOnStrings(str, ',', ';');
            textures = new Texture[texs.length - 2];
            for (ti = 0; ti < texs.length; ++ti) {
                if (ti <= 1) continue;
                textures[ti - 2] = Asset.getTextureNM(texs[ti]);
            }
            t.attackFront = new Sprite(textures, Stringer.parseInt(texs[1]), Stringer.parseFloat(texs[0]));
        }
        if ((str = Respawn.getString("STAY_ANIM", obj, Main.settings, key)) != null) {
            texs = Mesh.cutOnStrings(str, ',', ';');
            textures = new Texture[texs.length - 2];
            for (ti = 0; ti < texs.length; ++ti) {
                if (ti <= 1) continue;
                textures[ti - 2] = Asset.getTextureNM(texs[ti]);
            }
            t.stayFront = new Sprite(textures, Stringer.parseInt(texs[1]), Stringer.parseFloat(texs[0]));
            t.model_height = t.stayFront.getHeight() * (t.stayFront.textures[0].scale < 2 ? 2 : 1);
            t.setCharacterSize(t.model_height);
        }
        if ((str = Respawn.getString("WALK_ANIM", obj, Main.settings, key)) != null) {
            texs = Mesh.cutOnStrings(str, ',', ';');
            textures = new Texture[texs.length - 2];
            for (ti = 0; ti < texs.length; ++ti) {
                if (ti <= 1) continue;
                textures[ti - 2] = Asset.getTextureNM(texs[ti]);
            }
            t.walkFront = new Sprite(textures, Stringer.parseInt(texs[1]), Stringer.parseFloat(texs[0]));
        }
        if ((str = Respawn.getString("DAMAGE_BACK_ANIM", obj, Main.settings, key)) != null) {
            texs = Mesh.cutOnStrings(str, ',', ';');
            textures = new Texture[texs.length - 2];
            for (ti = 0; ti < texs.length; ++ti) {
                if (ti <= 1) continue;
                textures[ti - 2] = Asset.getTextureNM(texs[ti]);
            }
            t.damageBack = new Sprite(textures, Stringer.parseInt(texs[1]), Stringer.parseFloat(texs[0]));
        }
        if ((str = Respawn.getString("DEATH_BACK_ANIM", obj, Main.settings, key)) != null) {
            texs = Mesh.cutOnStrings(str, ',', ';');
            textures = new Texture[texs.length - 2];
            for (ti = 0; ti < texs.length; ++ti) {
                if (ti <= 1) continue;
                textures[ti - 2] = Asset.getTextureNM(texs[ti]);
            }
            t.deathBack = new Sprite(textures, Stringer.parseInt(texs[1]), Stringer.parseFloat(texs[0]));
            t.deathBack.limiter = true;
        }
        if ((str = Respawn.getString("ATTACK_BACK_ANIM", obj, Main.settings, key)) != null) {
            texs = Mesh.cutOnStrings(str, ',', ';');
            textures = new Texture[texs.length - 2];
            for (ti = 0; ti < texs.length; ++ti) {
                if (ti <= 1) continue;
                textures[ti - 2] = Asset.getTextureNM(texs[ti]);
            }
            t.attackBack = new Sprite(textures, Stringer.parseInt(texs[1]), Stringer.parseFloat(texs[0]));
        }
        if ((str = Respawn.getString("STAY_BACK_ANIM", obj, Main.settings, key)) != null) {
            texs = Mesh.cutOnStrings(str, ',', ';');
            textures = new Texture[texs.length - 2];
            for (ti = 0; ti < texs.length; ++ti) {
                if (ti <= 1) continue;
                textures[ti - 2] = Asset.getTextureNM(texs[ti]);
            }
            t.stayBack = new Sprite(textures, Stringer.parseInt(texs[1]), Stringer.parseFloat(texs[0]));
        }
        if ((str = Respawn.getString("WALK_BACK_ANIM", obj, Main.settings, key)) != null) {
            texs = Mesh.cutOnStrings(str, ',', ';');
            textures = new Texture[texs.length - 2];
            for (ti = 0; ti < texs.length; ++ti) {
                if (ti <= 1) continue;
                textures[ti - 2] = Asset.getTextureNM(texs[ti]);
            }
            t.walkBack = new Sprite(textures, Stringer.parseInt(texs[1]), Stringer.parseFloat(texs[0]));
        }
        if ((str = Respawn.getString("DAMAGE_SIDE_ANIM", obj, Main.settings, key)) != null) {
            texs = Mesh.cutOnStrings(str, ',', ';');
            textures = new Texture[texs.length - 2];
            for (ti = 0; ti < texs.length; ++ti) {
                if (ti <= 1) continue;
                textures[ti - 2] = Asset.getTextureNM(texs[ti]);
            }
            t.damageSide = new Sprite(textures, Stringer.parseInt(texs[1]), Stringer.parseFloat(texs[0]));
        }
        if ((str = Respawn.getString("DEATH_SIDE_ANIM", obj, Main.settings, key)) != null) {
            texs = Mesh.cutOnStrings(str, ',', ';');
            textures = new Texture[texs.length - 2];
            for (ti = 0; ti < texs.length; ++ti) {
                if (ti <= 1) continue;
                textures[ti - 2] = Asset.getTextureNM(texs[ti]);
            }
            t.deathSide = new Sprite(textures, Stringer.parseInt(texs[1]), Stringer.parseFloat(texs[0]));
            t.deathSide.limiter = true;
        }
        if ((str = Respawn.getString("ATTACK_SIDE_ANIM", obj, Main.settings, key)) != null) {
            texs = Mesh.cutOnStrings(str, ',', ';');
            textures = new Texture[texs.length - 2];
            for (ti = 0; ti < texs.length; ++ti) {
                if (ti <= 1) continue;
                textures[ti - 2] = Asset.getTextureNM(texs[ti]);
            }
            t.attackSide = new Sprite(textures, Stringer.parseInt(texs[1]), Stringer.parseFloat(texs[0]));
        }
        if ((str = Respawn.getString("STAY_SIDE_ANIM", obj, Main.settings, key)) != null) {
            texs = Mesh.cutOnStrings(str, ',', ';');
            textures = new Texture[texs.length - 2];
            for (ti = 0; ti < texs.length; ++ti) {
                if (ti <= 1) continue;
                textures[ti - 2] = Asset.getTextureNM(texs[ti]);
            }
            t.staySide = new Sprite(textures, Stringer.parseInt(texs[1]), Stringer.parseFloat(texs[0]));
        }
        if ((str = Respawn.getString("WALK_SIDE_ANIM", obj, Main.settings, key)) != null) {
            texs = Mesh.cutOnStrings(str, ',', ';');
            textures = new Texture[texs.length - 2];
            for (ti = 0; ti < texs.length; ++ti) {
                if (ti <= 1) continue;
                textures[ti - 2] = Asset.getTextureNM(texs[ti]);
            }
            t.walkSide = new Sprite(textures, Stringer.parseInt(texs[1]), Stringer.parseFloat(texs[0]));
        }
        Mesh meshz = null;
        if (t.meshImage != null) {
            meshz = t.meshImage.getMesh();
            meshz.setTexture(mt);
        }
        if (Respawn.getString("ANIMSPEED", obj, Main.settings, key) != null) {
            t.animspeed = Respawn.getInt("ANIMSPEED", obj, Main.settings, key);
        }
        if (Respawn.getString("ATTACKANIMSPEED", obj, Main.settings, key) != null) {
            t.attackanimspeed = Respawn.getInt("ATTACKANIMSPEED", obj, Main.settings, key);
        }
        if (Respawn.getString("DAMAGE", obj, Main.settings, key) != null) {
            t.damage = Respawn.getInt("DAMAGE", obj, Main.settings, key);
        }
        if (Respawn.getString("ATTACKRADIUS", obj, Main.settings, key) != null) {
            t.attackradius = Respawn.getFloat("ATTACKRADIUS", obj, Main.settings, key);
        }
        if (Respawn.getString("JUMPHEIGHT", obj, Main.settings, key) != null) {
            t.jumpheight = Respawn.getInt("JUMPHEIGHT", obj, Main.settings, key);
        }
        if (Respawn.getString("JUMPSPEED", obj, Main.settings, key) != null) {
            t.jumpspeed = Respawn.getFloat("JUMPSPEED", obj, Main.settings, key);
        }
        if (Respawn.getString("SPEED", obj, Main.settings, key) != null) {
            t.speed = Respawn.getInt("SPEED", obj, Main.settings, key);
        }
        if (Respawn.getString("REACTTIMER", obj, Main.settings, key) != null) {
            t.reacttimer = Respawn.getInt("REACTTIMER", obj, Main.settings, key);
        }
        if (Respawn.getString("ATTACKTIMER", obj, Main.settings, key) != null) {
            t.attacktimer = Respawn.getInt("ATTACKTIMER", obj, Main.settings, key);
        }
        if (Respawn.getString("AI", obj, Main.settings, key) != null) {
            t.ai = Respawn.getInt("AI", obj, Main.settings, key);
        }
        if (Respawn.getString("ENEMYREACTION", obj, Main.settings, key) != null) {
            t.playerreaction = Respawn.getInt("ENEMYREACTION", obj, Main.settings, key);
        }
        if (Respawn.getString("ATTACKTRIGGER", obj, Main.settings, key) != null) {
            t.attacktrigger = Respawn.getInt("ATTACKTRIGGER", obj, Main.settings, key);
        }
        if (Respawn.getString("ATTACK", obj, Main.settings, key) != null) {
            t.toAttack = Mesh.cutOnInts(Respawn.getString("ATTACK", obj, Main.settings, key), ',', ';');
        }
        if (Respawn.getString("FOLLOW", obj, Main.settings, key) != null) {
            t.toFollow = Mesh.cutOnInts(Respawn.getString("FOLLOW", obj, Main.settings, key), ',', ';');
        }
        if (Respawn.getString("FRIENDLY_FIRE", obj, Main.settings, key) != null) {
            t.friendlyFire = Mesh.cutOnInts(Respawn.getString("FRIENDLY_FIRE", obj, Main.settings, key), ',', ';');
        }
        if (Respawn.getString("FRACTION", obj, Main.settings, key) != null) {
            t.fraction = Respawn.getInt("FRACTION", obj, Main.settings, key);
        }
        if (Respawn.getString("FRAGSONDEATH", obj, Main.settings, key) != null) {
            t.fragsOnDeath = Respawn.getInt("FRAGSONDEATH", obj, Main.settings, key);
        }
        if (Respawn.getString("FRAGS_ON_ANY_DEATH", obj, Main.settings, key) != null) {
            t.fragsOnAnyDeath = Respawn.getInt("FRAGS_ON_ANY_DEATH", obj, Main.settings, key);
        }
        if (Respawn.getString("MONEYONDEATH", obj, Main.settings, key) != null) {
            t.moneyOnDeath = Respawn.getInt("MONEYONDEATH", obj, Main.settings, key);
        }
        if (Respawn.getString("SLEEPONDAMAGE", obj, Main.settings, key) != null) {
            t.damageSleepTime = Respawn.getInt("SLEEPONDAMAGE", obj, Main.settings, key);
        }
        if (Respawn.getString("MAXENEMYDISTANCE", obj, Main.settings, key) != null) {
            t.maxEnemyDistance = Respawn.getInt("MAXENEMYDISTANCE", obj, Main.settings, key);
        }
        if (Respawn.getString("ATTACKONDAMAGE", obj, Main.settings, key) != null && Respawn.getInt("ATTACKONDAMAGE", obj, Main.settings, key) == 1) {
            t.unicalEnemies = new Vector();
        }
        if (Respawn.getString("ATTACKONDAMAGE_OP", obj, Main.settings, key) != null && Respawn.getInt("ATTACKONDAMAGE_OP", obj, Main.settings, key) == 1) {
            if (t.unicalEnemies == null) {
                t.unicalEnemies = new Vector();
            }
            t.attackOnDamageOnlyPlayer = true;
        }
        if (Respawn.getString("ROT", obj, Main.settings, key) != null) {
            t.getCharacter().rotY(Respawn.getInt("ROT", obj, Main.settings, key));
        }
        if ((tmp = Respawn.getString("MUZZLE_FLASH_POS", obj, Main.settings, key)) != null) {
            t.muzzleFlashPos = new Vertex(Mesh.cutOnInts(tmp, ',', ';'));
            t.muzzleFlash = new Sprite(Asset.getTexture(Respawn.getString("MUZZLE_FLASH", obj, Main.settings, key)), Respawn.getInt("MUZZLE_FLASH_SCALE", obj, Main.settings, key));
            if (t.muzzleFlash.textures[0].alphaMixing) {
                t.muzzleFlash.mode = (byte)3;
            }
            t.muzzleFlash.fog = false;
            t.lastAttack = 0L;
            t.muzzleFlashTimer = Respawn.getInt("MUZZLE_FLASH_TIMER", obj, Main.settings, key);
        }
        if (modes != null && meshz != null) {
            Asset.applyMeshEffects(meshz, modes);
        }
        return t;
    }

    public static void loadRM(Stringer txt, RoomObject obj, Stringer lvl, String key) {
        Respawn.loadRM(txt, obj, lvl, key, "");
    }

    public static void loadRM(Stringer txt, RoomObject obj, Stringer lvl, String key, String bN) {
        String tmp = Respawn.getString(bN + "ACTIVABLE", txt, Main.settings, key);
        if (tmp != null) {
            obj.activable = tmp.equals("1");
        }
        if ((tmp = Respawn.getString(bN + "CLICKABLE", txt, Main.settings, key)) != null) {
            obj.clickable = tmp.equals("1");
        }
        if ((tmp = Respawn.getString(bN + "SINGLEUSE", txt, Main.settings, key)) != null) {
            obj.singleUse = tmp.equals("1");
        }
        if ((tmp = Respawn.getString(bN + "DESTROYONUSE", txt, Main.settings, key)) != null) {
            obj.destroyOnUse = tmp.equals("1");
        }
        if ((tmp = Respawn.getString(bN + "NAME", txt, Main.settings, key)) != null) {
            obj.name = tmp;
        }
        if ((tmp = Respawn.getString(bN + "DESC", txt, Main.settings, key)) != null) {
            obj.desc = tmp;
        }
        if ((tmp = Respawn.getString(bN + "NEED", txt, Main.settings, key)) != null) {
            obj.need = Mesh.cutOnStrings(tmp, ',');
        }
        if ((tmp = Respawn.getString(bN + "ON_ACTIVATE", txt, Main.settings, key)) != null) {
            obj.additional = Mesh.cutOnStrings(tmp, ';');
        }
        if ((tmp = Respawn.getString(bN + "ALWAYS_ACTIVATE", txt, Main.settings, key)) != null && tmp.equals("1")) {
            obj.alwaysActivate = true;
        }
        if ((tmp = Respawn.getString(bN + "MESSAGE", txt, Main.settings, key)) != null) {
            obj.message = tmp;
        }
        if ((tmp = Respawn.getString(bN + "ERRMESSAGE", txt, Main.settings, key)) != null) {
            obj.errMessage = tmp;
        }
        if ((tmp = Respawn.getString(bN + "RADIUS", txt, Main.settings, key)) != null) {
            obj.radius = Stringer.parseLong(tmp);
        }
        if ((tmp = Respawn.getString(bN + "MESSAGETIMEOUT", txt, Main.settings, key)) != null) {
            obj.messageTimeOut = Stringer.parseLong(tmp);
        }
        if ((tmp = Respawn.getString(bN + "MESSAGETYPE", txt, Main.settings, key)) != null) {
            obj.messageType = Stringer.parseInt(tmp);
        }
        if ((tmp = Respawn.getString(bN + "ERRMESSAGETIMEOUT", txt, Main.settings, key)) != null) {
            obj.messageTimeOut = Stringer.parseLong(tmp);
        }
        if ((tmp = Respawn.getString(bN + "ERRMESSAGETYPE", txt, Main.settings, key)) != null) {
            obj.messageType = Stringer.parseInt(tmp);
        }
        if ((tmp = Respawn.getString(bN + "MSGDELAY", txt, Main.settings, key)) != null) {
            obj.messageDelay = Stringer.parseLong(tmp);
        }
        if ((tmp = Respawn.getString(bN + "REUSETIMER", txt, Main.settings, key)) != null) {
            obj.lastActivate = 0L;
            obj.timeToReset = Stringer.parseLong(tmp);
            obj.hideWhenUnusable = true;
        }
        if ((tmp = Respawn.getString(bN + "HIDEREUSE", txt, Main.settings, key)) != null) {
            obj.hideWhenUnusable = false;
            if (tmp.equals("1")) {
                obj.hideWhenUnusable = true;
            }
        }
        if ((tmp = Respawn.getString(bN + "ERRMSGDELAY", txt, Main.settings, key)) != null) {
            obj.errMessageDelay = Stringer.parseLong(tmp);
        }
        if ((tmp = Respawn.getString(bN + "NEEDTOPOINT", txt, Main.settings, key)) != null) {
            if (tmp.equals("1")) {
                obj.needToPoint = true;
            } else if (tmp.equals("2")) {
                obj.needToPoint = true;
                obj.squarePoint = true;
            }
        }
        if (obj.needToPoint && (obj instanceof SpriteObject || obj instanceof MeshObject || obj instanceof NPC)) {
            obj.dynamicPoint = true;
        }
        if ((tmp = Respawn.getString(bN + "DYNAMICPOINT", txt, Main.settings, key)) != null) {
            if (tmp.equals("1")) {
                obj.dynamicPoint = true;
            } else if (tmp.equals("0")) {
                obj.dynamicPoint = false;
            }
        }
        if (obj.needToPoint && !obj.dynamicPoint) {
            GameObject mo;
            if (obj instanceof SpriteObject) {
                SpriteObject spr = (SpriteObject)obj;
                obj.pointRadius = spr.spr.getWidth() / 2;
                obj.pointHeight = spr.spr.getHeight() / 2;
                obj.pointOffset = new Vector3D(0, spr.spr.getHeight() / 2 + spr.spr.offsetY, 0);
            } else if (obj instanceof MeshObject) {
                mo = (MeshObject)obj;
                int sizex = mo.animation.getMesh().maxX() - mo.animation.getMesh().minX();
                int sizey = mo.animation.getMesh().maxY() - mo.animation.getMesh().minY();
                int sizez = mo.animation.getMesh().maxZ() - mo.animation.getMesh().minZ();
                obj.pointRadius = (sizex + sizez) / 4;
                obj.pointHeight = sizey / 2;
                obj.pointOffset = new Vector3D(mo.animation.getMesh().maxX() - sizex / 2, mo.animation.getMesh().maxY() - sizey / 2, mo.animation.getMesh().maxZ() - sizez / 2);
            } else if (obj instanceof NPC) {
                mo = (NPC)obj;
                int sizex = ((NPC)mo).meshImage.getMesh().maxX() - ((NPC)mo).meshImage.getMesh().minX();
                int sizey = ((NPC)mo).meshImage.getMesh().maxY() - ((NPC)mo).meshImage.getMesh().minY();
                int sizez = ((NPC)mo).meshImage.getMesh().maxZ() - ((NPC)mo).meshImage.getMesh().minZ();
                obj.pointRadius = (sizex + sizez) / 4;
                obj.pointHeight = sizey / 2;
                obj.pointOffset = new Vector3D(((NPC)mo).meshImage.getMesh().maxX() - sizex / 2, ((NPC)mo).meshImage.getMesh().maxY() - sizey / 2, ((NPC)mo).meshImage.getMesh().maxZ() - sizez / 2);
            }
        }
        if ((tmp = Respawn.getString(bN + "POINTRADIUS", txt, Main.settings, key)) != null) {
            obj.pointHeight = obj.pointRadius = Stringer.parseInt(tmp);
        }
        if ((tmp = Respawn.getString(bN + "POINTHEIGHT", txt, Main.settings, key)) != null) {
            obj.pointHeight = Stringer.parseInt(tmp);
        }
        if ((tmp = Respawn.getString(bN + "POINTOFFSET", txt, Main.settings, key)) != null) {
            int[] ps = Mesh.cutOnInts(tmp, ',');
            obj.pointOffset = new Vector3D(ps[0], ps[1], ps[2]);
        }
        if ((tmp = Respawn.getString(bN + "SOUND_ON_ACTIVATE", txt, Main.settings, key)) != null) {
            obj.sound = tmp;
            if (Main.isSounds && Main.sounds != 0) {
                Asset.getSound(tmp);
            }
        }
        if ((tmp = Respawn.getString(bN + "VISIBLE", txt, Main.settings, key)) != null) {
            obj.visible = false;
            if (tmp.equals("1")) {
                obj.visible = true;
            }
        }
        obj.activateOnlyOne = Respawn.getInt(bN + "ACTIVATE_ONLY_THIS", txt, Main.settings, key, lvl, 0) == 1;
        obj.reloadDestroy = Respawn.getInt(bN + "DESTROY_ON_LEVEL_RELOAD", txt, Main.settings, key, lvl, 1) == 1;
    }

    private static String getString(String s, Stringer s1, Stringer s2) {
        String ss = s1.getString(s);
        if (ss != null) {
            return ss;
        }
        if (s2 != null && (ss = s2.getString(s)) != null) {
            return ss;
        }
        return null;
    }

    private static String getString2(String s, Stringer s1, Stringer s2) {
        String ss = s1.getString2(s);
        if (ss != null) {
            return ss;
        }
        if (s2 != null && (ss = s2.getString2(s)) != null) {
            return ss;
        }
        return null;
    }

    private static int getInt(String s, Stringer s1, Stringer s2) {
        if (s1.getString(s) != null) {
            return s1.getInt(s);
        }
        if (s2 != null && s2.getString(s) != null) {
            return s2.getInt(s);
        }
        return 0;
    }

    private static int getInt(String s, Stringer s1, Stringer s2, int def) {
        if (s1.getString(s) != null) {
            return s1.getInt(s);
        }
        if (s2 != null && s2.getString(s) != null) {
            return s2.getInt(s);
        }
        return def;
    }

    private static float getFloat(String s, Stringer s1, Stringer s2) {
        if (s1.getString(s) != null) {
            return s1.getFloat(s);
        }
        if (s2 != null && s2.getString(s) != null) {
            return s2.getFloat(s);
        }
        return 0.0f;
    }

    private static String getString(String s, Stringer s1, Stringer s2, String key) {
        String ss = s1.getString(s);
        if (ss != null) {
            return ss;
        }
        if (s2 != null && (ss = s2.getString(key + s)) != null) {
            return ss;
        }
        if (s2 != null && (ss = s2.getString(s)) != null) {
            return ss;
        }
        return null;
    }

    private static String getString2(String s, Stringer s1, Stringer s2, String key) {
        String ss = s1.getString(s);
        if (ss != null) {
            return ss;
        }
        if (s2 != null && (ss = s2.getString2(key + s)) != null) {
            return ss;
        }
        if (s2 != null && (ss = s2.getString2(s)) != null) {
            return ss;
        }
        return null;
    }

    private static int getInt(String s, Stringer s1, Stringer s2, String key) {
        if (s1.getString(s) != null) {
            return s1.getInt(s);
        }
        if (s2 != null && s2.getString(key + s) != null) {
            return s2.getInt(key + s);
        }
        if (s2 != null && s2.getString(s) != null) {
            return s2.getInt(s);
        }
        return 0;
    }

    private static int getInt(String s, Stringer s1, Stringer s2, String key, Stringer lvl, int def) {
        if (s1.getString(s) != null) {
            return s1.getInt(s);
        }
        if (s2 != null && s2.getString(key + s) != null) {
            return s2.getInt(key + s);
        }
        if (lvl != null && lvl.getString(s) != null) {
            return lvl.getInt(s);
        }
        if (s2 != null && s2.getString(s) != null) {
            return s2.getInt(s);
        }
        return def;
    }

    private static long getLong(String s, Stringer s1, Stringer s2, String key) {
        if (s1.getString(s) != null) {
            return s1.getLong(s);
        }
        if (s2 != null && s2.getString(key + s) != null) {
            return s2.getLong(key + s);
        }
        if (s2 != null && s2.getString(s) != null) {
            return s2.getLong(s);
        }
        return 0L;
    }

    private static float getFloat(String s, Stringer s1, Stringer s2, String key) {
        if (s1.getString(s) != null) {
            return s1.getFloat(s);
        }
        if (s2 != null && s2.getString(key + s) != null) {
            return s2.getFloat(key + s);
        }
        if (s2 != null && s2.getString(s) != null) {
            return s2.getFloat(s);
        }
        return 0.0f;
    }

    public static String[] createScript(String str) {
        Vector<Object> tmp = new Vector<Object>();
        Object[] strs = Mesh.cutOnStrings(str, '\n');
        for (int i = 0; i < strs.length; ++i) {
            if (strs[i] == null || strs[i].indexOf("//") == 0 || ((String)strs[i]).equals(" ")) continue;
            if (((String)strs[i]).indexOf("//") > 0) {
                strs[i] = ((String)strs[i]).substring(0, ((String)strs[i]).indexOf("//"));
            }
            Stringer.removeEmpty((String)strs[i]);
            Stringer.removeSpaces((String)strs[i]);
            if ((((String)strs[i]).charAt(0) == '}' || ((String)strs[i]).charAt(0) == '{') && ((String)strs[i]).length() > 1) {
                tmp.addElement(((String)strs[i]).substring(1, ((String)strs[i]).length()));
                tmp.addElement(((String)strs[i]).substring(0, 1));
                continue;
            }
            if ((((String)strs[i]).charAt(((String)strs[i]).length() - 1) == '}' || ((String)strs[i]).charAt(((String)strs[i]).length() - 1) == '{') && ((String)strs[i]).length() > 1) {
                tmp.addElement(((String)strs[i]).substring(0, ((String)strs[i]).length() - 1));
                tmp.addElement(((String)strs[i]).substring(((String)strs[i]).length() - 1, ((String)strs[i]).length()));
                continue;
            }
            tmp.addElement(strs[i]);
        }
        strs = new String[tmp.size()];
        tmp.copyInto(strs);
        return strs;
    }

    static {
        defaultOneBot = false;
    }
}

