/*
 * Decompiled with CFR 0.152.
 */
package com.Rendering;

import com.Gameplay.Map.LightMapper;
import com.HUD.DeveloperMenu;
import com.Math.MathUtils;
import com.Rendering.Graphics3D;
import com.Rendering.Texture;
import com.Rendering.Vertex;
import com.misc.Main;

public class TexturingAffine {
    public static final int fp = 12;
    public static final int FP = 4096;
    public static final int fpPosition = 14;
    public static final int FPPosition = 16384;

    public static final void paint(Graphics3D g3d, Texture texture, Vertex a, int au, int av, Vertex b, int bu, int bv, Vertex c, int cu, int cv, int fogc, byte fog, int sz2, int af, int bf, int cf, short nx, short ny, short nz) {
        if (DeveloperMenu.renderPolygonsOverwrite) {
            TexturingAffine.paintOverwrite(g3d, a, b, c);
            return;
        }
        if (!texture.alphaMixing && texture.drawmode == 4) {
            fog = 0;
        }
        au = au * texture.rImg.w >> 8;
        bu = bu * texture.rImg.w >> 8;
        cu = cu * texture.rImg.w >> 8;
        av = av * texture.rImg.h >> 8;
        bv = bv * texture.rImg.h >> 8;
        cv = cv * texture.rImg.h >> 8;
        switch (fog) {
            case 0: {
                TexturingAffine.paintAffine_0(g3d, texture, a, au, av, b, bu, bv, c, cu, cv, fogc, sz2);
                break;
            }
            case 1: {
                if (Main.fogQ > 0) {
                    TexturingAffine.paintAffine_1(g3d, texture, a, au, av, b, bu, bv, c, cu, cv, fogc, sz2);
                    break;
                }
                TexturingAffine.paintAffine_0(g3d, texture, a, au, av, b, bu, bv, c, cu, cv, fogc, sz2);
                break;
            }
            case 2: {
                TexturingAffine.paintAffine_2(g3d, texture, a, au, av, b, bu, bv, c, cu, cv, fogc, sz2);
                break;
            }
            case 3: {
                if (Main.fogQ > 0) {
                    TexturingAffine.paintAffine_3(g3d, texture, a, au, av, b, bu, bv, c, cu, cv, fogc, sz2);
                    break;
                }
                TexturingAffine.paintAffine_0(g3d, texture, a, au, av, b, bu, bv, c, cu, cv, fogc, sz2);
                break;
            }
            case 4: {
                TexturingAffine.paintAffine_4(g3d, texture, a, au, av, b, bu, bv, c, cu, cv, fogc, sz2);
                break;
            }
            case 5: {
                TexturingAffine.paintAffine_5(g3d, texture, a, au, av, b, bu, bv, c, cu, cv, fogc, sz2, af, bf, cf, nx, ny, nz);
                break;
            }
            case 6: {
                if (Main.fogQ > 0) {
                    TexturingAffine.paintAffine_5(g3d, texture, a, au, av, b, bu, bv, c, cu, cv, fogc, sz2, af, bf, cf, nx, ny, nz);
                    break;
                }
                TexturingAffine.paintAffine_0(g3d, texture, a, au, av, b, bu, bv, c, cu, cv, fogc, sz2);
                break;
            }
            case 7: {
                TexturingAffine.paint_glass(g3d, texture, a, au, av, b, bu, bv, c, cu, cv, fogc, sz2);
                break;
            }
            case 8: {
                TexturingAffine.paintFill(g3d, a, b, c, texture, au, av);
                break;
            }
            case 9: {
                if (Main.fogQ > 0) {
                    TexturingAffine.paintAffine_5(g3d, texture, a, au, av, b, bu, bv, c, cu, cv, fogc, sz2, af, bf, cf, nx, ny, nz);
                    break;
                }
                TexturingAffine.paintAffine_0(g3d, texture, a, au, av, b, bu, bv, c, cu, cv, fogc, sz2);
                break;
            }
            case 10: {
                TexturingAffine.paintDitherGradient(g3d, texture, a, af, b, bf, c, cf);
                break;
            }
            case 11: {
                af = 255 + a.rz * 255 / Graphics3D.waterDistance;
                if (af > 255) {
                    af = 255;
                }
                if (af < 0) {
                    af = 0;
                }
                if ((bf = 255 + b.rz * 255 / Graphics3D.waterDistance) > 255) {
                    bf = 255;
                }
                if (bf < 0) {
                    bf = 0;
                }
                if ((cf = 255 + c.rz * 255 / Graphics3D.waterDistance) > 255) {
                    cf = 255;
                }
                if (cf < 0) {
                    cf = 0;
                }
                TexturingAffine.paintDitherGradient(g3d, texture, a, af, b, bf, c, cf);
                break;
            }
            case 12: {
                af = 255 + a.rz * 255 / Graphics3D.fDist;
                if (af > 255) {
                    af = 255;
                }
                if (af < 0) {
                    af = 0;
                }
                if ((bf = 255 + b.rz * 255 / Graphics3D.fDist) > 255) {
                    bf = 255;
                }
                if (bf < 0) {
                    bf = 0;
                }
                if ((cf = 255 + c.rz * 255 / Graphics3D.fDist) > 255) {
                    cf = 255;
                }
                if (cf < 0) {
                    cf = 0;
                }
                TexturingAffine.paintDitherGradient(g3d, texture, a, af, b, bf, c, cf);
            }
        }
    }

    static final void paintAffine_0(Graphics3D g3d, Texture texture, Vertex a, int au, int av, Vertex b, int bu, int bv, Vertex c, int cu, int cv, int fogc, int sz2) {
        int y_end;
        int tb;
        Vertex t;
        if (b.sy < a.sy) {
            t = a;
            a = b;
            b = t;
            tb = au;
            au = bu;
            bu = tb;
            tb = av;
            av = bv;
            bv = tb;
        }
        if (c.sy < a.sy) {
            t = c;
            c = a;
            a = t;
            tb = cu;
            cu = au;
            au = tb;
            tb = cv;
            cv = av;
            av = tb;
        }
        if (c.sy < b.sy) {
            t = b;
            b = c;
            c = t;
            tb = bu;
            bu = cu;
            cu = tb;
            tb = bv;
            bv = cv;
            cv = tb;
        }
        if (a.sy == c.sy) {
            return;
        }
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int tempI = c.sy - a.sy;
        int dx_start = (c.sx - a.sx << 14) / tempI;
        int du_start = (cu - au << 12) / tempI;
        int dv_start = (cv - av << 12) / tempI;
        int dx_end = 0;
        int du_end = 0;
        int dv_end = 0;
        if (b.sy != a.sy) {
            tempI = b.sy - a.sy;
            dx_end = (b.sx - a.sx << 14) / tempI;
            du_end = (bu - au << 12) / tempI;
            dv_end = (bv - av << 12) / tempI;
        }
        tempI = b.sy - a.sy;
        int x_start = (a.sx << 14) + dx_start * tempI;
        int u_start = (au << 12) + du_start * tempI;
        int v_start = (av << 12) + dv_start * tempI;
        int x_end = b.sx << 14;
        int u_end = bu << 12;
        int v_end = bv << 12;
        tempI = x_start - x_end >> 14;
        if (tempI == 0) {
            return;
        }
        int du = (u_start - u_end) / tempI;
        int dv = (v_start - v_end) / tempI;
        x_end = x_start = a.sx << 14;
        u_end = u_start = au << 12;
        v_end = v_start = av << 12;
        int y_start = a.sy;
        int n = y_end = c.sy < g3d.height ? c.sy : g3d.height;
        while (y_start < y_end) {
            if (y_start == b.sy) {
                if (c.sy == b.sy) {
                    return;
                }
                tempI = b.sy - a.sy;
                x_start = (a.sx << 14) + dx_start * tempI;
                u_start = (au << 12) + du_start * tempI;
                v_start = (av << 12) + dv_start * tempI;
                x_end = b.sx << 14;
                u_end = bu << 12;
                v_end = bv << 12;
                tempI = c.sy - b.sy;
                dx_end = (c.sx - b.sx << 14) / tempI;
                du_end = (cu - bu << 12) / tempI;
                dv_end = (cv - bv << 12) / tempI;
            }
            if (y_start >= 0) {
                int col;
                int x2;
                int v;
                int u;
                int x1;
                if (x_start > x_end) {
                    x1 = x_end >> 14;
                    u = u_end;
                    v = v_end;
                    x2 = x_start >> 14;
                } else {
                    x1 = x_start >> 14;
                    u = u_start;
                    v = v_start;
                    x2 = x_end >> 14;
                }
                if (x1 < 0) {
                    u -= du * x1;
                    v -= dv * x1;
                    x1 = 0;
                }
                if (x2 > g3d.width) {
                    x2 = g3d.width;
                }
                tempI = g3d.width * y_start;
                x1 += tempI;
                x2 += tempI;
                while (x2 - x1 >= 6) {
                    col = tex[(v >> 12 << widthBIT) + (u >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col;
                    }
                    if ((col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 1] = col;
                    }
                    if ((col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 2] = col;
                    }
                    if ((col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 3] = col;
                    }
                    if ((col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 4] = col;
                    }
                    if ((col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 5] = col;
                    }
                    u += du;
                    v += dv;
                    x1 += 6;
                }
                while (x1 < x2) {
                    col = tex[(v >> 12 << widthBIT) + (u >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col;
                    }
                    u += du;
                    v += dv;
                    ++x1;
                }
            }
            ++y_start;
            x_start += dx_start;
            u_start += du_start;
            v_start += dv_start;
            x_end += dx_end;
            u_end += du_end;
            v_end += dv_end;
        }
    }

    static final void paintAffine_1(Graphics3D g3d, Texture texture, Vertex a, int au, int av, Vertex b, int bu, int bv, Vertex c, int cu, int cv, int fogc, int sz2) {
        int y_end;
        int tb;
        Vertex t;
        int colf = sz2 & 0xFEFEFE;
        if (b.sy < a.sy) {
            t = a;
            a = b;
            b = t;
            tb = au;
            au = bu;
            bu = tb;
            tb = av;
            av = bv;
            bv = tb;
        }
        if (c.sy < a.sy) {
            t = c;
            c = a;
            a = t;
            tb = cu;
            cu = au;
            au = tb;
            tb = cv;
            cv = av;
            av = tb;
        }
        if (c.sy < b.sy) {
            t = b;
            b = c;
            c = t;
            tb = bu;
            bu = cu;
            cu = tb;
            tb = bv;
            bv = cv;
            cv = tb;
        }
        if (a.sy == c.sy) {
            return;
        }
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int tempI = c.sy - a.sy;
        int dx_start = (c.sx - a.sx << 14) / tempI;
        int du_start = (cu - au << 12) / tempI;
        int dv_start = (cv - av << 12) / tempI;
        int dx_end = 0;
        int du_end = 0;
        int dv_end = 0;
        if (b.sy != a.sy) {
            tempI = b.sy - a.sy;
            dx_end = (b.sx - a.sx << 14) / tempI;
            du_end = (bu - au << 12) / tempI;
            dv_end = (bv - av << 12) / tempI;
        }
        tempI = b.sy - a.sy;
        int x_start = (a.sx << 14) + dx_start * tempI;
        int u_start = (au << 12) + du_start * tempI;
        int v_start = (av << 12) + dv_start * tempI;
        int x_end = b.sx << 14;
        int u_end = bu << 12;
        int v_end = bv << 12;
        tempI = x_start - x_end >> 14;
        if (tempI == 0) {
            return;
        }
        int du = (u_start - u_end) / tempI;
        int dv = (v_start - v_end) / tempI;
        x_end = x_start = a.sx << 14;
        u_end = u_start = au << 12;
        v_end = v_start = av << 12;
        int y_start = a.sy;
        int n = y_end = c.sy < g3d.height ? c.sy : g3d.height;
        while (y_start < y_end) {
            if (y_start == b.sy) {
                if (c.sy == b.sy) {
                    return;
                }
                tempI = b.sy - a.sy;
                x_start = (a.sx << 14) + dx_start * tempI;
                u_start = (au << 12) + du_start * tempI;
                v_start = (av << 12) + dv_start * tempI;
                x_end = b.sx << 14;
                u_end = bu << 12;
                v_end = bv << 12;
                tempI = c.sy - b.sy;
                dx_end = (c.sx - b.sx << 14) / tempI;
                du_end = (cu - bu << 12) / tempI;
                dv_end = (cv - bv << 12) / tempI;
            }
            if (y_start >= 0) {
                int col;
                int x2;
                int v;
                int u;
                int x1;
                if (x_start > x_end) {
                    x1 = x_end >> 14;
                    u = u_end;
                    v = v_end;
                    x2 = x_start >> 14;
                } else {
                    tempI = x_start % 4096;
                    x1 = x_start >> 14;
                    u = u_start;
                    v = v_start;
                    x2 = x_end >> 14;
                }
                if (x1 < 0) {
                    u -= du * x1;
                    v -= dv * x1;
                    x1 = 0;
                }
                if (x2 > g3d.width) {
                    x2 = g3d.width;
                }
                tempI = g3d.width * y_start;
                x1 += tempI;
                x2 += tempI;
                u -= du;
                v -= dv;
                while (x2 - x1 >= 4) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + colf;
                        rgb[x1] = col | (col >> 8 & 0x10101) * 255;
                    }
                    if ((col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT]) != 0) {
                        col = (col & 0xFEFEFE) + colf;
                        rgb[x1 + 1] = col | (col >> 8 & 0x10101) * 255;
                    }
                    if ((col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT]) != 0) {
                        col = (col & 0xFEFEFE) + colf;
                        rgb[x1 + 2] = col | (col >> 8 & 0x10101) * 255;
                    }
                    if ((col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT]) != 0) {
                        col = (col & 0xFEFEFE) + colf;
                        rgb[x1 + 3] = col | (col >> 8 & 0x10101) * 255;
                    }
                    x1 += 4;
                }
                while (x1 < x2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + colf;
                        rgb[x1] = col | (col >> 8 & 0x10101) * 255;
                    }
                    ++x1;
                }
            }
            ++y_start;
            x_start += dx_start;
            u_start += du_start;
            v_start += dv_start;
            x_end += dx_end;
            u_end += du_end;
            v_end += dv_end;
        }
    }

    static final void paintAffine_2(Graphics3D g3d, Texture texture, Vertex a, int au, int av, Vertex b, int bu, int bv, Vertex c, int cu, int cv, int fogc, int sz2) {
        int y_end;
        int tb;
        Vertex t;
        if (b.sy < a.sy) {
            t = a;
            a = b;
            b = t;
            tb = au;
            au = bu;
            bu = tb;
            tb = av;
            av = bv;
            bv = tb;
        }
        if (c.sy < a.sy) {
            t = c;
            c = a;
            a = t;
            tb = cu;
            cu = au;
            au = tb;
            tb = cv;
            cv = av;
            av = tb;
        }
        if (c.sy < b.sy) {
            t = b;
            b = c;
            c = t;
            tb = bu;
            bu = cu;
            cu = tb;
            tb = bv;
            bv = cv;
            cv = tb;
        }
        if (a.sy == c.sy) {
            return;
        }
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int tempI = c.sy - a.sy;
        int dx_start = (c.sx - a.sx << 14) / tempI;
        int du_start = (cu - au << 12) / tempI;
        int dv_start = (cv - av << 12) / tempI;
        int dx_end = 0;
        int du_end = 0;
        int dv_end = 0;
        if (b.sy != a.sy) {
            tempI = b.sy - a.sy;
            dx_end = (b.sx - a.sx << 14) / tempI;
            du_end = (bu - au << 12) / tempI;
            dv_end = (bv - av << 12) / tempI;
        }
        tempI = b.sy - a.sy;
        int x_start = (a.sx << 14) + dx_start * tempI;
        int u_start = (au << 12) + du_start * tempI;
        int v_start = (av << 12) + dv_start * tempI;
        int x_end = b.sx << 14;
        int u_end = bu << 12;
        int v_end = bv << 12;
        tempI = x_start - x_end >> 14;
        if (tempI == 0) {
            return;
        }
        int du = (u_start - u_end) / tempI;
        int dv = (v_start - v_end) / tempI;
        x_end = x_start = a.sx << 14;
        u_end = u_start = au << 12;
        v_end = v_start = av << 12;
        int y_start = a.sy;
        int n = y_end = c.sy < g3d.height ? c.sy : g3d.height;
        while (y_start < y_end) {
            if (y_start == b.sy) {
                if (c.sy == b.sy) {
                    return;
                }
                tempI = b.sy - a.sy;
                x_start = (a.sx << 14) + dx_start * tempI;
                u_start = (au << 12) + du_start * tempI;
                v_start = (av << 12) + dv_start * tempI;
                x_end = b.sx << 14;
                u_end = bu << 12;
                v_end = bv << 12;
                tempI = c.sy - b.sy;
                dx_end = (c.sx - b.sx << 14) / tempI;
                du_end = (cu - bu << 12) / tempI;
                dv_end = (cv - bv << 12) / tempI;
            }
            if (y_start >= 0) {
                int col;
                int x2;
                int v;
                int u;
                int x1;
                if (x_start > x_end) {
                    x1 = x_end >> 14;
                    u = u_end;
                    v = v_end;
                    x2 = x_start >> 14;
                } else {
                    x1 = x_start >> 14;
                    u = u_start;
                    v = v_start;
                    x2 = x_end >> 14;
                }
                if (x1 < 0) {
                    u -= du * x1;
                    v -= dv * x1;
                    x1 = 0;
                }
                if (x2 > g3d.width) {
                    x2 = g3d.width;
                }
                tempI = g3d.width * y_start;
                x1 += tempI;
                x2 += tempI;
                u -= du;
                v -= dv;
                while (x2 - x1 >= 4) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + (rgb[x1] & 0xFEFEFE);
                        rgb[x1] = col | (col >> 8 & 0x10101) * 255;
                    }
                    if ((col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT]) != 0) {
                        col = (col & 0xFEFEFE) + (rgb[x1 + 1] & 0xFEFEFE);
                        rgb[x1 + 1] = col | (col >> 8 & 0x10101) * 255;
                    }
                    if ((col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT]) != 0) {
                        col = (col & 0xFEFEFE) + (rgb[x1 + 2] & 0xFEFEFE);
                        rgb[x1 + 2] = col | (col >> 8 & 0x10101) * 255;
                    }
                    if ((col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT]) != 0) {
                        col = (col & 0xFEFEFE) + (rgb[x1 + 3] & 0xFEFEFE);
                        rgb[x1 + 3] = col | (col >> 8 & 0x10101) * 255;
                    }
                    x1 += 4;
                }
                while (x1 < x2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + (rgb[x1] & 0xFEFEFE);
                        rgb[x1] = col | (col >> 8 & 0x10101) * 255;
                    }
                    ++x1;
                }
            }
            ++y_start;
            x_start += dx_start;
            u_start += du_start;
            v_start += dv_start;
            x_end += dx_end;
            u_end += du_end;
            v_end += dv_end;
        }
    }

    static final void paintAffine_3(Graphics3D g3d, Texture texture, Vertex a, int au, int av, Vertex b, int bu, int bv, Vertex c, int cu, int cv, int fogc, int sz2) {
        int y_end;
        int tb;
        Vertex t;
        if (b.sy < a.sy) {
            t = a;
            a = b;
            b = t;
            tb = au;
            au = bu;
            bu = tb;
            tb = av;
            av = bv;
            bv = tb;
        }
        if (c.sy < a.sy) {
            t = c;
            c = a;
            a = t;
            tb = cu;
            cu = au;
            au = tb;
            tb = cv;
            cv = av;
            av = tb;
        }
        if (c.sy < b.sy) {
            t = b;
            b = c;
            c = t;
            tb = bu;
            bu = cu;
            cu = tb;
            tb = bv;
            bv = cv;
            cv = tb;
        }
        if (a.sy == c.sy) {
            return;
        }
        if (Graphics3D.fDist / 255 != 0) {
            sz2 = -TexturingAffine.max(a.rz, b.rz, c.rz) / (Graphics3D.fDist / 255);
        }
        if (sz2 > 255) {
            sz2 = 255;
        }
        if (sz2 < 0) {
            sz2 = 0;
        }
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int isz2 = 255 - sz2;
        int f2 = (fogc & 0xFF00FF) * sz2;
        int f22 = (fogc & 0xFF00) * sz2;
        int tempI = c.sy - a.sy;
        int dx_start = (c.sx - a.sx << 14) / tempI;
        int du_start = (cu - au << 12) / tempI;
        int dv_start = (cv - av << 12) / tempI;
        int dx_end = 0;
        int du_end = 0;
        int dv_end = 0;
        if (b.sy != a.sy) {
            tempI = b.sy - a.sy;
            dx_end = (b.sx - a.sx << 14) / tempI;
            du_end = (bu - au << 12) / tempI;
            dv_end = (bv - av << 12) / tempI;
        }
        tempI = b.sy - a.sy;
        int x_start = (a.sx << 14) + dx_start * tempI;
        int u_start = (au << 12) + du_start * tempI;
        int v_start = (av << 12) + dv_start * tempI;
        int x_end = b.sx << 14;
        int u_end = bu << 12;
        int v_end = bv << 12;
        tempI = x_start - x_end >> 14;
        if (tempI == 0) {
            return;
        }
        int du = (u_start - u_end) / tempI;
        int dv = (v_start - v_end) / tempI;
        x_end = x_start = a.sx << 14;
        u_end = u_start = au << 12;
        v_end = v_start = av << 12;
        int y_start = a.sy;
        int n = y_end = c.sy < g3d.height ? c.sy : g3d.height;
        if (Main.fogQ == 2 && !Main.forceLQFog) {
            TexturingAffine.paintAffine_3_HQ(x_start, x_end, y_start, y_end, u_start, u_end, v_start, v_end, dx_start, dx_end, du_start, du_end, dv_start, dv_end, a, b, c, au, av, bu, bv, cu, cv, du, dv, g3d, texture);
            return;
        }
        TexturingAffine.paintAffine_3_LQ(x_start, x_end, y_start, y_end, u_start, u_end, v_start, v_end, dx_start, dx_end, du_start, du_end, dv_start, dv_end, a, b, c, au, av, bu, bv, cu, cv, du, dv, g3d, texture, isz2, f2, f22);
    }

    static final void paintAffine_3_LQ(int x_start, int x_end, int y_start, int y_end, int u_start, int u_end, int v_start, int v_end, int dx_start, int dx_end, int du_start, int du_end, int dv_start, int dv_end, Vertex a, Vertex b, Vertex c, int au, int av, int bu, int bv, int cu, int cv, int du, int dv, Graphics3D g3d, Texture texture, int isz2, int f2, int f22) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        while (y_start < y_end) {
            int tempI;
            if (y_start == b.sy) {
                if (c.sy == b.sy) {
                    return;
                }
                tempI = b.sy - a.sy;
                x_start = (a.sx << 14) + dx_start * tempI;
                u_start = (au << 12) + du_start * tempI;
                v_start = (av << 12) + dv_start * tempI;
                x_end = b.sx << 14;
                u_end = bu << 12;
                v_end = bv << 12;
                tempI = c.sy - b.sy;
                dx_end = (c.sx - b.sx << 14) / tempI;
                du_end = (cu - bu << 12) / tempI;
                dv_end = (cv - bv << 12) / tempI;
            }
            if (y_start >= 0) {
                int col;
                int x2;
                int v;
                int u;
                int x1;
                if (x_start > x_end) {
                    x1 = x_end >> 14;
                    u = u_end;
                    v = v_end;
                    x2 = x_start >> 14;
                } else {
                    x1 = x_start >> 14;
                    u = u_start;
                    v = v_start;
                    x2 = x_end >> 14;
                }
                if (x1 < 0) {
                    u -= du * x1;
                    v -= dv * x1;
                    x1 = 0;
                }
                if (x2 > g3d.width) {
                    x2 = g3d.width;
                }
                tempI = g3d.width * y_start;
                x1 += tempI;
                x2 += tempI;
                u -= du;
                v -= dv;
                while (x2 - x1 >= 4) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 + f2 & 0xFF00FF00 | (col & 0xFF00) * isz2 + f22 & 0xFF0000) >>> 8;
                    }
                    if ((col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 1] = ((col & 0xFF00FF) * isz2 + f2 & 0xFF00FF00 | (col & 0xFF00) * isz2 + f22 & 0xFF0000) >>> 8;
                    }
                    if ((col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 2] = ((col & 0xFF00FF) * isz2 + f2 & 0xFF00FF00 | (col & 0xFF00) * isz2 + f22 & 0xFF0000) >>> 8;
                    }
                    if ((col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 3] = ((col & 0xFF00FF) * isz2 + f2 & 0xFF00FF00 | (col & 0xFF00) * isz2 + f22 & 0xFF0000) >>> 8;
                    }
                    x1 += 4;
                }
                while (x2 - x1 >= 2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 + f2 & 0xFF00FF00 | (col & 0xFF00) * isz2 + f22 & 0xFF0000) >>> 8;
                    }
                    if ((col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 1] = ((col & 0xFF00FF) * isz2 + f2 & 0xFF00FF00 | (col & 0xFF00) * isz2 + f22 & 0xFF0000) >>> 8;
                    }
                    x1 += 2;
                }
                while (x1 < x2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 + f2 & 0xFF00FF00 | (col & 0xFF00) * isz2 + f22 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            ++y_start;
            x_start += dx_start;
            u_start += du_start;
            v_start += dv_start;
            x_end += dx_end;
            u_end += du_end;
            v_end += dv_end;
        }
    }

    static final void paintAffine_3_HQ(int x_start, int x_end, int y_start, int y_end, int u_start, int u_end, int v_start, int v_end, int dx_start, int dx_end, int du_start, int du_end, int dv_start, int dv_end, Vertex a, Vertex b, Vertex c, int au, int av, int bu, int bv, int cu, int cv, int du, int dv, Graphics3D g3d, Texture texture) {
        int fogcolor = Graphics3D.fogc;
        int fogcolor2 = fogcolor & 0xFF00;
        fogcolor &= 0xFF00FF;
        int af = -a.rz * 255 / Graphics3D.fDist;
        if (af > 255) {
            af = 255;
        }
        if (af < 0) {
            af = 0;
        }
        af = 255 - af;
        int bf = -b.rz * 255 / Graphics3D.fDist;
        if (bf > 255) {
            bf = 255;
        }
        if (bf < 0) {
            bf = 0;
        }
        bf = 255 - bf;
        int cf = -c.rz * 255 / Graphics3D.fDist;
        if (cf > 255) {
            cf = 255;
        }
        if (cf < 0) {
            cf = 0;
        }
        cf = 255 - cf;
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int tempI = c.sy - a.sy;
        int df_start = (cf - af << 12) / tempI;
        int df_end = 0;
        if (b.sy != a.sy) {
            tempI = b.sy - a.sy;
            df_end = (bf - af << 12) / tempI;
        }
        tempI = b.sy - a.sy;
        int f_start = (af << 12) + df_start * tempI;
        int f_end = bf << 12;
        if ((tempI = (a.sx << 14) + dx_start * tempI - (b.sx << 14) >> 14) == 0) {
            return;
        }
        int df = (f_start - f_end) / tempI;
        f_end = f_start = af << 12;
        while (y_start < y_end) {
            if (y_start == b.sy) {
                if (c.sy == b.sy) {
                    return;
                }
                tempI = b.sy - a.sy;
                x_start = (a.sx << 14) + dx_start * tempI;
                u_start = (au << 12) + du_start * tempI;
                v_start = (av << 12) + dv_start * tempI;
                f_start = (af << 12) + df_start * tempI;
                x_end = b.sx << 14;
                u_end = bu << 12;
                v_end = bv << 12;
                f_end = bf << 12;
                tempI = c.sy - b.sy;
                dx_end = (c.sx - b.sx << 14) / tempI;
                du_end = (cu - bu << 12) / tempI;
                dv_end = (cv - bv << 12) / tempI;
                df_end = (cf - bf << 12) / tempI;
            }
            if (y_start >= 0) {
                int col;
                int isz;
                int isz2;
                int x2;
                int f;
                int v;
                int u;
                int x1;
                if (x_start > x_end) {
                    x1 = x_end >> 14;
                    u = u_end;
                    v = v_end;
                    f = f_end;
                    x2 = x_start >> 14;
                } else {
                    x1 = x_start >> 14;
                    u = u_start;
                    v = v_start;
                    f = f_start;
                    x2 = x_end >> 14;
                }
                if (x1 < 0) {
                    u -= du * x1;
                    v -= dv * x1;
                    f -= df * x1;
                    x1 = 0;
                }
                if (x2 > g3d.width) {
                    x2 = g3d.width;
                }
                tempI = g3d.width * y_start;
                x1 += tempI;
                x2 += tempI;
                u -= du;
                v -= dv;
                while (x2 - x1 >= 2) {
                    isz2 = (f += df) >> 12;
                    isz = 255 - isz2;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 + fogcolor * isz & 0xFF00FF00 | (col & 0xFF00) * isz2 + fogcolor2 * isz & 0xFF0000) >>> 8;
                    }
                    isz2 = (f += df) >> 12;
                    isz = 255 - isz2;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1 + 1] = ((col & 0xFF00FF) * isz2 + fogcolor * isz & 0xFF00FF00 | (col & 0xFF00) * isz2 + fogcolor2 * isz & 0xFF0000) >>> 8;
                    }
                    x1 += 2;
                }
                while (x1 < x2) {
                    isz2 = (f += df) >> 12;
                    isz = 255 - isz2;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 + fogcolor * isz & 0xFF00FF00 | (col & 0xFF00) * isz2 + fogcolor2 * isz & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            ++y_start;
            x_start += dx_start;
            u_start += du_start;
            v_start += dv_start;
            f_start += df_start;
            x_end += dx_end;
            u_end += du_end;
            v_end += dv_end;
            f_end += df_end;
        }
    }

    static final void paintAffine_4(Graphics3D g3d, Texture texture, Vertex a, int au, int av, Vertex b, int bu, int bv, Vertex c, int cu, int cv, int fogc, int sz2) {
        int y_end;
        int tb;
        Vertex t;
        if (b.sy < a.sy) {
            t = a;
            a = b;
            b = t;
            tb = au;
            au = bu;
            bu = tb;
            tb = av;
            av = bv;
            bv = tb;
        }
        if (c.sy < a.sy) {
            t = c;
            c = a;
            a = t;
            tb = cu;
            cu = au;
            au = tb;
            tb = cv;
            cv = av;
            av = tb;
        }
        if (c.sy < b.sy) {
            t = b;
            b = c;
            c = t;
            tb = bu;
            bu = cu;
            cu = tb;
            tb = bv;
            bv = cv;
            cv = tb;
        }
        if (a.sy == c.sy) {
            return;
        }
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int tempI = c.sy - a.sy;
        int dx_start = (c.sx - a.sx << 14) / tempI;
        int du_start = (cu - au << 12) / tempI;
        int dv_start = (cv - av << 12) / tempI;
        int dx_end = 0;
        int du_end = 0;
        int dv_end = 0;
        if (b.sy != a.sy) {
            tempI = b.sy - a.sy;
            dx_end = (b.sx - a.sx << 14) / tempI;
            du_end = (bu - au << 12) / tempI;
            dv_end = (bv - av << 12) / tempI;
        }
        tempI = b.sy - a.sy;
        int x_start = (a.sx << 14) + dx_start * tempI;
        int u_start = (au << 12) + du_start * tempI;
        int v_start = (av << 12) + dv_start * tempI;
        int x_end = b.sx << 14;
        int u_end = bu << 12;
        int v_end = bv << 12;
        tempI = x_start - x_end >> 14;
        if (tempI == 0) {
            return;
        }
        int du = (u_start - u_end) / tempI;
        int dv = (v_start - v_end) / tempI;
        x_end = x_start = a.sx << 14;
        u_end = u_start = au << 12;
        v_end = v_start = av << 12;
        int y_start = a.sy;
        int n = y_end = c.sy < g3d.height ? c.sy : g3d.height;
        while (y_start < y_end) {
            if (y_start == b.sy) {
                if (c.sy == b.sy) {
                    return;
                }
                tempI = b.sy - a.sy;
                x_start = (a.sx << 14) + dx_start * tempI;
                u_start = (au << 12) + du_start * tempI;
                v_start = (av << 12) + dv_start * tempI;
                x_end = b.sx << 14;
                u_end = bu << 12;
                v_end = bv << 12;
                tempI = c.sy - b.sy;
                dx_end = (c.sx - b.sx << 14) / tempI;
                du_end = (cu - bu << 12) / tempI;
                dv_end = (cv - bv << 12) / tempI;
            }
            if (y_start >= 0) {
                int cols;
                int ca;
                int col;
                int x2;
                int v;
                int u;
                int x1;
                if (x_start > x_end) {
                    x1 = x_end >> 14;
                    u = u_end;
                    v = v_end;
                    x2 = x_start >> 14;
                } else {
                    x1 = x_start >> 14;
                    u = u_start;
                    v = v_start;
                    x2 = x_end >> 14;
                }
                if (x1 < 0) {
                    u -= du * x1;
                    v -= dv * x1;
                    x1 = 0;
                }
                if (x2 > g3d.width) {
                    x2 = g3d.width;
                }
                tempI = g3d.width * y_start;
                x1 += tempI;
                x2 += tempI;
                u -= du;
                v -= dv;
                while (x2 - x1 >= 4) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        ca = col >> 24 & 0xFF;
                        cols = rgb[x1];
                        rgb[x1] = ((col & 0xFF00FF) * ca + (cols & 0xFF00FF) * (255 - ca) & 0xFF00FF00 | (col & 0xFF00) * ca + (cols & 0xFF00) * (255 - ca) & 0xFF0000) >>> 8;
                    }
                    if ((col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT]) != 0) {
                        ca = col >> 24 & 0xFF;
                        cols = rgb[x1 + 1];
                        rgb[x1 + 1] = ((col & 0xFF00FF) * ca + (cols & 0xFF00FF) * (255 - ca) & 0xFF00FF00 | (col & 0xFF00) * ca + (cols & 0xFF00) * (255 - ca) & 0xFF0000) >>> 8;
                    }
                    if ((col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT]) != 0) {
                        ca = col >> 24 & 0xFF;
                        cols = rgb[x1 + 2];
                        rgb[x1 + 2] = ((col & 0xFF00FF) * ca + (cols & 0xFF00FF) * (255 - ca) & 0xFF00FF00 | (col & 0xFF00) * ca + (cols & 0xFF00) * (255 - ca) & 0xFF0000) >>> 8;
                    }
                    if ((col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT]) != 0) {
                        ca = col >> 24 & 0xFF;
                        cols = rgb[x1 + 3];
                        rgb[x1 + 3] = ((col & 0xFF00FF) * ca + (cols & 0xFF00FF) * (255 - ca) & 0xFF00FF00 | (col & 0xFF00) * ca + (cols & 0xFF00) * (255 - ca) & 0xFF0000) >>> 8;
                    }
                    x1 += 4;
                }
                while (x1 < x2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        ca = col >> 24 & 0xFF;
                        cols = rgb[x1];
                        rgb[x1] = ((col & 0xFF00FF) * ca + (cols & 0xFF00FF) * (255 - ca) & 0xFF00FF00 | (col & 0xFF00) * ca + (cols & 0xFF00) * (255 - ca) & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            ++y_start;
            x_start += dx_start;
            u_start += du_start;
            v_start += dv_start;
            x_end += dx_end;
            u_end += du_end;
            v_end += dv_end;
        }
    }

    static final void paintAffine_5(Graphics3D g3d, Texture texture, Vertex a, int au, int av, Vertex b, int bu, int bv, Vertex c, int cu, int cv, int fogc, int sz2, int af, int bf, int cf, short nx, short ny, short nz) {
        int tb;
        Vertex t;
        if (b.sy < a.sy) {
            t = a;
            a = b;
            b = t;
            tb = au;
            au = bu;
            bu = tb;
            tb = av;
            av = bv;
            bv = tb;
            tb = af;
            af = bf;
            bf = tb;
        }
        if (c.sy < a.sy) {
            t = c;
            c = a;
            a = t;
            tb = cu;
            cu = au;
            au = tb;
            tb = cv;
            cv = av;
            av = tb;
            tb = cf;
            cf = af;
            af = tb;
        }
        if (c.sy < b.sy) {
            t = b;
            b = c;
            c = t;
            tb = bu;
            bu = cu;
            cu = tb;
            tb = bv;
            bv = cv;
            cv = tb;
            tb = bf;
            bf = cf;
            cf = tb;
        }
        if (a.sy == c.sy) {
            return;
        }
        if (texture.getDrawMode() == 6) {
            if (Graphics3D.fDist / 255 != 0) {
                sz2 = -TexturingAffine.max(a.rz, b.rz, c.rz) / (Graphics3D.fDist / 255);
            }
            if (sz2 > 255) {
                sz2 = 255;
            }
            if (sz2 < 0) {
                sz2 = 0;
            }
        }
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int tempI = c.sy - a.sy;
        int dx_start = (c.sx - a.sx << 14) / tempI;
        int du_start = (cu - au << 12) / tempI;
        int dv_start = (cv - av << 12) / tempI;
        int dx_end = 0;
        int du_end = 0;
        int dv_end = 0;
        if (b.sy != a.sy) {
            tempI = b.sy - a.sy;
            dx_end = (b.sx - a.sx << 14) / tempI;
            du_end = (bu - au << 12) / tempI;
            dv_end = (bv - av << 12) / tempI;
        }
        tempI = b.sy - a.sy;
        int x_start = (a.sx << 14) + dx_start * tempI;
        int u_start = (au << 12) + du_start * tempI;
        int v_start = (av << 12) + dv_start * tempI;
        int x_end = b.sx << 14;
        int u_end = bu << 12;
        int v_end = bv << 12;
        tempI = x_start - x_end >> 14;
        if (tempI == 0) {
            return;
        }
        int du = (u_start - u_end) / tempI;
        int dv = (v_start - v_end) / tempI;
        x_end = x_start = a.sx << 14;
        u_end = u_start = au << 12;
        v_end = v_start = av << 12;
        int y_start = a.sy;
        int y_end = c.sy < g3d.height ? c.sy : g3d.height;
        int isz2 = 255 - sz2;
        if (!(Main.fogQ < 2 || Main.forceLQFog || texture.drawmode != 6 && texture.drawmode != 9)) {
            if (texture.drawmode == 6) {
                af = 255 + a.rz * 255 / Graphics3D.fDist;
                if (af > 255) {
                    af = 255;
                }
                if (af < 0) {
                    af = 0;
                }
                if ((bf = 255 + b.rz * 255 / Graphics3D.fDist) > 255) {
                    bf = 255;
                }
                if (bf < 0) {
                    bf = 0;
                }
                if ((cf = 255 + c.rz * 255 / Graphics3D.fDist) > 255) {
                    cf = 255;
                }
                if (cf < 0) {
                    cf = 0;
                }
            }
            if (LightMapper.cameraVectorLight && texture.drawmode == 6) {
                af = af * MathUtils.calcLight(nx, ny, nz, a.x - g3d.getCamera().m03, a.y - g3d.getCamera().m13, a.z - g3d.getCamera().m23) / 255;
                bf = bf * MathUtils.calcLight(nx, ny, nz, b.x - g3d.getCamera().m03, b.y - g3d.getCamera().m13, b.z - g3d.getCamera().m23) / 255;
                cf = cf * MathUtils.calcLight(nx, ny, nz, c.x - g3d.getCamera().m03, c.y - g3d.getCamera().m13, c.z - g3d.getCamera().m23) / 255;
            }
            TexturingAffine.paintAffine_9_HQ(x_start, x_end, y_start, y_end, u_start, u_end, v_start, v_end, dx_start, dx_end, du_start, du_end, dv_start, dv_end, a, b, c, au, av, bu, bv, cu, cv, du, dv, g3d, texture, af, bf, cf);
            return;
        }
        TexturingAffine.paintAffine_5_draw(x_start, x_end, y_start, y_end, u_start, u_end, v_start, v_end, dx_start, dx_end, du_start, du_end, dv_start, dv_end, a, b, c, au, av, bu, bv, cu, cv, du / 2, dv / 2, g3d, texture, isz2);
    }

    static final void paintAffine_5_draw(int x_start, int x_end, int y_start, int y_end, int u_start, int u_end, int v_start, int v_end, int dx_start, int dx_end, int du_start, int du_end, int dv_start, int dv_end, Vertex a, Vertex b, Vertex c, int au, int av, int bu, int bv, int cu, int cv, int du, int dv, Graphics3D g3d, Texture texture, int isz2) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        while (y_start < y_end) {
            int tempI;
            if (y_start == b.sy) {
                if (c.sy == b.sy) {
                    return;
                }
                tempI = b.sy - a.sy;
                x_start = (a.sx << 14) + dx_start * tempI;
                u_start = (au << 12) + du_start * tempI;
                v_start = (av << 12) + dv_start * tempI;
                x_end = b.sx << 14;
                u_end = bu << 12;
                v_end = bv << 12;
                tempI = c.sy - b.sy;
                dx_end = (c.sx - b.sx << 14) / tempI;
                du_end = (cu - bu << 12) / tempI;
                dv_end = (cv - bv << 12) / tempI;
            }
            if (y_start >= 0) {
                int col;
                int x2;
                int v;
                int u;
                int x1;
                if (x_start > x_end) {
                    x1 = x_end >> 14;
                    u = u_end;
                    v = v_end;
                    x2 = x_start >> 14;
                } else {
                    x1 = x_start >> 14;
                    u = u_start;
                    v = v_start;
                    x2 = x_end >> 14;
                }
                if (x1 < 0) {
                    u -= du * x1;
                    v -= dv * x1;
                    x1 = 0;
                }
                if (x2 > g3d.width) {
                    x2 = g3d.width;
                }
                tempI = g3d.width * y_start;
                x1 += tempI;
                x2 += tempI;
                u -= du;
                v -= dv;
                while (x2 - x1 >= 6) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    if ((col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    if ((col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 2] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    if ((col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 3] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    if ((col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 4] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    if ((col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 5] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    x1 += 6;
                }
                while (x2 - x1 >= 2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    if ((col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
                while (x1 < x2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            ++y_start;
            x_start += dx_start;
            u_start += du_start;
            v_start += dv_start;
            x_end += dx_end;
            u_end += du_end;
            v_end += dv_end;
        }
    }

    static final void paintAffine_9_HQ(int x_start, int x_end, int y_start, int y_end, int u_start, int u_end, int v_start, int v_end, int dx_start, int dx_end, int du_start, int du_end, int dv_start, int dv_end, Vertex a, Vertex b, Vertex c, int au, int av, int bu, int bv, int cu, int cv, int du, int dv, Graphics3D g3d, Texture texture, int af, int bf, int cf) {
        int col;
        int isz2;
        int x2;
        int f;
        int v;
        int u;
        int x1;
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int tempI = c.sy - a.sy;
        int df_start = (cf - af << 12) / tempI;
        int df_end = 0;
        if (b.sy != a.sy) {
            tempI = b.sy - a.sy;
            df_end = (bf - af << 12) / tempI;
        }
        tempI = b.sy - a.sy;
        int f_start = (af << 12) + df_start * tempI;
        int f_end = bf << 12;
        if ((tempI = (a.sx << 14) + dx_start * tempI - (b.sx << 14) >> 14) == 0) {
            return;
        }
        int df = (f_start - f_end) / tempI;
        if (df > 0) {
            --df;
        }
        if (df < 0) {
            ++df;
        }
        f_end = f_start = af << 12;
        int y_end2 = y_end;
        if (y_end2 > b.sy) {
            y_end2 = b.sy;
        }
        while (y_start < y_end2) {
            if (y_start >= 0) {
                if (x_start > x_end) {
                    x1 = x_end >> 14;
                    u = u_end;
                    v = v_end;
                    f = f_end;
                    x2 = x_start >> 14;
                } else {
                    x1 = x_start >> 14;
                    u = u_start;
                    v = v_start;
                    f = f_start;
                    x2 = x_end >> 14;
                }
                if (x1 < 0) {
                    u -= du * x1;
                    v -= dv * x1;
                    f -= df * x1;
                    x1 = 0;
                }
                if (x2 > g3d.width) {
                    x2 = g3d.width;
                }
                tempI = g3d.width * y_start;
                x1 += tempI;
                x2 += tempI;
                u -= du;
                v -= dv;
                f -= df;
                while (x2 - x1 >= 2) {
                    u += du;
                    v += dv;
                    isz2 = (f += df) >> 12;
                    if (isz2 < 0) {
                        isz2 = 0;
                    }
                    if ((col = tex[(v >> 12 << widthBIT) + (u >> 12) & lengthBIT]) != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    u += du;
                    v += dv;
                    isz2 = (f += df) >> 12;
                    if (isz2 < 0) {
                        isz2 = 0;
                    }
                    if ((col = tex[(v >> 12 << widthBIT) + (u >> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    x1 += 2;
                }
                while (x1 < x2) {
                    u += du;
                    v += dv;
                    isz2 = (f += df) >> 12;
                    if (isz2 < 0) {
                        isz2 = 0;
                    }
                    if ((col = tex[(v >> 12 << widthBIT) + (u >> 12) & lengthBIT]) != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            ++y_start;
            x_start += dx_start;
            u_start += du_start;
            v_start += dv_start;
            f_start += df_start;
            x_end += dx_end;
            u_end += du_end;
            v_end += dv_end;
            f_end += df_end;
        }
        if (y_end <= y_start) {
            return;
        }
        if (c.sy == b.sy) {
            return;
        }
        tempI = b.sy - a.sy;
        x_start = (a.sx << 14) + dx_start * tempI;
        u_start = (au << 12) + du_start * tempI;
        v_start = (av << 12) + dv_start * tempI;
        f_start = (af << 12) + df_start * tempI;
        x_end = b.sx << 14;
        u_end = bu << 12;
        v_end = bv << 12;
        f_end = bf << 12;
        tempI = c.sy - b.sy;
        dx_end = (c.sx - b.sx << 14) / tempI;
        du_end = (cu - bu << 12) / tempI;
        dv_end = (cv - bv << 12) / tempI;
        df_end = (cf - bf << 12) / tempI;
        while (y_start < y_end) {
            if (y_start >= 0) {
                if (x_start > x_end) {
                    x1 = x_end >> 14;
                    u = u_end;
                    v = v_end;
                    f = f_end;
                    x2 = x_start >> 14;
                } else {
                    x1 = x_start >> 14;
                    u = u_start;
                    v = v_start;
                    f = f_start;
                    x2 = x_end >> 14;
                }
                if (x1 < 0) {
                    u -= du * x1;
                    v -= dv * x1;
                    f -= df * x1;
                    x1 = 0;
                }
                if (x2 > g3d.width) {
                    x2 = g3d.width;
                }
                tempI = g3d.width * y_start;
                x1 += tempI;
                x2 += tempI;
                u -= du;
                v -= dv;
                f -= df;
                while (x2 - x1 >= 2) {
                    u += du;
                    v += dv;
                    isz2 = (f += df) >> 12;
                    if (isz2 < 0) {
                        isz2 = 0;
                    }
                    if ((col = tex[(v >> 12 << widthBIT) + (u >> 12) & lengthBIT]) != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    u += du;
                    v += dv;
                    isz2 = (f += df) >> 12;
                    if (isz2 < 0) {
                        isz2 = 0;
                    }
                    if ((col = tex[(v >> 12 << widthBIT) + (u >> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    x1 += 2;
                }
                while (x1 < x2) {
                    u += du;
                    v += dv;
                    isz2 = (f += df) >> 12;
                    if (isz2 < 0) {
                        isz2 = 0;
                    }
                    if ((col = tex[(v >> 12 << widthBIT) + (u >> 12) & lengthBIT]) != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            ++y_start;
            x_start += dx_start;
            u_start += du_start;
            v_start += dv_start;
            f_start += df_start;
            x_end += dx_end;
            u_end += du_end;
            v_end += dv_end;
            f_end += df_end;
        }
    }

    static final void paintDitherGradient(Graphics3D g3d, Texture texture, Vertex a, int au2, Vertex b, int bu2, Vertex c, int cu2) {
        int tb;
        Vertex t;
        if (b.sy < a.sy) {
            t = a;
            a = b;
            b = t;
            tb = au2;
            au2 = bu2;
            bu2 = tb;
        }
        if (c.sy < a.sy) {
            t = c;
            c = a;
            a = t;
            tb = cu2;
            cu2 = au2;
            au2 = tb;
        }
        if (c.sy < b.sy) {
            t = b;
            b = c;
            c = t;
            tb = bu2;
            bu2 = cu2;
            cu2 = tb;
        }
        if (a.sy == c.sy) {
            return;
        }
        int wInH = texture.rImg.h / texture.rImg.w;
        int au = au2 * wInH / 256;
        int bu = bu2 * wInH / 256;
        int cu = cu2 * wInH / 256;
        if (au > wInH - 1) {
            au = wInH - 1;
        }
        if (bu > wInH - 1) {
            bu = wInH - 1;
        }
        if (cu > wInH - 1) {
            cu = wInH - 1;
        }
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length / wInH;
        int lengthBIT2 = lengthBIT - 1;
        int lengthBIT3 = tex.length - 1;
        int texWidth = texture.rImg.w;
        int widthBIT = texture.widthBITmode10;
        int[] rgb = g3d.display;
        int tempI = c.sy - a.sy;
        int dx_start = (c.sx - a.sx << 14) / tempI;
        int du_start = (cu - au << 12) / tempI;
        int dx_end = 0;
        int du_end = 0;
        boolean dv_end = false;
        if (b.sy != a.sy) {
            tempI = b.sy - a.sy;
            dx_end = (b.sx - a.sx << 14) / tempI;
            du_end = (bu - au << 12) / tempI;
        }
        tempI = b.sy - a.sy;
        int x_start = (a.sx << 14) + dx_start * tempI;
        int u_start = (au << 12) + du_start * tempI;
        int x_end = b.sx << 14;
        int u_end = bu << 12;
        tempI = x_start - x_end >> 14;
        if (tempI == 0) {
            return;
        }
        int du = (u_start - u_end) / tempI;
        x_end = x_start = a.sx << 14;
        u_end = u_start = au << 12;
        int y_start = a.sy;
        int y_end = c.sy < g3d.height ? c.sy : g3d.height;
        int yy = y_start * texWidth;
        int wMove = texWidth - g3d.width;
        if (du > 0) {
            --du;
        }
        if (du < 0) {
            ++du;
        }
        while (y_start < y_end) {
            if (y_start == b.sy) {
                if (c.sy == b.sy) {
                    return;
                }
                tempI = b.sy - a.sy;
                x_start = (a.sx << 14) + dx_start * tempI;
                u_start = (au << 12) + du_start * tempI;
                x_end = b.sx << 14;
                u_end = bu << 12;
                tempI = c.sy - b.sy;
                dx_end = (c.sx - b.sx << 14) / tempI;
                du_end = (cu - bu << 12) / tempI;
            }
            if (y_start >= 0) {
                int x2;
                int u;
                int x1;
                if (x_start > x_end) {
                    x1 = x_end >> 14;
                    u = u_end;
                    x2 = x_start >> 14;
                } else {
                    x1 = x_start >> 14;
                    u = u_start;
                    x2 = x_end >> 14;
                }
                if (x1 < 0) {
                    u -= du * x1;
                    x1 = 0;
                }
                if (x2 > g3d.width) {
                    x2 = g3d.width;
                }
                tempI = g3d.width * y_start;
                x1 += tempI;
                x2 += tempI;
                yy += wMove;
                int tmpu = u >> 12;
                while (x2 - x1 >= 7) {
                    rgb[x1] = tex[(x1 + yy & lengthBIT2) + (tmpu << widthBIT) & lengthBIT3];
                    tmpu = (u += du) >> 12;
                    rgb[++x1] = tex[(x1 + yy & lengthBIT2) + (tmpu << widthBIT) & lengthBIT3];
                    tmpu = (u += du) >> 12;
                    rgb[++x1] = tex[(x1 + yy & lengthBIT2) + (tmpu << widthBIT) & lengthBIT3];
                    tmpu = (u += du) >> 12;
                    rgb[++x1] = tex[(x1 + yy & lengthBIT2) + (tmpu << widthBIT) & lengthBIT3];
                    tmpu = (u += du) >> 12;
                    rgb[++x1] = tex[(x1 + yy & lengthBIT2) + (tmpu << widthBIT) & lengthBIT3];
                    tmpu = (u += du) >> 12;
                    rgb[++x1] = tex[(x1 + yy & lengthBIT2) + (tmpu << widthBIT) & lengthBIT3];
                    tmpu = (u += du) >> 12;
                    rgb[++x1] = tex[(x1 + yy & lengthBIT2) + (tmpu << widthBIT) & lengthBIT3];
                    tmpu = (u += du) >> 12;
                    ++x1;
                }
                while (x1 < x2) {
                    rgb[x1] = tex[(x1 + yy & lengthBIT2) + (tmpu << widthBIT) & lengthBIT3];
                    tmpu = (u += du) >> 12;
                    ++x1;
                }
            }
            ++y_start;
            x_start += dx_start;
            u_start += du_start;
            x_end += dx_end;
            u_end += du_end;
        }
    }

    static final void paint_glass(Graphics3D g3d, Texture texture, Vertex a, int au, int av, Vertex b, int bu, int bv, Vertex c, int cu, int cv, int fogc, int sz2) {
        int y_end;
        int tb;
        Vertex t;
        if (b.sy < a.sy) {
            t = a;
            a = b;
            b = t;
            tb = au;
            au = bu;
            bu = tb;
            tb = av;
            av = bv;
            bv = tb;
        }
        if (c.sy < a.sy) {
            t = c;
            c = a;
            a = t;
            tb = cu;
            cu = au;
            au = tb;
            tb = cv;
            cv = av;
            av = tb;
        }
        if (c.sy < b.sy) {
            t = b;
            b = c;
            c = t;
            tb = bu;
            bu = cu;
            cu = tb;
            tb = bv;
            bv = cv;
            cv = tb;
        }
        if (a.sy == c.sy) {
            return;
        }
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int scale = 50;
        scale = scale * (g3d.getHeight() + g3d.getWidth()) / 560;
        int tempI = c.sy - a.sy;
        int dx_start = (c.sx - a.sx << 14) / tempI;
        int du_start = (cu - au << 12) / tempI;
        int dv_start = (cv - av << 12) / tempI;
        int dx_end = 0;
        int du_end = 0;
        int dv_end = 0;
        if (b.sy != a.sy) {
            tempI = b.sy - a.sy;
            dx_end = (b.sx - a.sx << 14) / tempI;
            du_end = (bu - au << 12) / tempI;
            dv_end = (bv - av << 12) / tempI;
        }
        tempI = b.sy - a.sy;
        int x_start = (a.sx << 14) + dx_start * tempI;
        int u_start = (au << 12) + du_start * tempI;
        int v_start = (av << 12) + dv_start * tempI;
        int x_end = b.sx << 14;
        int u_end = bu << 12;
        int v_end = bv << 12;
        tempI = x_start - x_end >> 14;
        if (tempI == 0) {
            return;
        }
        int du = (u_start - u_end) / tempI;
        int dv = (v_start - v_end) / tempI;
        x_end = x_start = a.sx << 14;
        u_end = u_start = au << 12;
        v_end = v_start = av << 12;
        int y_start = a.sy;
        int n = y_end = c.sy < g3d.height ? c.sy : g3d.height;
        while (y_start < y_end) {
            if (y_start == b.sy) {
                if (c.sy == b.sy) {
                    return;
                }
                tempI = b.sy - a.sy;
                x_start = (a.sx << 14) + dx_start * tempI;
                u_start = (au << 12) + du_start * tempI;
                v_start = (av << 12) + dv_start * tempI;
                x_end = b.sx << 14;
                u_end = bu << 12;
                v_end = bv << 12;
                tempI = c.sy - b.sy;
                dx_end = (c.sx - b.sx << 14) / tempI;
                du_end = (cu - bu << 12) / tempI;
                dv_end = (cv - bv << 12) / tempI;
            }
            if (y_start >= 0) {
                int x2;
                int v;
                int u;
                int x1;
                if (x_start > x_end) {
                    x1 = x_end >> 14;
                    u = u_end;
                    v = v_end;
                    x2 = x_start >> 14;
                } else {
                    x1 = x_start >> 14;
                    u = u_start;
                    v = v_start;
                    x2 = x_end >> 14;
                }
                if (x1 < 0) {
                    u -= du * x1;
                    v -= dv * x1;
                    x1 = 0;
                }
                if (x2 > g3d.width) {
                    x2 = g3d.width;
                }
                tempI = g3d.width * y_start;
                x1 += tempI;
                x2 += tempI;
                u -= du;
                v -= dv;
                while (x1 < x2) {
                    int col = texture.rImg.img[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    int cr = ((col >> 16 & 0xFF) - 128) * scale / 200;
                    int cg = ((col >> 8 & 0xFF) - 128) * scale / 200;
                    int coord = x1 + cr + cg * g3d.getWidth();
                    if (coord >= g3d.getDisplay().length) {
                        coord = g3d.getDisplay().length - 1;
                    }
                    if (coord < 0) {
                        coord = 0;
                    }
                    rgb[x1] = rgb[coord];
                    ++x1;
                }
            }
            ++y_start;
            x_start += dx_start;
            u_start += du_start;
            v_start += dv_start;
            x_end += dx_end;
            u_end += du_end;
            v_end += dv_end;
        }
    }

    static final void paintFill(Graphics3D g3d, Vertex a, Vertex b, Vertex c, Texture texture, int au, int av) {
        int col = texture.rImg.img[(av << texture.widthBIT) + au & texture.rImg.img.length - 1];
        TexturingAffine.paintFill(g3d, a, b, c, col);
    }

    static final void paintFill(Graphics3D g3d, Vertex a, Vertex b, Vertex c, int col) {
        Vertex t;
        if (b.sy < a.sy) {
            t = a;
            a = b;
            b = t;
        }
        if (c.sy < a.sy) {
            t = c;
            c = a;
            a = t;
        }
        if (c.sy < b.sy) {
            t = b;
            b = c;
            c = t;
        }
        if (a.sy == c.sy) {
            return;
        }
        int[] rgb = g3d.display;
        int tempI = c.sy - a.sy;
        int dx_start = (c.sx - a.sx << 14) / tempI;
        int dx_end = 0;
        if (b.sy != a.sy) {
            tempI = b.sy - a.sy;
            dx_end = (b.sx - a.sx << 14) / tempI;
        }
        tempI = b.sy - a.sy;
        int x_start = (a.sx << 14) + dx_start * tempI;
        int x_end = b.sx << 14;
        if ((tempI = x_start - x_end >> 14) == 0) {
            return;
        }
        x_end = x_start = a.sx << 14;
        int y_start = a.sy;
        int y_end = c.sy < g3d.height ? c.sy : g3d.height;
        boolean dxe = false;
        boolean xe = false;
        boolean xs = false;
        TexturingAffine.fastFill(y_start, y_end, x_start, x_end, dx_start, dx_end, a, b, c, g3d, tempI, rgb, col);
    }

    static final void fastFill(int y_start, int y_end, int x_start, int x_end, int dx_start, int dx_end, Vertex a, Vertex b, Vertex c, Graphics3D g3d, int tempI, int[] rgb, int col) {
        while (y_start < y_end) {
            if (y_start == b.sy) {
                if (c.sy == b.sy) {
                    return;
                }
                x_start = (a.sx << 14) + dx_start * (b.sy - a.sy);
                x_end = b.sx << 14;
                dx_end = (c.sx - b.sx << 14) / (c.sy - b.sy);
            }
            if (y_start >= 0) {
                int x2;
                int x1 = x_start > x_end ? x_end >> 14 : x_start >> 14;
                int n = x2 = x_start > x_end ? x_start >> 14 : x_end >> 14;
                if (x1 < 0) {
                    x1 = 0;
                }
                if (x2 > g3d.width) {
                    x2 = g3d.width;
                }
                tempI = g3d.width * y_start;
                x1 += tempI;
                x2 += tempI;
                while (x2 - x1 >= 9) {
                    rgb[x1] = col;
                    rgb[x1 + 1] = col;
                    rgb[x1 + 2] = col;
                    rgb[x1 + 3] = col;
                    rgb[x1 + 4] = col;
                    rgb[x1 + 5] = col;
                    rgb[x1 + 6] = col;
                    rgb[x1 + 7] = col;
                    rgb[x1 + 8] = col;
                    x1 += 9;
                }
                while (x2 - x1 >= 4) {
                    rgb[x1] = col;
                    rgb[x1 + 1] = col;
                    rgb[x1 + 2] = col;
                    rgb[x1 + 3] = col;
                    x1 += 4;
                }
                while (x1 < x2) {
                    rgb[x1] = col;
                    ++x1;
                }
            }
            ++y_start;
            x_start += dx_start;
            x_end += dx_end;
        }
    }

    static final void paintOverwrite(Graphics3D g3d, Vertex a, Vertex b, Vertex c) {
        Vertex t;
        if (b.sy < a.sy) {
            t = a;
            a = b;
            b = t;
        }
        if (c.sy < a.sy) {
            t = c;
            c = a;
            a = t;
        }
        if (c.sy < b.sy) {
            t = b;
            b = c;
            c = t;
        }
        if (a.sy == c.sy) {
            return;
        }
        int[] rgb = g3d.display;
        int tempI = c.sy - a.sy;
        int dx_start = (c.sx - a.sx << 14) / tempI;
        int dx_end = 0;
        if (b.sy != a.sy) {
            tempI = b.sy - a.sy;
            dx_end = (b.sx - a.sx << 14) / tempI;
        }
        tempI = b.sy - a.sy;
        int x_start = (a.sx << 14) + dx_start * tempI;
        int x_end = b.sx << 14;
        if ((tempI = x_start - x_end >> 14) == 0) {
            return;
        }
        x_end = x_start = a.sx << 14;
        int y_start = a.sy;
        int y_end = c.sy < g3d.height ? c.sy : g3d.height;
        boolean dxe = false;
        boolean xe = false;
        boolean xs = false;
        TexturingAffine.fastOverwrite(y_start, y_end, x_start, x_end, dx_start, dx_end, a, b, c, g3d, tempI, rgb);
    }

    static final void fastOverwrite(int y_start, int y_end, int x_start, int x_end, int dx_start, int dx_end, Vertex a, Vertex b, Vertex c, Graphics3D g3d, int tempI, int[] rgb) {
        while (y_start < y_end) {
            if (y_start == b.sy) {
                if (c.sy == b.sy) {
                    return;
                }
                x_start = (a.sx << 14) + dx_start * (b.sy - a.sy);
                x_end = b.sx << 14;
                dx_end = (c.sx - b.sx << 14) / (c.sy - b.sy);
            }
            if (y_start >= 0) {
                int x2;
                int x1 = x_start > x_end ? x_end >> 14 : x_start >> 14;
                int n = x2 = x_start > x_end ? x_start >> 14 : x_end >> 14;
                if (x1 < 0) {
                    x1 = 0;
                }
                if (x2 > g3d.width) {
                    x2 = g3d.width;
                }
                tempI = g3d.width * y_start;
                x1 += tempI;
                x2 += tempI;
                while (x2 - x1 >= 9) {
                    int n2 = x1;
                    rgb[n2] = rgb[n2] + 1;
                    int n3 = x1 + 1;
                    rgb[n3] = rgb[n3] + 1;
                    int n4 = x1 + 2;
                    rgb[n4] = rgb[n4] + 1;
                    int n5 = x1 + 3;
                    rgb[n5] = rgb[n5] + 1;
                    int n6 = x1 + 4;
                    rgb[n6] = rgb[n6] + 1;
                    int n7 = x1 + 5;
                    rgb[n7] = rgb[n7] + 1;
                    int n8 = x1 + 6;
                    rgb[n8] = rgb[n8] + 1;
                    int n9 = x1 + 7;
                    rgb[n9] = rgb[n9] + 1;
                    int n10 = x1 + 8;
                    rgb[n10] = rgb[n10] + 1;
                    x1 += 9;
                }
                while (x2 - x1 >= 4) {
                    int n11 = x1;
                    rgb[n11] = rgb[n11] + 1;
                    int n12 = x1 + 1;
                    rgb[n12] = rgb[n12] + 1;
                    int n13 = x1 + 2;
                    rgb[n13] = rgb[n13] + 1;
                    int n14 = x1 + 3;
                    rgb[n14] = rgb[n14] + 1;
                    x1 += 4;
                }
                while (x1 < x2) {
                    int n15 = x1++;
                    rgb[n15] = rgb[n15] + 1;
                }
            }
            ++y_start;
            x_start += dx_start;
            x_end += dx_end;
        }
    }

    public static int sqr(int x) {
        return x * x;
    }

    private static final int max(int a, int b, int c) {
        if (a == b || b == c) {
            return TexturingAffine.min(a, c);
        }
        if (a == c) {
            return TexturingAffine.min(a, b);
        }
        if (a < b && a < c) {
            return a;
        }
        if (b < a && b < c) {
            return b;
        }
        return c;
    }

    private static final int min(int a, int b) {
        if (a < b) {
            return a;
        }
        return b;
    }
}

