/*
 * Decompiled with CFR 0.152.
 */
package com.HUD;

import com.HUD.Base.ItemList;
import com.HUD.GUIScreen;
import com.HUD.Menu;
import com.Rendering.Meshes.Mesh;
import com.misc.ImageResize;
import com.misc.Main;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class SplashScreen
extends GUIScreen {
    private final Main main;
    private int action;
    private Image[] splash;
    private Image background;
    private ItemList list;
    private final String[] langlist = Mesh.cutOnStrings(Mesh.getStringFromResource("/languages/languages.txt"), ',');
    private long splashBeginTime = -1L;

    public SplashScreen(Main var1) {
        this.main = var1;
        this.setFont(Main.getFont());
        this.onAction(1);
        if (Main.bcks != null) {
            Main.bcks = ImageResize.createImage(Main.bcks, this.getWidth(), Main.bcks.getHeight());
        }
        if (Main.bcks2 != null) {
            Main.bcks2 = ImageResize.createImage(Main.bcks2, this.getWidth(), Main.bcks2.getHeight());
        }
    }

    public final void destroy() {
        super.destroy();
        this.splash = null;
        this.background = null;
    }

    private void onAction(int action) {
        this.action = action;
        if (action == 1) {
            if (this.splashBeginTime != -1L) {
                return;
            }
            this.splash = new Image[Main.splash.length];
            for (int i = 0; i < Main.splash.length; ++i) {
                this.splash[i] = ImageResize.createImage(Main.splash[i], (float)this.getHeight() / 320.0f, (float)this.getHeight() / 320.0f);
            }
            this.splashBeginTime = System.currentTimeMillis();
        } else if (action == 2) {
            this.splash = null;
            this.background = ImageResize.createImage(Main.background_logo, this.getWidth(), this.getHeight());
            String[] langs = new String[this.langlist.length];
            if (langs != null) {
                for (int i = 0; i < langs.length; ++i) {
                    langs[i] = this.langlist[i];
                    if (langs[i] == null) continue;
                    if (Main.settings.getString(langs[i]) != null) {
                        langs[i] = Main.settings.getString2(langs[i]);
                    }
                    if (Main.getGameText().getString(langs[i]) == null) continue;
                    langs[i] = Main.settings.getString2(langs[i]);
                }
            }
            this.list = new ItemList(langs, Main.getFont());
            this.setSoftKeysNames(Main.getGameText().getString2("SELECT"), null);
        } else if (action == 3) {
            this.splash = null;
            if (this.background == null) {
                this.background = ImageResize.createImage(Main.background_logo, this.getWidth(), this.getHeight());
            }
            String[] langs = new String[]{Main.getGameText().getString2("AUDIO") + ":" + Main.getGameText().getString2("ON"), Main.getGameText().getString2("AUDIO") + ":" + Main.getGameText().getString2("OFF")};
            this.list = new ItemList(langs, Main.getFont());
            this.setSoftKeysNames(Main.getGameText().getString2("SELECT"), null);
        }
        this.repaint();
    }

    protected final void paint(Graphics g) {
        if (this.action == 1) {
            g.setColor(0xFFFFFF);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            int splashIndex = (int)(System.currentTimeMillis() - this.splashBeginTime) / 3500;
            if (this.splash != null && this.splash.length > splashIndex) {
                g.drawImage(this.splash[splashIndex], this.getWidth() / 2, this.getHeight() / 2, 3);
            }
            try {
                Thread.sleep(20L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (System.currentTimeMillis() - this.splashBeginTime >= (long)(3500 * this.splash.length)) {
                if (Main.lang == -1) {
                    this.onAction(2);
                } else {
                    this.onAction(3);
                }
            } else {
                this.repaint();
            }
        } else if (this.action == 2) {
            if (this.background != null) {
                g.drawImage(this.background, 0, 0, 0);
            }
            if (this.list != null) {
                this.list.draw(g, 0, 0, this.getWidth(), this.getHeight());
            }
        } else if (this.action == 3) {
            if (this.background != null) {
                g.drawImage(this.background, 0, 0, 0);
            }
            if (this.list != null) {
                this.list.draw(g, 0, 0, this.getWidth(), this.getHeight());
            }
        }
        if (this.action != 1) {
            this.drawSoftKeys(g);
        }
    }

    protected final void onKey2() {
        if (this.action == 2 || this.action == 3) {
            this.list.scrollUp();
            this.repaint();
        }
    }

    protected final void onKey8() {
        if (this.action == 2 || this.action == 3) {
            this.list.scrollDown();
            this.repaint();
        }
    }

    protected final void onKey5() {
        if (this.action == 1) {
            this.splashBeginTime = System.currentTimeMillis() - (long)(3500 * this.splash.length);
        } else if (this.action == 2) {
            String var1 = "/languages/" + this.langlist[this.list.getIndex()].toLowerCase() + ".txt";
            this.main.setLanguage(var1);
            Main.lang = this.list.getIndex();
            this.main.saveSettingToStore();
            this.setFont(Main.getFont());
            this.onAction(3);
        } else if (this.action == 3) {
            boolean mus;
            Main.isSounds = mus = this.list.getIndex() == 0;
            Main.isMusic = mus;
            Main.isFootsteps = mus;
            Main.setCurrent(new Menu(this.main));
            this.destroy();
        }
    }

    protected final void onLeftSoftKey() {
        this.onKey5();
    }

    void reloadScreen() {
        try {
            Thread.sleep(3000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.onAction(3);
    }

    public void sizeChanged(int w, int h) {
        this.background = null;
        this.background = ImageResize.createImage(Main.background_logo, w, h);
    }
}

