/*
 * Decompiled with CFR 0.152.
 */
package com.Gameplay.Map;

import com.Collision.Height;
import com.Collision.Ray;
import com.Gameplay.Map.Light;
import com.Gameplay.Map.Portal;
import com.Gameplay.Map.Room;
import com.Gameplay.Map.RoomObject;
import com.Gameplay.Map.Skybox;
import com.Gameplay.Objects.MeshObject;
import com.HUD.DeveloperMenu;
import com.Math.Matrix;
import com.Math.Vector3D;
import com.Rendering.DirectX7;
import com.Rendering.Texture;
import com.misc.Main;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public final class House {
    private Room[] rooms;
    private Room[][] neighbours;
    private Vector nearRooms = new Vector();
    private final Vector renderedPortals = new Vector();
    private Skybox skybox;
    public int deep = 1;
    private final Vector tVec = new Vector();
    private final Vector tVec2 = new Vector();
    private final Vector tmpObj = new Vector();
    public boolean noPortals = false;

    public House(Room[] rooms, Room[][] neighbours) {
        this.rooms = rooms;
        this.neighbours = neighbours;
        this.deep = 1;
        this.noPortals = false;
    }

    public final void destroy() {
        for (int var1 = 0; var1 < this.rooms.length; ++var1) {
            this.rooms[var1].destroy();
            this.rooms[var1] = null;
        }
        this.rooms = null;
        this.neighbours = null;
        this.nearRooms.removeAllElements();
        this.renderedPortals.removeAllElements();
        this.nearRooms = null;
        if (this.skybox != null) {
            this.skybox.destroy();
            this.skybox = null;
        }
        this.deep = 1;
        this.noPortals = false;
    }

    public final void setTexture(Texture texture) {
        for (int var2 = 0; var2 < this.rooms.length; ++var2) {
            this.rooms[var2].getMesh().setTexture(texture);
        }
    }

    public final void setSkybox(Skybox skybox) {
        this.skybox = skybox;
    }

    public final Skybox getSkybox() {
        return this.skybox;
    }

    public final Room[] getRooms() {
        return this.rooms;
    }

    public final Room[] getNeighbourRooms(int part) {
        return this.neighbours[part];
    }

    private Vector getNearRooms(int part) {
        this.nearRooms.removeAllElements();
        if (part == -1) {
            return this.nearRooms;
        }
        if (this.rooms[part] != null) {
            this.nearRooms.addElement(this.rooms[part]);
        }
        Room[] nei = this.neighbours[part];
        for (int i = 0; i < nei.length; ++i) {
            if (nei[i] == null) continue;
            this.nearRooms.addElement(nei[i]);
        }
        return this.nearRooms;
    }

    public final boolean sphereCast(int part, Vector3D pos, int rad) {
        int i;
        boolean col = false;
        Vector nearRms = this.getNearRooms(part);
        if (nearRms.size() >= 1) {
            for (i = 0; i < nearRms.size(); ++i) {
                Room room = (Room)nearRms.elementAt(i);
                col |= room.sphereCast(pos, rad);
            }
        }
        this.getNearObjects(this.tVec, part);
        if (this.tVec.size() >= 1) {
            for (i = 0; i < this.tVec.size(); ++i) {
                Object obj = this.tVec.elementAt(i);
                if (!(obj instanceof MeshObject)) continue;
                MeshObject point = (MeshObject)obj;
                if (!point.precCol) continue;
                col |= point.sphereCollisionTest(pos, rad);
            }
        }
        return col;
    }

    public final boolean sphereCast(int[] parts, Vector3D pos, int rad) {
        int i;
        this.renderedPortals.removeAllElements();
        boolean col = false;
        for (i = 0; i < parts.length; ++i) {
            int part = parts[i];
            Vector nearRms = this.getNearRooms(part);
            if (nearRms.size() < 1) continue;
            for (int i2 = 0; i2 < nearRms.size(); ++i2) {
                Room room = (Room)nearRms.elementAt(i2);
                if (this.renderedPortals.contains(room)) continue;
                col |= room.sphereCast(pos, rad);
                this.renderedPortals.addElement(room);
            }
        }
        this.getNearObjects(this.tVec, parts[0]);
        if (this.tVec.size() >= 1) {
            for (i = 0; i < this.tVec.size(); ++i) {
                Object obj = this.tVec.elementAt(i);
                if (!(obj instanceof MeshObject)) continue;
                MeshObject point = (MeshObject)obj;
                if (!point.precCol) continue;
                col |= point.sphereCollisionTest(pos, rad);
            }
        }
        return col;
    }

    public final void rayCast(int part, Ray ray, boolean rayIsFromWeapons) {
        int i;
        if (part == -1) {
            return;
        }
        Vector nearRms = this.getNearRooms(part);
        for (i = 0; i < nearRms.size(); ++i) {
            ((Room)nearRms.elementAt(i)).rayCast(ray);
        }
        this.getNearObjects(this.tVec, part);
        for (i = 0; i < this.tVec.size(); ++i) {
            Object obj = this.tVec.elementAt(i);
            if (!(obj instanceof MeshObject)) continue;
            MeshObject point = (MeshObject)obj;
            if (!point.precCol || rayIsFromWeapons && point.ignoreWeaponRayCast) continue;
            point.rayCast(ray);
        }
    }

    public final void rayCastNoObjects(int part, Ray ray) {
        if (part == -1) {
            return;
        }
        Vector nearRms = this.getNearRooms(part);
        for (int i = 0; i < nearRms.size(); ++i) {
            ((Room)nearRms.elementAt(i)).rayCast(ray);
        }
    }

    public void computeHeight(int part, Height height) {
        if (part == -1) {
            return;
        }
        this.rooms[part].computeHeight(height);
        Room[] near = this.neighbours[part];
        for (int i = 0; i < near.length; ++i) {
            if (near[i] == null) continue;
            near[i].computeHeight(height);
        }
    }

    public void computeHeightFull(int part, Height height) {
        if (part == -1) {
            return;
        }
        this.computeHeight(part, height);
        this.getNearObjects(this.tVec, part);
        for (int i = 0; i < this.tVec.size(); ++i) {
            Object obj = this.tVec.elementAt(i);
            if (!(obj instanceof MeshObject)) continue;
            MeshObject point = (MeshObject)obj;
            if (!point.precCol) continue;
            point.computeHeight(height);
        }
    }

    public final void getNearObjects(Vector buf, int part) {
        buf.removeAllElements();
        if (part == -1) {
            return;
        }
        this.rooms[part].getObjects(buf);
        Room[] near = this.neighbours[part];
        for (int i = 0; i < near.length; ++i) {
            if (near[i] == null) continue;
            near[i].getObjects(buf);
        }
    }

    public final Vector getNearObjects(int part) {
        this.tmpObj.removeAllElements();
        if (part == -1) {
            return this.tmpObj;
        }
        this.rooms[part].getObjects(this.tmpObj);
        Room[] near = this.neighbours[part];
        if (near == null) {
            return this.tmpObj;
        }
        for (int i = 0; i < near.length; ++i) {
            if (near[i] == null) continue;
            near[i].getObjects(this.tmpObj);
        }
        return this.tmpObj;
    }

    public final int a_int_sub2(int part, int x, int y, int z) {
        int var5 = Integer.MIN_VALUE;
        Vector var8 = this.getNearRooms(part);
        for (int var6 = 0; var6 < var8.size(); ++var6) {
            int var7 = ((Room)var8.elementAt(var6)).a_int_sub2(x, y, z);
            if (var7 >= y || var7 <= var5) continue;
            var5 = var7;
        }
        return var5;
    }

    public final int a_int_sub(int part, int x, int y, int z) {
        int var5 = Integer.MIN_VALUE;
        Vector var8 = this.getNearRooms(part);
        for (int var6 = 0; var6 < var8.size(); ++var6) {
            if (!((Room)var8.elementAt(var6)).a_int_sub(x, y, z)) continue;
            var5 = ((Room)var8.elementAt(var6)).getId();
        }
        return var5;
    }

    public final int render(Graphics g, DirectX7 g3d, int[] part, int cx, int cz) {
        int x;
        if (this.skybox != null && (this.skybox.draw || this.skybox.skyboxAlways)) {
            this.skybox.render(g, g3d);
            if (!this.skybox.m3gRender) {
                g3d.render();
            }
            this.skybox.resetViewport();
        }
        if (part.length == 0) {
            return 0;
        }
        this.nearRooms.removeAllElements();
        this.renderedPortals.removeAllElements();
        for (x = part.length - 1; x >= 0; --x) {
            if (part[x] == -1) {
                return 0;
            }
            this.render(g3d, this.rooms[part[x]], 0, 0, g3d.getWidth(), g3d.getHeight(), cx, cz, false);
        }
        if (this.nearRooms.size() > 0) {
            for (x = 0; x < this.nearRooms.size(); ++x) {
                ((Room)this.nearRooms.elementAt(x)).render(g3d, cx, cz);
                ((Room)this.nearRooms.elementAt(x)).render(g3d);
            }
        }
        return this.nearRooms.size();
    }

    public final int render(Graphics g, DirectX7 g3d, int part, int cx, int cz) {
        if (this.skybox != null && (this.skybox.draw || this.skybox.skyboxAlways)) {
            this.skybox.render(g, g3d);
            if (!this.skybox.m3gRender) {
                g3d.render();
            }
            this.skybox.resetViewport();
        }
        if (part == -1) {
            return 0;
        }
        this.nearRooms.removeAllElements();
        this.renderedPortals.removeAllElements();
        this.render(g3d, this.rooms[part], 0, 0, g3d.getWidth(), g3d.getHeight(), cx, cz, true);
        for (part = 0; part < this.nearRooms.size(); ++part) {
            ((Room)this.nearRooms.elementAt(part)).render(g3d);
        }
        return this.nearRooms.size();
    }

    private void render(DirectX7 g3d, Room mainRoom, int x1, int y1, int x2, int y2, int cx, int cz, boolean renderPortals) {
        if (mainRoom != null) {
            Portal[] portals;
            mainRoom.setViewport(x1, y1, x2, y2);
            if (renderPortals) {
                mainRoom.render(g3d, cx, cz);
            }
            if (!this.nearRooms.contains(mainRoom)) {
                this.nearRooms.addElement(mainRoom);
            }
            if (mainRoom.isOpenSky() && this.skybox != null) {
                this.skybox.addViewport(x1, y1, x2, y2);
                this.skybox.draw = true;
            }
            if ((portals = mainRoom.getPortals()) == null) {
                return;
            }
            if (portals.length == 0) {
                return;
            }
            for (int var7 = 0; var7 < portals.length; ++var7) {
                Portal portal = portals[var7];
                if (portal.getRoom() != null && this.nearRooms.contains(portal.getRoom()) && !renderPortals && portal.isVisible(g3d, x1, y1, x2, y2)) {
                    portal.getRoom().addViewport(portal.getMinX(), portal.getMaxX(), portal.getMinY(), portal.getMaxY());
                }
                if (this.nearRooms.contains(portal.getRoom()) || !portal.isVisible(g3d, x1, y1, x2, y2)) continue;
                int pMinX = portal.getMinX();
                int pMinY = portal.getMinY();
                int pMaxX = portal.getMaxX();
                int pMaxY = portal.getMaxY();
                if (pMinX < x1) {
                    pMinX = x1;
                }
                if (pMinY < y1) {
                    pMinY = y1;
                }
                if (pMaxX > x2) {
                    pMaxX = x2;
                }
                if (pMaxY > y2) {
                    pMaxY = y2;
                }
                int sizex = pMaxX - pMinX;
                int sizey = pMaxY - pMinY;
                if (sizex < 1 || sizey < 1) continue;
                if (portal.getRoom() != null) {
                    this.renderedPortals.addElement(portal);
                    this.render(g3d, portal.getRoom(), pMinX, pMinY, pMaxX, pMaxY, cx, cz, renderPortals);
                    continue;
                }
                if (!mainRoom.isOpenSky() || this.skybox == null) continue;
                this.skybox.addViewport(pMinX, pMinY, pMaxX, pMaxY);
                this.skybox.draw = true;
            }
        }
    }

    public final Vector getObjects() {
        this.tVec2.removeAllElements();
        for (int i = 0; i < this.rooms.length; ++i) {
            this.rooms[i].getObjects(this.tVec2);
        }
        return this.tVec2;
    }

    public void addObject(RoomObject obj) {
        this.recomputePart(obj);
        if (obj.getPart() == -1) {
            if (DeveloperMenu.debugMode) {
                System.out.println("House: \u041e\u0431\u044a\u0435\u043a\u0442 \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u0432\u043d\u0435 \u043a\u0430\u0440\u0442\u044b \u0438 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d");
                System.out.println(obj.getPosX() + " " + obj.getPosY() + " " + obj.getPosZ());
            }
            return;
        }
    }

    public void removeObject(RoomObject obj) {
        if (obj.getPart() == -1) {
            return;
        }
        this.rooms[obj.getPart()].removeObject(obj);
    }

    public void recomputePart(RoomObject obj) {
        if (!obj.isNeedRecomputePart()) {
            return;
        }
        int x = obj.getPosX();
        int z = obj.getPosZ();
        int y = obj.getPosY();
        int oldPart = obj.getPart();
        int newPart = Main.l2dRoomRendering ? this.calcPartL2D(oldPart, x, y, z) : this.calcPartQuantum(oldPart, x, y, z);
        if (obj.getNewPart() != -1) {
            newPart = obj.getNewPart();
            obj.setNewPart(-1);
        }
        if (newPart == -1) {
            newPart = oldPart;
        }
        if (newPart != -1 && (newPart != oldPart || oldPart == -1)) {
            if (oldPart != -1) {
                this.rooms[oldPart].removeObject(obj);
            }
            this.rooms[newPart].addObject(obj);
            obj.setPart(newPart);
        }
    }

    public int calcPartL2D(int oldPart, int x, int y, int z) {
        if (this.rooms.length == 1) {
            return 0;
        }
        if (oldPart != -1) {
            if (this.rooms[oldPart].isPointOnMesh(x, y, z) != -1) {
                return oldPart;
            }
            Room[] neighbours2 = this.neighbours[oldPart];
            for (int i = 0; i < neighbours2.length; ++i) {
                if (neighbours2[i] == null || neighbours2[i].isPointOnMesh(x, y, z) == -1) continue;
                return neighbours2[i].getId();
            }
        }
        for (int i = 0; i < this.rooms.length; ++i) {
            if (this.rooms[i].isPointOnMesh(x, y, z) == -1) continue;
            return i;
        }
        return -1;
    }

    public int calcPartQuantum(int oldPart, int x, int y, int z) {
        if (this.rooms.length == 1) {
            return 0;
        }
        if (oldPart != -1) {
            if (this.rooms[oldPart].a_int_sub(x, y, z)) {
                return oldPart;
            }
            Room[] neighbours2 = this.neighbours[oldPart];
            for (int i = 0; i < neighbours2.length; ++i) {
                if (neighbours2[i] == null || !neighbours2[i].a_int_sub(x, y, z)) continue;
                return neighbours2[i].getId();
            }
        }
        for (int i = 0; i < this.rooms.length; ++i) {
            if (!this.rooms[i].a_int_sub(x, y, z)) continue;
            return i;
        }
        return -1;
    }

    public static int[] getParts(House house, int part, Matrix cam) {
        Vector<String> parts = new Vector<String>();
        Room[] rooms = house.getRooms();
        int x = cam.m03;
        int y = cam.m13;
        int z = cam.m23;
        for (int i = 0; i < rooms.length; ++i) {
            Room mesh = rooms[i];
            if (x <= mesh.getMinX() || x >= mesh.getMaxX() || z <= mesh.getMinZ() || z >= mesh.getMaxZ() || (!rooms[i].isOpenSky() || y < mesh.getMinY()) && (rooms[i].isOpenSky() || y < mesh.getMinY() || y > mesh.getMaxY())) continue;
            parts.addElement(String.valueOf(i));
        }
        if (parts.indexOf(String.valueOf(part)) == -1) {
            parts.addElement(String.valueOf(part));
        }
        int[] out = new int[parts.size()];
        for (int i = 0; i < parts.size(); ++i) {
            out[i] = Integer.parseInt((String)parts.elementAt(i));
        }
        parts.removeAllElements();
        return out;
    }

    public final int computePart(int oldPart, int x, int y, int z) {
        if (oldPart != -1) {
            Room[] var5;
            if (this.rooms[oldPart].isPointOnMesh(x, y, z) != -1) {
                return oldPart;
            }
            if (oldPart != -1 && (var5 = this.neighbours[oldPart]) != null && var5.length > 0) {
                for (int var4 = 0; var4 < var5.length; ++var4) {
                    if (var5[var4] == null || var5[var4].isPointOnMesh(x, y, z) == -1) continue;
                    return var5[var4].getId();
                }
            }
        }
        for (oldPart = this.rooms.length - 1; oldPart >= 0; --oldPart) {
            if (this.rooms[oldPart] == null || this.rooms[oldPart].isPointOnMesh(x, y, z) == -1) continue;
            return oldPart;
        }
        return -1;
    }

    public boolean isNear(int id1, int id2) {
        if (id1 == -1 || id2 == -1) {
            return false;
        }
        if (id1 == id2) {
            return true;
        }
        if (id1 >= this.neighbours.length) {
            return false;
        }
        Room[] rooms = this.neighbours[id1];
        if (rooms != null) {
            for (int i = 0; i < rooms.length; ++i) {
                Room room = rooms[i];
                if (room == null || room.getId() != id2) continue;
                return true;
            }
        }
        return false;
    }

    public void sortLights(Light[] lights) {
        for (int i = 0; i < lights.length; ++i) {
            if (lights[i].part != -1) continue;
            lights[i].part = this.calcPartQuantum(-1, lights[i].pos.x, lights[i].pos.y, lights[i].pos.z);
        }
        Vector<Light> lits = new Vector<Light>();
        for (int i = 0; i < this.rooms.length; ++i) {
            int x;
            Room room = this.rooms[i];
            if (room == null) continue;
            lits.removeAllElements();
            int id = room.getId();
            for (x = 0; x < lights.length; ++x) {
                if (!this.isNear(id, lights[x].part)) continue;
                lits.addElement(lights[x]);
            }
            if (lits.size() <= 0) continue;
            room.lights = new Light[lits.size()];
            for (x = 0; x < lits.size(); ++x) {
                room.lights[x] = (Light)lits.elementAt(x);
            }
        }
    }
}

