/*
 * Decompiled with CFR 0.152.
 */
package com.Math;

import com.Math.MathUtils;
import com.Math.Vector3D;

public final class Matrix {
    private static final short[] sin = new short[360];
    private static final short[] cos = new short[360];
    public static final int fp = 14;
    public static final int FP = 16384;
    public int m00 = 16384;
    public int m01 = 0;
    public int m02 = 0;
    public int m03 = 0;
    public int m10 = 0;
    public int m11 = 16384;
    public int m12 = 0;
    public int m13 = 0;
    public int m20 = 0;
    public int m21 = 0;
    public int m22 = 16384;
    public int m23 = 0;
    public int m30 = 0;
    public int m31 = 0;
    public int m32 = 0;
    public int m33 = 16384;

    public final void setIdentity() {
        this.m00 = 16384;
        this.m01 = 0;
        this.m02 = 0;
        this.m03 = 0;
        this.m10 = 0;
        this.m11 = 16384;
        this.m12 = 0;
        this.m13 = 0;
        this.m20 = 0;
        this.m21 = 0;
        this.m22 = 16384;
        this.m23 = 0;
    }

    public final void set(Matrix m) {
        this.m00 = m.m00;
        this.m01 = m.m01;
        this.m02 = m.m02;
        this.m03 = m.m03;
        this.m10 = m.m10;
        this.m11 = m.m11;
        this.m12 = m.m12;
        this.m13 = m.m13;
        this.m20 = m.m20;
        this.m21 = m.m21;
        this.m22 = m.m22;
        this.m23 = m.m23;
    }

    public final void set(int mm00, int mm01, int mm02, int mm03, int mm10, int mm11, int mm12, int mm13, int mm20, int mm21, int mm22, int mm23) {
        this.m00 = mm00;
        this.m01 = mm01;
        this.m02 = mm02;
        this.m03 = mm03;
        this.m10 = mm10;
        this.m11 = mm11;
        this.m12 = mm12;
        this.m13 = mm13;
        this.m20 = mm20;
        this.m21 = mm21;
        this.m22 = mm22;
        this.m23 = mm23;
    }

    public void getPosition(Vector3D v) {
        v.set(this.m03, this.m13, this.m23);
    }

    public final void invert() {
        long var1 = ((long)this.m00 * (long)this.m03 >> 14) + ((long)this.m10 * (long)this.m13 >> 14) + ((long)this.m20 * (long)this.m23 >> 14);
        long var3 = ((long)this.m01 * (long)this.m03 >> 14) + ((long)this.m11 * (long)this.m13 >> 14) + ((long)this.m21 * (long)this.m23 >> 14);
        long var5 = ((long)this.m02 * (long)this.m03 >> 14) + ((long)this.m12 * (long)this.m13 >> 14) + ((long)this.m22 * (long)this.m23 >> 14);
        this.m03 = (int)(-var1);
        this.m13 = (int)(-var3);
        this.m23 = (int)(-var5);
        int var7 = this.m01;
        this.m01 = this.m10;
        this.m10 = var7;
        var7 = this.m02;
        this.m02 = this.m20;
        this.m20 = var7;
        var7 = this.m12;
        this.m12 = this.m21;
        this.m21 = var7;
    }

    private static int fixDegree(int degree) {
        while (degree < 0) {
            degree += 360;
        }
        while (degree >= 360) {
            degree -= 360;
        }
        return degree;
    }

    public final void setRotX(int degree) {
        degree = Matrix.fixDegree(degree);
        this.m00 = 16384;
        this.m01 = 0;
        this.m02 = 0;
        this.m03 = 0;
        this.m10 = 0;
        this.m11 = cos[degree];
        this.m12 = -sin[degree];
        this.m13 = 0;
        this.m20 = 0;
        this.m21 = sin[degree];
        this.m22 = cos[degree];
        this.m23 = 0;
    }

    public final void mul(Matrix m) {
        this.mul(this, m);
    }

    public final void mul(Matrix m2, Matrix m1) {
        long t00 = (long)(m2.m00 * m1.m00 + m2.m01 * m1.m10 + m2.m02 * m1.m20) + (long)m2.m03 * (long)m1.m30 >> 14;
        long t01 = (long)(m2.m00 * m1.m01 + m2.m01 * m1.m11 + m2.m02 * m1.m21) + (long)m2.m03 * (long)m1.m31 >> 14;
        long t02 = (long)(m2.m00 * m1.m02 + m2.m01 * m1.m12 + m2.m02 * m1.m22) + (long)m2.m03 * (long)m1.m32 >> 14;
        long t03 = (long)m2.m00 * (long)m1.m03 + (long)m2.m01 * (long)m1.m13 + (long)m2.m02 * (long)m1.m23 + (long)m2.m03 * (long)m1.m33 >> 14;
        long t10 = (long)(m2.m10 * m1.m00 + m2.m11 * m1.m10 + m2.m12 * m1.m20) + (long)m2.m13 * (long)m1.m30 >> 14;
        long t11 = (long)(m2.m10 * m1.m01 + m2.m11 * m1.m11 + m2.m12 * m1.m21) + (long)m2.m13 * (long)m1.m31 >> 14;
        long t12 = (long)(m2.m10 * m1.m02 + m2.m11 * m1.m12 + m2.m12 * m1.m22) + (long)m2.m13 * (long)m1.m32 >> 14;
        long t13 = (long)m2.m10 * (long)m1.m03 + (long)m2.m11 * (long)m1.m13 + (long)m2.m12 * (long)m1.m23 + (long)m2.m13 * (long)m1.m33 >> 14;
        long t20 = (long)(m2.m20 * m1.m00 + m2.m21 * m1.m10 + m2.m22 * m1.m20) + (long)m2.m23 * (long)m1.m30 >> 14;
        long t21 = (long)(m2.m20 * m1.m01 + m2.m21 * m1.m11 + m2.m22 * m1.m21) + (long)m2.m23 * (long)m1.m31 >> 14;
        long t22 = (long)(m2.m20 * m1.m02 + m2.m21 * m1.m12 + m2.m22 * m1.m22) + (long)m2.m23 * (long)m1.m32 >> 14;
        long t23 = (long)m2.m20 * (long)m1.m03 + (long)m2.m21 * (long)m1.m13 + (long)m2.m22 * (long)m1.m23 + (long)m2.m23 * (long)m1.m33 >> 14;
        this.m00 = (int)t00;
        this.m01 = (int)t01;
        this.m02 = (int)t02;
        this.m03 = (int)t03;
        this.m10 = (int)t10;
        this.m11 = (int)t11;
        this.m12 = (int)t12;
        this.m13 = (int)t13;
        this.m20 = (int)t20;
        this.m21 = (int)t21;
        this.m22 = (int)t22;
        this.m23 = (int)t23;
    }

    public void rotY(int degree) {
        degree = Matrix.fixDegree(degree);
        short c = cos[degree];
        short s = sin[degree];
        int xX = this.m00 * c + this.m20 * s >> 14;
        int xY = this.m01 * c + this.m21 * s >> 14;
        int xZ = this.m02 * c + this.m22 * s >> 14;
        int zX = this.m20 * c - this.m00 * s >> 14;
        int zY = this.m21 * c - this.m01 * s >> 14;
        int zZ = this.m22 * c - this.m02 * s >> 14;
        this.m00 = xX;
        this.m01 = xY;
        this.m02 = xZ;
        this.m20 = zX;
        this.m21 = zY;
        this.m22 = zZ;
    }

    public void setRotY(int degree) {
        degree = Matrix.fixDegree(degree);
        this.m00 = cos[degree];
        this.m01 = 0;
        this.m02 = sin[degree];
        this.m03 = 0;
        this.m10 = 0;
        this.m11 = 16384;
        this.m12 = 0;
        this.m13 = 0;
        this.m20 = -sin[degree];
        this.m21 = 0;
        this.m22 = cos[degree];
        this.m23 = 0;
    }

    public void setRotZ(int degree) {
        degree = Matrix.fixDegree(degree);
        this.m00 = cos[degree];
        this.m01 = -sin[degree];
        this.m02 = 0;
        this.m03 = 0;
        this.m10 = sin[degree];
        this.m11 = cos[degree];
        this.m12 = 0;
        this.m13 = 0;
        this.m20 = 0;
        this.m21 = 0;
        this.m22 = 16384;
        this.m23 = 0;
    }

    public void rotZ(int degree) {
        degree = Matrix.fixDegree(degree);
        short c = cos[degree];
        short s = sin[degree];
        int yX = this.m10 * c + this.m00 * s >> 14;
        int yY = this.m11 * c + this.m01 * s >> 14;
        int yZ = this.m12 * c + this.m02 * s >> 14;
        int xX = this.m00 * c - this.m10 * s >> 14;
        int xY = this.m01 * c - this.m11 * s >> 14;
        int xZ = this.m02 * c - this.m12 * s >> 14;
        this.m10 = yX;
        this.m11 = yY;
        this.m12 = yZ;
        this.m00 = xX;
        this.m01 = xY;
        this.m02 = xZ;
    }

    public final void setPosition(int x, int y, int z) {
        this.m03 = x;
        this.m13 = y;
        this.m23 = z;
    }

    public final void setPosition(Vector3D pos) {
        this.m03 = pos.x;
        this.m13 = pos.y;
        this.m23 = pos.z;
    }

    public final void addPosition(Vector3D pos) {
        this.m03 += pos.x;
        this.m13 += pos.y;
        this.m23 += pos.z;
    }

    public final void divPosition(int x, int y, int z) {
        this.m03 /= x;
        this.m13 /= y;
        this.m23 /= z;
    }

    public final void subPosition(int x, int y, int z) {
        this.m03 -= x;
        this.m13 -= y;
        this.m23 -= z;
    }

    public final void addPosition(int x, int y, int z) {
        this.m03 += x;
        this.m13 += y;
        this.m23 += z;
    }

    public final void setSide(int x, int y, int z) {
        this.m00 = x;
        this.m10 = y;
        this.m20 = z;
    }

    public final void scale(int x, int y, int z) {
        this.m00 = this.m00 * x >> 14;
        this.m10 = this.m10 * x >> 14;
        this.m20 = this.m20 * x >> 14;
        this.m01 = this.m01 * y >> 14;
        this.m11 = this.m11 * y >> 14;
        this.m21 = this.m21 * y >> 14;
        this.m02 = this.m02 * z >> 14;
        this.m12 = this.m12 * z >> 14;
        this.m22 = this.m22 * z >> 14;
    }

    public final void setUp(int x, int y, int z) {
        this.m01 = x;
        this.m11 = y;
        this.m21 = z;
    }

    public final void setDir(int x, int y, int z) {
        this.m02 = x;
        this.m12 = y;
        this.m22 = z;
    }

    public void translate(int x, int y, int z) {
        if (x != 0) {
            this.m03 += this.m00 * x >> 14;
            this.m13 += this.m10 * x >> 14;
            this.m23 += this.m20 * x >> 14;
        }
        if (y != 0) {
            this.m03 += this.m01 * y >> 14;
            this.m13 += this.m11 * y >> 14;
            this.m23 += this.m21 * y >> 14;
        }
        if (z != 0) {
            this.m03 += this.m02 * z >> 14;
            this.m13 += this.m12 * z >> 14;
            this.m23 += this.m22 * z >> 14;
        }
    }

    public static int cos(int deg) {
        while (deg < 0) {
            deg += 360;
        }
        return cos[deg % 360];
    }

    public static int sin(int deg) {
        while (deg < 0) {
            deg += 360;
        }
        return sin[deg % 360];
    }

    public int getRotZ() {
        int rt = MathUtils.getAnglez(0, 0, -this.m02, -this.m22);
        rt = MathUtils.fixDegree(rt);
        return rt;
    }

    public int getRotZHQ() {
        int rt = MathUtils.getAnglezHQ(0, 0, -this.m02, -this.m22);
        return rt;
    }

    static {
        for (int var0 = 0; var0 < 360; ++var0) {
            Matrix.sin[var0] = (short)(Math.sin(Math.toRadians(var0)) * 16384.0);
            Matrix.cos[var0] = (short)(Math.cos(Math.toRadians(var0)) * 16384.0);
        }
    }
}

