/*
 * Decompiled with CFR 0.152.
 */
package com.AI;

import com.AI.Bot;
import com.Gameplay.Map.House;
import com.Gameplay.Map.Portal;
import com.Gameplay.Map.Scene;
import com.Gameplay.Objects.GameObject;
import com.Math.Matrix;
import com.Math.Vector3D;
import com.Rendering.DirectX7;
import com.Rendering.Fps;
import com.Rendering.Meshes.BoundingBox;
import com.Rendering.Meshes.MeshImage;
import com.misc.Main;
import java.util.Vector;

public final class BigZombie
extends Bot {
    public static byte fallDeath = 1;
    public static boolean bloodHas = true;
    public static int max_hp = 400;
    private static Fps fps;
    private static Main main;
    public static int model_height;
    private static BoundingBox boundingBox;
    public static int[] attack;
    private int state = -1;
    public MeshImage meshImage;
    private GameObject enemy = null;
    private boolean notCol = false;
    private final Vector3D dir = new Vector3D();

    public BigZombie(Vector3D pos) {
        if (Main.bigzombiemod != null) {
            this.meshImage = new MeshImage(Main.bigzombiemod.getMesh(), Main.bigzombiemod.getAnimation());
            boundingBox = new BoundingBox(Main.bigzombiemod.getAnimation());
        }
        this.name = "BIG_ZOMBIE";
        this.getCharacter().getTransform().setIdentity();
        this.set(pos);
        this.fraction = 2;
        this.deathFall = fallDeath;
        this.hasBlood = bloodHas;
    }

    public final void set(Vector3D pos) {
        super.set(pos);
        this.setHp(max_hp);
        this.setCharacterSize(model_height);
        this.dir.set(pos.x, pos.y, pos.z + 50);
        this.lookAt(pos.x, pos.z + 50);
        this.notCol = false;
    }

    public final void destroy() {
        super.destroy();
        this.enemy = null;
        this.meshImage = null;
    }

    public final void render(DirectX7 g3d, int x1, int y1, int x2, int y2) {
        if (!this.visible) {
            return;
        }
        Matrix mat = this.getCharacter().getTransform();
        Matrix finalMatrix = g3d.computeFinalMatrix(mat);
        if (!boundingBox.isVisible(g3d, finalMatrix, x1, y1, x2, y2)) {
            return;
        }
        if (mat.m11 == 16384) {
            if (this.state == 1) {
                this.meshImage.setFrame(this.getFrameInter() * Main.bigzombieanimspeed / 100);
            }
            if (this.state == 2) {
                this.meshImage.setFrame(this.getFrameInter() * Main.bigzombieattackanimspeed / 100);
            }
        }
        this.meshImage.setMatrix(finalMatrix);
        this.meshImage.setTexture(Main.bigzombietex);
        g3d.addRenderObject(this.meshImage, x1, y1, x2, y2);
        this.meshImage.sz += this.character.getRadius();
        if (this.character.oldFloorPoly != null && this.character.oldFloorPoly.sz > this.meshImage.sz) {
            this.character.oldFloorPoly.sz = this.meshImage.sz - 1;
        }
        this.renderBlood(g3d, 1500);
    }

    protected final void action(Scene scene) {
        if (Math.abs(this.getFrameInterDiv()) % Main.bigzombiereacttimer == 1) {
            House house = scene.getHouse();
            Vector objects = house.getObjects();
            if (this.enemy != null && this.enemy.isDead() || this.enemy != null && Fps.nFrame == 0) {
                this.enemy = null;
            }
            this.enemy = this.findBot(objects, this, attack);
            if (this.enemy != null) {
                Vector3D walkTo = this.dir;
                if (this.notCollided(house, this.enemy) && scene.getHouse().isNear(this.getPart(), this.enemy.getPart())) {
                    Matrix mat = this.enemy.getCharacter().getTransform();
                    walkTo.set(mat.m03, mat.m13, mat.m23);
                    this.notCol = true;
                } else {
                    int nextPart = scene.getNext(this.getPart(), this.enemy.getPart());
                    Portal portal = BigZombie.commonPortal(house, this.getPart(), nextPart);
                    if (portal != null) {
                        BigZombie.computeCentre(portal, walkTo);
                    }
                    this.notCol = false;
                }
                if (this.dir.x != 0 && this.dir.z != 0) {
                    this.lookAt(this.dir.x, this.dir.z);
                }
                long distance = this.character.distance(this.enemy.getCharacter());
                if (this.notCol && (float)distance <= (float)BigZombie.sqr(this.character.getRadius() + this.enemy.getCharacter().getRadius()) * Main.bigzombieattackradius) {
                    this.state = Main.bigzombieplayerreaction;
                } else {
                    if (this.character.isCollision() && !this.notCol) {
                        this.character.jump(Main.bigzombiejumpheight, Main.bigzombiejumpspeed);
                    }
                    if (distance > BigZombie.sqr(this.character.getRadius() * 11)) {
                        this.character.jump(Main.bigzombiejumpheight2, Main.bigzombiejumpspeed2);
                    }
                    this.state = Main.bigzombieai;
                }
            } else {
                this.state = -1;
            }
        }
        if (this.state == 1) {
            this.moveZ(Main.bigzombiespeed);
        }
        if (this.state == Main.bigzombieattacktrigger && this.getFrameInterDiv() % Main.bigzombieattacktimer == 0 && this.notCol) {
            this.enemy.damage(this, Main.bigzombiedamage);
        }
    }

    static {
        model_height = 2000;
    }
}

