/*
 * Decompiled with CFR 0.152.
 */
package com.HUD.Base;

import com.HUD.Base.Font;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public final class Text {
    public Vector lines = new Vector();
    private Font font;
    private int wSpace;
    public int hSpace;
    private int width;
    public int height;
    private boolean centreAlign = false;
    private int y;

    public Text(String str, int wSpace, int hSpace, int width, int height, Font font) {
        this.font = font;
        this.wSpace = wSpace;
        this.hSpace = hSpace;
        this.width = width;
        this.height = height;
        str = Text.deleteCR(str);
        this.fillLines(str, this.lines);
        this.y = 0;
    }

    public int lineHeight() {
        return this.font.height() + 3;
    }

    private static String deleteCR(String str) {
        StringBuffer var2 = new StringBuffer(str);
        int var1 = 0;
        while (var1 < var2.length()) {
            if (var2.charAt(var1) == '\r') {
                var2.deleteCharAt(var1);
                continue;
            }
            ++var1;
        }
        return var2.toString();
    }

    private void fillLines(String txt, Vector lines) {
        int wordWidth = 0;
        int wordStart = 0;
        int lastSpace = -1;
        for (int i = 0; i < txt.length(); ++i) {
            char ch = txt.charAt(i);
            if (ch == ' ') {
                lastSpace = i;
            }
            int wordEnd = -1;
            if (ch == '\n') {
                wordEnd = i++;
            } else if (wordWidth + this.font.charWidth(ch) > this.width) {
                if (lastSpace != -1) {
                    i = lastSpace + 1;
                    wordEnd = lastSpace;
                    lastSpace = -1;
                } else {
                    wordEnd = i;
                }
            }
            if (wordEnd != -1) {
                String line = "";
                if (wordStart != -1 && wordStart <= wordEnd) {
                    line = txt.substring(wordStart, wordEnd);
                }
                lines.addElement(line);
                lastSpace = -1;
                wordWidth = 0;
                wordStart = i;
                continue;
            }
            wordWidth += this.font.charWidth(ch);
        }
        if (wordStart < txt.length()) {
            lines.addElement(txt.substring(wordStart, txt.length()));
        }
    }

    public final void draw(Graphics g) {
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        g.setClip(Math.max(clipX, this.wSpace), Math.max(clipY, this.hSpace), Math.min(clipWidth, this.width), Math.min(clipHeight, this.height));
        int stepY = this.lineHeight();
        int posY = this.y;
        for (int i = 0; i < this.lines.size(); ++i) {
            if (posY + stepY >= 0) {
                int posX;
                if (posY > this.height) break;
                String str = (String)this.lines.elementAt(i);
                posX = this.centreAlign ? (posX = this.width - this.font.widthOf(str) >> 1) : 0;
                this.font.drawString(g, str, posX + this.wSpace, posY + this.hSpace, 0);
            }
            posY += stepY;
        }
        g.setClip(clipX, clipY, clipWidth, clipHeight);
    }

    public final void move(int dy) {
        this.y += dy;
        int textHeight = this.lineHeight() * this.lines.size() - 3;
        if (textHeight > this.height) {
            if (this.y > 0) {
                this.y = 0;
            }
            if (this.y + textHeight < this.height) {
                this.y = this.height - textHeight;
            }
        } else if (this.y < 0) {
            this.y = 0;
        }
        if (textHeight + this.y < this.height && this.y > 0) {
            this.y = 0;
        }
    }

    public final void setY(int dy) {
        this.y = dy;
        int textHeight = this.lineHeight() * this.lines.size() - 3;
        if (textHeight > this.height) {
            if (this.y > 0) {
                this.y = 0;
            }
            if (this.y + textHeight < this.height) {
                this.y = this.height - textHeight;
            }
        } else if (this.y < 0) {
            this.y = 0;
        }
        if (textHeight + this.y < this.height && this.y > 0) {
            this.y = 0;
        }
    }

    public final int getY() {
        return this.y;
    }

    public final void setCentreAlign(boolean flag) {
        this.centreAlign = true;
    }
}

