/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Transform;

public final class cParticleSystem {
    private cParticle[] mParts = new cParticle[20];
    private short mSysPartCount = 0;
    public short mType = 0;
    public int mOrigX = 0;
    public int mOrigY = 0;
    public int mOrigZ = 0;
    public int mLOrigX = 0;
    public int mLOrigY = 0;
    public int mLOrigZ = 0;
    public int mNewEmitX = 0;
    public int mNewEmitY = 0;
    public int mNewEmitZ = 0;
    public int mOldEmitX = 0;
    public int mOldEmitY = 0;
    public int mOldEmitZ = 0;
    public short mDirYaw = (short)1024;
    public short mDirPitch = 0;
    public short mDirRoll = 0;
    public short mLDirYaw = (short)1024;
    public short mLDirPitch = 0;
    public short mMinPartsPerPeriod;
    public short mMaxPartsPerPeriod;
    public short mFramesPeriod;
    public short mInactivePeriod;
    private short mPartsGenerated = 0;
    private short mParts_To_GenOnThisFrame = 0;
    private short mPartsGenOnThisFrame = 0;
    private boolean canGenMore = false;
    private short currentContor = 0;
    public short mFxCount = 1;
    public short mCurrFxID = 0;
    public cFxObj[] mFxObj = null;
    public Image mImagePNG = null;
    public Transform mTrans = new Transform();
    public static float[] mMatrix = new float[16];
    public boolean mStopGenerate = false;
    public boolean mAliveParticles = false;
    public int[] mColors = null;
    public static int[][] propPS = new int[][]{{3, 3, 6, 4, 6, 5, 6, 1, 1, 1, 0}, {1, 6, -1, 3, 4, 3, 2}, {1, 1, 4, 7, 10, 3, 0}, {1, 7, -1, 3, 4, 3, 0}, {1, 6, -1, 3, 4, 3, 2}};

    public cParticleSystem(int type) {
        int i;
        boolean offset = false;
        switch (type) {
            case 1: {
                this.mColors = new int[2];
                this.mColors[0] = -256;
                this.mColors[1] = -14848;
                break;
            }
            case 2: {
                this.mImagePNG = cGame.smokePNG;
                break;
            }
            case 3: {
                this.mColors = new int[2];
                break;
            }
            case 4: {
                this.mColors = new int[2];
                this.mColors[0] = -256;
                this.mColors[1] = -14848;
            }
        }
        for (i = 0; i < this.mParts.length; ++i) {
            this.mParts[i] = new cParticle();
        }
        this.mFxCount = (short)propPS[type][0];
        this.mFxObj = new cFxObj[this.mFxCount];
        for (i = 0; i < this.mFxCount; ++i) {
            this.mFxObj[i] = new cFxObj(propPS[type][1 + i * 2 + 0], propPS[type][1 + i * 2 + 1]);
        }
        int var4 = 1 + this.mFxCount * 2;
        this.mMinPartsPerPeriod = (short)propPS[type][var4 + 0];
        this.mMaxPartsPerPeriod = (short)propPS[type][var4 + 1];
        this.mFramesPeriod = (short)propPS[type][var4 + 2];
        this.mInactivePeriod = (short)propPS[type][var4 + 3];
        this.mType = (short)type;
    }

    public final void unload() {
        int i;
        this.mImagePNG = null;
        this.mColors = null;
        for (i = 0; i < this.mParts.length; ++i) {
            this.mParts[i] = null;
        }
        this.mParts = null;
        for (i = 0; i < this.mFxCount; ++i) {
            this.mFxObj[i].unload();
            this.mFxObj[i] = null;
        }
        this.mFxObj = null;
    }

    public final void setDirection(int dirYaw, int dirPitch, int dirRoll, int lDirYaw, int lDirPitch) {
        this.mDirYaw = (short)dirYaw;
        this.mDirPitch = (short)dirPitch;
        this.mDirRoll = (short)dirRoll;
        this.mLDirYaw = (short)lDirYaw;
        this.mLDirPitch = (short)lDirPitch;
    }

    public final void setOrigin(int x, int y, int z, int lx, int ly, int lz) {
        this.mOrigX = x;
        this.mOrigY = y;
        this.mOrigZ = z;
        this.mLOrigX = lx;
        this.mLOrigY = ly;
        this.mLOrigZ = lz;
    }

    public final void setColor(int colIdx, int alpha, int red, int green, int blue) {
        this.mColors[colIdx] = (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }

    private void calculateGlobalPos() {
        this.mTrans.setIdentity();
        this.mTrans.postTranslate((float)this.mOrigX, (float)this.mOrigY, (float)this.mOrigZ);
        if (this.mDirYaw != 0) {
            this.mTrans.postRotate((float)this.mDirYaw / 11.37f, 0.0f, 0.0f, 1.0f);
        }
        if (this.mDirPitch != 0) {
            this.mTrans.postRotate((float)(-this.mDirPitch) / 11.37f, 0.0f, 1.0f, 0.0f);
        }
        if (this.mDirRoll != 0) {
            this.mTrans.postRotate((float)this.mDirRoll / 11.37f, 1.0f, 0.0f, 0.0f);
        }
        this.mTrans.postTranslate((float)this.mLOrigX, (float)this.mLOrigY, (float)this.mLOrigZ);
        if (this.mType == 2) {
            this.mOldEmitX = this.mNewEmitX;
            this.mOldEmitY = this.mNewEmitY;
            this.mOldEmitZ = this.mNewEmitZ;
            this.mTrans.get(mMatrix);
            this.mNewEmitX = (int)mMatrix[3];
            this.mNewEmitY = (int)mMatrix[7];
            this.mNewEmitZ = (int)mMatrix[11];
        }
    }

    public final void emit() {
        this.systemUpdate();
        for (int i = 0; i < this.mSysPartCount; ++i) {
            this.updateParticle(this.mParts[i]);
        }
    }

    public final void render(Graphics3D g3d) {
        if (this.mAliveParticles) {
            for (int i = 0; i < this.mSysPartCount; ++i) {
                if (!this.mParts[i].mActive) continue;
                this.renderParticle(this.mParts[i], g3d);
            }
        }
    }

    public final void systemInit(int partCount) {
        this.mSysPartCount = (short)partCount;
        for (int i = 0; i < this.mParts.length; ++i) {
            cParticleSystem.resetParticle(this.mParts[i]);
        }
        this.currentContor = 0;
        this.canGenMore = false;
        this.currentContor = 0;
        this.mPartsGenerated = 0;
        this.mAliveParticles = false;
    }

    private void systemUpdate() {
        int frame = this.currentContor & this.mFramesPeriod;
        this.mPartsGenOnThisFrame = 0;
        this.mParts_To_GenOnThisFrame = 0;
        if (!this.mStopGenerate) {
            if (frame >= this.mInactivePeriod) {
                int remainPartsForThisPeriod;
                if (frame == this.mInactivePeriod) {
                    this.mPartsGenerated = 0;
                    this.canGenMore = true;
                }
                if ((remainPartsForThisPeriod = this.mMaxPartsPerPeriod - this.mPartsGenerated) > 0) {
                    this.canGenMore = true;
                    this.mParts_To_GenOnThisFrame = (short)cMath.rand(0, remainPartsForThisPeriod);
                    if (frame == this.mFramesPeriod && this.mPartsGenerated < this.mMinPartsPerPeriod) {
                        this.mParts_To_GenOnThisFrame = (short)(this.mMinPartsPerPeriod - this.mPartsGenerated);
                    }
                }
            }
        } else {
            this.canGenMore = false;
        }
        if (this.canGenMore || this.mAliveParticles) {
            this.calculateGlobalPos();
        }
        this.currentContor = (short)(this.currentContor + 1);
        this.mAliveParticles = false;
    }

    private void initParticle(cParticle p) {
        block7: {
            int var10003;
            int var10002;
            int var10001;
            cParticle var10000;
            int vel;
            p.mLife = (short)64;
            switch (this.mType) {
                case 0: {
                    p.setPos(0, 0, 0);
                    p.mDegradation = (short)6;
                    break block7;
                }
                case 1: {
                    p.setPos(0, 0, 10 - cMath.rand(0, 20));
                    vel = cMath.rand(20, 25);
                    p.setVel(vel, this.mLDirYaw + 128 - cMath.rand(0, 256), this.mLDirPitch + 256 - cMath.rand(0, 512));
                    var10000 = p;
                    var10001 = cMath.rand(0, 1);
                    var10002 = 0;
                    var10003 = 2048 - cMath.rand(0, 1024);
                    break;
                }
                case 2: {
                    int scale;
                    p.setPos(this.mNewEmitX, this.mNewEmitY, this.mNewEmitZ);
                    int vel2 = cMath.rand(3, 8);
                    p.setVel(vel2, this.mLDirYaw + this.mDirYaw, this.mLDirPitch + this.mDirPitch);
                    p.setAcc(cMath.rand(0, 1), 0, 1024);
                    p.mDegradation = (short)vel2;
                    p.mScaleX = scale = cMath.rand(1, 3) * 4096;
                    p.mScaleY = scale;
                    p.mScaleZ = scale;
                    break block7;
                }
                case 3: {
                    p.setPos(0, 200 - cMath.rand(0, 400), cMath.rand(0, 200));
                    vel = cMath.rand(20, 25);
                    p.setVel(vel, this.mLDirYaw, this.mLDirPitch);
                    var10000 = p;
                    var10001 = 0;
                    var10002 = 0;
                    var10003 = 0;
                    break;
                }
                case 4: {
                    p.setPos(0, 0, 10 - cMath.rand(0, 20));
                    vel = cMath.rand(20, 25);
                    p.setVel(vel, this.mLDirYaw + 128 - cMath.rand(0, 256), this.mLDirPitch + 256 - cMath.rand(0, 512));
                    var10000 = p;
                    var10001 = cMath.rand(0, 1);
                    var10002 = 0;
                    var10003 = 2048 - cMath.rand(0, 1024);
                    break;
                }
                default: {
                    break block7;
                }
            }
            var10000.setAcc(var10001, var10002, var10003);
            p.mDegradation = (short)(vel >> 1);
            p.mScaleX = 4096;
            p.mScaleY = cMath.rand(3, 4) * 4096;
            p.mScaleZ = 4096;
            p.mColor = this.mColors[cMath.rand(0, 8) >> 2];
        }
        p.mAnimationFrame = 0;
        p.mActive = true;
    }

    private void updateParticle(cParticle p) {
        p.mLife = (short)(p.mLife - p.mDegradation);
        if (p.mLife < 0) {
            cParticleSystem.resetParticle(p);
            if (this.mPartsGenOnThisFrame >= this.mParts_To_GenOnThisFrame || this.mPartsGenerated >= this.mMaxPartsPerPeriod) {
                this.canGenMore = false;
            }
            if (this.canGenMore) {
                this.mAliveParticles = true;
                this.initParticle(p);
                this.mPartsGenerated = (short)(this.mPartsGenerated + 1);
                this.mPartsGenOnThisFrame = (short)(this.mPartsGenOnThisFrame + 1);
                return;
            }
        } else {
            this.mAliveParticles = true;
            this.computeParticle(p);
        }
    }

    private void renderParticle(cParticle p, Graphics3D g3d) {
        block9: {
            cFxObj fxObj;
            block10: {
                float var10004;
                float var10003;
                float var10002;
                float var10001;
                Transform var10000;
                if (!p.mActive) break block9;
                fxObj = this.mFxObj[this.mCurrFxID];
                switch (this.mType) {
                    case 0: {
                        this.mTrans.get(mMatrix);
                        fxObj.mModelTrans.setIdentity();
                        fxObj.mModelTrans.postTranslate(mMatrix[3] / PLATFORM.mCoord2JsrDivider, mMatrix[7] / PLATFORM.mCoord2JsrDivider, mMatrix[11] / PLATFORM.mCoord2JsrDivider);
                        int dirX = cGame.s_camX - (int)mMatrix[3];
                        int dirY = cGame.s_camY - (int)mMatrix[7];
                        int roll = cMath.angleZeroTo2PI(cMath.angleZeroTo2PI(this.mDirYaw + this.mLDirYaw) + 4096 - cMath.atan2(dirX, dirY));
                        fxObj.mModelTrans.postRotate((float)(this.mDirYaw + this.mLDirYaw) / 11.37f, 0.0f, 0.0f, 1.0f);
                        fxObj.mModelTrans.postRotate(90.06157f, 0.0f, 1.0f, 0.0f);
                        if (roll != 0) {
                            fxObj.mModelTrans.postRotate((float)roll / 11.37f, 0.0f, 0.0f, 1.0f);
                        }
                        fxObj.renderAnim(g3d, 0, p.mAnimationFrame);
                        return;
                    }
                    case 1: 
                    case 4: {
                        fxObj.mModelTrans.set(this.mTrans);
                        fxObj.mModelTrans.postTranslate((float)p.mX, (float)p.mY, (float)p.mZ);
                        fxObj.mModelTrans.get(mMatrix);
                        fxObj.mModelTrans.setIdentity();
                        fxObj.mModelTrans.postTranslate(mMatrix[3] / PLATFORM.mCoord2JsrDivider, mMatrix[7] / PLATFORM.mCoord2JsrDivider, mMatrix[11] / PLATFORM.mCoord2JsrDivider);
                        var10000 = fxObj.mModelTrans;
                        var10001 = (float)(this.mDirYaw + p.mVelYaw - 1024) / 11.37f;
                        var10002 = 0.0f;
                        var10003 = 0.0f;
                        var10004 = 1.0f;
                        break;
                    }
                    case 2: {
                        cMath.getScrCoorFrom3D(cGame.s_camNearView, cGame.s_camW, cGame.s_camH, cGame.s_camViewportW, cGame.s_camViewportH, cGame.s_camViewX, cGame.s_camViewY, cGame.s_camViewZ, cGame.s_camUpX, cGame.s_camUpY, cGame.s_camUpZ, cGame.s_camRightX, cGame.s_camRightY, cGame.s_camRightZ, cGame.s_camX, cGame.s_camY, cGame.s_camZ, p.mX, p.mY, p.mZ);
                        if (this.mImagePNG != null) {
                            cGame.s_g.drawRegion(this.mImagePNG, (p.mAnimationFrame & 1) * 32, (p.mAnimationFrame >> 1) * 32, 32, 32, 0, (cGame.s_screenWidth >> 1) + cMath.s_viewportX, cGame.s_interfaceTop + (cGame.s_viewportHeight >> 1) - cMath.s_viewportY, 3);
                            return;
                        }
                        return;
                    }
                    case 3: {
                        fxObj.mModelTrans.set(this.mTrans);
                        fxObj.mModelTrans.postTranslate((float)p.mX, (float)p.mY, (float)p.mZ);
                        fxObj.mModelTrans.get(mMatrix);
                        fxObj.mModelTrans.setIdentity();
                        fxObj.mModelTrans.postTranslate(mMatrix[3] / PLATFORM.mCoord2JsrDivider, mMatrix[7] / PLATFORM.mCoord2JsrDivider, mMatrix[11] / PLATFORM.mCoord2JsrDivider);
                        int dirX = cGame.s_camX - (int)mMatrix[3];
                        int dirY = cGame.s_camY - (int)mMatrix[7];
                        int roll = cMath.angleZeroTo2PI(cMath.angleZeroTo2PI(this.mDirYaw + p.mVelYaw) + 4096 - cMath.atan2(dirX, dirY));
                        fxObj.mModelTrans.postRotate((float)(this.mDirYaw + p.mVelYaw - 1024) / 11.37f, 0.0f, 0.0f, 1.0f);
                        if (roll != 0) {
                            var10000 = fxObj.mModelTrans;
                            var10001 = (float)(-roll) / 11.37f;
                            var10002 = 0.0f;
                            var10003 = 1.0f;
                            var10004 = 0.0f;
                            break;
                        }
                        break block10;
                    }
                    default: {
                        return;
                    }
                }
                var10000.postRotate(var10001, var10002, var10003, var10004);
            }
            fxObj.mModelTrans.postScale((float)p.mScaleX / 4096.0f, (float)p.mScaleY / 4096.0f, (float)p.mScaleZ / 4096.0f);
            fxObj.mFxMesh.setVtxBuffColor(p.mColor);
            fxObj.render(g3d);
        }
    }

    private static void resetParticle(cParticle p) {
        p.mActive = false;
    }

    private void computeParticle(cParticle p) {
        int var10003;
        int var10002;
        short var10001;
        block6: {
            cParticle var10000;
            int scale1;
            boolean scale = false;
            switch (this.mType) {
                case 0: {
                    p.mAnimationFrame = (short)(4 * (64 - p.mLife) >> 6);
                    return;
                }
                case 1: 
                case 4: {
                    scale1 = ((this.mType == 4 ? 81920 : 69632) - p.mScaleY) * (64 - p.mLife) >> 6;
                    var10000 = p;
                    break;
                }
                case 2: {
                    int scale12;
                    p.mScaleX = scale12 = p.mScaleX + ((12288 - p.mScaleX) * (64 - p.mLife) >> 6);
                    p.mScaleY = scale12;
                    p.mScaleZ = scale12;
                    p.mAnimationFrame = (short)(3 * (64 - p.mLife) >> 6);
                    p.mVelX += p.mAccX;
                    p.mVelY += p.mAccY;
                    p.mVelZ += p.mAccZ;
                    p.mX += p.mVelX >> 12;
                    p.mY += p.mVelY >> 12;
                    p.mZ = (short)(p.mZ + (p.mVelZ >> 12));
                    p.mX += 7 * (this.mNewEmitX - this.mOldEmitX) >> 3;
                    p.mY += 7 * (this.mNewEmitY - this.mOldEmitY) >> 3;
                    var10000 = p;
                    var10001 = p.mZ;
                    var10002 = 7 * (this.mNewEmitZ - this.mOldEmitZ);
                    var10003 = 3;
                    break block6;
                }
                case 3: {
                    scale1 = (57344 - p.mScaleY) * (64 - p.mLife) >> 6;
                    var10000 = p;
                    break;
                }
                default: {
                    return;
                }
            }
            var10000.mScaleX = 4096;
            p.mScaleY += scale1;
            p.mScaleZ = 4096;
            p.mVelX += p.mAccX;
            p.mVelY += p.mAccY;
            p.mVelZ += p.mAccZ;
            p.mX += p.mVelX >> 12;
            p.mY += p.mVelY >> 12;
            var10000 = p;
            var10001 = p.mZ;
            var10002 = p.mVelZ;
            var10003 = 12;
        }
        var10000.mZ = (short)(var10001 + (var10002 >> var10003));
    }
}

