/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.CompositingMode;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Material;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.PolygonMode;
import javax.microedition.m3g.Sprite3D;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;

final class cRoad {
    static final String[] s_skyFiles = new String[]{"beach_sky", "beach", "", "chinatown_sky", "chinatown", "", "industrial_sky", "industrial", "", "downtown_sky", "downtown", "", "latino_sky", "latino", ""};
    static short[] s_sectionCount;
    static short[][] s_sections;
    static short s_sectionWidth;
    static short s_sectionSideWidth;
    static byte s_sectionSteer;
    static short s_sectionPull;
    static int s_numberOfIntersections;
    static cIntersection[] s_intersections;
    static int[] s_mapWorldMinX;
    static int[] s_mapWorldMaxX;
    static int[] s_mapWorldMaxY;
    static int s_numberOfRoads;
    static int s_currentSpline;
    static int s_currentIntersection;
    static int s_currentTriangle;
    static short s_numberOfDrifts;
    static byte[] s_driftRoads;
    static short[] s_driftStartSeg;
    static short[] s_driftEndSeg;
    static boolean[] s_availableRoads;
    static short[][] s_roadIntersection;
    static int[] s_vtxCount;
    static int[][] s_vtx;
    static int[][] s_dist;
    static int[] s_roadLength;
    static IndexBuffer[][][] s_roadIdxBuffer;
    static VertexBuffer[][] s_roadVtxBuffer;
    static Appearance s_roadAppearance;
    static cTexture s_roadTexture;
    static PolygonMode s_roadPolygonMode;
    static Transform[] s_roadTransforms;
    static short[][] s_roadYaws;
    static int s_currentSection;
    static int s_currentSectionWidth;
    static int s_currentSideWidth;
    static int s_currentSegment;
    static int s_closestLight;
    static short[][] s_segmentsList;
    static short[] s_objectList;
    static short s_ObjectsInList;
    static boolean[] s_roadsInRenderList;
    static short[] s_IntersectionsRenderList;
    static VertexBuffer[][][] s_fenceVtxBuffer;
    static IndexBuffer[][] s_fenceIdxBuffer;
    static PolygonMode[] s_fencePolygonMode;
    static cTexture s_fenceTexture;
    static Appearance s_fenceAppearance;
    static Transform s_fenceTransform;
    static int s_skyColor;
    static int s_groundColor;
    static cMesh s_raceMarker;
    static cMesh s_raceEnd;
    static cMesh s_roadBlock;
    static cMesh s_roadBlockLeft;
    static cMesh s_roadBlockRight;
    static cMesh s_jumpPlatform;
    static cMesh s_roadObstacle;
    static cAnimObject s_animTexObject;
    static cNeon s_neon;
    static cNOS s_nos;
    static int[][] s_roadObstacleCoords;
    static byte[] s_roadObstaclesHitFrames;
    static short[] s_roadObstaclesSpeedYaw;
    static int s_numberOfRoadBlocks;
    static int s_lastRoadObstacleIndex;
    static int s_objectCount;
    static cObject[] s_objects;
    static short[] s_objectTypes;
    static short[] s_objectRoadsCount;
    static short[] s_objectRoadsNumber;
    static short[] s_objectVertexIdx;
    static cFxObj s_whiteLight;
    static cFxObj s_redLight;
    static ASprite s_skyLayer1;
    static int s_skyLayer1Width;
    static int s_skyLayer1Height;
    static int s_skyLayer1GlobalRange;
    static ASprite s_skyLayer2;
    static int s_skyLayer2Width;
    static int s_skyLayer2Height;
    static int s_skyLayer2GlobalRange;
    static int s_skyAltitudeZeroScrY;
    static int off;
    static byte s_numberOfRaces;
    static byte[] s_raceType;
    static byte[] s_raceNumberOfEnemyes;
    static byte[] s_raceNrOfLaps;
    static byte[] s_raceStartRoad;
    static short[] s_raceStartSegment;
    static byte[] s_raceEndRoad;
    static short[] s_raceEndSegment;
    static byte[] s_raceNrCheckPoints;
    static byte[][] s_raceRoadCheckPoints;
    static short[][] s_raceSegmentCheckPoints;
    static byte[] s_raceNrObjects;
    static byte[][] s_raceObjectsRoad;
    static short[][] s_raceObjectsSegment;
    static byte[][] s_raceObjectsLane;
    static byte[] s_raceNrHelperPoints;
    static byte[][] s_raceRoadHelperPoints;
    static byte[] s_raceTime;
    static byte[] s_racePoints;
    static byte[] s_raceBonusNr;
    static byte[][] s_raceBonusRoad;
    static short[][] s_raceBonusSegment;
    static byte[][] s_raceBonusLane;
    static byte[][] s_raceBonusType;
    static byte[] s_tempRoadData;
    static int[][] s_jumpPlatformCoords;
    static int s_lastJumpPlatform;
    static int s_carTargetZ;
    static boolean s_bCarIsLanding;
    static final int[] s_barriersNumber;
    static byte[] s_jumpSucceeded;
    static int s_drawnObjects;
    static int s_drawRoadSegments;
    static int s_drawRoadFences;
    static short[] s_sectionsToRender;
    static int s_rotationAngle;
    public static Image2D s_skyImage2DLayer1;
    public static Image2D s_skyImage2DLayer2;
    public static Image2D s_skyBgImage2D;
    static Sprite3D s_skySPR3DLayer1;
    static Sprite3D s_skySPR3DLayer2;
    static Transform s_skyTransform;
    static int roadIdx;
    static short[][] s_nextRoadsList;

    cRoad() {
    }

    static boolean loadRoadGeometry(byte[] roadData) {
        cRoad.loadRoadGeometry(roadData, cGame.s_currentTrack, true);
        return true;
    }

    static boolean loadRoadGeometry(byte[] roadData, int trackIdx, boolean createIntersections) {
        try {
            int nrSplines;
            int j;
            int i;
            s_numberOfRoads = (roadData[off++] & 0xFF) + ((roadData[off++] & 0xFF) << 8);
            s_availableRoads = new boolean[s_numberOfRoads];
            s_roadTransforms = new Transform[s_numberOfRoads];
            s_sections = new short[s_numberOfRoads][];
            s_sectionCount = new short[s_numberOfRoads];
            s_roadsInRenderList = new boolean[s_numberOfRoads];
            s_IntersectionsRenderList = new short[2];
            for (i = 0; i < s_numberOfRoads; ++i) {
                cRoad.s_sectionCount[i] = (short)((roadData[off++] & 0xFF) + ((roadData[off++] & 0xFF) << 8));
                cRoad.s_sections[i] = new short[s_sectionCount[i]];
                for (j = 0; j < s_sectionCount[i]; ++j) {
                    cRoad.s_sections[i][j] = (short)((roadData[off++] & 0xFF) + ((roadData[off++] & 0xFF) << 8));
                }
            }
            s_sectionWidth = (short)3400;
            s_sectionSideWidth = (short)100;
            s_currentSectionWidth = s_sectionWidth;
            s_currentSideWidth = s_sectionSideWidth;
            s_currentSpline = 0;
            s_vtxCount = new int[s_numberOfRoads];
            s_vtx = new int[s_numberOfRoads][];
            s_dist = new int[s_numberOfRoads][];
            s_roadLength = new int[s_numberOfRoads];
            s_roadYaws = new short[s_numberOfRoads][];
            s_roadIntersection = new short[s_numberOfRoads][2];
            for (i = 0; i < s_numberOfRoads; ++i) {
                cRoad.s_roadIntersection[i][0] = -1;
                cRoad.s_roadIntersection[i][1] = -1;
            }
            if (s_roadVtxBuffer == null) {
                s_roadVtxBuffer = new VertexBuffer[cGame.k_cityCount][];
            }
            if (s_roadIdxBuffer == null) {
                s_roadIdxBuffer = new IndexBuffer[cGame.k_cityCount][][];
            }
            if (s_roadIdxBuffer[trackIdx] == null) {
                cRoad.s_roadIdxBuffer[trackIdx] = new IndexBuffer[s_numberOfRoads][];
                for (i = 0; i < s_numberOfRoads; ++i) {
                    cRoad.s_roadIdxBuffer[trackIdx][i] = new IndexBuffer[s_sectionCount[i]];
                }
            }
            if (s_roadVtxBuffer[trackIdx] == null) {
                cRoad.s_roadVtxBuffer[trackIdx] = new VertexBuffer[s_numberOfRoads];
            }
            for (nrSplines = 0; nrSplines < s_numberOfRoads; ++nrSplines) {
                cRoad.s_vtxCount[nrSplines] = (roadData[off++] & 0xFF) + ((roadData[off++] & 0xFF) << 8);
                cRoad.s_vtx[nrSplines] = new int[3 * s_vtxCount[nrSplines] * 2];
                cRoad.s_dist[nrSplines] = new int[s_vtxCount[nrSplines] * 2];
                for (i = 0; i < s_vtxCount[nrSplines] * 2; ++i) {
                    int var10003;
                    int var10002;
                    int var10001;
                    int[] var10000;
                    cRoad.s_dist[nrSplines][i] = (short)((roadData[off++] & 0xFF) + ((roadData[off++] & 0xFF) << 8));
                    if (i >= 2) {
                        int[] nArray = s_dist[nrSplines];
                        int n = i;
                        nArray[n] = nArray[n] + s_dist[nrSplines][i - 2];
                    }
                    if (i % 2 == 0) {
                        cRoad.s_vtx[nrSplines][i * 3 + 0] = (roadData[off++] & 0xFF) + ((roadData[off++] & 0xFF) << 8) + ((roadData[off++] & 0xFF) << 16) + ((roadData[off++] & 0xFF) << 24);
                        cRoad.s_vtx[nrSplines][i * 3 + 1] = (roadData[off++] & 0xFF) + ((roadData[off++] & 0xFF) << 8) + ((roadData[off++] & 0xFF) << 16) + ((roadData[off++] & 0xFF) << 24);
                        var10000 = s_vtx[nrSplines];
                        var10001 = i * 3 + 2;
                        var10002 = roadData[off++] & 0xFF;
                        var10003 = (roadData[off++] & 0xFF) << 8;
                    } else {
                        short spline = (short)((roadData[off++] & 0xFF) + ((roadData[off++] & 0xFF) << 8));
                        short xc = (short)((roadData[off++] & 0xFF) + ((roadData[off++] & 0xFF) << 8));
                        int yc = (roadData[off++] & 0xFF) + ((roadData[off++] & 0xFF) << 8);
                        cRoad.s_vtx[nrSplines][i * 3 + 0] = s_vtx[nrSplines][(i - 1) * 3 + 0] + spline;
                        cRoad.s_vtx[nrSplines][i * 3 + 1] = s_vtx[nrSplines][(i - 1) * 3 + 1] + xc;
                        var10000 = s_vtx[nrSplines];
                        var10001 = i * 3 + 2;
                        var10002 = s_vtx[nrSplines][(i - 1) * 3 + 2];
                        var10003 = yc;
                    }
                    var10000[var10001] = var10002 + var10003;
                }
                cRoad.s_roadYaws[nrSplines] = new short[s_vtxCount[nrSplines]];
                for (i = 0; i < s_vtxCount[nrSplines]; ++i) {
                    cRoad.s_roadYaws[nrSplines][i] = (short)((roadData[off++] & 0xFF) + ((roadData[off++] & 0xFF) << 8));
                    cRoad.s_roadYaws[nrSplines][i] = (short)cMath.addAngle(s_roadYaws[nrSplines][i], 1024);
                }
                cRoad.s_roadYaws[nrSplines][0] = s_roadYaws[nrSplines][1];
                short[] var16 = new short[3 * s_vtxCount[nrSplines] * 2];
                VertexArray var18 = new VertexArray(var16.length / 3, 3, 2);
                VertexArray var20 = new VertexArray(var16.length / 3, 2, 2);
                for (int vertexes = 0; vertexes < var16.length; ++vertexes) {
                    var16[vertexes] = (short)((s_vtx[nrSplines][vertexes] - s_vtx[nrSplines][vertexes % 3]) / 8);
                }
                var18.set(0, var16.length / 3, var16);
                if (s_roadVtxBuffer[trackIdx][nrSplines] == null) {
                    cRoad.s_roadVtxBuffer[trackIdx][nrSplines] = new VertexBuffer();
                    s_roadVtxBuffer[trackIdx][nrSplines].setPositions(var18, 8.0f / PLATFORM.mCoord2JsrDivider, (float[])null);
                }
                if (s_roadTransforms[nrSplines] == null) {
                    cRoad.s_roadTransforms[nrSplines] = new Transform();
                    s_roadTransforms[nrSplines].postTranslate((float)s_vtx[nrSplines][0] / PLATFORM.mCoord2JsrDivider, (float)s_vtx[nrSplines][1] / PLATFORM.mCoord2JsrDivider, (float)s_vtx[nrSplines][2] / PLATFORM.mCoord2JsrDivider);
                }
                short[] var22 = new short[s_vtxCount[nrSplines] * 2 * 2];
                int v = 0;
                for (i = 0; i < s_vtxCount[nrSplines]; ++i) {
                    int var24;
                    int u = 0;
                    for (j = 0; j < 2; ++j) {
                        var22[(i * 2 + j) * 2 + 0] = (short)u;
                        var22[(i * 2 + j) * 2 + 1] = (short)v;
                        u += 128;
                    }
                    if (i >= s_vtxCount[nrSplines] - 2) {
                        var24 = v >> 7 << 7;
                    } else {
                        int d = s_dist[nrSplines][i * 2 + 2] - s_dist[nrSplines][i * 2];
                        var24 = v + d / 2;
                    }
                    v = var24;
                }
                s_roadVtxBuffer[trackIdx][nrSplines].setTexCoords(0, var20, 0.0078125f, (float[])null);
                var20.set(0, var22.length / 2, var22);
                cRoad.s_roadLength[nrSplines] = s_dist[nrSplines][s_dist[nrSplines].length - 1];
                cRoad.createIndexes(nrSplines, trackIdx);
            }
            if (createIntersections) {
                s_numberOfIntersections = (roadData[off++] & 0xFF) + ((roadData[off++] & 0xFF) << 8);
                s_intersections = new cIntersection[s_numberOfIntersections];
                for (i = 0; i < s_numberOfIntersections; ++i) {
                    nrSplines = (roadData[off++] & 0xFF) + ((roadData[off++] & 0xFF) << 8);
                    int[] var17 = new int[nrSplines];
                    int[] var23 = new int[6 * nrSplines];
                    for (j = 0; j < nrSplines; ++j) {
                        var17[j] = (roadData[off++] & 0xFF) + ((roadData[off++] & 0xFF) << 8);
                        cRoad.s_roadIntersection[var17[j]][(short)(roadData[cRoad.off++] & 0xFF)] = (short)i;
                    }
                    int var19 = (roadData[off++] & 0xFF) + ((roadData[off++] & 0xFF) << 8) + ((roadData[off++] & 0xFF) << 16) + ((roadData[off++] & 0xFF) << 24);
                    int var21 = (roadData[off++] & 0xFF) + ((roadData[off++] & 0xFF) << 8) + ((roadData[off++] & 0xFF) << 16) + ((roadData[off++] & 0xFF) << 24);
                    for (j = 0; j < var23.length; ++j) {
                        var23[j] = (roadData[off++] & 0xFF) + ((roadData[off++] & 0xFF) << 8) + ((roadData[off++] & 0xFF) << 16) + ((roadData[off++] & 0xFF) << 24);
                    }
                    cRoad.s_intersections[i] = new cIntersection(var17, nrSplines, var23, var23.length, var19, var21, i);
                }
            }
            cGame.Call_System_GC(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    static void loadTrackTexture(int texIndex) {
        int var10001;
        PolygonMode var10000;
        s_roadTexture = new cTexture();
        s_roadAppearance = new Appearance();
        s_roadTexture = cTexture.getTexture(1, texIndex, false, false, 241, 241, false, false);
        if (PLATFORM.bUseExplicitTriangleStrip) {
            var10000 = s_roadPolygonMode;
            var10001 = 160;
        } else {
            var10000 = s_roadPolygonMode;
            var10001 = 162;
        }
        var10000.setCulling(var10001);
        s_roadPolygonMode.setPerspectiveCorrectionEnable(true);
        s_roadAppearance.setPolygonMode(s_roadPolygonMode);
        s_roadAppearance.setTexture(0, cRoad.s_roadTexture.mTexture);
    }

    private static void createIndexes(int k, int trackIdx) {
        int[] stripLen = new int[1];
        int prevStart = 0;
        for (int i = 0; i < s_sectionCount[k]; ++i) {
            int var10002;
            int var10001;
            int[] var10000;
            if (i == s_sectionCount[k] - 1) {
                var10000 = stripLen;
                var10001 = 0;
                var10002 = s_vtxCount[k] - s_sections[k][i];
            } else {
                var10000 = stripLen;
                var10001 = 0;
                var10002 = s_sections[k][i + 1] - s_sections[k][i] + 1;
            }
            var10000[var10001] = var10002 * 2;
            cRoad.s_roadIdxBuffer[trackIdx][k][i] = new TriangleStripArray(prevStart, stripLen);
            prevStart += stripLen[0] - 2;
        }
    }

    static void loadRaces(byte[] roadData) {
        int i;
        if ((s_numberOfDrifts = (short)((roadData[off++] & 0xFF) + ((roadData[off++] & 0xFF) << 8) + 1)) > 0) {
            s_driftRoads = new byte[s_numberOfDrifts];
            s_driftStartSeg = new short[s_numberOfDrifts];
            s_driftEndSeg = new short[s_numberOfDrifts];
            for (i = 0; i < s_numberOfDrifts; ++i) {
                cRoad.s_driftRoads[i] = (byte)(roadData[off++] & 0xFF);
                cRoad.s_driftStartSeg[i] = (short)((roadData[off++] & 0xFF) + ((roadData[off++] & 0xFF) << 8));
                cRoad.s_driftEndSeg[i] = (short)((roadData[off++] & 0xFF) + ((roadData[off++] & 0xFF) << 8));
            }
        }
        if ((s_numberOfRaces = (byte)((roadData[off++] & 0xFF) + 1)) > 0) {
            s_raceType = new byte[s_numberOfRaces];
            s_raceNumberOfEnemyes = new byte[s_numberOfRaces];
            s_raceNrOfLaps = new byte[s_numberOfRaces];
            s_raceStartRoad = new byte[s_numberOfRaces];
            s_raceStartSegment = new short[s_numberOfRaces];
            s_raceEndRoad = new byte[s_numberOfRaces];
            s_raceEndSegment = new short[s_numberOfRaces];
            s_raceNrCheckPoints = new byte[s_numberOfRaces];
            s_raceNrHelperPoints = new byte[s_numberOfRaces];
            s_raceNrObjects = new byte[s_numberOfRaces];
            s_raceRoadCheckPoints = new byte[s_numberOfRaces][];
            s_raceSegmentCheckPoints = new short[s_numberOfRaces][];
            s_raceRoadHelperPoints = new byte[s_numberOfRaces][];
            s_raceObjectsRoad = new byte[s_numberOfRaces][];
            s_raceObjectsSegment = new short[s_numberOfRaces][];
            s_raceObjectsLane = new byte[s_numberOfRaces][];
            s_raceTime = new byte[s_numberOfRaces];
            s_racePoints = new byte[s_numberOfRaces];
            s_raceBonusNr = new byte[s_numberOfRaces];
            s_raceBonusRoad = new byte[s_numberOfRaces][];
            s_raceBonusSegment = new short[s_numberOfRaces][];
            s_raceBonusLane = new byte[s_numberOfRaces][];
            s_raceBonusType = new byte[s_numberOfRaces][];
        }
        for (i = 0; i < s_numberOfRaces; ++i) {
            int j;
            cRoad.s_raceType[i] = (byte)(roadData[off++] & 0xFF);
            cRoad.s_raceNumberOfEnemyes[i] = (byte)(roadData[off++] & 0xFF);
            cRoad.s_raceNrOfLaps[i] = (byte)(roadData[off++] & 0xFF);
            cRoad.s_raceStartRoad[i] = (byte)(roadData[off++] & 0xFF);
            cRoad.s_raceStartSegment[i] = (short)((roadData[off++] & 0xFF) + ((roadData[off++] & 0xFF) << 8));
            cRoad.s_raceEndRoad[i] = (byte)(roadData[off++] & 0xFF);
            cRoad.s_raceEndSegment[i] = (short)((roadData[off++] & 0xFF) + ((roadData[off++] & 0xFF) << 8));
            cRoad.s_raceNrCheckPoints[i] = (byte)((roadData[off++] & 0xFF) + 1);
            if (s_raceNrCheckPoints[i] > 0) {
                cRoad.s_raceRoadCheckPoints[i] = new byte[s_raceNrCheckPoints[i]];
                cRoad.s_raceSegmentCheckPoints[i] = new short[s_raceNrCheckPoints[i]];
            }
            for (j = 0; j < s_raceNrCheckPoints[i]; ++j) {
                cRoad.s_raceRoadCheckPoints[i][j] = (byte)(roadData[off++] & 0xFF);
                cRoad.s_raceSegmentCheckPoints[i][j] = (short)((roadData[off++] & 0xFF) + ((roadData[off++] & 0xFF) << 8));
            }
            cRoad.s_raceNrObjects[i] = (byte)((roadData[off++] & 0xFF) + 1);
            if (s_raceNrObjects[i] > 0) {
                cRoad.s_raceObjectsRoad[i] = new byte[s_raceNrObjects[i]];
                cRoad.s_raceObjectsSegment[i] = new short[s_raceNrObjects[i]];
                cRoad.s_raceObjectsLane[i] = new byte[s_raceNrObjects[i]];
            }
            for (j = 0; j < s_raceNrObjects[i]; ++j) {
                cRoad.s_raceObjectsRoad[i][j] = (byte)(roadData[off++] & 0xFF);
                cRoad.s_raceObjectsSegment[i][j] = (short)((roadData[off++] & 0xFF) + ((roadData[off++] & 0xFF) << 8));
                cRoad.s_raceObjectsLane[i][j] = (byte)(roadData[off++] & 0xFF);
            }
            cRoad.s_raceNrHelperPoints[i] = (byte)((roadData[off++] & 0xFF) + 1);
            if (s_raceNrHelperPoints[i] > 0) {
                cRoad.s_raceRoadHelperPoints[i] = new byte[s_raceNrHelperPoints[i]];
            }
            for (j = 0; j < s_raceNrHelperPoints[i]; ++j) {
                cRoad.s_raceRoadHelperPoints[i][j] = (byte)(roadData[off++] & 0xFF);
            }
            cRoad.s_raceTime[i] = (byte)(roadData[off++] & 0xFF);
            cRoad.s_racePoints[i] = (byte)(roadData[off++] & 0xFF);
            cRoad.s_raceBonusNr[i] = (byte)((roadData[off++] & 0xFF) + 1);
            if (s_raceBonusNr[i] <= 0) continue;
            cRoad.s_raceBonusRoad[i] = new byte[s_raceBonusNr[i]];
            cRoad.s_raceBonusSegment[i] = new short[s_raceBonusNr[i]];
            cRoad.s_raceBonusLane[i] = new byte[s_raceBonusNr[i]];
            cRoad.s_raceBonusType[i] = new byte[s_raceBonusNr[i]];
            for (j = 0; j < s_raceBonusNr[i]; ++j) {
                cRoad.s_raceBonusRoad[i][j] = (byte)(roadData[off++] & 0xFF);
                cRoad.s_raceBonusSegment[i][j] = (short)((roadData[off++] & 0xFF) + ((roadData[off++] & 0xFF) << 8));
                cRoad.s_raceBonusType[i][j] = (byte)(roadData[off++] & 0xFF);
                cRoad.s_raceBonusLane[i][j] = (byte)(roadData[off++] & 0xFF);
            }
        }
    }

    static void loadObjects(byte[] roadData) {
        int meshId;
        int i;
        s_segmentsList = new short[5][3];
        s_objectList = new short[120];
        s_objectCount = (roadData[off++] & 0xFF) + ((roadData[off++] & 0xFF) << 8);
        s_objects = new cObject[s_objectCount];
        s_objectTypes = new short[s_objectCount];
        s_objectRoadsCount = new short[s_objectCount];
        s_objectRoadsNumber = new short[s_objectCount * 2];
        s_objectVertexIdx = new short[s_objectCount * 2];
        for (i = 0; i < s_objectCount; ++i) {
            cMesh var10002;
            int var10001;
            cObject[] var10000;
            int lib = roadData[off++] & 0xFF;
            cRoad.s_objectTypes[i] = (short)((roadData[off++] & 0xFF) + ((roadData[off++] & 0xFF) << 8));
            if (lib <= PLATFORM.mRoadMaxLayer) {
                var10000 = s_objects;
                var10001 = i;
                var10002 = new cMesh();
            } else {
                var10000 = s_objects;
                var10001 = i;
                var10002 = null;
            }
            var10000[var10001] = var10002;
            meshId = (roadData[off++] & 0xFF) + ((roadData[off++] & 0xFF) << 8) + ((roadData[off++] & 0xFF) << 16) + ((roadData[off++] & 0xFF) << 24);
            int data = (roadData[off++] & 0xFF) + ((roadData[off++] & 0xFF) << 8) + ((roadData[off++] & 0xFF) << 16) + ((roadData[off++] & 0xFF) << 24);
            ++off;
            ++off;
            short rz = (short)((roadData[off++] & 0xFF) + ((roadData[off++] & 0xFF) << 8));
            short angle = (short)((roadData[off++] & 0xFF) + ((roadData[off++] & 0xFF) << 8));
            if (s_objects[i] != null) {
                s_objects[i].setTransform(meshId, data, 0, angle, 0, 0, rz);
            }
            cRoad.s_objectRoadsCount[i] = (short)((roadData[off++] & 0xFF) + ((roadData[off++] & 0xFF) << 8));
            for (int j = 0; j < s_objectRoadsCount[i]; ++j) {
                cRoad.s_objectRoadsNumber[2 * i + j] = (short)((roadData[off++] & 0xFF) + ((roadData[off++] & 0xFF) << 8));
                ++off;
                ++off;
                cRoad.s_objectVertexIdx[2 * i + j] = (short)((roadData[off++] & 0xFF) + ((roadData[off++] & 0xFF) << 8));
            }
        }
        String var11 = null;
        for (i = 0; i < s_objectCount; ++i) {
            if (s_objects[i] == null) continue;
            meshId = s_objectTypes[i] - 1;
            String var12 = cMesh.getLib(meshId);
            if (var12 != var11) {
                cGame.Lib_Open(var12, true);
                var11 = var12;
            }
            byte[] data1 = cGame.Lib_GetData(meshId, false);
            s_objects[i].load(s_objectTypes[i] - 1, data1);
        }
        cGame.Lib_UnBindData();
        cGame.Lib_Close();
        cGame.Lib_Open("/meshprop", true);
        for (i = 0; i < s_objectCount; ++i) {
            if (s_objects[i] == null) continue;
            meshId = s_objectTypes[i] - 1;
            byte[] var13 = cGame.Lib_GetData(meshId, false);
            ((cMesh)s_objects[i]).loadAnchors(meshId, var13);
        }
        cGame.Lib_Close();
        s_redLight = new cFxObj(0, 0);
        if (cGame.s_gameDayNight == 1) {
            s_whiteLight = new cFxObj(0, 1);
        }
    }

    static void loadSpecialObjects() {
        s_raceMarker = new cMesh();
        cGame.Lib_Open(cMesh.getLib(98), true);
        byte[] data = cGame.Lib_GetData(98, false);
        s_raceMarker.load(98, data);
        cRoad.s_raceMarker.shadow = true;
        cGame.Lib_UnBindData();
        cGame.Lib_Close();
        s_raceEnd = new cMesh();
        cGame.Lib_Open(cMesh.getLib(96), true);
        data = cGame.Lib_GetData(96, false);
        s_raceEnd.load(96, data);
        cRoad.s_raceEnd.shadow = true;
        cGame.Lib_UnBindData();
        cGame.Lib_Close();
        s_nos = new cNOS();
        s_neon = new cNeon((byte)cGame.s_neonColor[0], (byte)cGame.s_neonColor[1], (byte)cGame.s_neonColor[2]);
        s_roadBlock = new cMesh();
        cGame.Lib_Open(cMesh.getLib(95), true);
        data = cGame.Lib_GetData(95, false);
        cGame.Lib_UnBindData();
        cGame.Lib_Close();
        cGame.Lib_Open("/meshprop", true);
        byte[] meshPropData = cGame.Lib_GetData(95, false);
        s_roadBlock.load(95, data);
        s_roadBlock.loadAnchors(95, meshPropData);
        cRoad.s_roadBlock.shadow = true;
        cGame.Lib_UnBindData();
        cGame.Lib_Close();
        s_roadBlockLeft = new cMesh();
        cGame.Lib_Open(cMesh.getLib(93), true);
        data = cGame.Lib_GetData(93, false);
        s_roadBlockLeft.load(93, data);
        cRoad.s_roadBlockLeft.shadow = true;
        cGame.Lib_UnBindData();
        cGame.Lib_Close();
        s_roadBlockRight = new cMesh();
        cGame.Lib_Open(cMesh.getLib(94), true);
        data = cGame.Lib_GetData(94, false);
        s_roadBlockRight.load(94, data);
        cRoad.s_roadBlockRight.shadow = true;
        cGame.Lib_UnBindData();
        cGame.Lib_Close();
        s_jumpPlatform = new cMesh();
        cGame.Lib_Open(cMesh.getLib(97), true);
        data = cGame.Lib_GetData(97, false);
        s_jumpPlatform.load(97, data);
        cGame.Lib_UnBindData();
        cGame.Lib_Close();
        cGame.Lib_Open("/meshprop", true);
        meshPropData = cGame.Lib_GetData(97, false);
        s_jumpPlatform.load(97, data);
        s_jumpPlatform.loadAnchors(97, meshPropData);
        cRoad.s_jumpPlatform.shadow = true;
        cGame.Lib_UnBindData();
        cGame.Lib_Close();
        s_roadObstacle = new cMesh();
        cGame.Lib_Open(cMesh.getLib(92), true);
        data = cGame.Lib_GetData(92, false);
        s_roadObstacle.load(92, data);
        cGame.Lib_UnBindData();
        cGame.Lib_Close();
        cGame.Lib_Open("/meshprop", true);
        meshPropData = cGame.Lib_GetData(92, false);
        s_roadObstacle.load(92, data);
        s_roadObstacle.loadAnchors(92, meshPropData);
        cRoad.s_roadObstacle.shadow = true;
        cGame.Lib_UnBindData();
        cGame.Lib_Close();
        s_animTexObject = new cAnimObject(0, 0, 0);
    }

    private static void initRoadObstacles(int[] instances) {
        int i;
        s_numberOfRoadBlocks = 0;
        if (instances != null) {
            for (i = 0; i < s_raceNrObjects[cGame.s_currentRace]; ++i) {
                s_numberOfRoadBlocks += instances[i];
            }
        } else {
            s_numberOfRoadBlocks = s_raceNrObjects[cGame.s_currentRace];
        }
        s_roadObstaclesHitFrames = new byte[s_numberOfRoadBlocks];
        s_roadObstaclesSpeedYaw = new short[s_numberOfRoadBlocks];
        s_roadObstacleCoords = new int[s_numberOfRoadBlocks][4];
        for (i = 0; i < s_numberOfRoadBlocks; ++i) {
            cRoad.s_roadObstaclesHitFrames[i] = 0;
        }
        s_lastRoadObstacleIndex = 0;
    }

    static void loadRoadObstacles(int[] instances) {
        cRoad.initRoadObstacles(instances);
        for (int i = 0; i < s_raceNrObjects[cGame.s_currentRace]; ++i) {
            if (instances == null) {
                cRoad.positionRoadObstacle(s_raceObjectsRoad[cGame.s_currentRace][i], s_raceObjectsSegment[cGame.s_currentRace][i], s_raceObjectsLane[cGame.s_currentRace][i]);
                continue;
            }
            cRoad.positionRoadObstacle(s_raceObjectsRoad[cGame.s_currentRace][i], s_raceObjectsSegment[cGame.s_currentRace][i], s_raceObjectsLane[cGame.s_currentRace][i], instances[i]);
        }
    }

    private static void positionRoadObstacle(byte road, short segment, byte lane) {
        cRoad.s_roadObstacleCoords[cRoad.s_lastRoadObstacleIndex][0] = cRoad.getLaneX(road, lane, segment);
        cRoad.s_roadObstacleCoords[cRoad.s_lastRoadObstacleIndex][1] = cRoad.getLaneY(road, lane, segment);
        cRoad.s_roadObstacleCoords[cRoad.s_lastRoadObstacleIndex][2] = 0;
        cRoad.s_roadObstacleCoords[cRoad.s_lastRoadObstacleIndex][3] = s_roadYaws[road][segment];
        ++s_lastRoadObstacleIndex;
    }

    private static void positionRoadObstacle(byte road, short segment, byte lane, int numberOfInstances) {
        if (cGame.s_challengeType == 3) {
            lane = (byte)4;
        }
        Transform t = cMath.s_tempTrans;
        s_jumpPlatform.getAnchorTransform(t, 5, 0, true, false);
        int xc0 = cMesh.mLastAnchorX;
        s_jumpPlatform.getAnchorTransform(t, 5, 2, true, false);
        int xc2 = cMesh.mLastAnchorX;
        int jumpPlatforWidth = xc0 - xc2 < 0 ? -(xc0 - xc2) : xc0 - xc2;
        int angle = s_roadYaws[road][segment];
        if (numberOfInstances < 0) {
            angle += 2048;
        }
        int startX = cRoad.getLaneX(road, lane, segment) + jumpPlatforWidth * (cMath.cos(angle) >> 12);
        int startY = cRoad.getLaneY(road, lane, segment) + jumpPlatforWidth * (cMath.sin(angle) >> 12);
        for (int i = 0; i < numberOfInstances; ++i) {
            cRoad.s_roadObstacleCoords[cRoad.s_lastRoadObstacleIndex + i][0] = startX + 800 * (cMath.cos(angle) >> 12);
            cRoad.s_roadObstacleCoords[cRoad.s_lastRoadObstacleIndex + i][1] = startY + 800 * (cMath.sin(angle) >> 12);
            cRoad.s_roadObstacleCoords[cRoad.s_lastRoadObstacleIndex + i][2] = 0;
            cRoad.s_roadObstacleCoords[cRoad.s_lastRoadObstacleIndex + i][3] = angle;
            startX = s_roadObstacleCoords[s_lastRoadObstacleIndex + i][0];
            startY = s_roadObstacleCoords[s_lastRoadObstacleIndex + i][1];
        }
        s_lastRoadObstacleIndex += numberOfInstances;
    }

    private static void renderRoadObstacles(Graphics3D g3d) {
        for (int i = 0; i < s_numberOfRoadBlocks; ++i) {
            if (s_roadObstaclesHitFrames[i] == -1) continue;
            s_roadObstacle.setTransform(s_roadObstacleCoords[i][0], s_roadObstacleCoords[i][1], s_roadObstacleCoords[i][2], s_roadObstacleCoords[i][3], 0, 0);
            if (cGame.s_challengeType == 3) {
                s_roadObstacle.setScale(5.0f, 1.0f, 1.0f);
            }
            if (!cRoad.inCamBoundingSphere(((PLATFORM.bDoubleViewDistance ? 7500 : 4500) + 500) * ((PLATFORM.bDoubleViewDistance ? 7500 : 4500) + 500), cRoad.s_roadObstacle.mX, cRoad.s_roadObstacle.mY)) continue;
            s_roadObstacle.render(g3d);
        }
    }

    static void computeObstaclesCollisions() {
        for (int i = 0; i < s_numberOfRoadBlocks; ++i) {
            if (s_roadObstaclesHitFrames[i] == -1 || s_roadObstaclesHitFrames[i] > 0 || cGame.s_playerCar.mZ > 50) continue;
            s_roadObstacle.setTransform(s_roadObstacleCoords[i][0], s_roadObstacleCoords[i][1], s_roadObstacleCoords[i][2], s_roadObstacleCoords[i][3], 0, 0);
            if (!cCar.CheckMeshCollision(cGame.s_playerCar, s_roadObstacle, 1600)) continue;
            if (cGame.s_gameSubState != 7) {
                ++cGame.s_challengePoints;
            }
            cGame.Sfx_play(1, 1);
            cRoad.s_roadObstaclesHitFrames[i] = 20;
            cRoad.s_roadObstaclesSpeedYaw[i] = (short)cGame.s_playerCar.mSpeedYaw;
            if (cGame.s_challengeType != 3) continue;
            cRoad.setFailedJump(i);
        }
        cRoad.updateRoadObstaclesPosition();
    }

    private static void updateRoadObstaclesPosition() {
        for (int i = 0; i < s_numberOfRoadBlocks; ++i) {
            if (s_roadObstaclesHitFrames[i] <= 0) continue;
            int[] nArray = s_roadObstacleCoords[i];
            nArray[0] = nArray[0] + (100 * cMath.cos(s_roadObstaclesSpeedYaw[i]) >> 12);
            int[] nArray2 = s_roadObstacleCoords[i];
            nArray2[1] = nArray2[1] + (100 * cMath.sin(s_roadObstaclesSpeedYaw[i]) >> 12);
            int[] nArray3 = s_roadObstacleCoords[i];
            nArray3[2] = nArray3[2] + 100;
            int[] nArray4 = s_roadObstacleCoords[i];
            nArray4[2] = nArray4[2] + 256;
            int n = i;
            s_roadObstaclesHitFrames[n] = (byte)(s_roadObstaclesHitFrames[n] - 1);
            if (s_roadObstaclesHitFrames[n] > 0) continue;
            cRoad.s_roadObstaclesHitFrames[i] = -1;
        }
    }

    static void unloadRoadObstacles() {
        s_numberOfRoadBlocks = 0;
        s_lastRoadObstacleIndex = 0;
        s_roadObstaclesHitFrames = null;
        s_roadObstaclesSpeedYaw = null;
        s_roadObstacleCoords = null;
    }

    static void loadJumpPlatforms() {
        int i;
        s_jumpPlatformCoords = new int[cGame.s_currentRace][4];
        s_lastJumpPlatform = -1;
        for (i = 0; i < s_raceNrObjects[cGame.s_currentRace]; ++i) {
            cRoad.s_jumpPlatformCoords[i][0] = cRoad.getLaneX(s_raceObjectsRoad[cGame.s_currentRace][i], s_raceObjectsLane[cGame.s_currentRace][i], s_raceObjectsSegment[cGame.s_currentRace][i]);
            cRoad.s_jumpPlatformCoords[i][1] = cRoad.getLaneY(s_raceObjectsRoad[cGame.s_currentRace][i], s_raceObjectsLane[cGame.s_currentRace][i], s_raceObjectsSegment[cGame.s_currentRace][i]);
            cRoad.s_jumpPlatformCoords[i][2] = 0;
            int angle = s_roadYaws[s_raceObjectsRoad[cGame.s_currentRace][i]][s_raceObjectsSegment[cGame.s_currentRace][i]] + 1024;
            if (cGame.getNextCorrectIntersection(s_raceObjectsRoad[cGame.s_currentRace][i]) == s_roadIntersection[s_raceObjectsRoad[cGame.s_currentRace][i]][0] && s_raceObjectsRoad[cGame.s_currentRace][i] != s_raceEndRoad[cGame.s_currentRace]) {
                angle += 2048;
            }
            cRoad.s_jumpPlatformCoords[i][3] = angle;
        }
        cRoad.loadRoadObstacles(s_barriersNumber);
        for (i = 0; i < s_jumpSucceeded.length; ++i) {
            cRoad.s_jumpSucceeded[i] = 0;
        }
    }

    private static void renderJumpPlatforms(Graphics3D g3d) {
        if (cGame.s_currentRace != -1 && cGame.s_gameSubState != 1 && cGame.s_challengeType == 3 && s_jumpPlatform != null) {
            for (int i = 0; i < s_raceNrObjects[cGame.s_currentRace]; ++i) {
                s_jumpPlatform.setTransform(s_jumpPlatformCoords[i][0], s_jumpPlatformCoords[i][1], s_jumpPlatformCoords[i][2], s_jumpPlatformCoords[i][3], 0, 0);
                s_jumpPlatform.render(g3d);
            }
        }
    }

    static void computeJumpPlatfotmCollision() {
        if (cGame.s_playerCar.mFlying) {
            cGame.s_playerCar.UnsetCarInput(-1);
        } else if (cGame.s_currentRace != -1 && cGame.s_gameSubState != 1 && s_jumpPlatform != null) {
            for (int i = 0; i < s_raceNrObjects[cGame.s_currentRace]; ++i) {
                s_jumpPlatform.setTransform(s_jumpPlatformCoords[i][0], s_jumpPlatformCoords[i][1], s_jumpPlatformCoords[i][2], s_jumpPlatformCoords[i][3], 0, 0);
                if (!cGame.s_playerCar.ComputeMeshCollision(s_jumpPlatform, 1600)) continue;
                s_lastJumpPlatform = i;
                cRoad.initCarJump();
                return;
            }
        }
    }

    private static void initCarJump() {
        cGame.Sfx_play(3, 1);
        s_carTargetZ = 26 + (cGame.s_playerCar.mDisplaySpeed >> 3);
        s_bCarIsLanding = false;
        cGame.s_playerCar.mVertAccel = 0;
        cGame.s_playerCar.mFlying = true;
        cGame.s_playerCar.mPitch += (15 + (cGame.s_playerCar.mDisplaySpeed >> 6)) * 11;
        cGame.s_playerCar.mPitch = 1024 < cGame.s_playerCar.mPitch ? 1024 : cGame.s_playerCar.mPitch;
        cGame.s_raceJumpGain = s_carTargetZ * 10;
    }

    static void endCarJump() {
        s_carTargetZ = 0;
        if (s_lastJumpPlatform >= 0 && s_jumpSucceeded[s_lastJumpPlatform] != -1) {
            cRoad.s_jumpSucceeded[cRoad.s_lastJumpPlatform] = 1;
        }
    }

    private static void setFailedJump(int idx) {
        int barrierNumber = 0;
        for (int i = 0; i < s_barriersNumber.length; ++i) {
            if ((barrierNumber += s_barriersNumber[i]) <= idx) continue;
            cRoad.s_jumpSucceeded[i] = -1;
            return;
        }
    }

    static void unloadJumpPlatforms() {
        if (s_jumpPlatformCoords != null) {
            for (int ___i = 0; ___i < s_jumpPlatformCoords.length; ++___i) {
                cRoad.s_jumpPlatformCoords[___i] = null;
            }
            s_jumpPlatformCoords = null;
        }
        cRoad.unloadRoadObstacles();
    }

    private static int getDistance(int seg1, int seg2) {
        return cRoad.getDistance(s_currentSpline, seg1, seg2);
    }

    private static int getDistance(int road, int seg1, int seg2) {
        return seg1 == seg2 ? 0 : (s_dist[road][seg2 * 2] - s_dist[road][seg1 * 2] < 0 ? -(s_dist[road][seg2 * 2] - s_dist[road][seg1 * 2]) : s_dist[road][seg2 * 2] - s_dist[road][seg1 * 2]);
    }

    static int getDistance(int road1, int seg1, int road2, int seg2) {
        int side1;
        int side2;
        if (seg1 == seg2 && road1 == road2) {
            return 0;
        }
        if (road1 == road2) {
            return cRoad.getDistance(road1, seg1, seg2);
        }
        if (s_roadIntersection[road1][0] == s_roadIntersection[road2][0]) {
            side2 = 0;
            side1 = 0;
        } else if (s_roadIntersection[road1][1] == s_roadIntersection[road2][0]) {
            side1 = 1;
            side2 = 0;
        } else if (s_roadIntersection[road1][0] == s_roadIntersection[road2][1]) {
            side1 = 0;
            side2 = 1;
        } else {
            if (s_roadIntersection[road1][1] != s_roadIntersection[road2][1]) {
                return -1;
            }
            side2 = 1;
            side1 = 1;
        }
        if (side1 == 1) {
            side1 = s_vtxCount[road1] - 1;
        }
        if (side2 == 1) {
            side2 = s_vtxCount[road2] - 1;
        }
        return cRoad.getDistance(road1, seg1, side1) + cRoad.getDistance(road2, seg2, side2);
    }

    static void setSegment(int intersection, int spline, int seg) {
        s_currentSpline = spline;
        s_currentIntersection = intersection;
        for (int i = 0; i < s_sectionCount[s_currentSpline]; ++i) {
            if (i == s_sectionCount[s_currentSpline] - 1) {
                s_currentSection = i;
                break;
            }
            if (s_sections[s_currentSpline][i] > seg || seg >= s_sections[s_currentSpline][i + 1]) continue;
            s_currentSection = i;
            break;
        }
        if (s_sectionWidth > 0) {
            s_currentSectionWidth = s_sectionWidth;
        }
        if (s_sectionSideWidth > 0) {
            s_currentSideWidth = s_sectionSideWidth;
        }
        s_currentSegment = seg;
    }

    private static void renderObjects(Graphics3D g3d, int o, short[] objList) {
        s_drawnObjects = 0;
        if (objList != null) {
            for (int i = 0; i < s_ObjectsInList; ++i) {
                int j;
                Transform var13;
                int count;
                cMesh mesh;
                cObject obj = s_objects[objList[i]];
                if (obj.getPropFlip() && o != 0) {
                    obj.setRotateZ(o == 1 ? 0 : 2048);
                }
                if (!(mesh = (cMesh)obj).inFrustrum()) continue;
                short oldZ = mesh.mZ;
                int propCollidable = mesh.getPropCollidable();
                if (propCollidable >= 2 && propCollidable <= 5 && cGame.s_gameState == 22) {
                    count = (int)cGame.s_frameCounter * 130;
                    int t = 100 * cMath.cos(count) >> 12;
                    mesh.setTransform(mesh.mX, mesh.mY, mesh.mZ + t, 0, 0, 0);
                    mesh.setRotateZ(count);
                }
                if (PLATFORM.bUseObjectShadows && mesh.getFlag(64)) {
                    mesh.renderAsShadow(g3d, 0, 0, -1727855869);
                }
                mesh.render(g3d);
                ++s_drawnObjects;
                if (propCollidable >= 2 && propCollidable <= 5) {
                    mesh.setTransform(mesh.mX, mesh.mY, oldZ, 0, 0, 0);
                }
                if ((cMesh.s_mAnchorX[mesh.mMeshIndex] == null ? 0 : (count = cMesh.s_mAnchorX[mesh.mMeshIndex][1] == null ? 0 : cMesh.s_mAnchorX[mesh.mMeshIndex][1].length)) != 0 && cGame.s_gameDayNight == 1) {
                    var13 = cRoad.s_whiteLight.mModelTrans;
                    for (j = 0; j < count; ++j) {
                        mesh.getAnchorTransform(var13, 1, j, true, false);
                        cRoad.s_whiteLight.mX = cMesh.mLastAnchorX;
                        cRoad.s_whiteLight.mY = cMesh.mLastAnchorY;
                        cRoad.s_whiteLight.mZ = cMesh.mLastAnchorZ;
                        s_whiteLight.render(g3d);
                    }
                }
                if ((cMesh.s_mAnchorX[mesh.mMeshIndex] == null ? 0 : (count = cMesh.s_mAnchorX[mesh.mMeshIndex][0] == null ? 0 : cMesh.s_mAnchorX[mesh.mMeshIndex][0].length)) == 0) continue;
                var13 = cRoad.s_redLight.mModelTrans;
                for (j = 0; j < count; ++j) {
                    mesh.getAnchorTransform(var13, 0, j, true, false);
                    cRoad.s_redLight.mX = cMesh.mLastAnchorX;
                    cRoad.s_redLight.mY = cMesh.mLastAnchorY;
                    cRoad.s_redLight.mZ = cMesh.mLastAnchorZ;
                    s_redLight.render(g3d);
                }
            }
            if (-1 != s_closestLight) {
                s_closestLight = -1;
            }
        }
    }

    private static int getSectionsFromSegments(int road, int startSegment, int endSegment) {
        int startSection = cRoad.getSegmentSection(road, startSegment);
        int endSection = cRoad.getSegmentSection(road, endSegment);
        for (int i = startSection; i <= endSection; ++i) {
            cRoad.s_sectionsToRender[i - startSection] = (short)i;
        }
        return endSection - startSection + 1;
    }

    private static int getSegmentSection(int road, int segment) {
        for (int i = 0; i < s_sectionCount[road]; ++i) {
            if (s_sections[road][i] <= segment) continue;
            return i - 1;
        }
        return s_sectionCount[road] - 1;
    }

    static void render(Graphics3D g3d) {
        int k;
        s_drawRoadSegments = 0;
        s_drawRoadFences = 0;
        for (k = 0; k < roadIdx; ++k) {
            int sectionsNo = cRoad.getSectionsFromSegments(s_segmentsList[k][0], s_segmentsList[k][1], s_segmentsList[k][2]);
            for (int i = 0; i < sectionsNo; ++i) {
                ++s_drawRoadSegments;
                g3d.render(s_roadVtxBuffer[cGame.s_currentTrack][s_segmentsList[k][0]], s_roadIdxBuffer[cGame.s_currentTrack][s_segmentsList[k][0]][s_sectionsToRender[i]], s_roadAppearance, s_roadTransforms[s_segmentsList[k][0]]);
            }
            ++s_drawRoadFences;
            s_fenceAppearance.setPolygonMode(s_fencePolygonMode[0]);
            s_fenceTransform.setIdentity();
            s_fenceTransform.postTranslate((float)s_vtx[s_segmentsList[k][0]][0] / PLATFORM.mCoord2JsrDivider, (float)s_vtx[s_segmentsList[k][0]][1] / PLATFORM.mCoord2JsrDivider, (float)s_vtx[s_segmentsList[k][0]][2] / PLATFORM.mCoord2JsrDivider);
            g3d.render(s_fenceVtxBuffer[cGame.s_currentTrack][s_segmentsList[k][0]][0], s_fenceIdxBuffer[cGame.s_currentTrack][s_segmentsList[k][0]], s_fenceAppearance, s_fenceTransform);
            s_fenceTransform.setIdentity();
            s_fenceTransform.postTranslate((float)s_vtx[s_segmentsList[k][0]][3] / PLATFORM.mCoord2JsrDivider, (float)s_vtx[s_segmentsList[k][0]][4] / PLATFORM.mCoord2JsrDivider, (float)s_vtx[s_segmentsList[k][0]][5] / PLATFORM.mCoord2JsrDivider);
            s_fenceAppearance.setPolygonMode(s_fencePolygonMode[1]);
            g3d.render(s_fenceVtxBuffer[cGame.s_currentTrack][s_segmentsList[k][0]][1], s_fenceIdxBuffer[cGame.s_currentTrack][s_segmentsList[k][0]], s_fenceAppearance, s_fenceTransform);
        }
        for (k = 0; k < 2; ++k) {
            if (s_IntersectionsRenderList[k] == -1) continue;
            s_intersections[s_IntersectionsRenderList[k]].render(g3d);
        }
        cRoad.renderObjects(g3d, 0, s_objectList);
        cRoad.renderSpecialObjects(g3d);
        cRoad.renderRoadObstacles(g3d);
        cRoad.renderJumpPlatforms(g3d);
    }

    private static void renderSpecialObjects(Graphics3D g3d) {
        try {
            int i;
            block10: {
                int var3;
                block12: {
                    int var10000;
                    block13: {
                        block11: {
                            block9: {
                                if (cGame.s_gameSubState == 6) {
                                    for (i = 0; i < s_raceBonusNr[cGame.s_currentRace]; ++i) {
                                        cGame.s_raceBonuses[i].renderBonus(g3d);
                                    }
                                }
                                if (cGame.s_gameSubState != 0) break block9;
                                for (i = 0; i < s_numberOfRaces; ++i) {
                                    if (cGame.s_infoRaceType[cGame.s_currentTrack][i] == 5 && cGame.s_missionsTime[cGame.s_currentTrack][i] == -2 || cGame.s_infoRaceType[cGame.s_currentTrack][i] == 7) continue;
                                    cRoad.s_raceMarker.mX = cRoad.getCenterX(s_raceStartRoad[i], s_raceStartSegment[i]);
                                    cRoad.s_raceMarker.mY = cRoad.getCenterY(s_raceStartRoad[i], s_raceStartSegment[i]);
                                    cRoad.s_raceMarker.mZ = (short)10;
                                    if (!cRoad.inCamBoundingSphere(((PLATFORM.bDoubleViewDistance ? 7500 : 4500) + 500) * ((PLATFORM.bDoubleViewDistance ? 7500 : 4500) + 500), cRoad.s_raceMarker.mX, cRoad.s_raceMarker.mY)) continue;
                                    s_raceMarker.setTransform(cRoad.s_raceMarker.mX, cRoad.s_raceMarker.mY, cRoad.s_raceMarker.mZ, 0, 0, 0);
                                    s_raceMarker.render(g3d);
                                }
                                break block10;
                            }
                            if (cGame.s_gameSubState == 1) {
                                return;
                            }
                            var3 = 1;
                            if (s_raceNrHelperPoints[cGame.s_currentRace] <= 0) break block11;
                            if (s_roadIntersection[s_raceEndRoad[cGame.s_currentRace]][0] != s_raceRoadHelperPoints[cGame.s_currentRace][s_raceNrHelperPoints[cGame.s_currentRace] - 1]) break block12;
                            var10000 = -1;
                            break block13;
                        }
                        var10000 = 0;
                    }
                    var3 = var10000;
                }
                cRoad.s_raceEnd.mX = cRoad.getCenterX(s_raceEndRoad[cGame.s_currentRace], s_raceEndSegment[cGame.s_currentRace] + var3);
                cRoad.s_raceEnd.mY = cRoad.getCenterY(s_raceEndRoad[cGame.s_currentRace], s_raceEndSegment[cGame.s_currentRace] + var3);
                cRoad.s_raceEnd.mZ = 0;
                if (cRoad.inCamBoundingSphere(((PLATFORM.bDoubleViewDistance ? 7500 : 4500) + 500) * ((PLATFORM.bDoubleViewDistance ? 7500 : 4500) + 500) << 1, cRoad.s_raceEnd.mX, cRoad.s_raceEnd.mY) && (cGame.s_beginGameStep != 0 || cGame.s_bIsInstantPlay)) {
                    s_raceEnd.setTransform(cRoad.s_raceEnd.mX, cRoad.s_raceEnd.mY, cRoad.s_raceEnd.mZ, s_roadYaws[s_raceEndRoad[cGame.s_currentRace]][s_raceEndSegment[cGame.s_currentRace]], 0, 0);
                    s_raceEnd.render(g3d);
                }
            }
            if (cGame.s_playerCar.mCurrentIntersection == -1) {
                for (i = 0; i < 2; ++i) {
                    if (!cRoad.inCamBoundingSphere(((PLATFORM.bDoubleViewDistance ? 7500 : 4500) + 500) * ((PLATFORM.bDoubleViewDistance ? 7500 : 4500) + 500), cRoad.s_intersections[cRoad.s_roadIntersection[cGame.s_playerCar.mCurrentRoad][i]].xCenter, cRoad.s_intersections[cRoad.s_roadIntersection[cGame.s_playerCar.mCurrentRoad][i]].yCenter)) continue;
                    s_intersections[s_roadIntersection[cGame.s_playerCar.mCurrentRoad][i]].renderRoadBlocks(g3d);
                }
                return;
            }
            s_intersections[cGame.s_playerCar.mCurrentIntersection].renderRoadBlocks(g3d);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static int getLeftX(int seg) {
        return cRoad.getLeftX(s_currentSpline, seg);
    }

    static int getLeftY(int seg) {
        return cRoad.getLeftY(s_currentSpline, seg);
    }

    private static int getLeftX(int road, int seg) {
        return s_vtx[road][seg * 3 * 2 + 0];
    }

    private static int getLeftY(int road, int seg) {
        return s_vtx[road][seg * 3 * 2 + 1];
    }

    private static int getLeftZ(int road, int seg) {
        return s_vtx[road][seg * 3 * 2 + 2];
    }

    static int getRightX(int seg) {
        return cRoad.getRightX(s_currentSpline, seg);
    }

    static int getRightY(int seg) {
        return cRoad.getRightY(s_currentSpline, seg);
    }

    private static int getRightX(int road, int seg) {
        return s_vtx[road][seg * 3 * 2 + 3 + 0];
    }

    private static int getRightY(int road, int seg) {
        return s_vtx[road][seg * 3 * 2 + 3 + 1];
    }

    private static int getRightZ(int road, int seg) {
        return s_vtx[road][seg * 3 * 2 + 3 + 2];
    }

    static int getCenterX(int road, int seg) {
        return cRoad.getLeftX(road, seg) + cRoad.getRightX(road, seg) >> 1;
    }

    static int getCenterY(int road, int seg) {
        return cRoad.getLeftY(road, seg) + cRoad.getRightY(road, seg) >> 1;
    }

    static int getCenterZ(int road, int seg) {
        return cRoad.getRightZ(road, seg) + cRoad.getLeftZ(road, seg) >> 1;
    }

    static int getCenterX(int seg) {
        return s_currentIntersection != -1 ? cRoad.s_intersections[cRoad.s_currentIntersection].xCenter : cRoad.getLeftX(seg) + cRoad.getRightX(seg) >> 1;
    }

    static int getCenterY(int seg) {
        return s_currentIntersection != -1 ? cRoad.s_intersections[cRoad.s_currentIntersection].yCenter : cRoad.getLeftY(seg) + cRoad.getRightY(seg) >> 1;
    }

    static int getLaneX(int road, int lane, int seg) {
        switch (lane) {
            case 0: {
                return cRoad.getRightX(road, seg);
            }
            case 1: {
                return cRoad.getRightX(road, seg) * 3 + cRoad.getCenterX(road, seg) >> 2;
            }
            case 2: {
                return cRoad.getRightX(road, seg) + cRoad.getCenterX(road, seg) >> 1;
            }
            case 3: {
                return cRoad.getRightX(road, seg) + cRoad.getCenterX(road, seg) * 3 >> 2;
            }
            case 4: {
                return cRoad.getCenterX(road, seg);
            }
            case 5: {
                return cRoad.getLeftX(road, seg) + cRoad.getCenterX(road, seg) * 3 >> 2;
            }
            case 6: {
                return cRoad.getLeftX(road, seg) + cRoad.getCenterX(road, seg) >> 1;
            }
            case 7: {
                return cRoad.getLeftX(road, seg) * 3 + cRoad.getCenterX(road, seg) >> 2;
            }
            case 8: {
                return cRoad.getLeftX(road, seg);
            }
        }
        return 0;
    }

    static int getLaneY(int road, int lane, int seg) {
        switch (lane) {
            case 0: {
                return cRoad.getRightY(road, seg);
            }
            case 1: {
                return cRoad.getRightY(road, seg) * 3 + cRoad.getCenterY(road, seg) >> 2;
            }
            case 2: {
                return cRoad.getRightY(road, seg) + cRoad.getCenterY(road, seg) >> 1;
            }
            case 3: {
                return cRoad.getRightY(road, seg) + cRoad.getCenterY(road, seg) * 3 >> 2;
            }
            case 4: {
                return cRoad.getCenterY(road, seg);
            }
            case 5: {
                return cRoad.getLeftY(road, seg) + cRoad.getCenterY(road, seg) * 3 >> 2;
            }
            case 6: {
                return cRoad.getLeftY(road, seg) + cRoad.getCenterY(road, seg) >> 1;
            }
            case 7: {
                return cRoad.getLeftY(road, seg) * 3 + cRoad.getCenterY(road, seg) >> 2;
            }
            case 8: {
                return cRoad.getLeftY(road, seg);
            }
        }
        return 0;
    }

    static int getLaneZ(int road, int lane, int seg) {
        switch (lane) {
            case 0: {
                return cRoad.getRightZ(road, seg);
            }
            case 1: {
                return cRoad.getRightZ(road, seg) * 3 + cRoad.getCenterZ(road, seg) >> 2;
            }
            case 2: {
                return cRoad.getRightZ(road, seg) + cRoad.getCenterZ(road, seg) >> 1;
            }
            case 3: {
                return cRoad.getRightZ(road, seg) + cRoad.getCenterZ(road, seg) * 3 >> 2;
            }
            case 4: {
                return cRoad.getCenterZ(road, seg);
            }
            case 5: {
                return cRoad.getLeftZ(road, seg) + cRoad.getCenterZ(road, seg) * 3 >> 2;
            }
            case 6: {
                return cRoad.getLeftZ(road, seg) + cRoad.getCenterZ(road, seg) >> 1;
            }
            case 7: {
                return cRoad.getLeftZ(road, seg) * 3 + cRoad.getCenterZ(road, seg) >> 2;
            }
            case 8: {
                return cRoad.getLeftZ(road, seg);
            }
        }
        return 0;
    }

    private static int getTriangle(int x, int y, int start, int end) {
        int x1 = s_vtx[s_currentSpline][start * 3 + 0];
        int y1 = s_vtx[s_currentSpline][start * 3 + 1];
        int x2 = s_vtx[s_currentSpline][start * 3 + 3];
        int y2 = s_vtx[s_currentSpline][start * 3 + 4];
        for (int i = start + 2; i < end; ++i) {
            int x3 = s_vtx[s_currentSpline][i * 3 + 0];
            int y3 = s_vtx[s_currentSpline][i * 3 + 1];
            long fAB = (y - y1) * (x2 - x1) - (x - x1) * (y2 - y1);
            long fBC = (y - y2) * (x3 - x2) - (x - x2) * (y3 - y2);
            long fCA = (y - y3) * (x1 - x3) - (x - x3) * (y1 - y3);
            if (!(fBC < 5000L && fBC > -5000L || fAB < 5000L && fAB > -5000L || fCA < 5000L && fCA > -5000L)) {
                if (fAB * fBC > 0L && fBC * fCA > 0L) {
                    return i - 2;
                }
            } else {
                boolean c = false;
                if ((y1 <= y && y < y3 || y3 <= y && y < y1) && x < (x3 - x1) * (y - y1) / (y3 - y1) + x1) {
                    c = true;
                }
                if ((y2 <= y && y < y1 || y1 <= y && y < y2) && x < (x1 - x2) * (y - y2) / (y1 - y2) + x2) {
                    boolean bl = c = !c;
                }
                if ((y3 <= y && y < y2 || y2 <= y && y < y3) && x < (x2 - x3) * (y - y3) / (y2 - y3) + x3) {
                    boolean bl = c = !c;
                }
                if (c) {
                    return i - 2;
                }
            }
            x1 = x2;
            y1 = y2;
            x2 = x3;
            y2 = y3;
        }
        return -999999;
    }

    static int getRoadYaw(int road, int segment) {
        return road >= s_roadYaws.length ? 0 : (segment >= s_roadYaws[road].length ? 0 : s_roadYaws[road][segment]);
    }

    static int getRoadYaw(int segment) {
        return s_currentIntersection == -1 ? s_roadYaws[s_currentSpline][segment] : 0;
    }

    static boolean isPointOnRoad(int x, int y, boolean saveData) {
        if (s_currentIntersection == -1) {
            int start;
            int tri = (s_currentSegment - 4) * 2;
            int k = (s_currentSegment + 8) * 2;
            if (tri < 0) {
                tri = 0;
            }
            if (k > 2 * s_vtxCount[s_currentSpline]) {
                k = 2 * s_vtxCount[s_currentSpline];
            }
            if ((start = cRoad.getTriangle(x, y, tri, k)) >= 0) {
                if (saveData) {
                    s_currentTriangle = start;
                    s_currentSegment = s_currentTriangle >> 1;
                }
                return true;
            }
            for (int end = 0; end < 2; ++end) {
                if (s_roadIntersection[s_currentSpline][end] == -1 || (start = s_intersections[s_roadIntersection[s_currentSpline][end]].getTriangleFromIntersection(x, y)) < 0) continue;
                if (saveData) {
                    s_currentTriangle = start;
                    s_currentIntersection = s_roadIntersection[s_currentSpline][end];
                    s_currentSegment = 0;
                }
                return true;
            }
        } else {
            int tri = s_intersections[s_currentIntersection].getTriangleFromIntersection(x, y);
            if (tri >= 0) {
                if (saveData) {
                    s_currentTriangle = tri;
                }
                return true;
            }
            for (int k = 0; k < cRoad.s_intersections[cRoad.s_currentIntersection].nrRoads; ++k) {
                s_currentSpline = cRoad.s_intersections[cRoad.s_currentIntersection].roads[k];
                int end = 2 * s_vtxCount[cRoad.s_intersections[cRoad.s_currentIntersection].roads[k]];
                if (!s_availableRoads[s_currentSpline] || (tri = cRoad.getTriangle(x, y, 0, end)) < 0) continue;
                if (saveData) {
                    s_currentTriangle = tri;
                    s_currentIntersection = -1;
                    s_currentSegment = s_currentTriangle >> 1;
                }
                return true;
            }
        }
        return false;
    }

    static int getRoadRatio(int tri, int x, int y) {
        if (s_currentIntersection == -1) {
            boolean even = (tri & 1) == 0;
            int fi = 0;
            int li = 1;
            if (!even) {
                fi = 1;
                li = 2;
            }
            int x0 = s_vtx[s_currentSpline][(tri + fi) * 3 + 0];
            int y0 = s_vtx[s_currentSpline][(tri + fi) * 3 + 1];
            int x1 = s_vtx[s_currentSpline][(tri + li) * 3 + 0] - x0;
            int y1 = s_vtx[s_currentSpline][(tri + li) * 3 + 1] - y0;
            int dot = (x -= x0) * x1 + (y -= y0) * y1 >> 8;
            int sqrt = x1 * x1 + y1 * y1 >> 8;
            return sqrt == 0 ? 0 : s_currentSectionWidth * dot / sqrt;
        }
        return 0;
    }

    private static int getTriangleHeight(int tri, int x, int y) {
        if (s_currentIntersection == -1) {
            if (tri * 3 + 2 >= s_vtxCount[s_currentSpline] - 1) {
                return 0;
            }
            int x0 = s_vtx[s_currentSpline][(tri + 0) * 3 + 0];
            int y0 = s_vtx[s_currentSpline][(tri + 0) * 3 + 1];
            int z0 = s_vtx[s_currentSpline][(tri + 0) * 3 + 2];
            int x1 = s_vtx[s_currentSpline][(tri + 2) * 3 + 0] - x0;
            int y1 = s_vtx[s_currentSpline][(tri + 2) * 3 + 1] - y0;
            int z1 = s_vtx[s_currentSpline][(tri + 2) * 3 + 2] - z0;
            int dot = (int)((long)(x -= x0) * (long)x1 + (long)((y -= y0) * y1) >> 8);
            int sqrt = (int)((long)x1 * (long)x1 + (long)(y1 * y1) >> 8);
            int r = sqrt == 0 ? 0 : 1024 * dot / sqrt;
            r = 1024 < r ? 1024 : r;
            r = 0 > r ? 0 : r;
            return z0 + (r * z1 >> 10);
        }
        return 0;
    }

    static int getRoadHeight(int x, int y) {
        return cRoad.isPointOnRoad(x, y, false) ? cRoad.getTriangleHeight(s_currentTriangle, x, y) : -999999;
    }

    static int getSegmentDistance(int seg, int dist, boolean forward) {
        int res;
        block4: {
            res = -999999;
            if (seg >= s_vtxCount[s_currentSpline]) break block4;
            if (forward) {
                for (int i = seg; i < s_vtxCount[s_currentSpline]; ++i) {
                    if (cRoad.getDistance(seg, i) < dist) continue;
                    res = i;
                    break;
                }
            } else {
                for (int i = seg; i >= 0; --i) {
                    if (cRoad.getDistance(i, seg) < dist) continue;
                    res = i;
                    break;
                }
            }
        }
        return res;
    }

    private static void fillImage2D(Image2D img, byte[] imgdata, boolean transp, int color) {
        int iw = img.getWidth();
        int ih = img.getHeight();
        int nb = transp ? 4 : 3;
        int ncol = imgdata.length / (ih * nb);
        byte r = (byte)(color >> 16 & 0xFF);
        byte g = (byte)(color >> 8 & 0xFF);
        byte b = (byte)(color & 0xFF);
        int var10000 = 0;
        while (true) {
            int curcol = var10000;
            if (var10000 >= ncol * ih * nb) {
                var10000 = 0;
                while (true) {
                    curcol = var10000;
                    if (var10000 >= iw) {
                        return;
                    }
                    int columns = curcol + ncol > iw ? iw - curcol : ncol;
                    img.set(curcol, 0, columns, ih, imgdata);
                    var10000 = curcol + ncol;
                }
            }
            imgdata[curcol] = r;
            imgdata[curcol + 1] = g;
            imgdata[curcol + 2] = b;
            if (transp) {
                imgdata[curcol + 3] = 0;
            }
            var10000 = curcol + nb;
        }
    }

    public static void load3DSky() {
        s_skyImage2DLayer1 = new Image2D(99, 240, 130);
        Appearance tempApp1 = new Appearance();
        CompositingMode tempCM1 = new CompositingMode();
        tempCM1.setBlending(68);
        tempCM1.setDepthTestEnable(false);
        tempCM1.setDepthWriteEnable(false);
        tempApp1.setCompositingMode(tempCM1);
        s_skySPR3DLayer1 = new Sprite3D(false, s_skyImage2DLayer1, tempApp1);
        s_skyImage2DLayer2 = new Image2D(100, 240, 130);
        Appearance tempApp2 = new Appearance();
        CompositingMode tempCM2 = new CompositingMode();
        tempCM2.setBlending(64);
        tempCM2.setDepthTestEnable(false);
        tempCM2.setDepthWriteEnable(false);
        tempApp2.setCompositingMode(tempCM2);
        s_skySPR3DLayer2 = new Sprite3D(false, s_skyImage2DLayer2, tempApp2);
        s_skyBgImage2D = new Image2D(99, 4, cGame.s_viewportHeight);
        s_skyTransform = new Transform();
    }

    static void loadSky$1cf967a4(int layer1, int layer2) {
        s_skyColor = cGame.skyColors[cGame.s_currentTrack];
        s_groundColor = cGame.groundColors[cGame.s_currentTrack];
        s_skyLayer1 = null;
        s_skyLayer1 = new ASprite();
        cGame.LoadFile("/res/bg_" + s_skyFiles[layer1] + ".tex");
        s_skyLayer1.Load(cGame._file_data, 0);
        s_skyLayer1Width = s_skyLayer1.GetFrameWidth(0);
        s_skyLayer1Height = s_skyLayer1.GetFrameHeight(0);
        s_skyLayer2 = null;
        s_skyLayer2 = new ASprite();
        cGame.LoadFile("/res/bg_" + s_skyFiles[layer2] + ".tex");
        s_skyLayer2.Load(cGame._file_data, 0);
        s_skyLayer2Width = s_skyLayer2.GetFrameWidth(0);
        s_skyLayer2Height = s_skyLayer2.GetFrameHeight(0);
        if (!PLATFORM.bUse3DSky) {
            s_skyLayer1.BuildCacheImages(0, 0, -1, -1);
            s_skyLayer1.FreeCacheData();
            s_skyLayer2.BuildCacheImages(0, 0, -1, -1);
            s_skyLayer2.FreeCacheData();
        } else {
            int index;
            int off;
            int fmodule;
            byte[] imgdata = cGame._file_data;
            cRoad.fillImage2D(s_skyImage2DLayer1, imgdata, false, s_skyColor);
            for (fmodule = 0; fmodule < s_skyLayer1.GetFModules(0); ++fmodule) {
                off = cRoad.s_skyLayer1._frames_fm_start[0] + fmodule << 2;
                index = cRoad.s_skyLayer1._fmodules[off] & 0xFF;
                s_skyLayer1.DecodeImageToByteArray(imgdata, index, false, false);
                s_skyImage2DLayer1.set(s_skyLayer1.GetFrameModuleX(0, fmodule), s_skyLayer1.GetFrameModuleY(0, fmodule) + (130 - s_skyLayer1Height), s_skyLayer1.GetFrameModuleWidth(0, fmodule), s_skyLayer1.GetFrameModuleHeight(0, fmodule), imgdata);
            }
            cRoad.fillImage2D(s_skyImage2DLayer2, imgdata, true, 0);
            for (fmodule = 0; fmodule < s_skyLayer2.GetFModules(0); ++fmodule) {
                off = cRoad.s_skyLayer2._frames_fm_start[0] + fmodule << 2;
                index = cRoad.s_skyLayer2._fmodules[off] & 0xFF;
                s_skyLayer2.DecodeImageToByteArray(imgdata, index, true, false);
                s_skyImage2DLayer2.set(s_skyLayer2.GetFrameModuleX(0, fmodule), s_skyLayer2.GetFrameModuleY(0, fmodule) + (130 - s_skyLayer2Height), s_skyLayer2.GetFrameModuleWidth(0, fmodule), s_skyLayer2.GetFrameModuleHeight(0, fmodule), imgdata);
            }
            cRoad.fillImage2D(s_skyBgImage2D, imgdata, false, s_skyColor);
            cGame.s_background.setImage(s_skyBgImage2D);
            cGame.s_background.setImageMode(33, 32);
        }
    }

    static void renderSky(Graphics g, Graphics3D g3d, int yaw, int altitude, boolean use3DSky) {
        int top;
        int topLayer2;
        block24: {
            int cropX2;
            int cropX1;
            block27: {
                int var10000;
                block26: {
                    int ScreenX;
                    block25: {
                        int skyViewportY;
                        block23: {
                            block19: {
                                block22: {
                                    block21: {
                                        block20: {
                                            int topLayer1;
                                            block18: {
                                                topLayer1 = s_skyAltitudeZeroScrY - (5 * s_skyLayer2Height >> 2);
                                                topLayer2 = s_skyAltitudeZeroScrY - s_skyLayer2Height;
                                                topLayer2 += altitude * s_skyLayer2GlobalRange / 3500;
                                                top = (topLayer1 += altitude * s_skyLayer1GlobalRange / 3500) + s_skyLayer1Height;
                                                g.setColor(s_skyColor);
                                                g.fillRect(0, 0, cGame.s_screenWidth, top);
                                                if (use3DSky) {
                                                    skyViewportY = cGame.s_interfaceTop + (cGame.s_viewportHeight >> 1) - topLayer1;
                                                    cMath.get3DFromScrCoor(cGame.s_camNearView, cGame.s_camW, cGame.s_camH, cGame.s_camViewportW, cGame.s_camViewportH, cGame.s_camViewX, cGame.s_camViewY, cGame.s_camViewZ, cGame.s_camUpX, cGame.s_camUpY, cGame.s_camUpZ, cGame.s_camRightX, cGame.s_camRightY, cGame.s_camRightZ, cGame.s_camTransformX, cGame.s_camTransformY, cGame.s_camTransformZ, 0, skyViewportY - 10);
                                                    s_skyTransform.setIdentity();
                                                    s_skyTransform.postTranslate((float)cMath.s_3DPosX / PLATFORM.mCoord2JsrDivider, (float)cMath.s_3DPosY / PLATFORM.mCoord2JsrDivider, (float)cMath.s_3DPosZ / PLATFORM.mCoord2JsrDivider);
                                                }
                                                yaw = -yaw;
                                                yaw = (int)((float)(yaw + 0x100000 & 0xFFF) / 11.37f);
                                                ScreenX = yaw * s_skyLayer1Width * 1 / 360 % s_skyLayer1Width - (cGame.s_screenWidth >> 1);
                                                if (use3DSky) break block18;
                                                if (ScreenX < 0) {
                                                    s_skyLayer1.PaintFrame(g, 0, -ScreenX, topLayer1, 0);
                                                    s_skyLayer1.PaintFrame(g, 0, -ScreenX - s_skyLayer1Width, topLayer1, 0);
                                                    s_skyLayer1.PaintFrame(g, 0, -ScreenX + s_skyLayer1Width, topLayer1, 0);
                                                } else if (ScreenX > 0) {
                                                    s_skyLayer1.PaintFrame(g, 0, -ScreenX + s_skyLayer1Width, topLayer1, 0);
                                                    s_skyLayer1.PaintFrame(g, 0, -ScreenX + s_skyLayer1Width * 2, topLayer1, 0);
                                                    s_skyLayer1.PaintFrame(g, 0, -ScreenX, topLayer1, 0);
                                                } else {
                                                    s_skyLayer1.PaintFrame(g, 0, 0, topLayer1, 0);
                                                    s_skyLayer1.PaintFrame(g, 0, s_skyLayer1Width, topLayer1, 0);
                                                }
                                                break block19;
                                            }
                                            skyViewportY = cGame.s_interfaceTop + (cGame.s_viewportHeight >> 1) - topLayer1 - (s_skyLayer1Height >> 1);
                                            cMath.get3DFromScrCoor(cGame.s_camNearView, cGame.s_camW, cGame.s_camH, cGame.s_camViewportW, cGame.s_camViewportH, cGame.s_camViewX, cGame.s_camViewY, cGame.s_camViewZ, cGame.s_camUpX, cGame.s_camUpY, cGame.s_camUpZ, cGame.s_camRightX, cGame.s_camRightY, cGame.s_camRightZ, cGame.s_camTransformX, cGame.s_camTransformY, cGame.s_camTransformZ, 0, skyViewportY);
                                            s_skyTransform.setIdentity();
                                            s_skyTransform.postTranslate((float)cMath.s_3DPosX / PLATFORM.mCoord2JsrDivider, (float)cMath.s_3DPosY / PLATFORM.mCoord2JsrDivider, (float)cMath.s_3DPosZ / PLATFORM.mCoord2JsrDivider);
                                            cropX1 = -(s_skyLayer1Width - cGame.s_screenWidth >> 1);
                                            cropX2 = -(s_skyLayer1Width - cGame.s_screenWidth >> 1);
                                            if (ScreenX >= 0) break block20;
                                            cropX1 -= -ScreenX;
                                            var10000 = cropX2 - (-ScreenX - s_skyLayer1Width);
                                            break block21;
                                        }
                                        if (ScreenX <= 0) break block22;
                                        cropX1 += ScreenX;
                                        var10000 = cropX2 + (ScreenX - s_skyLayer1Width);
                                    }
                                    cropX2 = var10000;
                                }
                                s_skySPR3DLayer1.setCrop(cropX1, 0, s_skyLayer1Width, s_skyLayer1Height);
                                g3d.render((Node)s_skySPR3DLayer1, s_skyTransform);
                                if (cropX2 != cropX1) {
                                    s_skySPR3DLayer1.setCrop(cropX2, 0, s_skyLayer1Width, s_skyLayer1Height);
                                    g3d.render((Node)s_skySPR3DLayer1, s_skyTransform);
                                }
                            }
                            ScreenX = yaw * s_skyLayer2Width * 3 / 360 % s_skyLayer2Width - (cGame.s_screenWidth >> 1);
                            if (use3DSky) break block23;
                            if (ScreenX < 0) {
                                s_skyLayer2.PaintFrame(g, 0, -ScreenX, topLayer2, 0);
                                s_skyLayer2.PaintFrame(g, 0, -ScreenX - s_skyLayer2Width, topLayer2, 0);
                                s_skyLayer2.PaintFrame(g, 0, -ScreenX + s_skyLayer2Width, topLayer2, 0);
                            } else if (ScreenX > 0) {
                                s_skyLayer2.PaintFrame(g, 0, -ScreenX + s_skyLayer2Width, topLayer2, 0);
                                s_skyLayer2.PaintFrame(g, 0, -ScreenX + s_skyLayer2Width * 2, topLayer2, 0);
                                s_skyLayer2.PaintFrame(g, 0, -ScreenX, topLayer2, 0);
                            } else {
                                s_skyLayer2.PaintFrame(g, 0, 0, topLayer2, 0);
                                s_skyLayer2.PaintFrame(g, 0, s_skyLayer2Width, topLayer2, 0);
                            }
                            break block24;
                        }
                        skyViewportY = cGame.s_interfaceTop + (cGame.s_viewportHeight >> 1) - topLayer2 - (s_skyLayer2Height >> 1);
                        cMath.get3DFromScrCoor(cGame.s_camNearView, cGame.s_camW, cGame.s_camH, cGame.s_camViewportW, cGame.s_camViewportH, cGame.s_camViewX, cGame.s_camViewY, cGame.s_camViewZ, cGame.s_camUpX, cGame.s_camUpY, cGame.s_camUpZ, cGame.s_camRightX, cGame.s_camRightY, cGame.s_camRightZ, cGame.s_camTransformX, cGame.s_camTransformY, cGame.s_camTransformZ, 0, skyViewportY);
                        s_skyTransform.setIdentity();
                        s_skyTransform.postTranslate((float)cMath.s_3DPosX / PLATFORM.mCoord2JsrDivider, (float)cMath.s_3DPosY / PLATFORM.mCoord2JsrDivider, (float)cMath.s_3DPosZ / PLATFORM.mCoord2JsrDivider);
                        cropX1 = -(s_skyLayer2Width - cGame.s_screenWidth >> 1);
                        cropX2 = -(s_skyLayer2Width - cGame.s_screenWidth >> 1);
                        if (ScreenX >= 0) break block25;
                        cropX1 -= -ScreenX;
                        var10000 = cropX2 - (-ScreenX - s_skyLayer2Width);
                        break block26;
                    }
                    if (ScreenX <= 0) break block27;
                    cropX1 += ScreenX;
                    var10000 = cropX2 + (ScreenX - s_skyLayer2Width);
                }
                cropX2 = var10000;
            }
            s_skySPR3DLayer2.setCrop(cropX1, 0, s_skyLayer2Width, s_skyLayer2Height);
            g3d.render((Node)s_skySPR3DLayer2, s_skyTransform);
            if (cropX2 != cropX1) {
                s_skySPR3DLayer2.setCrop(cropX2, 0, s_skyLayer2Width, s_skyLayer2Height);
                g3d.render((Node)s_skySPR3DLayer2, s_skyTransform);
            }
        }
        top = topLayer2 + s_skyLayer2Height;
        if (!use3DSky) {
            g.setColor(s_groundColor);
            g.fillRect(0, top, cGame.s_screenWidth, cGame.s_screenHeight - top);
        }
    }

    static void unload() {
        int ___i;
        if (s_whiteLight != null) {
            s_whiteLight.unload();
            s_whiteLight = null;
        }
        if (s_redLight != null) {
            s_redLight.unload();
            s_redLight = null;
        }
        for (___i = 0; ___i < s_objectCount; ++___i) {
            if (s_objects[___i] == null) continue;
            s_objects[___i].unload();
            cRoad.s_objects[___i] = null;
        }
        if (s_objects != null) {
            for (___i = 0; ___i < s_objects.length; ++___i) {
                cRoad.s_objects[___i] = null;
            }
            s_objects = null;
        }
        s_objectTypes = null;
        s_objectRoadsCount = null;
        s_objectRoadsNumber = null;
        s_objectVertexIdx = null;
        s_segmentsList = null;
        s_objectList = null;
        s_availableRoads = null;
        s_roadLength = null;
        s_vtxCount = null;
        if (s_roadTransforms != null) {
            for (___i = 0; ___i < s_roadTransforms.length; ++___i) {
                cRoad.s_roadTransforms[___i] = null;
            }
            s_roadTransforms = null;
        }
        for (___i = 0; ___i < s_numberOfIntersections; ++___i) {
            s_intersections[___i].unloadIntersection();
            cRoad.s_intersections[___i] = null;
        }
        cIntersection.s_textureFenceIntersection = null;
        cIntersection.s_intersectionFenceAppearance = null;
        s_intersections = null;
        s_roadIntersection = null;
        if (s_roadAppearance != null) {
            s_roadAppearance.setCompositingMode((CompositingMode)null);
            s_roadAppearance.setPolygonMode((PolygonMode)null);
            s_roadAppearance.setMaterial((Material)null);
            s_roadAppearance.setTexture(0, (Texture2D)null);
            s_roadAppearance = null;
        }
        s_roadAppearance = null;
        s_fencePolygonMode = null;
        if (s_fenceTexture != null) {
            s_fenceTexture.unload();
            s_fenceTexture = null;
        }
        if (s_fenceAppearance != null) {
            s_fenceAppearance.setCompositingMode((CompositingMode)null);
            s_fenceAppearance.setPolygonMode((PolygonMode)null);
            s_fenceAppearance.setMaterial((Material)null);
            s_fenceAppearance.setTexture(0, (Texture2D)null);
            s_fenceAppearance = null;
        }
        s_fenceAppearance = null;
        if (s_roadTexture != null) {
            s_roadTexture.unload();
            s_roadTexture = null;
        }
        for (___i = 0; ___i < s_numberOfRoads; ++___i) {
            cRoad.s_roadYaws[___i] = null;
        }
        if (s_vtx != null) {
            for (___i = 0; ___i < s_vtx.length; ++___i) {
                cRoad.s_vtx[___i] = null;
            }
            s_vtx = null;
        }
        if (s_dist != null) {
            for (___i = 0; ___i < s_dist.length; ++___i) {
                cRoad.s_dist[___i] = null;
            }
            s_dist = null;
        }
        if (s_sections != null) {
            for (___i = 0; ___i < s_sections.length; ++___i) {
                cRoad.s_sections[___i] = null;
            }
            s_sections = null;
        }
        s_sectionCount = null;
        s_roadsInRenderList = null;
        s_IntersectionsRenderList = null;
        if (s_skyLayer1 != null) {
            s_skyLayer1.unload();
            s_skyLayer1 = null;
        }
        if (s_skyLayer2 != null) {
            s_skyLayer2.unload();
            s_skyLayer2 = null;
        }
        cRoad.unloadRaces();
        cGame.Call_System_GC(false);
    }

    private static void unloadRaces() {
        int ___i;
        s_raceType = null;
        s_raceNumberOfEnemyes = null;
        s_raceNrOfLaps = null;
        s_raceStartRoad = null;
        s_raceStartSegment = null;
        s_raceEndRoad = null;
        s_raceEndSegment = null;
        s_raceNrCheckPoints = null;
        s_raceNrObjects = null;
        s_raceNrHelperPoints = null;
        if (s_raceRoadCheckPoints != null) {
            for (___i = 0; ___i < s_raceRoadCheckPoints.length; ++___i) {
                cRoad.s_raceRoadCheckPoints[___i] = null;
            }
            s_raceRoadCheckPoints = null;
        }
        if (s_raceSegmentCheckPoints != null) {
            for (___i = 0; ___i < s_raceSegmentCheckPoints.length; ++___i) {
                cRoad.s_raceSegmentCheckPoints[___i] = null;
            }
            s_raceSegmentCheckPoints = null;
        }
        if (s_raceRoadHelperPoints != null) {
            for (___i = 0; ___i < s_raceRoadHelperPoints.length; ++___i) {
                cRoad.s_raceRoadHelperPoints[___i] = null;
            }
            s_raceRoadHelperPoints = null;
        }
        if (s_raceObjectsRoad != null) {
            for (___i = 0; ___i < s_raceObjectsRoad.length; ++___i) {
                cRoad.s_raceObjectsRoad[___i] = null;
            }
            s_raceObjectsRoad = null;
        }
        if (s_raceObjectsSegment != null) {
            for (___i = 0; ___i < s_raceObjectsSegment.length; ++___i) {
                cRoad.s_raceObjectsSegment[___i] = null;
            }
            s_raceObjectsSegment = null;
        }
        if (s_raceObjectsLane != null) {
            for (___i = 0; ___i < s_raceObjectsLane.length; ++___i) {
                cRoad.s_raceObjectsLane[___i] = null;
            }
            s_raceObjectsLane = null;
        }
        s_raceTime = null;
        s_racePoints = null;
        s_raceBonusNr = null;
        if (s_raceBonusRoad != null) {
            for (___i = 0; ___i < s_raceBonusRoad.length; ++___i) {
                cRoad.s_raceBonusRoad[___i] = null;
            }
            s_raceBonusRoad = null;
        }
        if (s_raceBonusSegment != null) {
            for (___i = 0; ___i < s_raceBonusSegment.length; ++___i) {
                cRoad.s_raceBonusSegment[___i] = null;
            }
            s_raceBonusSegment = null;
        }
        if (s_raceBonusLane != null) {
            for (___i = 0; ___i < s_raceBonusLane.length; ++___i) {
                cRoad.s_raceBonusLane[___i] = null;
            }
            s_raceBonusLane = null;
        }
        if (s_raceBonusType != null) {
            for (___i = 0; ___i < s_raceBonusType.length; ++___i) {
                cRoad.s_raceBonusType[___i] = null;
            }
            s_raceBonusType = null;
        }
        s_driftRoads = null;
        s_driftStartSeg = null;
        s_driftEndSeg = null;
    }

    static void updateSectionsList() {
        block13: {
            boolean inFront;
            boolean var10000;
            int var10;
            short var11;
            int currentSegment;
            int i;
            boolean wrongWay;
            int segmentsToRenderBack;
            block12: {
                boolean segmentsToRenderFront = false;
                segmentsToRenderBack = cGame.s_gameSubState != 3 && cGame.s_gameSubState != 20 ? 2 : 10;
                boolean roadsInIntersection = false;
                cGame.s_playerCar.UpdateWrongWay();
                wrongWay = cGame.s_playerCar.mWrongway;
                roadIdx = 0;
                s_ObjectsInList = 0;
                for (i = 0; i < s_numberOfRoads; ++i) {
                    cRoad.s_roadsInRenderList[i] = false;
                }
                if (s_currentIntersection == -1) break block12;
                int var102 = cRoad.getNextRoads(s_currentIntersection, -1);
                for (i = 0; i < var102; ++i) {
                    boolean var100002;
                    int currentSegment2;
                    if (s_nextRoadsList[i][1] == 1) {
                        currentSegment2 = s_vtxCount[s_nextRoadsList[i][0]] - 1;
                        var100002 = false;
                    } else {
                        currentSegment2 = 0;
                        var100002 = true;
                    }
                    boolean roadSide = var100002;
                    cRoad.s_segmentsList[cRoad.roadIdx][0] = s_nextRoadsList[i][0];
                    cRoad.s_roadsInRenderList[cRoad.s_nextRoadsList[i][0]] = true;
                    cRoad.addToSegmentList(s_nextRoadsList[i][0], currentSegment2, 5, roadSide);
                }
                break block13;
            }
            int currentRoad = s_currentSpline;
            int n = currentSegment = wrongWay ? s_currentSegment + 1 : s_currentSegment - 1;
            if (segmentsToRenderBack > 0) {
                var11 = (short)(wrongWay ? 1 : 0);
                cRoad.s_segmentsList[cRoad.roadIdx][0] = (short)currentRoad;
                cRoad.s_roadsInRenderList[currentRoad] = true;
                if ((segmentsToRenderBack = segmentsToRenderBack - cRoad.addToSegmentList(currentRoad, currentSegment, segmentsToRenderBack, wrongWay) >> 1) > 0 && s_roadIntersection[currentRoad][var11] != -1) {
                    var10 = cRoad.getNextRoads(s_roadIntersection[currentRoad][var11], currentRoad);
                    for (i = 0; i < var10; ++i) {
                        if (s_nextRoadsList[i][1] == 1) {
                            currentSegment = s_vtxCount[s_nextRoadsList[i][0]] - 1;
                            var10000 = false;
                        } else {
                            currentSegment = 0;
                            var10000 = true;
                        }
                        inFront = var10000;
                        cRoad.s_segmentsList[cRoad.roadIdx][0] = s_nextRoadsList[i][0];
                        cRoad.s_roadsInRenderList[cRoad.s_nextRoadsList[i][0]] = true;
                        cRoad.addToSegmentList(s_nextRoadsList[i][0], currentSegment, segmentsToRenderBack, inFront);
                    }
                }
            }
            currentRoad = s_currentSpline;
            currentSegment = s_currentSegment;
            var11 = (short)(!wrongWay ? 1 : 0);
            cRoad.s_segmentsList[cRoad.roadIdx][0] = (short)currentRoad;
            cRoad.s_roadsInRenderList[currentRoad] = true;
            int var9 = 10 - cRoad.addToSegmentList(currentRoad, currentSegment, 10, !wrongWay);
            if ((var9 >>= 1) <= 0 || s_roadIntersection[currentRoad][var11] == -1) break block13;
            var10 = cRoad.getNextRoads(s_roadIntersection[currentRoad][var11], currentRoad);
            for (i = 0; i < var10; ++i) {
                if (s_nextRoadsList[i][1] == 1) {
                    currentSegment = s_vtxCount[s_nextRoadsList[i][0]] - 1;
                    var10000 = false;
                } else {
                    currentSegment = 0;
                    var10000 = true;
                }
                inFront = var10000;
                cRoad.s_segmentsList[cRoad.roadIdx][0] = s_nextRoadsList[i][0];
                cRoad.s_roadsInRenderList[cRoad.s_nextRoadsList[i][0]] = true;
                cRoad.addToSegmentList(s_nextRoadsList[i][0], currentSegment, var9, inFront);
            }
        }
    }

    static void updateObjectsList() {
        boolean added = false;
        for (int i = 0; i < s_objectCount; ++i) {
            if (s_objects[i] == null) continue;
            added = false;
            block1: for (int j = 0; j < s_objectRoadsCount[i] && !added; ++j) {
                if (!s_roadsInRenderList[s_objectRoadsNumber[2 * i + j]]) continue;
                for (int k = 0; k < roadIdx && !added; ++k) {
                    int viewDist;
                    int var10001;
                    int var10000;
                    if (s_objectRoadsNumber[2 * i + j] != s_segmentsList[k][0] || s_objectVertexIdx[2 * i + j] < s_segmentsList[k][1] || s_objectVertexIdx[2 * i + j] > s_segmentsList[k][2]) continue;
                    if (s_currentIntersection == -1) {
                        var10000 = s_currentSpline;
                        var10001 = s_currentSegment;
                    } else {
                        short radius = (short)(cRoad.getSplineIntersectionHead((short)s_currentIntersection, s_segmentsList[k][0]) == 0 ? 0 : s_vtxCount[s_segmentsList[k][0]] - 1);
                        var10000 = s_segmentsList[k][0];
                        var10001 = radius;
                    }
                    int dist = cRoad.getDistance(var10000, var10001, s_segmentsList[k][0], s_objectVertexIdx[2 * i + j]);
                    int var7 = s_objects[i].getPropRadius();
                    int n = 2 * (PLATFORM.bDoubleViewDistance ? 7500 : 4500) < s_objects[i].getPropViewDistance() ? 2 * (PLATFORM.bDoubleViewDistance ? 7500 : 4500) : (viewDist = s_objects[i].getPropViewDistance());
                    if (dist < var7 || dist >= viewDist) continue;
                    short s = s_ObjectsInList;
                    s_ObjectsInList = (short)(s + 1);
                    cRoad.s_objectList[s] = (short)i;
                    added = true;
                    continue block1;
                }
            }
        }
    }

    static void updateIntersectionsList() {
        if (s_currentIntersection != -1) {
            cRoad.s_IntersectionsRenderList[0] = (short)s_currentIntersection;
            for (int i = 1; i < 2; ++i) {
                cRoad.s_IntersectionsRenderList[i] = -1;
            }
        } else {
            for (int i = 0; i < 2; ++i) {
                cRoad.s_IntersectionsRenderList[i] = s_roadIntersection[s_currentSpline][i];
            }
        }
    }

    private static short addToSegmentList(int road, int startSegment, int segmentsToRender, boolean inFront) {
        int endSegment;
        boolean shouldIncreaseIdx;
        int oldEndSeg;
        int oldStartSeg;
        block9: {
            int var10000;
            block8: {
                block7: {
                    if (startSegment < 0) {
                        return 0;
                    }
                    oldStartSeg = 9999;
                    oldEndSeg = -1;
                    int currentIdx = roadIdx;
                    shouldIncreaseIdx = true;
                    for (endSegment = 0; endSegment < roadIdx; ++endSegment) {
                        if (s_segmentsList[endSegment][0] != road) continue;
                        oldStartSeg = s_segmentsList[endSegment][1];
                        oldEndSeg = s_segmentsList[endSegment][2];
                        currentIdx = endSegment;
                        shouldIncreaseIdx = false;
                        break;
                    }
                    if ((endSegment = startSegment + (inFront ? 1 : -1) * segmentsToRender) >= 0) break block7;
                    var10000 = 0;
                    break block8;
                }
                if (endSegment <= s_vtxCount[road] - 1) break block9;
                var10000 = s_vtxCount[road] - 1;
            }
            endSegment = var10000;
        }
        if (endSegment < startSegment) {
            int tmp = endSegment;
            endSegment = startSegment;
            startSegment = tmp;
        }
        cRoad.s_segmentsList[currentIdx][1] = (short)(oldStartSeg < startSegment ? oldStartSeg : startSegment);
        cRoad.s_segmentsList[currentIdx][2] = (short)(oldEndSeg > endSegment ? oldEndSeg : endSegment);
        if (shouldIncreaseIdx) {
            ++roadIdx;
        }
        return (short)(endSegment - startSegment < 0 ? -(endSegment - startSegment) : endSegment - startSegment);
    }

    private static int getNextRoads(int intersectionNumber, int currentRoad) {
        int roadNumber = cRoad.s_intersections[intersectionNumber].nrRoads;
        int resultLength = roadNumber - 1;
        if (currentRoad == -1) {
            ++resultLength;
        }
        short[][] roads = s_nextRoadsList;
        int index = 0;
        for (int i = 0; i < roadNumber; ++i) {
            if (cRoad.s_intersections[intersectionNumber].roads[i] == currentRoad) continue;
            roads[index][0] = cRoad.s_intersections[intersectionNumber].roads[i];
            roads[index][1] = cRoad.getSplineIntersectionHead((short)intersectionNumber, roads[index][0]);
            ++index;
        }
        return resultLength;
    }

    private static byte getSplineIntersectionHead(short intersection, short road) {
        for (int i = 0; i < 2; ++i) {
            if (s_roadIntersection[road][i] != intersection) continue;
            return (byte)i;
        }
        return -1;
    }

    static void buildFences(int cityIdx) {
        if (s_fenceVtxBuffer == null) {
            s_fenceVtxBuffer = new VertexBuffer[cGame.k_cityCount][][];
        }
        if (s_fenceIdxBuffer == null) {
            s_fenceIdxBuffer = new TriangleStripArray[cGame.k_cityCount][];
        }
        if (s_fenceVtxBuffer[cityIdx] == null) {
            cRoad.s_fenceVtxBuffer[cityIdx] = new VertexBuffer[s_numberOfRoads][2];
        }
        if (s_fenceIdxBuffer[cityIdx] == null) {
            cRoad.s_fenceIdxBuffer[cityIdx] = new TriangleStripArray[s_numberOfRoads];
        }
        if (s_fenceTransform == null) {
            s_fenceTransform = new Transform();
        }
        for (int i = 0; i < s_numberOfRoads; ++i) {
            int stripLength;
            int j;
            short extraVertex = (short)((s_vtxCount[i] - 1) % 1 != 0 ? 1 : 0);
            int vertexPerRoadSide = (s_vtxCount[i] - 1) / 1 + 1 + extraVertex;
            short[][] vtx = new short[2][vertexPerRoadSide * 3 * 2];
            byte[] tex = new byte[(vertexPerRoadSide - 1) * 4 * 2];
            VertexArray vertArrayL = new VertexArray(vertexPerRoadSide * 2, 3, 2);
            VertexArray vertArrayR = new VertexArray(vertexPerRoadSide * 2, 3, 2);
            VertexArray texArrayL = new VertexArray(vertexPerRoadSide * 2, 2, 1);
            for (j = 0; j < vertexPerRoadSide - extraVertex; ++j) {
                vtx[0][j * 6 + 0] = (short)((s_vtx[i][j * 6 * 1 + 0] - s_vtx[i][0]) / 8);
                vtx[0][j * 6 + 1] = (short)((s_vtx[i][j * 6 * 1 + 1] - s_vtx[i][1]) / 8);
                vtx[0][j * 6 + 2] = (short)((s_vtx[i][j * 6 * 1 + 2] - s_vtx[i][2]) / 8);
                vtx[0][j * 6 + 3] = (short)((s_vtx[i][j * 6 * 1 + 0] - s_vtx[i][0]) / 8);
                vtx[0][j * 6 + 4] = (short)((s_vtx[i][j * 6 * 1 + 1] - s_vtx[i][1]) / 8);
                vtx[0][j * 6 + 5] = (short)((s_vtx[i][j * 6 * 1 + 2] - s_vtx[i][2]) / 8 + 20);
                vtx[1][j * 6 + 0] = (short)((s_vtx[i][j * 6 * 1 + 3] - s_vtx[i][3]) / 8);
                vtx[1][j * 6 + 1] = (short)((s_vtx[i][j * 6 * 1 + 4] - s_vtx[i][4]) / 8);
                vtx[1][j * 6 + 2] = (short)((s_vtx[i][j * 6 * 1 + 5] - s_vtx[i][5]) / 8);
                vtx[1][j * 6 + 3] = (short)((s_vtx[i][j * 6 * 1 + 3] - s_vtx[i][3]) / 8);
                vtx[1][j * 6 + 4] = (short)((s_vtx[i][j * 6 * 1 + 4] - s_vtx[i][4]) / 8);
                vtx[1][j * 6 + 5] = (short)((s_vtx[i][j * 6 * 1 + 5] - s_vtx[i][5]) / 8 + 20);
            }
            if (extraVertex != 0) {
                stripLength = 3 * s_vtxCount[i] * 2;
                vtx[0][vertexPerRoadSide * 6 - 6] = (short)((s_vtx[i][stripLength - 6] - s_vtx[i][0]) / 8);
                vtx[0][vertexPerRoadSide * 6 - 5] = (short)((s_vtx[i][stripLength - 5] - s_vtx[i][1]) / 8);
                vtx[0][vertexPerRoadSide * 6 - 4] = (short)((s_vtx[i][stripLength - 4] - s_vtx[i][2]) / 8);
                vtx[0][vertexPerRoadSide * 6 - 3] = (short)((s_vtx[i][stripLength - 6] - s_vtx[i][0]) / 8);
                vtx[0][vertexPerRoadSide * 6 - 2] = (short)((s_vtx[i][stripLength - 5] - s_vtx[i][0]) / 8);
                vtx[0][vertexPerRoadSide * 6 - 1] = (short)((s_vtx[i][stripLength - 4] - s_vtx[i][0]) / 8 + 20);
                vtx[1][vertexPerRoadSide * 6 - 6] = (short)((s_vtx[i][stripLength - 2] - s_vtx[i][3]) / 8);
                vtx[1][vertexPerRoadSide * 6 - 5] = (short)((s_vtx[i][stripLength - 1] - s_vtx[i][4]) / 8);
                vtx[1][vertexPerRoadSide * 6 - 4] = (short)((s_vtx[i][stripLength - 0] - s_vtx[i][5]) / 8);
                vtx[1][vertexPerRoadSide * 6 - 3] = (short)((s_vtx[i][stripLength - 2] - s_vtx[i][3]) / 8);
                vtx[1][vertexPerRoadSide * 6 - 2] = (short)((s_vtx[i][stripLength - 1] - s_vtx[i][3]) / 8);
                vtx[1][vertexPerRoadSide * 6 - 1] = (short)((s_vtx[i][stripLength - 0] - s_vtx[i][3]) / 8 + 20);
            }
            vertArrayL.set(0, vertexPerRoadSide * 2, vtx[0]);
            vertArrayR.set(0, vertexPerRoadSide * 2, vtx[1]);
            for (j = 0; j < vertexPerRoadSide - 1; ++j) {
                tex[j * 8 + 0] = 0;
                tex[j * 8 + 1] = 0;
                tex[j * 8 + 2] = 0;
                tex[j * 8 + 3] = 1;
                tex[j * 8 + 4] = 1;
                tex[j * 8 + 5] = 0;
                tex[j * 8 + 6] = 1;
                tex[j * 8 + 7] = 1;
            }
            texArrayL.set(0, vertexPerRoadSide * 2, tex);
            if (s_fenceVtxBuffer[cityIdx][i][0] == null) {
                cRoad.s_fenceVtxBuffer[cityIdx][i][0] = new VertexBuffer();
                s_fenceVtxBuffer[cityIdx][i][0].setPositions(vertArrayL, 8.0f / PLATFORM.mCoord2JsrDivider, (float[])null);
                s_fenceVtxBuffer[cityIdx][i][0].setTexCoords(0, texArrayL, 1.0f, (float[])null);
            }
            if (s_fenceVtxBuffer[cityIdx][i][1] == null) {
                cRoad.s_fenceVtxBuffer[cityIdx][i][1] = new VertexBuffer();
                s_fenceVtxBuffer[cityIdx][i][1].setPositions(vertArrayR, 8.0f / PLATFORM.mCoord2JsrDivider, (float[])null);
                s_fenceVtxBuffer[cityIdx][i][1].setTexCoords(0, texArrayL, 1.0f, (float[])null);
            }
            stripLength = vertexPerRoadSide * 2;
            int[] nArray = new int[1];
            int[] stripLen = nArray;
            nArray[0] = stripLength;
            if (s_fenceIdxBuffer[cityIdx][i] != null) continue;
            cRoad.s_fenceIdxBuffer[cityIdx][i] = new TriangleStripArray(0, stripLen);
        }
    }

    static void loadFenceTexture(int texIndex) {
        s_fenceTexture = new cTexture();
        s_fenceAppearance = new Appearance();
        s_fencePolygonMode = new PolygonMode[2];
        for (int i = 0; i < 2; ++i) {
            cRoad.s_fencePolygonMode[i] = new PolygonMode();
            PolygonMode var10000 = s_fencePolygonMode[i];
            var10000.setCulling(162);
            s_fencePolygonMode[i].setPerspectiveCorrectionEnable(true);
        }
        s_fenceTexture = cTexture.getTexture(1, texIndex, false, false, 241, 241, false, false);
        s_fenceAppearance.setTexture(0, cRoad.s_fenceTexture.mTexture);
    }

    static int getRoadBetweenIntersections(int inter1, int inter2) {
        for (int i = 0; i < cRoad.s_intersections[inter1].nrRoads; ++i) {
            if ((s_roadIntersection[cRoad.s_intersections[inter1].roads[i]][0] != inter1 || s_roadIntersection[cRoad.s_intersections[inter1].roads[i]][1] != inter2) && (s_roadIntersection[cRoad.s_intersections[inter1].roads[i]][0] != inter2 || s_roadIntersection[cRoad.s_intersections[inter1].roads[i]][1] != inter1)) continue;
            return cRoad.s_intersections[inter1].roads[i];
        }
        return -1;
    }

    static void loadTracksInfo(byte[] roadData, int i) {
        int off = 0;
        int var4 = off + 1;
        int var10002 = roadData[0] & 0xFF;
        ++var4;
        var10002 += (roadData[1] & 0xFF) << 8;
        ++var4;
        ++var4;
        cGame.s_infoTrackNames[i] = (var10002 += (roadData[2] & 0xFF) << 16) + ((roadData[3] & 0xFF) << 24);
        ++var4;
        cGame.s_infoRaceNumbers[i] = (byte)((roadData[4] & 0xFF) + 1);
        cGame.s_infoRaceType[i] = new byte[cGame.s_infoRaceNumbers[i]];
        cGame.s_infoRaceX[i] = new int[cGame.s_infoRaceNumbers[i]];
        cGame.s_infoRaceY[i] = new int[cGame.s_infoRaceNumbers[i]];
        cGame.s_infoRaceReward[i] = new short[cGame.s_infoRaceNumbers[i]];
        cGame.s_infoRaceRewardStep[i] = new short[cGame.s_infoRaceNumbers[i]];
        cGame.s_infoRaceName[i] = new int[cGame.s_infoRaceNumbers[i]];
        cGame.s_infoRaceDescription[i] = new int[cGame.s_infoRaceNumbers[i]];
        for (int j = 0; j < cGame.s_infoRaceNumbers[i]; ++j) {
            cGame.s_infoRaceType[i][j] = (byte)(roadData[var4++] & 0xFF);
            cGame.s_infoRaceX[i][j] = (roadData[var4++] & 0xFF) + ((roadData[var4++] & 0xFF) << 8) + ((roadData[var4++] & 0xFF) << 16) + ((roadData[var4++] & 0xFF) << 24);
            cGame.s_infoRaceY[i][j] = (roadData[var4++] & 0xFF) + ((roadData[var4++] & 0xFF) << 8) + ((roadData[var4++] & 0xFF) << 16) + ((roadData[var4++] & 0xFF) << 24);
            cGame.s_infoRaceReward[i][j] = (short)((roadData[var4++] & 0xFF) + ((roadData[var4++] & 0xFF) << 8));
            cGame.s_infoRaceRewardStep[i][j] = (short)((roadData[var4++] & 0xFF) + ((roadData[var4++] & 0xFF) << 8));
            cGame.s_infoRaceName[i][j] = (roadData[var4++] & 0xFF) + ((roadData[var4++] & 0xFF) << 8) + ((roadData[var4++] & 0xFF) << 16) + ((roadData[var4++] & 0xFF) << 24);
            cGame.s_infoRaceDescription[i][j] = (roadData[var4++] & 0xFF) + ((roadData[var4++] & 0xFF) << 8) + ((roadData[var4++] & 0xFF) << 16) + ((roadData[var4++] & 0xFF) << 24);
        }
        cRoad.s_mapWorldMinX[i] = (roadData[var4++] & 0xFF) + ((roadData[var4++] & 0xFF) << 8) + ((roadData[var4++] & 0xFF) << 16) + ((roadData[var4++] & 0xFF) << 24);
        cRoad.s_mapWorldMaxX[i] = (roadData[var4++] & 0xFF) + ((roadData[var4++] & 0xFF) << 8) + ((roadData[var4++] & 0xFF) << 16) + ((roadData[var4++] & 0xFF) << 24);
        cRoad.s_mapWorldMaxY[i] = (roadData[var4++] & 0xFF) + ((roadData[var4++] & 0xFF) << 8) + ((roadData[var4++] & 0xFF) << 16) + ((roadData[var4] & 0xFF) << 24);
    }

    static boolean inCamBoundingSphere(long distsq, int x, int y) {
        long xDist = (long)(cGame.s_camX - x) * (long)(cGame.s_camX - x);
        long yDist = (long)(cGame.s_camY - y) * (long)(cGame.s_camY - y);
        return xDist + yDist < distsq;
    }

    static {
        s_roadPolygonMode = new PolygonMode();
        off = 0;
        s_numberOfRaces = 0;
        s_tempRoadData = null;
        s_lastJumpPlatform = -1;
        s_carTargetZ = 0;
        s_bCarIsLanding = true;
        s_barriersNumber = new int[]{3, 5, 7, 8, 7, 6};
        s_jumpSucceeded = new byte[s_barriersNumber.length];
        s_sectionsToRender = new short[4];
        s_rotationAngle = 0;
        roadIdx = 0;
        s_nextRoadsList = new short[5][2];
    }
}

