/*
 * Decompiled with CFR 0.152.
 */
package aeMods.z1Model;

import aeMods.z1Model.Polygon;
import aeMods.z1Model.PolygonInfo;
import aeMods.z1Model.Vector3D;
import aeMods.z1Model.Z1Model;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public class Loader {
    public static Z1Model loadModel(String path) {
        try {
            int i;
            InputStream is = new Object().getClass().getResourceAsStream(path);
            DataInputStream dis = new DataInputStream(is);
            dis.skipBytes(16);
            PolygonInfo[] submeshes = new PolygonInfo[dis.readByte()];
            for (int i2 = 0; i2 < submeshes.length; ++i2) {
                submeshes[i2] = new PolygonInfo(Loader.readString(dis), dis.readByte(), dis.readByte(), dis.readByte());
            }
            Vector3D[] positions = new Vector3D[dis.readShort()];
            for (int i3 = 0; i3 < positions.length; ++i3) {
                positions[i3] = new Vector3D(dis.readByte(), dis.readByte(), dis.readByte());
            }
            Vector3D[] normals = new Vector3D[dis.readShort()];
            for (int i4 = 0; i4 < normals.length; ++i4) {
                normals[i4] = new Vector3D(dis.readByte(), dis.readByte(), dis.readByte());
            }
            int uvXAdd = dis.readInt();
            int uvYAdd = dis.readInt();
            int uvScale = dis.readInt();
            Vector3D[] uvs = new Vector3D[dis.readShort()];
            for (int i5 = 0; i5 < uvs.length; ++i5) {
                uvs[i5] = new Vector3D(dis.readUnsignedByte() + uvXAdd, dis.readUnsignedByte() + uvYAdd, 0);
            }
            Polygon[] pols = new Polygon[dis.readShort()];
            for (i = 0; i < pols.length; ++i) {
                pols[i] = new Polygon(new PolygonInfo(submeshes[dis.readByte()]));
                dis.skipBytes(1);
            }
            for (i = 0; i < pols.length; ++i) {
                pols[i].setPosition(positions[dis.readShort()], positions[dis.readShort()], positions[dis.readShort()]);
            }
            for (i = 0; i < pols.length; ++i) {
                pols[i].setNormals(normals[dis.readShort()], normals[dis.readShort()], normals[dis.readShort()]);
            }
            for (i = 0; i < pols.length; ++i) {
                pols[i].setUV(uvs[dis.readShort()], uvs[dis.readShort()], uvs[dis.readShort()]);
            }
            dis.close();
            is.close();
            return new Z1Model(pols, uvScale);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void exportModel(Z1Model model, String path) {
        try {
            Polygon pol;
            int i;
            Vector3D vec;
            Polygon pol2;
            int i2;
            FileConnection fc = (FileConnection)Connector.open((String)path);
            if (!fc.exists()) {
                fc.create();
            }
            DataOutputStream dos = fc.openDataOutputStream();
            dos.writeLong(0L);
            dos.writeLong(0L);
            int minU = Integer.MAX_VALUE;
            int minV = Integer.MAX_VALUE;
            Vector positions = new Vector();
            Vector normals = new Vector();
            Vector uvs = new Vector();
            Vector submeshes = new Vector();
            for (i2 = 0; i2 < model.pols.length; ++i2) {
                pol2 = model.pols[i2];
                pol2.pinfId = Loader.find(submeshes, (PolygonInfo)pol2.pinf).index;
                pol2.apid = Loader.find(positions, (int)pol2.ax, (int)pol2.ay, (int)pol2.az).index;
                pol2.bpid = Loader.find(positions, (int)pol2.bx, (int)pol2.by, (int)pol2.bz).index;
                pol2.cpid = Loader.find(positions, (int)pol2.cx, (int)pol2.cy, (int)pol2.cz).index;
                pol2.anid = Loader.find(normals, (int)pol2.anx, (int)pol2.any, (int)pol2.anz).index;
                pol2.bnid = Loader.find(normals, (int)pol2.bnx, (int)pol2.bny, (int)pol2.bnz).index;
                pol2.cnid = Loader.find(normals, (int)pol2.cnx, (int)pol2.cny, (int)pol2.cnz).index;
                minU = Math.min(pol2.au, minU);
                minV = Math.min(pol2.av, minV);
                minU = Math.min(pol2.bu, minU);
                minV = Math.min(pol2.bv, minV);
                minU = Math.min(pol2.cu, minU);
                minV = Math.min(pol2.cv, minV);
                pol2.auvid = Loader.find(uvs, (int)pol2.au, (int)pol2.av, (int)0).index;
                pol2.buvid = Loader.find(uvs, (int)pol2.bu, (int)pol2.bv, (int)0).index;
                pol2.cuvid = Loader.find(uvs, (int)pol2.cu, (int)pol2.cv, (int)0).index;
            }
            dos.writeByte((byte)submeshes.size());
            for (i2 = 0; i2 < submeshes.size(); ++i2) {
                PolygonInfo submesh = (PolygonInfo)submeshes.elementAt(i2);
                Loader.writeString(submesh.texName, dos);
                dos.writeByte(submesh.alphaThreshold);
                dos.writeByte(submesh.blendingMode);
                dos.writeByte(submesh.doubleSideRendering);
            }
            dos.writeShort((short)positions.size());
            for (i2 = 0; i2 < positions.size(); ++i2) {
                vec = (Vector3D)positions.elementAt(i2);
                dos.writeByte((byte)vec.x);
                dos.writeByte((byte)vec.y);
                dos.writeByte((byte)vec.z);
            }
            dos.writeShort((short)normals.size());
            for (i2 = 0; i2 < normals.size(); ++i2) {
                vec = (Vector3D)normals.elementAt(i2);
                dos.writeByte((byte)vec.x);
                dos.writeByte((byte)vec.y);
                dos.writeByte((byte)vec.z);
            }
            dos.writeInt(minU);
            dos.writeInt(minV);
            dos.writeInt(model.uvScale);
            dos.writeShort((short)uvs.size());
            for (i2 = 0; i2 < uvs.size(); ++i2) {
                vec = (Vector3D)uvs.elementAt(i2);
                dos.writeByte(vec.x - minU);
                dos.writeByte(vec.y - minV);
            }
            dos.writeShort((short)model.pols.length);
            for (i2 = 0; i2 < model.pols.length; ++i2) {
                pol2 = model.pols[i2];
                dos.writeByte((byte)pol2.pinfId);
                dos.writeByte(3);
            }
            for (i2 = 0; i2 < model.pols.length; ++i2) {
                pol2 = model.pols[i2];
                dos.writeShort((short)pol2.apid);
                dos.writeShort((short)pol2.bpid);
                dos.writeShort((short)pol2.cpid);
                ((Vector3D)positions.elementAt((int)pol2.apid)).index = -1;
                ((Vector3D)positions.elementAt((int)pol2.bpid)).index = -1;
                ((Vector3D)positions.elementAt((int)pol2.cpid)).index = -1;
            }
            int used = 0;
            for (i = 0; i < positions.size(); ++i) {
                if (((Vector3D)positions.elementAt((int)i)).index != -1) continue;
                ++used;
            }
            for (i = 0; i < model.pols.length; ++i) {
                pol = model.pols[i];
                dos.writeShort((short)pol.anid);
                dos.writeShort((short)pol.bnid);
                dos.writeShort((short)pol.cnid);
            }
            for (i = 0; i < model.pols.length; ++i) {
                pol = model.pols[i];
                dos.writeShort((short)pol.auvid);
                dos.writeShort((short)pol.buvid);
                dos.writeShort((short)pol.cuvid);
            }
            dos.close();
            fc.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Vector3D find(Vector vec, Vector3D toFind) {
        return Loader.find(vec, toFind.x, toFind.y, toFind.z);
    }

    public static Vector3D find(Vector vec, int x, int y, int z) {
        for (int i = 0; i < vec.size(); ++i) {
            Vector3D vec3d = (Vector3D)vec.elementAt(i);
            if (!vec3d.compare(x, y, z)) continue;
            return vec3d;
        }
        Vector3D el = new Vector3D(x, y, z);
        el.index = vec.size();
        vec.addElement(el);
        return el;
    }

    public static PolygonInfo find(Vector vec, PolygonInfo pinf) {
        for (int i = 0; i < vec.size(); ++i) {
            PolygonInfo pinf2 = (PolygonInfo)vec.elementAt(i);
            if (!pinf.compare(pinf2)) continue;
            return pinf2;
        }
        PolygonInfo el = new PolygonInfo(pinf);
        el.index = vec.size();
        vec.addElement(el);
        return el;
    }

    public static String readString(DataInputStream dis) throws IOException {
        char[] data = new char[dis.readByte()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (char)dis.readByte();
        }
        return String.valueOf(data);
    }

    public static void writeString(String str, DataOutputStream dos) throws IOException {
        dos.writeByte((byte)str.length());
        for (int i = 0; i < str.length(); ++i) {
            dos.writeByte(str.charAt(i));
        }
    }
}

