/*
 * Decompiled with CFR 0.152.
 */
package aeMods.z1Model;

import aeMods.z1Model.Polygon;
import java.util.Vector;

public class Z1Model {
    public Polygon[] pols;
    public int uvScale;

    public Z1Model(Polygon[] pols, int uvScale) {
        this.pols = pols;
        this.uvScale = uvScale;
    }

    public void recalculateNormals() {
        for (int i = 0; i < this.pols.length; ++i) {
            this.pols[i].recalculateNormals();
        }
    }

    public void getUVPolygons(Vector polygons, String texture, int width, int height, int[] texUvs) {
        block0: for (int i = 0; i < this.pols.length; ++i) {
            Polygon p = this.pols[i];
            if (!p.pinf.texName.equals(texture)) continue;
            double mu = (p.au + p.bu + p.cu) / 3;
            double mv = (p.av + p.bv + p.cv) / 3;
            mu = mu * (double)this.uvScale * (double)width / 1000000.0;
            mv = mv * (double)this.uvScale * (double)height / 1000000.0;
            for (int x = 0; x < texUvs.length / 4; ++x) {
                if (!(mu >= (double)texUvs[x * 4]) || !(mv >= (double)texUvs[x * 4 + 1]) || !(mu <= (double)(texUvs[x * 4] + texUvs[x * 4 + 2])) || !(mv <= (double)(texUvs[x * 4 + 1] + texUvs[x * 4 + 3]))) continue;
                polygons.addElement(p);
                continue block0;
            }
        }
    }
}

