/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.bsp2D;

import java.util.Vector;
import org.thenesis.planetino2.bsp2D.BSPLine;
import org.thenesis.planetino2.bsp2D.BSPPolygon;
import org.thenesis.planetino2.bsp2D.BSPTreeTraverseListener;
import org.thenesis.planetino2.bsp2D.BSPTreeTraverser;
import org.thenesis.planetino2.graphics3D.texture.ShadedSurface;
import org.thenesis.planetino2.graphics3D.texture.ShadedTexture;
import org.thenesis.planetino2.graphics3D.texture.Texture;
import org.thenesis.planetino2.math3D.Point;
import org.thenesis.planetino2.math3D.Rectangle;
import org.thenesis.planetino2.math3D.Vector3D;

public class BSPTree {
    private Node root;

    public BSPTree(Node root) {
        this.root = root;
    }

    public Node getRoot() {
        return this.root;
    }

    public Rectangle calcBounds() {
        final Point min = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
        final Point max = new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);
        BSPTreeTraverser traverser = new BSPTreeTraverser();
        traverser.setListener(new BSPTreeTraverseListener(){

            public boolean visitPolygon(BSPPolygon poly, boolean isBack) {
                for (int i = 0; i < poly.getNumVertices(); ++i) {
                    Vector3D v = poly.getVertex(i);
                    int x = (int)Math.floor(v.x);
                    int y = (int)Math.floor(v.z);
                    min.x = Math.min(min.x, x);
                    max.x = Math.max(max.x, x);
                    min.y = Math.min(min.y, y);
                    max.y = Math.max(max.y, y);
                }
                return true;
            }
        });
        traverser.traverse(this);
        return new Rectangle(min.x, min.y, max.x - min.x, max.y - min.y);
    }

    public Leaf getLeaf(float x, float z) {
        return this.getLeaf(this.root, x, z);
    }

    protected Leaf getLeaf(Node node, float x, float z) {
        if (node == null || node instanceof Leaf) {
            return (Leaf)node;
        }
        int side = node.partition.getSideThin(x, z);
        if (side == -1) {
            return this.getLeaf(node.back, x, z);
        }
        return this.getLeaf(node.front, x, z);
    }

    public Node getCollinearNode(BSPLine partition) {
        return this.getCollinearNode(this.root, partition);
    }

    protected Node getCollinearNode(Node node, BSPLine partition) {
        if (node == null || node instanceof Leaf) {
            return null;
        }
        int side = node.partition.getSide(partition);
        if (side == 0) {
            return node;
        }
        if (side == 1) {
            return this.getCollinearNode(node.front, partition);
        }
        if (side == -1) {
            return this.getCollinearNode(node.back, partition);
        }
        Node front = this.getCollinearNode(node.front, partition);
        if (front != null) {
            return front;
        }
        return this.getCollinearNode(node.back, partition);
    }

    public Leaf getFrontLeaf(BSPLine partition) {
        return this.getLeaf(this.root, partition, 1);
    }

    public Leaf getBackLeaf(BSPLine partition) {
        return this.getLeaf(this.root, partition, -1);
    }

    protected Leaf getLeaf(Node node, BSPLine partition, int side) {
        if (node == null || node instanceof Leaf) {
            return (Leaf)node;
        }
        int segSide = node.partition.getSide(partition);
        if (segSide == 0) {
            segSide = side;
        }
        if (segSide == 1) {
            return this.getLeaf(node.front, partition, side);
        }
        if (segSide == -1) {
            return this.getLeaf(node.back, partition, side);
        }
        return null;
    }

    public void createSurfaces(final Vector lights) {
        BSPTreeTraverser traverser = new BSPTreeTraverser();
        traverser.setListener(new BSPTreeTraverseListener(){

            public boolean visitPolygon(BSPPolygon poly, boolean isBack) {
                Texture texture = poly.getTexture();
                if (texture instanceof ShadedTexture) {
                    ShadedSurface.createShadedSurface(poly, (ShadedTexture)texture, poly.getTextureBounds(), lights, poly.getAmbientLightIntensity());
                }
                return true;
            }
        });
        traverser.traverse(this);
    }

    public static class Leaf
    extends Node {
        public float floorHeight;
        public float ceilHeight;
        public boolean isBack;
        public Vector portals;
        public Rectangle bounds;
    }

    public static class Node {
        public Node front;
        public Node back;
        public BSPLine partition;
        public Vector polygons;
    }
}

