/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.bsp2D;

import java.util.Enumeration;
import java.util.Vector;
import org.thenesis.planetino2.bsp2D.BSPLine;
import org.thenesis.planetino2.bsp2D.BSPTree;
import org.thenesis.planetino2.math3D.Vector3D;
import org.thenesis.planetino2.path.AStarNode;

public class Portal
extends AStarNode {
    private BSPLine divider;
    private BSPTree.Leaf front;
    private BSPTree.Leaf back;
    private Vector neighbors;
    private Vector3D midPoint;

    public Portal(BSPLine divider, BSPTree.Leaf front, BSPTree.Leaf back) {
        this.divider = divider;
        this.front = front;
        this.back = back;
        this.midPoint = new Vector3D((divider.x1 + divider.x2) / 2.0f, Math.max(front.floorHeight, back.floorHeight), (divider.y1 + divider.y2) / 2.0f);
    }

    public Vector3D getMidPoint() {
        return this.midPoint;
    }

    public void buildNeighborList() {
        Enumeration e;
        this.neighbors = new Vector();
        if (this.front != null) {
            e = this.front.portals.elements();
            while (e.hasMoreElements()) {
                this.neighbors.addElement(e.nextElement());
            }
        }
        if (this.back != null) {
            e = this.back.portals.elements();
            while (e.hasMoreElements()) {
                this.neighbors.addElement(e.nextElement());
            }
        }
        this.neighbors.trimToSize();
        while (this.neighbors.removeElement(this)) {
        }
    }

    public void addNeighbor(AStarNode node) {
        if (this.neighbors == null) {
            this.buildNeighborList();
        }
        this.neighbors.addElement(node);
    }

    public void removeNeighbor(AStarNode node) {
        if (this.neighbors == null) {
            this.buildNeighborList();
        }
        this.neighbors.removeElement(node);
    }

    public float getCost(AStarNode node) {
        return this.getEstimatedCost(node);
    }

    public float getEstimatedCost(AStarNode node) {
        if (node instanceof Portal) {
            Portal other = (Portal)node;
            float dx = this.midPoint.x - other.midPoint.x;
            float dz = this.midPoint.z - other.midPoint.z;
            return (float)Math.sqrt(dx * dx + dz * dz);
        }
        return node.getEstimatedCost(this);
    }

    public Vector getNeighbors() {
        if (this.neighbors == null) {
            this.buildNeighborList();
        }
        return this.neighbors;
    }
}

