/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.engine;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import org.thenesis.planetino2.engine.GameCore;
import org.thenesis.planetino2.graphics.Color;
import org.thenesis.planetino2.graphics.Screen;
import org.thenesis.planetino2.graphics3D.Overlay;
import org.thenesis.planetino2.graphics3D.PolygonRenderer;
import org.thenesis.planetino2.graphics3D.SolidPolygonRenderer;
import org.thenesis.planetino2.input.GameAction;
import org.thenesis.planetino2.input.InputManager;
import org.thenesis.planetino2.math3D.Polygon3D;
import org.thenesis.planetino2.math3D.Transform3D;
import org.thenesis.planetino2.math3D.Vector3D;
import org.thenesis.planetino2.math3D.ViewWindow;
import org.thenesis.planetino2.util.TimeSmoothie;

public abstract class GameCore3D
extends GameCore {
    private static final long INSTRUCTIONS_TIME = 4000L;
    protected PolygonRenderer polygonRenderer;
    protected ViewWindow viewWindow;
    protected Vector polygons;
    private Vector overlays = new Vector();
    protected TimeSmoothie timeSmoothie = new TimeSmoothie();
    protected boolean drawFrameRate = false;
    protected boolean drawInstructions = true;
    private boolean timeSmoothing = false;
    private long drawInstructionsTime = 0L;
    private int numFrames;
    private long startTime;
    private float frameRate;
    protected InputManager inputManager;
    private GameAction exit = new GameAction("exit");
    private GameAction smallerView = new GameAction("smallerView", 1);
    private GameAction largerView = new GameAction("largerView", 1);
    private GameAction frameRateToggle = new GameAction("frameRateToggle", 1);
    protected GameAction goForward = new GameAction("goForward");
    protected GameAction goBackward = new GameAction("goBackward");
    protected GameAction goUp = new GameAction("goUp");
    protected GameAction goDown = new GameAction("goDown");
    protected GameAction goLeft = new GameAction("goLeft");
    protected GameAction goRight = new GameAction("goRight");
    protected GameAction turnLeft = new GameAction("turnLeft");
    protected GameAction turnRight = new GameAction("turnRight");
    protected GameAction tiltUp = new GameAction("tiltUp");
    protected GameAction tiltDown = new GameAction("tiltDown");
    protected GameAction tiltLeft = new GameAction("tiltLeft");
    protected GameAction tiltRight = new GameAction("tiltRight");
    protected GameAction timeSmoothingToggle = new GameAction("timeSmoothingToggle", 1);

    public GameCore3D(Screen screen, InputManager inputManager) {
        super(screen);
        this.inputManager = inputManager;
    }

    public void init() {
        super.init();
        this.inputManager.mapToKey(this.goForward, 114);
        this.inputManager.mapToKey(this.goForward, 50);
        this.inputManager.mapToKey(this.goBackward, 97);
        this.inputManager.mapToKey(this.goBackward, 56);
        this.inputManager.mapToKey(this.goLeft, 122);
        this.inputManager.mapToKey(this.goLeft, 52);
        this.inputManager.mapToKey(this.goRight, 101);
        this.inputManager.mapToKey(this.goRight, 54);
        this.inputManager.mapToKey(this.goUp, 51);
        this.inputManager.mapToKey(this.goDown, 49);
        this.inputManager.mapToMouse(this.turnLeft, 0);
        this.inputManager.mapToMouse(this.turnRight, 1);
        this.inputManager.mapToMouse(this.tiltUp, 2);
        this.inputManager.mapToMouse(this.tiltDown, 3);
        this.createPolygonRenderer();
        this.polygons = new Vector();
        this.createPolygons();
    }

    public abstract void createPolygons();

    public void createPolygonRenderer() {
        this.viewWindow = new ViewWindow(0, 0, this.screen.getWidth(), this.screen.getHeight(), (float)Math.toRadians(75.0));
        Transform3D camera = new Transform3D(0.0f, 100.0f, 0.0f);
        this.polygonRenderer = new SolidPolygonRenderer(camera, this.viewWindow);
    }

    public void setViewBounds(int width, int height) {
        width = Math.min(width, this.screen.getWidth());
        height = Math.min(height, this.screen.getHeight());
        width = Math.max(64, width);
        height = Math.max(48, height);
        this.viewWindow.setBounds((this.screen.getWidth() - width) / 2, (this.screen.getHeight() - height) / 2, width, height);
        for (int i = 0; i < 2; ++i) {
            Graphics g = this.screen.getGraphics();
            g.setColor(Color.BLACK.getRGB());
            g.fillRect(0, 0, this.screen.getWidth(), this.screen.getHeight());
            this.screen.update();
        }
    }

    public void update(long elapsedTime) {
        this.drawInstructionsTime += elapsedTime;
        if (this.drawInstructionsTime >= 4000L) {
            this.drawInstructions = false;
        }
        if (this.exit.isPressed()) {
            this.stop();
            return;
        }
        if (this.largerView.isPressed()) {
            this.setViewBounds(this.viewWindow.getWidth() + 64, this.viewWindow.getHeight() + 48);
        } else if (this.smallerView.isPressed()) {
            this.setViewBounds(this.viewWindow.getWidth() - 64, this.viewWindow.getHeight() - 48);
        }
        if (this.frameRateToggle.isPressed()) {
            boolean bl = this.drawFrameRate = !this.drawFrameRate;
        }
        if (this.timeSmoothingToggle.isPressed()) {
            this.timeSmoothing = !this.timeSmoothing;
            this.drawInstructions = true;
            this.drawInstructionsTime = 0L;
        }
        if (this.timeSmoothing) {
            elapsedTime = this.timeSmoothie.getTime(elapsedTime);
        }
        this.updateWorld(elapsedTime);
        for (int i = 0; i < this.overlays.size(); ++i) {
            Overlay overlay = (Overlay)this.overlays.elementAt(i);
            if (!overlay.isEnabled()) continue;
            overlay.update(elapsedTime);
        }
    }

    public void updateWorld(long elapsedTime) {
        elapsedTime = Math.min(elapsedTime, 100L);
        float angleChange = 2.0E-4f * (float)elapsedTime;
        float distanceChange = 0.5f * (float)elapsedTime;
        Transform3D camera = this.polygonRenderer.getCamera();
        Vector3D cameraLoc = camera.getLocation();
        if (this.goForward.isPressed()) {
            cameraLoc.x -= distanceChange * camera.getSinAngleY();
            cameraLoc.z -= distanceChange * camera.getCosAngleY();
        }
        if (this.goBackward.isPressed()) {
            cameraLoc.x += distanceChange * camera.getSinAngleY();
            cameraLoc.z += distanceChange * camera.getCosAngleY();
        }
        if (this.goLeft.isPressed()) {
            cameraLoc.x -= distanceChange * camera.getCosAngleY();
            cameraLoc.z += distanceChange * camera.getSinAngleY();
        }
        if (this.goRight.isPressed()) {
            cameraLoc.x += distanceChange * camera.getCosAngleY();
            cameraLoc.z -= distanceChange * camera.getSinAngleY();
        }
        if (this.goUp.isPressed()) {
            cameraLoc.y += distanceChange;
        }
        if (this.goDown.isPressed()) {
            cameraLoc.y -= distanceChange;
        }
        int tilt = this.tiltUp.getAmount() - this.tiltDown.getAmount();
        tilt = Math.min(tilt, 200);
        tilt = Math.max(tilt, -200);
        float newAngleX = camera.getAngleX() + (float)tilt * angleChange;
        newAngleX = Math.max(newAngleX, -1.5707964f);
        newAngleX = Math.min(newAngleX, 1.5707964f);
        camera.setAngleX(newAngleX);
        int turn = this.turnLeft.getAmount() - this.turnRight.getAmount();
        turn = Math.min(turn, 200);
        turn = Math.max(turn, -200);
        camera.rotateAngleY((float)turn * angleChange);
        if (this.tiltLeft.isPressed()) {
            camera.rotateAngleZ(10.0f * angleChange);
        }
        if (this.tiltRight.isPressed()) {
            camera.rotateAngleZ(-10.0f * angleChange);
        }
    }

    public void draw(Graphics g) {
        int viewX1 = this.viewWindow.getLeftOffset();
        int viewY1 = this.viewWindow.getTopOffset();
        int viewX2 = viewX1 + this.viewWindow.getWidth();
        int viewY2 = viewY1 + this.viewWindow.getHeight();
        if (viewX1 != 0 || viewY1 != 0) {
            g.setColor(Color.BLACK.getRGB());
            g.fillRect(0, 0, viewX1, this.screen.getHeight());
            g.fillRect(viewX2, 0, this.screen.getWidth() - viewX2, this.screen.getHeight());
            g.fillRect(viewX1, 0, this.viewWindow.getWidth(), viewY1);
            g.fillRect(viewX1, viewY2, this.viewWindow.getWidth(), this.screen.getHeight() - viewY2);
        }
        this.drawPolygons(g);
        this.drawOverlays(g);
    }

    public void drawPolygons(Graphics g) {
        this.polygonRenderer.startFrame(this.screen);
        for (int i = 0; i < this.polygons.size(); ++i) {
            this.polygonRenderer.draw(g, (Polygon3D)this.polygons.elementAt(i));
        }
        this.polygonRenderer.endFrame(this.screen);
    }

    public void drawOverlays(Graphics g) {
        if (this.drawInstructions) {
            long fade = 4000L - this.drawInstructionsTime;
            if (fade < 500L) {
                fade = fade * 255L / 500L;
                g.setColor(new Color(0xFFFFFF | (int)fade << 24, true).getRGB());
            } else {
                g.setColor(Color.WHITE.getRGB());
            }
            System.out.println("drawInstructions");
            g.drawString("Use the mouse/arrow keys to move. Press Esc to exit.", 5, this.fontSize, 20);
        }
        if (this.drawFrameRate) {
            g.setColor(Color.WHITE.getRGB());
            this.calcFrameRate();
            g.drawString(this.frameRate + " frames/sec", 5, this.screen.getHeight() - 5, 20);
        }
        for (int i = 0; i < this.overlays.size(); ++i) {
            Overlay overlay = (Overlay)this.overlays.elementAt(i);
            if (!overlay.isEnabled()) continue;
            Font prevFont = g.getFont();
            int prevColor = g.getColor();
            overlay.draw(g, this.viewWindow);
            g.setColor(prevColor);
            g.setFont(prevFont);
        }
    }

    public void addOverlay(Overlay overlay) {
        this.overlays.addElement(overlay);
    }

    public void removeOverlay(Overlay overlay) {
        this.overlays.removeElement(overlay);
    }

    public void calcFrameRate() {
        ++this.numFrames;
        long currTime = System.currentTimeMillis();
        if (currTime > this.startTime + 500L) {
            this.frameRate = (float)this.numFrames * 1000.0f / (float)(currTime - this.startTime);
            this.startTime = currTime;
            this.numFrames = 0;
        }
    }
}

