/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.game;

import org.thenesis.planetino2.game.GameObject;
import org.thenesis.planetino2.math3D.Vector3D;

public class Physics {
    public static final float DEFAULT_GRAVITY_ACCEL = -0.002f;
    public static final float DEFAULT_SCOOT_ACCEL = 0.006f;
    private static Physics instance;
    private float gravityAccel = -0.002f;
    private float scootAccel = 0.006f;
    private Vector3D velocity = new Vector3D();

    public static synchronized Physics getInstance() {
        if (instance == null) {
            instance = new Physics();
        }
        return instance;
    }

    protected Physics() {
    }

    public float getGravityAccel() {
        return this.gravityAccel;
    }

    public void setGravityAccel(float gravityAccel) {
        this.gravityAccel = gravityAccel;
    }

    public float getScootAccel() {
        return this.scootAccel;
    }

    public void setScootAccel(float scootAccel) {
        this.scootAccel = scootAccel;
    }

    public void applyGravity(GameObject object, long elapsedTime) {
        this.velocity.setTo(0.0f, this.gravityAccel * (float)elapsedTime, 0.0f);
        object.getTransform().addVelocity(this.velocity);
    }

    public void scootUp(GameObject object, long elapsedTime) {
        this.velocity.setTo(0.0f, this.scootAccel * (float)elapsedTime, 0.0f);
        object.getTransform().addVelocity(this.velocity);
    }

    public void scootDown(GameObject object, long elapsedTime) {
        this.velocity.setTo(0.0f, -this.scootAccel * (float)elapsedTime, 0.0f);
        object.getTransform().addVelocity(this.velocity);
    }

    public void jumpToHeight(GameObject object, float jumpHeight) {
        this.jump(object, this.getJumpVelocity(jumpHeight));
    }

    public void jump(GameObject object, float jumpVelocity) {
        this.velocity.setTo(0.0f, jumpVelocity, 0.0f);
        object.getTransform().getVelocity().y = 0.0f;
        object.getTransform().addVelocity(this.velocity);
    }

    public float getJumpVelocity(float jumpHeight) {
        return (float)Math.sqrt(-2.0f * this.gravityAccel * jumpHeight);
    }
}

