/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.game;

import org.thenesis.planetino2.ai.Projectile;
import org.thenesis.planetino2.game.JumpingGameObject;
import org.thenesis.planetino2.math3D.PolygonGroup;
import org.thenesis.planetino2.math3D.PolygonGroupBounds;
import org.thenesis.planetino2.math3D.Vector3D;

public class Player
extends JumpingGameObject {
    private static final float BULLET_HEIGHT = 75.0f;
    public static final float DEFAULT_PLAYER_RADIUS = 32.0f;
    public static final float DEFAULT_PLAYER_HEIGHT = 128.0f;
    private static final float DEFAULT_MAX_HEALTH = 100.0f;
    private PolygonGroup blastModel;
    private float maxHealth;
    private float health;

    public Player() {
        super(new PolygonGroup("player"));
        PolygonGroupBounds playerBounds = this.getBounds();
        playerBounds.setTopHeight(128.0f);
        playerBounds.setRadius(32.0f);
        this.maxHealth = 100.0f;
        this.setHealth(this.maxHealth);
    }

    public void setBlastModel(PolygonGroup blastModel) {
        this.blastModel = blastModel;
    }

    public float getHealth() {
        return this.health;
    }

    public void setHealth(float health) {
        this.health = health;
    }

    public float getMaxHealth() {
        return this.maxHealth;
    }

    public void addHealth(float addition) {
        this.setHealth(this.health + addition);
    }

    public boolean isAlive() {
        return this.health > 0.0f;
    }

    public void fireProjectile() {
        float x = -this.getTransform().getSinAngleY();
        float z = -this.getTransform().getCosAngleY();
        float cosX = this.getTransform().getCosAngleX();
        float sinX = this.getTransform().getSinAngleX();
        Projectile blast = new Projectile((PolygonGroup)this.blastModel.clone(), new Vector3D(cosX * x, sinX, cosX * z), null, 40, 60);
        float dist = this.getBounds().getRadius() + blast.getBounds().getRadius();
        blast.getLocation().setTo(this.getX() + x * dist, this.getY() + 75.0f, this.getZ() + z * dist);
        this.addSpawn(blast);
        this.makeNoise(500L);
    }
}

