/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.graphics3D.texture;

import java.util.Vector;
import org.thenesis.planetino2.graphics3D.texture.ShadedTexture;
import org.thenesis.planetino2.graphics3D.texture.Texture;
import org.thenesis.planetino2.math3D.Rectangle3D;
import org.thenesis.planetino2.math3D.TexturedPolygon3D;
import org.thenesis.planetino2.math3D.Vector3D;

public final class ShadedSurface
extends Texture {
    public static final int SURFACE_BORDER_SIZE = 1;
    public static final int SHADE_RES_BITS = 4;
    public static final int SHADE_RES = 16;
    public static final int SHADE_RES_MASK = 15;
    public static final int SHADE_RES_SQ = 256;
    public static final int SHADE_RES_SQ_BITS = 8;
    private int[] buffer;
    private boolean dirty;
    private ShadedTexture sourceTexture;
    private Rectangle3D sourceTextureBounds;
    private Rectangle3D surfaceBounds;
    private byte[] shadeMap;
    private int shadeMapWidth;
    private int shadeMapHeight;
    private int shadeValue;
    private int shadeValueInc;

    public ShadedSurface(int width, int height) {
        this(null, width, height);
    }

    public ShadedSurface(int[] buffer, int width, int height) {
        super(width, height);
        this.buffer = buffer;
        this.sourceTextureBounds = new Rectangle3D();
        this.dirty = true;
    }

    public static void createShadedSurface(TexturedPolygon3D poly, ShadedTexture texture, Vector lights, float ambientLightIntensity) {
        Vector3D origin = poly.getVertex(0);
        Vector3D dv = new Vector3D(poly.getVertex(1));
        dv.subtract(origin);
        Vector3D du = new Vector3D();
        du.setToCrossProduct(poly.getNormal(), dv);
        Rectangle3D bounds = new Rectangle3D(origin, du, dv, texture.getWidth(), texture.getHeight());
        ShadedSurface.createShadedSurface(poly, texture, bounds, lights, ambientLightIntensity);
    }

    public static void createShadedSurface(TexturedPolygon3D poly, ShadedTexture texture, Rectangle3D textureBounds, Vector lights, float ambientLightIntensity) {
        poly.setTexture(texture, textureBounds);
        Rectangle3D surfaceBounds = poly.calcBoundingRectangle();
        Vector3D du = new Vector3D(surfaceBounds.getDirectionU());
        Vector3D dv = new Vector3D(surfaceBounds.getDirectionV());
        du.multiply(1.0f);
        dv.multiply(1.0f);
        surfaceBounds.getOrigin().subtract(du);
        surfaceBounds.getOrigin().subtract(dv);
        int width = (int)Math.ceil(surfaceBounds.getWidth() + 2.0f);
        int height = (int)Math.ceil(surfaceBounds.getHeight() + 2.0f);
        surfaceBounds.setWidth(width);
        surfaceBounds.setHeight(height);
        ShadedSurface surface = new ShadedSurface(width, height);
        surface.setTexture(texture, textureBounds);
        surface.setSurfaceBounds(surfaceBounds);
        surface.buildShadeMap(lights, ambientLightIntensity);
        poly.setTexture(surface, surfaceBounds);
    }

    public int getColor(int x, int y) {
        return this.sourceTexture.getColor(x, y);
    }

    private int getColor565(int x, int y) {
        return this.buffer[x + y * this.width];
    }

    public int getColorChecked(int x, int y) {
        if (x < 0) {
            x = 0;
        } else if (x >= this.width) {
            x = this.width - 1;
        }
        if (y < 0) {
            y = 0;
        } else if (y >= this.height) {
            y = this.height - 1;
        }
        return this.getColor565(x, y);
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    protected void newSurface(int width, int height) {
        this.buffer = new int[width * height];
    }

    public void clearSurface() {
        this.buffer = null;
    }

    public boolean isCleared() {
        return this.buffer == null;
    }

    public void setTexture(ShadedTexture texture) {
        this.sourceTexture = texture;
        this.sourceTextureBounds.setWidth(texture.getWidth());
        this.sourceTextureBounds.setHeight(texture.getHeight());
    }

    public void setTexture(ShadedTexture texture, Rectangle3D bounds) {
        this.setTexture(texture);
        this.sourceTextureBounds.setTo(bounds);
    }

    public void setSurfaceBounds(Rectangle3D surfaceBounds) {
        this.surfaceBounds = surfaceBounds;
    }

    public Rectangle3D getSurfaceBounds() {
        return this.surfaceBounds;
    }

    public void buildSurface() {
    }

    public int getShade(int u, int v) {
        return this.shadeMap[u + v * this.shadeMapWidth];
    }

    public void buildShadeMap(Vector pointLights, float ambientLightIntensity) {
    }

    public ShadedTexture getSourceTexture() {
        return this.sourceTexture;
    }
}

