/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.math3D;

import org.thenesis.planetino2.math3D.Transform3D;
import org.thenesis.planetino2.math3D.Vector3D;
import org.thenesis.planetino2.util.MoreMath;

public class MovingTransform3D
extends Transform3D {
    public static final int FOREVER = -1;
    private static Vector3D temp = new Vector3D();
    private Vector3D velocity;
    private Movement velocityMovement;
    private Movement velocityAngleX;
    private Movement velocityAngleY;
    private Movement velocityAngleZ;

    public MovingTransform3D() {
        this.init();
    }

    public MovingTransform3D(Transform3D v) {
        super(v);
        this.init();
    }

    protected void init() {
        this.velocity = new Vector3D(0.0f, 0.0f, 0.0f);
        this.velocityMovement = new Movement();
        this.velocityAngleX = new Movement();
        this.velocityAngleY = new Movement();
        this.velocityAngleZ = new Movement();
    }

    public Object clone() {
        return new MovingTransform3D(this);
    }

    public void update(long elapsedTime) {
        float delta = this.velocityMovement.getDistance(elapsedTime);
        if (delta != 0.0f) {
            temp.setTo(this.velocity);
            temp.multiply(delta);
            this.location.add(temp);
        }
        this.rotateAngle(this.velocityAngleX.getDistance(elapsedTime), this.velocityAngleY.getDistance(elapsedTime), this.velocityAngleZ.getDistance(elapsedTime));
    }

    public void stop() {
        this.velocity.setTo(0.0f, 0.0f, 0.0f);
        this.velocityMovement.set(0.0f, 0L);
        this.velocityAngleX.set(0.0f, 0L);
        this.velocityAngleY.set(0.0f, 0L);
        this.velocityAngleZ.set(0.0f, 0L);
    }

    public void moveTo(Vector3D destination, float speed) {
        temp.setTo(destination);
        temp.subtract(this.location);
        float distance = temp.length();
        long time = (long)(distance / speed);
        temp.divide(distance);
        temp.multiply(speed);
        this.setVelocity(temp, time);
    }

    public boolean isMoving() {
        return !this.velocityMovement.isStopped() && !this.velocity.equals(0.0f, 0.0f, 0.0f);
    }

    public boolean isMovingIgnoreY() {
        return !this.velocityMovement.isStopped() && (this.velocity.x != 0.0f || this.velocity.z != 0.0f);
    }

    public long getRemainingMoveTime() {
        if (!this.isMoving()) {
            return 0L;
        }
        return this.velocityMovement.remainingTime;
    }

    public Vector3D getVelocity() {
        return this.velocity;
    }

    public void setVelocity(Vector3D v) {
        this.setVelocity(v, -1L);
    }

    public void setVelocity(Vector3D v, long time) {
        if (this.velocity != v) {
            this.velocity.setTo(v);
        }
        if (v.x == 0.0f && v.y == 0.0f && v.z == 0.0f) {
            this.velocityMovement.set(0.0f, 0L);
        } else {
            this.velocityMovement.set(1.0f, time);
        }
    }

    public void addVelocity(Vector3D v) {
        if (this.isMoving()) {
            this.velocity.add(v);
        } else {
            this.setVelocity(v);
        }
    }

    public void turnXTo(float angleDest, float speed) {
        this.turnTo(this.velocityAngleX, this.getAngleX(), angleDest, speed);
    }

    public void turnYTo(float angleDest, float speed) {
        this.turnTo(this.velocityAngleY, this.getAngleY(), angleDest, speed);
    }

    public void turnZTo(float angleDest, float speed) {
        this.turnTo(this.velocityAngleZ, this.getAngleZ(), angleDest, speed);
    }

    public void turnXTo(float y, float z, float angleOffset, float speed) {
        this.turnXTo((float)MoreMath.atan2(-z, y) + angleOffset, speed);
    }

    public void turnYTo(float x, float z, float angleOffset, float speed) {
        this.turnYTo((float)MoreMath.atan2(-z, x) + angleOffset, speed);
    }

    public void turnZTo(float x, float y, float angleOffset, float speed) {
        this.turnZTo((float)MoreMath.atan2(y, x) + angleOffset, speed);
    }

    protected float ensureAngleWithinBounds(float angle) {
        if ((double)angle < -Math.PI || (double)angle > Math.PI) {
            double newAngle = ((double)angle + Math.PI) / (Math.PI * 2);
            newAngle -= Math.floor(newAngle);
            newAngle = Math.PI * (newAngle * 2.0 - 1.0);
            return (float)newAngle;
        }
        return angle;
    }

    protected void turnTo(Movement movement, float startAngle, float endAngle, float speed) {
        if ((startAngle = this.ensureAngleWithinBounds(startAngle)) == (endAngle = this.ensureAngleWithinBounds(endAngle))) {
            movement.set(0.0f, 0L);
        } else {
            float distanceRight;
            float distanceLeft;
            float pi2 = (float)Math.PI * 2;
            if (startAngle < endAngle) {
                distanceLeft = startAngle - endAngle + pi2;
                distanceRight = endAngle - startAngle;
            } else {
                distanceLeft = startAngle - endAngle;
                distanceRight = endAngle - startAngle + pi2;
            }
            if (distanceLeft < distanceRight) {
                speed = -Math.abs(speed);
                movement.set(speed, (long)(distanceLeft / -speed));
            } else {
                speed = Math.abs(speed);
                movement.set(speed, (long)(distanceRight / speed));
            }
        }
    }

    public void setAngleVelocityX(float speed) {
        this.setAngleVelocityX(speed, -1L);
    }

    public void setAngleVelocityY(float speed) {
        this.setAngleVelocityY(speed, -1L);
    }

    public void setAngleVelocityZ(float speed) {
        this.setAngleVelocityZ(speed, -1L);
    }

    public void setAngleVelocityX(float speed, long time) {
        this.velocityAngleX.set(speed, time);
    }

    public void setAngleVelocityY(float speed, long time) {
        this.velocityAngleY.set(speed, time);
    }

    public void setAngleVelocityZ(float speed, long time) {
        this.velocityAngleZ.set(speed, time);
    }

    public float getAngleVelocityX() {
        return this.isTurningX() ? this.velocityAngleX.speed : 0.0f;
    }

    public float getAngleVelocityY() {
        return this.isTurningY() ? this.velocityAngleY.speed : 0.0f;
    }

    public float getAngleVelocityZ() {
        return this.isTurningZ() ? this.velocityAngleZ.speed : 0.0f;
    }

    public boolean isTurningX() {
        return !this.velocityAngleX.isStopped();
    }

    public boolean isTurningY() {
        return !this.velocityAngleY.isStopped();
    }

    public boolean isTurningZ() {
        return !this.velocityAngleZ.isStopped();
    }

    protected static class Movement {
        float speed;
        long remainingTime;

        protected Movement() {
        }

        public void set(float speed, long time) {
            this.speed = speed;
            this.remainingTime = time;
        }

        public boolean isStopped() {
            return this.speed == 0.0f || this.remainingTime == 0L;
        }

        public float getDistance(long elapsedTime) {
            if (this.remainingTime == 0L) {
                return 0.0f;
            }
            if (this.remainingTime != -1L) {
                elapsedTime = Math.min(elapsedTime, this.remainingTime);
                this.remainingTime -= elapsedTime;
            }
            return this.speed * (float)elapsedTime;
        }
    }
}

