/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.math3D;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.thenesis.planetino2.graphics3D.texture.ShadedSurface;
import org.thenesis.planetino2.graphics3D.texture.ShadedTexture;
import org.thenesis.planetino2.graphics3D.texture.Texture;
import org.thenesis.planetino2.math3D.PolygonGroup;
import org.thenesis.planetino2.math3D.TexturedPolygon3D;
import org.thenesis.planetino2.math3D.Vector3D;
import org.thenesis.planetino2.util.BufferedReader;
import org.thenesis.planetino2.util.StringTokenizer;

public class ObjectLoader {
    protected String path;
    protected Vector vertices;
    protected Material currentMaterial;
    protected Hashtable materials = new Hashtable();
    protected Vector lights;
    protected float ambientLightIntensity;
    protected Hashtable parsers;
    private PolygonGroup object;
    private PolygonGroup currentGroup;

    public ObjectLoader() {
        this.vertices = new Vector();
        this.parsers = new Hashtable();
        this.parsers.put("obj", new ObjLineParser());
        this.parsers.put("mtl", new MtlLineParser());
        this.currentMaterial = null;
        this.setLights(new Vector(), 1.0f);
    }

    public void setLights(Vector lights, float ambientLightIntensity) {
        this.lights = lights;
        this.ambientLightIntensity = ambientLightIntensity;
    }

    public PolygonGroup loadObject(String path, String filename) throws IOException {
        this.path = path;
        this.object = new PolygonGroup();
        this.object.setFilename(filename);
        this.vertices.removeAllElements();
        this.currentGroup = this.object;
        this.parseFile(filename);
        return this.object;
    }

    protected Vector3D getVector(String indexStr) {
        int index = Integer.parseInt(indexStr);
        if (index < 0) {
            index = this.vertices.size() + index + 1;
        }
        return (Vector3D)this.vertices.elementAt(index - 1);
    }

    protected void parseFile(String filename) throws IOException {
        System.out.println("path: " + this.path + " filename: " + filename);
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(this.path + filename)));
        LineParser parser = null;
        int extIndex = filename.lastIndexOf(46);
        if (extIndex != -1) {
            String ext = filename.substring(extIndex + 1);
            parser = (LineParser)this.parsers.get(ext.toLowerCase());
        }
        if (parser == null) {
            parser = (LineParser)this.parsers.get("obj");
        }
        while (true) {
            String line;
            if ((line = reader.readLine()) == null) {
                reader.close();
                return;
            }
            if ((line = line.trim()).length() <= 0 || line.startsWith("#")) continue;
            try {
                parser.parseLine(line);
            }
            catch (NumberFormatException ex) {
                throw new IOException(ex.getMessage());
            }
            catch (NoSuchElementException ex) {
                throw new IOException(ex.getMessage());
            }
        }
    }

    protected class MtlLineParser
    implements LineParser {
        protected MtlLineParser() {
        }

        public void parseLine(String line) throws NoSuchElementException {
            StringTokenizer tokenizer = new StringTokenizer(line);
            String command = tokenizer.nextToken();
            if (command.equals("newmtl")) {
                String name = tokenizer.nextToken();
                ObjectLoader.this.currentMaterial = (Material)ObjectLoader.this.materials.get(name);
                if (ObjectLoader.this.currentMaterial == null) {
                    ObjectLoader.this.currentMaterial = new Material();
                    ObjectLoader.this.materials.put(name, ObjectLoader.this.currentMaterial);
                }
            } else if (command.equals("map_Kd")) {
                String name = tokenizer.nextToken();
                ObjectLoader.this.currentMaterial.texture = (ShadedTexture)Texture.createTexture(ObjectLoader.this.path, name, true);
            }
        }
    }

    protected class ObjLineParser
    implements LineParser {
        protected ObjLineParser() {
        }

        public void parseLine(String line) throws IOException, NumberFormatException, NoSuchElementException {
            StringTokenizer tokenizer = new StringTokenizer(line);
            String command = tokenizer.nextToken();
            if (command.equals("v")) {
                ObjectLoader.this.vertices.addElement(new Vector3D(Float.parseFloat(tokenizer.nextToken()), Float.parseFloat(tokenizer.nextToken()), Float.parseFloat(tokenizer.nextToken())));
            } else if (command.equals("f")) {
                Vector<Vector3D> currVertices = new Vector<Vector3D>();
                while (tokenizer.hasMoreTokens()) {
                    String indexStr = tokenizer.nextToken();
                    int endIndex = indexStr.indexOf(47);
                    if (endIndex != -1) {
                        indexStr = indexStr.substring(0, endIndex);
                    }
                    currVertices.addElement(ObjectLoader.this.getVector(indexStr));
                }
                Object[] array = new Vector3D[currVertices.size()];
                currVertices.copyInto(array);
                TexturedPolygon3D poly = new TexturedPolygon3D((Vector3D[])array);
                ShadedSurface.createShadedSurface(poly, ObjectLoader.this.currentMaterial.texture, ObjectLoader.this.lights, ObjectLoader.this.ambientLightIntensity);
                ObjectLoader.this.currentGroup.addPolygon(poly);
            } else if (command.equals("g")) {
                if (tokenizer.hasMoreTokens()) {
                    String name = tokenizer.nextToken();
                    ObjectLoader.this.currentGroup = new PolygonGroup(name);
                } else {
                    ObjectLoader.this.currentGroup = new PolygonGroup();
                }
                ObjectLoader.this.object.addPolygonGroup(ObjectLoader.this.currentGroup);
            } else if (command.equals("mtllib")) {
                String name = tokenizer.nextToken();
                ObjectLoader.this.parseFile(name);
            } else if (command.equals("usemtl")) {
                String name = tokenizer.nextToken();
                ObjectLoader.this.currentMaterial = (Material)ObjectLoader.this.materials.get(name);
                if (ObjectLoader.this.currentMaterial == null) {
                    System.out.println("no material: " + name);
                }
            }
        }
    }

    protected static interface LineParser {
        public void parseLine(String var1) throws IOException, NumberFormatException, NoSuchElementException;
    }

    public static class Material {
        public ShadedTexture texture;
    }
}

