/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.test;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import org.thenesis.planetino2.bsp2D.BSPRenderer;
import org.thenesis.planetino2.bsp2D.BSPTree;
import org.thenesis.planetino2.bsp2D.MapLoader;
import org.thenesis.planetino2.engine.shooter3D.Bot;
import org.thenesis.planetino2.engine.shooter3D.ShooterCore;
import org.thenesis.planetino2.game.CollisionDetection;
import org.thenesis.planetino2.game.GameObject;
import org.thenesis.planetino2.game.GameObjectRenderer;
import org.thenesis.planetino2.game.GridGameObjectManager;
import org.thenesis.planetino2.graphics.Color;
import org.thenesis.planetino2.graphics.Screen;
import org.thenesis.planetino2.input.InputManager;
import org.thenesis.planetino2.math3D.PointLight3D;
import org.thenesis.planetino2.math3D.PolygonGroup;
import org.thenesis.planetino2.math3D.PolygonGroupBounds;
import org.thenesis.planetino2.math3D.Transform3D;

public class CollisionTest
extends ShooterCore {
    protected BSPTree bspTree;
    protected String mapFile;

    public CollisionTest(Screen screen, InputManager inputManager) {
        super(screen, inputManager);
        this.inputManager = inputManager;
    }

    public void createPolygons() {
        Graphics g = this.screen.getGraphics();
        g.setColor(Color.BLACK.getRGB());
        g.fillRect(0, 0, this.screen.getWidth(), this.screen.getHeight());
        g.setColor(Color.WHITE.getRGB());
        float ambientLightIntensity = 0.2f;
        Vector<PointLight3D> lights = new Vector<PointLight3D>();
        lights.addElement(new PointLight3D(-100.0f, 100.0f, 100.0f, 0.3f, -1.0f));
        lights.addElement(new PointLight3D(100.0f, 100.0f, 0.0f, 0.3f, -1.0f));
        MapLoader loader = new MapLoader();
        loader.setObjectLights(lights, ambientLightIntensity);
        try {
            this.bspTree = loader.loadMap("/res/", "test.map");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        CollisionDetection collisionDetection = new CollisionDetection(this.bspTree);
        this.gameObjectManager = new GridGameObjectManager(this.bspTree.calcBounds(), collisionDetection);
        this.gameObjectManager.addPlayer(new GameObject(new PolygonGroup("Player")));
        PolygonGroupBounds playerBounds = this.gameObjectManager.getPlayer().getBounds();
        playerBounds.setTopHeight(128.0f);
        playerBounds.setRadius(32.0f);
        ((BSPRenderer)this.polygonRenderer).setGameObjectManager(this.gameObjectManager);
        this.createGameObjects(loader.getObjectsInMap());
        Transform3D start = loader.getPlayerStartLocation();
        this.gameObjectManager.getPlayer().getTransform().setTo(start);
    }

    private void createGameObjects(Vector mapObjects) {
        Enumeration e = mapObjects.elements();
        while (e.hasMoreElements()) {
            PolygonGroup group = (PolygonGroup)e.nextElement();
            String filename = group.getFilename();
            if ("robot.obj3d".equals(filename)) {
                this.gameObjectManager.add(new Bot(group));
                continue;
            }
            this.gameObjectManager.add(new GameObject(group));
        }
    }

    public void drawPolygons(Graphics g) {
        this.polygonRenderer.startFrame(this.screen);
        ((BSPRenderer)this.polygonRenderer).draw(g, this.bspTree);
        this.gameObjectManager.draw(g, (GameObjectRenderer)((Object)this.polygonRenderer));
        this.polygonRenderer.endFrame(this.screen);
    }
}

