/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.test;

import java.io.IOException;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import org.thenesis.planetino2.engine.GameCore3D;
import org.thenesis.planetino2.engine.shooter3D.Blast;
import org.thenesis.planetino2.engine.shooter3D.Bot;
import org.thenesis.planetino2.game.GameObject;
import org.thenesis.planetino2.game.GameObjectManager;
import org.thenesis.planetino2.game.GameObjectRenderer;
import org.thenesis.planetino2.game.SimpleGameObjectManager;
import org.thenesis.planetino2.graphics.Screen;
import org.thenesis.planetino2.graphics3D.ZBufferedRenderer;
import org.thenesis.planetino2.graphics3D.texture.ShadedTexture;
import org.thenesis.planetino2.graphics3D.texture.Texture;
import org.thenesis.planetino2.input.GameAction;
import org.thenesis.planetino2.input.InputManager;
import org.thenesis.planetino2.math3D.MovingTransform3D;
import org.thenesis.planetino2.math3D.ObjectLoader;
import org.thenesis.planetino2.math3D.PointLight3D;
import org.thenesis.planetino2.math3D.PolygonGroup;
import org.thenesis.planetino2.math3D.Rectangle3D;
import org.thenesis.planetino2.math3D.TexturedPolygon3D;
import org.thenesis.planetino2.math3D.Transform3D;
import org.thenesis.planetino2.math3D.Vector3D;
import org.thenesis.planetino2.math3D.ViewWindow;

public class GameObjectTest
extends GameCore3D {
    private static final int NUM_BOTS = 5;
    private static final int NUM_POWER_UPS = 7;
    private static final int GAME_AREA_SIZE = 1500;
    private static final float PLAYER_SPEED = 0.5f;
    private static final float PLAYER_TURN_SPEED = 0.04f;
    private static final float BULLET_HEIGHT = 75.0f;
    protected GameAction fire = new GameAction("fire", 1);
    private PolygonGroup robotModel;
    private PolygonGroup powerUpModel;
    private PolygonGroup blastModel;
    private GameObjectManager gameObjectManager;
    private TexturedPolygon3D floor;

    public GameObjectTest(Screen screen, InputManager inputManager) {
        super(screen, inputManager);
        this.inputManager = inputManager;
    }

    public void init() {
        super.init();
        this.inputManager.mapToKey(this.fire, 53);
        this.inputManager.mapToMouse(this.fire, 8);
    }

    public void createPolygons() {
        GameObject object;
        int i;
        Texture floorTexture = Texture.createTexture("/res/", "roof1.png", true);
        ((ShadedTexture)floorTexture).setDefaultShadeLevel(47);
        Rectangle3D floorTextureBounds = new Rectangle3D(new Vector3D(0.0f, 0.0f, 0.0f), new Vector3D(1.0f, 0.0f, 0.0f), new Vector3D(0.0f, 0.0f, 1.0f), floorTexture.getWidth(), floorTexture.getHeight());
        float s = 1500.0f;
        this.floor = new TexturedPolygon3D(new Vector3D[]{new Vector3D(-s, 0.0f, s), new Vector3D(s, 0.0f, s), new Vector3D(s, 0.0f, -s), new Vector3D(-s, 0.0f, -s)});
        this.floor.setTexture(floorTexture, floorTextureBounds);
        float ambientLightIntensity = 0.5f;
        Vector<PointLight3D> lights = new Vector<PointLight3D>();
        lights.addElement(new PointLight3D(-100.0f, 100.0f, 100.0f, 0.5f, -1.0f));
        lights.addElement(new PointLight3D(100.0f, 100.0f, 0.0f, 0.5f, -1.0f));
        ObjectLoader loader = new ObjectLoader();
        loader.setLights(lights, ambientLightIntensity);
        try {
            this.robotModel = loader.loadObject("/res/", "robot.obj3d");
            this.powerUpModel = loader.loadObject("/res/", "cube.obj3d");
            this.blastModel = loader.loadObject("/res/", "blast.obj3d");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.gameObjectManager = new SimpleGameObjectManager();
        this.gameObjectManager.addPlayer(new GameObject(new PolygonGroup("Player")));
        this.gameObjectManager.getPlayer().getLocation().y = 5.0f;
        for (i = 0; i < 5; ++i) {
            object = new Bot((PolygonGroup)this.robotModel.clone());
            this.placeObject(object);
        }
        for (i = 0; i < 7; ++i) {
            object = new GameObject((PolygonGroup)this.powerUpModel.clone());
            this.placeObject(object);
        }
    }

    public void placeObject(GameObject object) {
        float size = 1500.0f;
        Random random = new Random();
        object.getLocation().setTo((float)(random.nextDouble() * (double)size - (double)(size / 2.0f)), 0.0f, (float)(random.nextDouble() * (double)size - (double)(size / 2.0f)));
        this.gameObjectManager.add(object);
    }

    public void createPolygonRenderer() {
        this.viewWindow = new ViewWindow(0, 0, this.screen.getWidth(), this.screen.getHeight(), (float)Math.toRadians(75.0));
        Transform3D camera = new Transform3D();
        this.polygonRenderer = new ZBufferedRenderer(camera, this.viewWindow);
    }

    public void updateWorld(long elapsedTime) {
        elapsedTime = Math.min(elapsedTime, 100L);
        GameObject player = this.gameObjectManager.getPlayer();
        MovingTransform3D playerTransform = player.getTransform();
        Vector3D velocity = playerTransform.getVelocity();
        playerTransform.stop();
        float x = -playerTransform.getSinAngleY();
        float z = -playerTransform.getCosAngleY();
        if (this.goForward.isPressed()) {
            velocity.add(x, 0.0f, z);
        }
        if (this.goBackward.isPressed()) {
            velocity.add(-x, 0.0f, -z);
        }
        if (this.goLeft.isPressed()) {
            velocity.add(z, 0.0f, -x);
        }
        if (this.goRight.isPressed()) {
            velocity.add(-z, 0.0f, x);
        }
        if (this.fire.isPressed()) {
            float cosX = playerTransform.getCosAngleX();
            float sinX = playerTransform.getSinAngleX();
            Blast blast = new Blast((PolygonGroup)this.blastModel.clone(), new Vector3D(cosX * x, sinX, cosX * z));
            blast.getLocation().setTo(player.getX(), player.getY() + 75.0f, player.getZ());
            this.gameObjectManager.add(blast);
        }
        velocity.multiply(0.5f);
        playerTransform.setVelocity(velocity);
        float angleVelocity = Math.min(this.tiltUp.getAmount(), 200);
        playerTransform.setAngleVelocityX((angleVelocity += (float)Math.max(-this.tiltDown.getAmount(), -200)) * 0.04f / 200.0f);
        angleVelocity = Math.min(this.turnLeft.getAmount(), 200);
        playerTransform.setAngleVelocityY((angleVelocity += (float)Math.max(-this.turnRight.getAmount(), -200)) * 0.04f / 200.0f);
        this.gameObjectManager.markAllVisible();
        this.gameObjectManager.update(elapsedTime);
        float angleX = playerTransform.getAngleX();
        float limit = 1.5707964f;
        if (angleX < -limit) {
            playerTransform.setAngleX(-limit);
        } else if (angleX > limit) {
            playerTransform.setAngleX(limit);
        }
        Transform3D camera = this.polygonRenderer.getCamera();
        camera.setTo(playerTransform);
        camera.getLocation().add(0.0f, 100.0f, 0.0f);
    }

    public void draw(Graphics g) {
        this.polygonRenderer.startFrame(this.screen);
        this.polygonRenderer.draw(g, this.floor);
        this.gameObjectManager.draw(g, (GameObjectRenderer)((Object)this.polygonRenderer));
        this.polygonRenderer.endFrame(this.screen);
    }
}

