/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.bsp2D;

import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;
import org.thenesis.planetino2.bsp2D.BSPPolygon;
import org.thenesis.planetino2.bsp2D.BSPTree;
import org.thenesis.planetino2.bsp2D.BSPTreeTraverseListener;
import org.thenesis.planetino2.bsp2D.BSPTreeTraverser;
import org.thenesis.planetino2.game.GameObjectManager;
import org.thenesis.planetino2.graphics.Screen;
import org.thenesis.planetino2.graphics3D.FastTexturedPolygonRenderer;
import org.thenesis.planetino2.graphics3D.ScanConverter;
import org.thenesis.planetino2.graphics3D.SortedScanConverter;
import org.thenesis.planetino2.graphics3D.ZBufferedRenderer;
import org.thenesis.planetino2.graphics3D.texture.Texture;
import org.thenesis.planetino2.math3D.Rectangle3D;
import org.thenesis.planetino2.math3D.TexturedPolygon3D;
import org.thenesis.planetino2.math3D.Transform3D;
import org.thenesis.planetino2.math3D.ViewWindow;

public class BSPRenderer
extends ZBufferedRenderer
implements BSPTreeTraverseListener {
    private static final int FILLED_CHECK = 3;
    protected Hashtable bspScanRenderers;
    protected BSPTreeTraverser traverser = new BSPTreeTraverser(this);
    protected Graphics currentGraphics2D;
    protected boolean viewNotFilledFirstTime = true;
    protected int polygonCount;
    static /* synthetic */ Class class$org$thenesis$planetino2$graphics3D$texture$PowerOf2Texture;
    static /* synthetic */ Class class$org$thenesis$planetino2$graphics3D$texture$ShadedTexture;
    static /* synthetic */ Class class$org$thenesis$planetino2$graphics3D$texture$ShadedSurface;

    public BSPRenderer(Transform3D camera, ViewWindow viewWindow) {
        super(camera, viewWindow, false);
    }

    public void setGameObjectManager(GameObjectManager gameObjectManager) {
        this.traverser.setGameObjectManager(gameObjectManager);
    }

    protected void init() {
        this.destPolygon = new TexturedPolygon3D();
        this.scanConverter = new SortedScanConverter(this.viewWindow);
        this.scanRenderers = new Hashtable();
        this.scanRenderers.put(class$org$thenesis$planetino2$graphics3D$texture$PowerOf2Texture == null ? (class$org$thenesis$planetino2$graphics3D$texture$PowerOf2Texture = BSPRenderer.class$("org.thenesis.planetino2.graphics3D.texture.PowerOf2Texture")) : class$org$thenesis$planetino2$graphics3D$texture$PowerOf2Texture, new ZBufferedRenderer.PowerOf2TextureZRenderer(this));
        this.scanRenderers.put(class$org$thenesis$planetino2$graphics3D$texture$ShadedTexture == null ? (class$org$thenesis$planetino2$graphics3D$texture$ShadedTexture = BSPRenderer.class$("org.thenesis.planetino2.graphics3D.texture.ShadedTexture")) : class$org$thenesis$planetino2$graphics3D$texture$ShadedTexture, new ZBufferedRenderer.ShadedTextureZRenderer(this));
        this.scanRenderers.put(class$org$thenesis$planetino2$graphics3D$texture$ShadedSurface == null ? (class$org$thenesis$planetino2$graphics3D$texture$ShadedSurface = BSPRenderer.class$("org.thenesis.planetino2.graphics3D.texture.ShadedSurface")) : class$org$thenesis$planetino2$graphics3D$texture$ShadedSurface, new ZBufferedRenderer.ShadedSurfaceZRenderer(this));
        this.bspScanRenderers = new Hashtable();
        this.bspScanRenderers.put(class$org$thenesis$planetino2$graphics3D$texture$PowerOf2Texture == null ? (class$org$thenesis$planetino2$graphics3D$texture$PowerOf2Texture = BSPRenderer.class$("org.thenesis.planetino2.graphics3D.texture.PowerOf2Texture")) : class$org$thenesis$planetino2$graphics3D$texture$PowerOf2Texture, new FastTexturedPolygonRenderer.PowerOf2TextureRenderer(this));
        this.bspScanRenderers.put(class$org$thenesis$planetino2$graphics3D$texture$ShadedTexture == null ? (class$org$thenesis$planetino2$graphics3D$texture$ShadedTexture = BSPRenderer.class$("org.thenesis.planetino2.graphics3D.texture.ShadedTexture")) : class$org$thenesis$planetino2$graphics3D$texture$ShadedTexture, new FastTexturedPolygonRenderer.ShadedTextureRenderer(this));
        this.bspScanRenderers.put(class$org$thenesis$planetino2$graphics3D$texture$ShadedSurface == null ? (class$org$thenesis$planetino2$graphics3D$texture$ShadedSurface = BSPRenderer.class$("org.thenesis.planetino2.graphics3D.texture.ShadedSurface")) : class$org$thenesis$planetino2$graphics3D$texture$ShadedSurface, new FastTexturedPolygonRenderer.ShadedSurfaceRenderer(this));
    }

    public void startFrame(Screen screen) {
        super.startFrame(screen);
        ((SortedScanConverter)this.scanConverter).clear();
        this.polygonCount = 0;
    }

    public void endFrame(Screen screen) {
        super.endFrame(screen);
        if (!((SortedScanConverter)this.scanConverter).isFilled()) {
            if (this.viewNotFilledFirstTime) {
                this.viewNotFilledFirstTime = false;
                System.out.println("View not completely filled.");
            }
            this.clearViewEveryFrame = true;
        } else {
            this.clearViewEveryFrame = false;
        }
    }

    public void draw(Graphics g, BSPTree tree) {
        ((SortedScanConverter)this.scanConverter).setSortedMode(true);
        this.currentGraphics2D = g;
        this.traverser.traverse(tree, this.camera.getLocation());
        ((SortedScanConverter)this.scanConverter).setSortedMode(false);
    }

    public boolean visitPolygon(BSPPolygon poly, boolean isBack) {
        SortedScanConverter scanConverter = (SortedScanConverter)this.scanConverter;
        this.draw(this.currentGraphics2D, poly);
        ++this.polygonCount;
        if (this.polygonCount == 3) {
            this.polygonCount = 0;
            return !scanConverter.isFilled();
        }
        return true;
    }

    protected void drawCurrentPolygon(Graphics g) {
        if (!(this.sourcePolygon instanceof BSPPolygon)) {
            super.drawCurrentPolygon(g);
            return;
        }
        this.buildSurface();
        SortedScanConverter scanConverter = (SortedScanConverter)this.scanConverter;
        TexturedPolygon3D poly = (TexturedPolygon3D)this.destPolygon;
        Texture texture = poly.getTexture();
        FastTexturedPolygonRenderer.ScanRenderer scanRenderer = (FastTexturedPolygonRenderer.ScanRenderer)this.bspScanRenderers.get(texture.getClass());
        scanRenderer.setTexture(texture);
        Rectangle3D textureBounds = poly.getTextureBounds();
        this.a.setToCrossProduct(textureBounds.getDirectionV(), textureBounds.getOrigin());
        this.b.setToCrossProduct(textureBounds.getOrigin(), textureBounds.getDirectionU());
        this.c.setToCrossProduct(textureBounds.getDirectionU(), textureBounds.getDirectionV());
        this.w = 1.6105636E9f / (this.viewWindow.getDistance() * this.c.getDotProduct(textureBounds.getOrigin()));
        int y = scanConverter.getTopBoundary();
        this.viewPos.y = this.viewWindow.convertFromScreenYToViewY(y);
        this.viewPos.z = -this.viewWindow.getDistance();
        while (y <= scanConverter.getBottomBoundary()) {
            for (int i = 0; i < scanConverter.getNumScans(y); ++i) {
                ScanConverter.Scan scan = scanConverter.getScan(y, i);
                if (!scan.isValid()) continue;
                this.viewPos.x = this.viewWindow.convertFromScreenXToViewX(scan.left);
                int offset = (y - this.viewWindow.getTopOffset()) * this.viewWindow.getWidth() + (scan.left - this.viewWindow.getLeftOffset());
                scanRenderer.render(offset, scan.left, scan.right);
                this.setScanDepth(offset, scan.right - scan.left + 1);
            }
            ++y;
            this.viewPos.y -= 1.0f;
        }
    }

    private void setScanDepth(int offset, int width) {
        float z = this.c.getDotProduct(this.viewPos);
        float dz = this.c.x;
        int depth = (int)(this.w * z);
        int dDepth = (int)(this.w * dz);
        short[] depthBuffer = this.zBuffer.getArray();
        int endOffset = offset + width;
        if (dDepth == 0) {
            short d = (short)(depth >> 12);
            while (offset < endOffset) {
                depthBuffer[offset++] = d;
            }
        } else {
            while (offset < endOffset) {
                depthBuffer[offset++] = (short)(depth >> 12);
                depth += dDepth;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

