/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.engine.shooter3D;

import org.thenesis.planetino2.engine.shooter3D.Bot;
import org.thenesis.planetino2.game.GameObject;
import org.thenesis.planetino2.math3D.MovingTransform3D;
import org.thenesis.planetino2.math3D.PolygonGroup;
import org.thenesis.planetino2.math3D.Vector3D;

public class Blast
extends GameObject {
    private static final long DIE_TIME = 5000L;
    private static final float SPEED = 1.5f;
    private static final float ROT_SPEED = 0.008f;
    private MovingTransform3D transform;
    private long aliveTime;

    public Blast(PolygonGroup polygonGroup, Vector3D direction) {
        super(polygonGroup);
        this.transform = polygonGroup.getTransform();
        Vector3D velocity = this.transform.getVelocity();
        velocity.setTo(direction);
        velocity.multiply(1.5f);
        this.transform.setVelocity(velocity);
        this.transform.setAngleVelocityY(0.008f);
        this.transform.setAngleVelocityZ(0.008f);
        this.setState(1);
    }

    public void update(GameObject player, long elapsedTime) {
        this.aliveTime += elapsedTime;
        if (this.aliveTime >= 5000L) {
            this.setState(2);
        } else {
            super.update(player, elapsedTime);
        }
    }

    public boolean isFlying() {
        return true;
    }

    public void notifyObjectCollision(GameObject object) {
        if (object instanceof Bot) {
            this.setState(object, 2);
            this.setState(2);
        }
    }

    public void notifyWallCollision() {
        this.transform.getVelocity().setTo(0.0f, 0.0f, 0.0f);
    }

    public void notifyFloorCollision() {
        this.notifyWallCollision();
    }

    public void notifyCeilingCollision() {
        this.notifyWallCollision();
    }
}

