/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.engine.shooter3D;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import org.thenesis.planetino2.game.Player;
import org.thenesis.planetino2.graphics.Color;
import org.thenesis.planetino2.graphics3D.Overlay;
import org.thenesis.planetino2.math3D.ViewWindow;

public class HeadsUpDisplay
implements Overlay {
    private static final float DISPLAY_INC_RATE = 0.04f;
    private Player player;
    private float displayedHealth;
    private Font font;

    public HeadsUpDisplay(Player player) {
        this.player = player;
        this.displayedHealth = 0.0f;
    }

    public void update(long elapsedTime) {
        float actualHealth = this.player.getHealth();
        if (actualHealth > this.displayedHealth) {
            this.displayedHealth = Math.min(actualHealth, this.displayedHealth + (float)elapsedTime * 0.04f);
        } else if (actualHealth < this.displayedHealth) {
            this.displayedHealth = Math.max(actualHealth, this.displayedHealth - (float)elapsedTime * 0.04f);
        }
    }

    public void draw(Graphics g, ViewWindow window) {
        Font font = Font.getDefaultFont();
        int fontHeight = font.getHeight();
        int spacing = fontHeight / 5;
        String str = Integer.toString((int)Math.floor((double)this.displayedHealth + 0.5));
        g.setColor(Color.WHITE.getRGB());
        g.drawString(str, 0, 0, 20);
        int x = font.charsWidth(str.toCharArray(), 0, str.length()) + spacing * 2;
        int y = fontHeight / 2;
        int w = window.getWidth() / 4;
        int h = window.getHeight() / 60;
        g.setColor(Color.GRAY.getRGB());
        g.fillRect(x, y, w, h);
        w = (int)Math.floor((double)((float)w * this.displayedHealth / this.player.getMaxHealth()) + 0.5);
        g.setColor(Color.WHITE.getRGB());
        g.fillRect(x, y, w, h);
    }

    public boolean isEnabled() {
        return this.player != null && (this.player.isAlive() || this.displayedHealth > 0.0f);
    }
}

