/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.graphics3D;

import org.thenesis.planetino2.math3D.Polygon3D;
import org.thenesis.planetino2.math3D.Vector3D;
import org.thenesis.planetino2.math3D.ViewWindow;
import org.thenesis.planetino2.util.MoreMath;

public class ScanConverter {
    private static final int SCALE_BITS = 16;
    private static final int SCALE = 65536;
    private static final int SCALE_MASK = 65535;
    protected ViewWindow view;
    protected Scan[] scans;
    protected int top;
    protected int bottom;

    public ScanConverter(ViewWindow view) {
        this.view = view;
    }

    public int getTopBoundary() {
        return this.top;
    }

    public int getBottomBoundary() {
        return this.bottom;
    }

    public Scan getScan(int y) {
        return this.scans[y];
    }

    protected void ensureCapacity() {
        int height = this.view.getTopOffset() + this.view.getHeight();
        if (this.scans == null || this.scans.length != height) {
            this.scans = new Scan[height];
            for (int i = 0; i < height; ++i) {
                this.scans[i] = new Scan();
            }
            this.top = 0;
            this.bottom = height - 1;
        }
    }

    private void clearCurrentScan() {
        for (int i = this.top; i <= this.bottom; ++i) {
            this.scans[i].clear();
        }
        this.top = Integer.MAX_VALUE;
        this.bottom = Integer.MIN_VALUE;
    }

    public boolean convert(Polygon3D polygon) {
        int i;
        this.ensureCapacity();
        this.clearCurrentScan();
        int minX = this.view.getLeftOffset();
        int maxX = this.view.getLeftOffset() + this.view.getWidth() - 1;
        int minY = this.view.getTopOffset();
        int maxY = this.view.getTopOffset() + this.view.getHeight() - 1;
        int numVertices = polygon.getNumVertices();
        for (i = 0; i < numVertices; ++i) {
            int yInt;
            int startY;
            float dy;
            Vector3D v1 = polygon.getVertex(i);
            Vector3D v2 = i == numVertices - 1 ? polygon.getVertex(0) : polygon.getVertex(i + 1);
            if (v1.y > v2.y) {
                Vector3D temp = v1;
                v1 = v2;
                v2 = temp;
            }
            if ((dy = v2.y - v1.y) == 0.0f) continue;
            int endY = Math.min(MoreMath.ceil(v2.y) - 1, maxY);
            this.top = Math.min(this.top, startY);
            this.bottom = Math.max(this.bottom, endY);
            float dx = v2.x - v1.x;
            if (dx == 0.0f) {
                int x = MoreMath.ceil(v1.x);
                x = Math.min(maxX + 1, Math.max(x, minX));
                for (int y = startY; y <= endY; ++y) {
                    this.scans[y].setBoundary(x);
                }
                continue;
            }
            float gradient = dx / dy;
            float startX = v1.x + ((float)startY - v1.y) * gradient;
            if (startX < (float)minX) {
                int yInt2 = (int)(v1.y + ((float)minX - v1.x) / gradient);
                yInt2 = Math.min(yInt2, endY);
                for (startY = Math.max(MoreMath.ceil(v1.y), minY); startY <= yInt2; ++startY) {
                    this.scans[startY].setBoundary(minX);
                }
            } else if (startX > (float)maxX) {
                int yInt3 = (int)(v1.y + ((float)maxX - v1.x) / gradient);
                yInt3 = Math.min(yInt3, endY);
                while (startY <= yInt3) {
                    this.scans[startY].setBoundary(maxX + 1);
                    ++startY;
                }
            }
            if (startY > endY) continue;
            float endX = v1.x + ((float)endY - v1.y) * gradient;
            if (endX < (float)minX) {
                yInt = MoreMath.ceil(v1.y + ((float)minX - v1.x) / gradient);
                yInt = Math.max(yInt, startY);
                while (endY >= yInt) {
                    this.scans[endY].setBoundary(minX);
                    --endY;
                }
            } else if (endX > (float)maxX) {
                yInt = MoreMath.ceil(v1.y + ((float)maxX - v1.x) / gradient);
                yInt = Math.max(yInt, startY);
                while (endY >= yInt) {
                    this.scans[endY].setBoundary(maxX + 1);
                    --endY;
                }
            }
            if (startY > endY) continue;
            int xScaled = (int)(65536.0f * v1.x + 65536.0f * ((float)startY - v1.y) * dx / dy) + 65535;
            int dxScaled = (int)(dx * 65536.0f / dy);
            for (int y = startY; y <= endY; ++y) {
                this.scans[y].setBoundary(xScaled >> 16);
                xScaled += dxScaled;
            }
        }
        for (i = this.top; i <= this.bottom; ++i) {
            if (!this.scans[i].isValid()) continue;
            return true;
        }
        return false;
    }

    public static class Scan {
        public int left;
        public int right;

        public void setBoundary(int x) {
            if (x < this.left) {
                this.left = x;
            }
            if (x - 1 > this.right) {
                this.right = x - 1;
            }
        }

        public void clear() {
            this.left = Integer.MAX_VALUE;
            this.right = Integer.MIN_VALUE;
        }

        public boolean isValid() {
            return this.left <= this.right;
        }

        public void setTo(int left, int right) {
            this.left = left;
            this.right = right;
        }

        public boolean equals(int left, int right) {
            return this.left == left && this.right == right;
        }
    }
}

