/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.graphics3D;

import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import org.thenesis.planetino2.graphics.Screen;
import org.thenesis.planetino2.graphics3D.FastTexturedPolygonRenderer;
import org.thenesis.planetino2.graphics3D.texture.ShadedSurface;
import org.thenesis.planetino2.graphics3D.texture.Texture;
import org.thenesis.planetino2.math3D.TexturedPolygon3D;
import org.thenesis.planetino2.math3D.Transform3D;
import org.thenesis.planetino2.math3D.ViewWindow;

public class ShadedSurfacePolygonRenderer
extends FastTexturedPolygonRenderer {
    private Vector builtSurfaces = new Vector();

    public ShadedSurfacePolygonRenderer(Transform3D camera, ViewWindow viewWindow) {
        this(camera, viewWindow, true);
    }

    public ShadedSurfacePolygonRenderer(Transform3D camera, ViewWindow viewWindow, boolean eraseView) {
        super(camera, viewWindow, eraseView);
    }

    public void endFrame(Screen screen) {
        super.endFrame(screen);
        Enumeration i = this.builtSurfaces.elements();
        while (i.hasMoreElements()) {
            ShadedSurface surface = (ShadedSurface)i.nextElement();
            if (surface.isDirty()) {
                surface.clearSurface();
                this.builtSurfaces.removeElement(surface);
                continue;
            }
            surface.setDirty(true);
        }
    }

    protected void drawCurrentPolygon(Graphics g) {
        this.buildSurface();
        super.drawCurrentPolygon(g);
    }

    protected void buildSurface() {
        Texture texture;
        if (this.sourcePolygon instanceof TexturedPolygon3D && (texture = ((TexturedPolygon3D)this.sourcePolygon).getTexture()) instanceof ShadedSurface) {
            ShadedSurface surface = (ShadedSurface)texture;
            if (surface.isCleared()) {
                surface.buildSurface();
                this.builtSurfaces.addElement(surface);
            }
            surface.setDirty(false);
        }
    }
}

