/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.graphics3D;

import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;
import org.thenesis.planetino2.game.GameObject;
import org.thenesis.planetino2.game.GameObjectRenderer;
import org.thenesis.planetino2.graphics.Screen;
import org.thenesis.planetino2.graphics3D.FastTexturedPolygonRenderer;
import org.thenesis.planetino2.graphics3D.ScanConverter;
import org.thenesis.planetino2.graphics3D.ShadedSurfacePolygonRenderer;
import org.thenesis.planetino2.graphics3D.ZBuffer;
import org.thenesis.planetino2.graphics3D.texture.PowerOf2Texture;
import org.thenesis.planetino2.graphics3D.texture.ShadedSurface;
import org.thenesis.planetino2.graphics3D.texture.ShadedTexture;
import org.thenesis.planetino2.graphics3D.texture.Texture;
import org.thenesis.planetino2.math3D.PolygonGroup;
import org.thenesis.planetino2.math3D.Rectangle3D;
import org.thenesis.planetino2.math3D.TexturedPolygon3D;
import org.thenesis.planetino2.math3D.Transform3D;
import org.thenesis.planetino2.math3D.ViewWindow;

public class ZBufferedRenderer
extends ShadedSurfacePolygonRenderer
implements GameObjectRenderer {
    protected static final int MIN_DISTANCE = 12;
    protected TexturedPolygon3D temp = new TexturedPolygon3D();
    protected ZBuffer zBuffer;
    protected float w;
    static /* synthetic */ Class class$org$thenesis$planetino2$graphics3D$texture$PowerOf2Texture;
    static /* synthetic */ Class class$org$thenesis$planetino2$graphics3D$texture$ShadedTexture;
    static /* synthetic */ Class class$org$thenesis$planetino2$graphics3D$texture$ShadedSurface;

    public ZBufferedRenderer(Transform3D camera, ViewWindow viewWindow) {
        this(camera, viewWindow, true);
    }

    public ZBufferedRenderer(Transform3D camera, ViewWindow viewWindow, boolean eraseView) {
        super(camera, viewWindow, eraseView);
    }

    protected void init() {
        this.destPolygon = new TexturedPolygon3D();
        this.scanConverter = new ScanConverter(this.viewWindow);
        this.scanRenderers = new Hashtable();
        this.scanRenderers.put(class$org$thenesis$planetino2$graphics3D$texture$PowerOf2Texture == null ? (class$org$thenesis$planetino2$graphics3D$texture$PowerOf2Texture = ZBufferedRenderer.class$("org.thenesis.planetino2.graphics3D.texture.PowerOf2Texture")) : class$org$thenesis$planetino2$graphics3D$texture$PowerOf2Texture, new PowerOf2TextureZRenderer());
        this.scanRenderers.put(class$org$thenesis$planetino2$graphics3D$texture$ShadedTexture == null ? (class$org$thenesis$planetino2$graphics3D$texture$ShadedTexture = ZBufferedRenderer.class$("org.thenesis.planetino2.graphics3D.texture.ShadedTexture")) : class$org$thenesis$planetino2$graphics3D$texture$ShadedTexture, new ShadedTextureZRenderer());
        this.scanRenderers.put(class$org$thenesis$planetino2$graphics3D$texture$ShadedSurface == null ? (class$org$thenesis$planetino2$graphics3D$texture$ShadedSurface = ZBufferedRenderer.class$("org.thenesis.planetino2.graphics3D.texture.ShadedSurface")) : class$org$thenesis$planetino2$graphics3D$texture$ShadedSurface, new ShadedSurfaceZRenderer());
    }

    public void startFrame(Screen screen) {
        super.startFrame(screen);
        if (this.zBuffer == null || this.zBuffer.getWidth() != this.viewWindow.getWidth() || this.zBuffer.getHeight() != this.viewWindow.getHeight()) {
            this.zBuffer = new ZBuffer(this.viewWindow.getWidth(), this.viewWindow.getHeight());
        } else if (this.clearViewEveryFrame) {
            this.zBuffer.clear();
        }
    }

    public boolean draw(Graphics g, GameObject object) {
        return this.draw(g, object.getPolygonGroup());
    }

    public boolean draw(Graphics g, PolygonGroup group) {
        boolean visible = false;
        group.resetIterator();
        while (group.hasNext()) {
            group.nextPolygonTransformed(this.temp);
            visible |= this.draw(g, this.temp);
        }
        return visible;
    }

    protected void drawCurrentPolygon(Graphics g) {
        if (!(this.sourcePolygon instanceof TexturedPolygon3D)) {
            return;
        }
        this.buildSurface();
        TexturedPolygon3D poly = (TexturedPolygon3D)this.destPolygon;
        Texture texture = poly.getTexture();
        FastTexturedPolygonRenderer.ScanRenderer scanRenderer = (FastTexturedPolygonRenderer.ScanRenderer)this.scanRenderers.get(texture.getClass());
        scanRenderer.setTexture(texture);
        Rectangle3D textureBounds = poly.getTextureBounds();
        this.a.setToCrossProduct(textureBounds.getDirectionV(), textureBounds.getOrigin());
        this.b.setToCrossProduct(textureBounds.getOrigin(), textureBounds.getDirectionU());
        this.c.setToCrossProduct(textureBounds.getDirectionU(), textureBounds.getDirectionV());
        this.w = 1.6105636E9f / (this.viewWindow.getDistance() * this.c.getDotProduct(textureBounds.getOrigin()));
        int y = this.scanConverter.getTopBoundary();
        this.viewPos.y = this.viewWindow.convertFromScreenYToViewY(y);
        this.viewPos.z = -this.viewWindow.getDistance();
        while (y <= this.scanConverter.getBottomBoundary()) {
            ScanConverter.Scan scan = this.scanConverter.getScan(y);
            if (scan.isValid()) {
                this.viewPos.x = this.viewWindow.convertFromScreenXToViewX(scan.left);
                int offset = (y - this.viewWindow.getTopOffset()) * this.viewWindow.getWidth() + (scan.left - this.viewWindow.getLeftOffset());
                scanRenderer.render(offset, scan.left, scan.right);
            }
            ++y;
            this.viewPos.y -= 1.0f;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class ShadedSurfaceZRenderer
    extends FastTexturedPolygonRenderer.ScanRenderer {
        public int checkBounds(int vScaled, int bounds) {
            int v = vScaled >> 12;
            if (v < 0) {
                vScaled = 0;
            } else if (v >= bounds) {
                vScaled = bounds - 1 << 12;
            }
            return vScaled;
        }

        public void render(int offset, int left, int right) {
            ShadedSurface texture = (ShadedSurface)this.currentTexture;
            ShadedTexture srcTexture = texture.getSourceTexture();
            int[] buffer = srcTexture.getRawData();
            int widthBits = srcTexture.getWidthBits();
            int widthMask = srcTexture.getWidthMask();
            int heightBits = srcTexture.getHeightBits();
            int heightMask = srcTexture.getHeightMask();
            float u = 4096.0f * ZBufferedRenderer.this.a.getDotProduct(ZBufferedRenderer.this.viewPos);
            float v = 4096.0f * ZBufferedRenderer.this.b.getDotProduct(ZBufferedRenderer.this.viewPos);
            float z = ZBufferedRenderer.this.c.getDotProduct(ZBufferedRenderer.this.viewPos);
            float du = 65536.0f * ZBufferedRenderer.this.a.x;
            float dv = 65536.0f * ZBufferedRenderer.this.b.x;
            float dz = 16.0f * ZBufferedRenderer.this.c.x;
            int nextTx = (int)(u / z);
            int nextTy = (int)(v / z);
            int depth = (int)(ZBufferedRenderer.this.w * z);
            int dDepth = (int)(ZBufferedRenderer.this.w * ZBufferedRenderer.this.c.x);
            int x = left;
            while (x <= right) {
                int tx = nextTx;
                int ty = nextTy;
                int maxLength = right - x + 1;
                if (maxLength > 16) {
                    nextTx = (int)((u += du) / (z += dz));
                    nextTy = (int)((v += dv) / z);
                    int dtx = nextTx - tx >> 4;
                    int dty = nextTy - ty >> 4;
                    int endOffset = offset + 16;
                    while (offset < endOffset) {
                        if (ZBufferedRenderer.this.zBuffer.checkDepth(offset, (short)(depth >> 12))) {
                            ZBufferedRenderer.this.doubleBufferData[offset] = buffer[(tx >> 12 & widthMask) + ((ty >> 12 & heightMask) << widthBits)];
                        }
                        ++offset;
                        tx += dtx;
                        ty += dty;
                        depth += dDepth;
                    }
                    x += 16;
                    continue;
                }
                int interpSize = maxLength;
                nextTx = (int)((u += (float)(interpSize * 4096) * ZBufferedRenderer.this.a.x) / (z += (float)interpSize * ZBufferedRenderer.this.c.x));
                nextTy = (int)((v += (float)(interpSize * 4096) * ZBufferedRenderer.this.b.x) / z);
                tx = this.checkBounds(tx, texture.getWidth());
                ty = this.checkBounds(ty, texture.getHeight());
                nextTx = this.checkBounds(nextTx, texture.getWidth());
                nextTy = this.checkBounds(nextTy, texture.getHeight());
                int dtx = (nextTx - tx) / interpSize;
                int dty = (nextTy - ty) / interpSize;
                int endOffset = offset + interpSize;
                while (offset < endOffset) {
                    if (ZBufferedRenderer.this.zBuffer.checkDepth(offset, (short)(depth >> 12))) {
                        ZBufferedRenderer.this.doubleBufferData[offset] = buffer[(tx >> 12 & widthMask) + ((ty >> 12 & heightMask) << widthBits)];
                    }
                    ++offset;
                    tx += dtx;
                    ty += dty;
                    depth += dDepth;
                }
                x += interpSize;
            }
        }
    }

    public class ShadedTextureZRenderer
    extends FastTexturedPolygonRenderer.ScanRenderer {
        public void render(int offset, int left, int right) {
            ShadedTexture texture = (ShadedTexture)this.currentTexture;
            int[] buffer = texture.getRawData();
            int widthBits = texture.getWidthBits();
            int widthMask = texture.getWidthMask();
            int heightBits = texture.getHeightBits();
            int heightMask = texture.getHeightMask();
            float u = 4096.0f * ZBufferedRenderer.this.a.getDotProduct(ZBufferedRenderer.this.viewPos);
            float v = 4096.0f * ZBufferedRenderer.this.b.getDotProduct(ZBufferedRenderer.this.viewPos);
            float z = ZBufferedRenderer.this.c.getDotProduct(ZBufferedRenderer.this.viewPos);
            float du = 65536.0f * ZBufferedRenderer.this.a.x;
            float dv = 65536.0f * ZBufferedRenderer.this.b.x;
            float dz = 16.0f * ZBufferedRenderer.this.c.x;
            int nextTx = (int)(u / z);
            int nextTy = (int)(v / z);
            int depth = (int)(ZBufferedRenderer.this.w * z);
            int dDepth = (int)(ZBufferedRenderer.this.w * ZBufferedRenderer.this.c.x);
            int x = left;
            while (x <= right) {
                int tx = nextTx;
                int ty = nextTy;
                int maxLength = right - x + 1;
                if (maxLength > 16) {
                    nextTx = (int)((u += du) / (z += dz));
                    nextTy = (int)((v += dv) / z);
                    int dtx = nextTx - tx >> 4;
                    int dty = nextTy - ty >> 4;
                    int endOffset = offset + 16;
                    while (offset < endOffset) {
                        if (ZBufferedRenderer.this.zBuffer.checkDepth(offset, (short)(depth >> 12))) {
                            ZBufferedRenderer.this.doubleBufferData[offset] = buffer[(tx >> 12 & widthMask) + ((ty >> 12 & heightMask) << widthBits)];
                        }
                        ++offset;
                        tx += dtx;
                        ty += dty;
                        depth += dDepth;
                    }
                    x += 16;
                    continue;
                }
                int interpSize = maxLength;
                nextTx = (int)((u += (float)(interpSize * 4096) * ZBufferedRenderer.this.a.x) / (z += (float)interpSize * ZBufferedRenderer.this.c.x));
                nextTy = (int)((v += (float)(interpSize * 4096) * ZBufferedRenderer.this.b.x) / z);
                int dtx = (nextTx - tx) / interpSize;
                int dty = (nextTy - ty) / interpSize;
                int endOffset = offset + interpSize;
                while (offset < endOffset) {
                    if (ZBufferedRenderer.this.zBuffer.checkDepth(offset, (short)(depth >> 12))) {
                        ZBufferedRenderer.this.doubleBufferData[offset] = buffer[(tx >> 12 & widthMask) + ((ty >> 12 & heightMask) << widthBits)];
                    }
                    ++offset;
                    tx += dtx;
                    ty += dty;
                    depth += dDepth;
                }
                x += interpSize;
            }
        }
    }

    public class PowerOf2TextureZRenderer
    extends FastTexturedPolygonRenderer.ScanRenderer {
        public void render(int offset, int left, int right) {
            PowerOf2Texture texture = (PowerOf2Texture)this.currentTexture;
            int[] buffer = texture.getRawData();
            int widthBits = texture.getWidthBits();
            int widthMask = texture.getWidthMask();
            int heightBits = texture.getHeightBits();
            int heightMask = texture.getHeightMask();
            float u = 4096.0f * ZBufferedRenderer.this.a.getDotProduct(ZBufferedRenderer.this.viewPos);
            float v = 4096.0f * ZBufferedRenderer.this.b.getDotProduct(ZBufferedRenderer.this.viewPos);
            float z = ZBufferedRenderer.this.c.getDotProduct(ZBufferedRenderer.this.viewPos);
            float du = 65536.0f * ZBufferedRenderer.this.a.x;
            float dv = 65536.0f * ZBufferedRenderer.this.b.x;
            float dz = 16.0f * ZBufferedRenderer.this.c.x;
            int nextTx = (int)(u / z);
            int nextTy = (int)(v / z);
            int depth = (int)(ZBufferedRenderer.this.w * z);
            int dDepth = (int)(ZBufferedRenderer.this.w * ZBufferedRenderer.this.c.x);
            int x = left;
            while (x <= right) {
                int tx = nextTx;
                int ty = nextTy;
                int maxLength = right - x + 1;
                if (maxLength > 16) {
                    nextTx = (int)((u += du) / (z += dz));
                    nextTy = (int)((v += dv) / z);
                    int dtx = nextTx - tx >> 4;
                    int dty = nextTy - ty >> 4;
                    int endOffset = offset + 16;
                    while (offset < endOffset) {
                        if (ZBufferedRenderer.this.zBuffer.checkDepth(offset, (short)(depth >> 12))) {
                            ZBufferedRenderer.this.doubleBufferData[offset] = buffer[(tx >> 12 & widthMask) + ((ty >> 12 & heightMask) << widthBits)];
                        }
                        ++offset;
                        tx += dtx;
                        ty += dty;
                        depth += dDepth;
                    }
                    x += 16;
                    continue;
                }
                int interpSize = maxLength;
                nextTx = (int)((u += (float)(interpSize * 4096) * ZBufferedRenderer.this.a.x) / (z += (float)interpSize * ZBufferedRenderer.this.c.x));
                nextTy = (int)((v += (float)(interpSize * 4096) * ZBufferedRenderer.this.b.x) / z);
                int dtx = (nextTx - tx) / interpSize;
                int dty = (nextTy - ty) / interpSize;
                int endOffset = offset + interpSize;
                while (offset < endOffset) {
                    if (ZBufferedRenderer.this.zBuffer.checkDepth(offset, (short)(depth >> 12))) {
                        ZBufferedRenderer.this.doubleBufferData[offset] = buffer[(tx >> 12 & widthMask) + ((ty >> 12 & heightMask) << widthBits)];
                    }
                    ++offset;
                    tx += dtx;
                    ty += dty;
                    depth += dDepth;
                }
                x += interpSize;
            }
        }
    }
}

