/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.math3D;

import org.thenesis.planetino2.math3D.Vector3D;

public class PointLight3D
extends Vector3D {
    public static final float NO_DISTANCE_FALLOFF = -1.0f;
    private float intensity;
    private float distanceFalloff;

    public PointLight3D() {
        this(0.0f, 0.0f, 0.0f, 1.0f, -1.0f);
    }

    public PointLight3D(PointLight3D p) {
        this.setTo(p);
    }

    public PointLight3D(float x, float y, float z, float intensity) {
        this(x, y, z, intensity, -1.0f);
    }

    public PointLight3D(float x, float y, float z, float intensity, float distanceFalloff) {
        this.setTo(x, y, z);
        this.setIntensity(intensity);
        this.setDistanceFalloff(distanceFalloff);
    }

    public void setTo(PointLight3D p) {
        this.setTo(p.x, p.y, p.z);
        this.setIntensity(p.getIntensity());
        this.setDistanceFalloff(p.getDistanceFalloff());
    }

    public float getIntensity(float distance) {
        if (this.distanceFalloff == -1.0f) {
            return this.intensity;
        }
        if (distance >= this.distanceFalloff) {
            return 0.0f;
        }
        return this.intensity * (this.distanceFalloff - distance) / (this.distanceFalloff + distance);
    }

    public float getIntensity() {
        return this.intensity;
    }

    public void setIntensity(float intensity) {
        this.intensity = intensity;
    }

    public float getDistanceFalloff() {
        return this.distanceFalloff;
    }

    public void setDistanceFalloff(float distanceFalloff) {
        this.distanceFalloff = distanceFalloff;
    }
}

